/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Health check performed by system automatically on a specific transport zone. For
 * overlay based zone, health check is performed on corresponding N-VDS of each
 * transport node with the VLAN and MTU specified by uplink profile of N-VDS for
 * the node. For VLAN based zone, health check is performed on corresponding N-VDS
 * of each transport node with MTU specified by uplink profile of N-VDS for the
 * node and VLAN specified by all logical switches in this zone.
 */
public final class AutomaticHealthCheck implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private com.vmware.nsx.model.HealthCheckResult result;

    private java.lang.String transportZoneId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public AutomaticHealthCheck() {
    }

    protected AutomaticHealthCheck(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.HealthCheckResult getResult() {
        return this.result;
    }

    /**
     *
     *
     * @param result New value for the property.
     */
    public void setResult(com.vmware.nsx.model.HealthCheckResult result) {
        this.result = result;
    }

    /**
     * ID of the transport zone where this automatic health check is performed.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransportZoneId() {
        return this.transportZoneId;
    }

    /**
     * ID of the transport zone where this automatic health check is performed.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param transportZoneId New value for the property.
     */
    public void setTransportZoneId(java.lang.String transportZoneId) {
        this.transportZoneId = transportZoneId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.automaticHealthCheck;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("result",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.result, this._getType().getField("result")));
        structValue.setField("transport_zone_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportZoneId, this._getType().getField("transport_zone_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.automaticHealthCheck;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.automaticHealthCheck.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static AutomaticHealthCheck _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new AutomaticHealthCheck(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static AutomaticHealthCheck _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new AutomaticHealthCheck(structValue);
    }

    /**
     * Builder class for {@link AutomaticHealthCheck}.
     */
    public static final class Builder {
        private com.vmware.nsx.model.HealthCheckResult result;
        private java.lang.String transportZoneId;

        /**
         * Constructor with parameters for the required properties of
         * {@link AutomaticHealthCheck}.
         */
        public Builder() {
        }

        /**
         *
         *
         * @param result New value for the property.
         */
        public Builder setResult(com.vmware.nsx.model.HealthCheckResult result) {
            this.result = result;
            return this;
        }

        /**
         * ID of the transport zone where this automatic health check is performed.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param transportZoneId New value for the property.
         */
        public Builder setTransportZoneId(java.lang.String transportZoneId) {
            this.transportZoneId = transportZoneId;
            return this;
        }

        public AutomaticHealthCheck build() {
            AutomaticHealthCheck result = new AutomaticHealthCheck();
            result.setResult(this.result);
            result.setTransportZoneId(this.transportZoneId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("result", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.healthCheckResult; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("result",
                                                                                "result",
                                                                                "getResult",
                                                                                "setResult");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_zone_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_zone_id",
                                                                                "transportZoneId",
                                                                                "getTransportZoneId",
                                                                                "setTransportZoneId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.automatic_health_check",
                                                            fields,
                                                            com.vmware.nsx.model.AutomaticHealthCheck.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

