/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * BFD configuration for the given Peer.
 */
public final class BfdConfigParameters implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long declareDeadMultiple;

    private java.lang.Long receiveInterval;

    private java.lang.Long transmitInterval;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public BfdConfigParameters() {
    }

    protected BfdConfigParameters(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Number of times a packet is missed before BFD declares the neighbor down.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDeclareDeadMultiple() {
        return this.declareDeadMultiple;
    }

    /**
     * Number of times a packet is missed before BFD declares the neighbor down.
     * format: int64
     *
     * @param declareDeadMultiple New value for the property.
     */
    public void setDeclareDeadMultiple(java.lang.Long declareDeadMultiple) {
        this.declareDeadMultiple = declareDeadMultiple;
    }

    /**
     * The time interval (in milliseconds) between heartbeat packets for BFD when
     * receiving heartbeats.| For edge cluster type of bare metal, this value should be
     * >= 50ms.| For edge cluster type of virtual machine or hybrid, this value should
     * be >= 500ms. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getReceiveInterval() {
        return this.receiveInterval;
    }

    /**
     * The time interval (in milliseconds) between heartbeat packets for BFD when
     * receiving heartbeats.| For edge cluster type of bare metal, this value should be
     * >= 50ms.| For edge cluster type of virtual machine or hybrid, this value should
     * be >= 500ms. format: int64
     *
     * @param receiveInterval New value for the property.
     */
    public void setReceiveInterval(java.lang.Long receiveInterval) {
        this.receiveInterval = receiveInterval;
    }

    /**
     * The time interval (in milliseconds) between heartbeat packets for BFD when
     * sending heartbeats.| For edge cluster type of bare metal, this value should be
     * >= 300ms.| For edge cluster type of virtual machine or hybrid, this value should
     * be >= 1000ms. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTransmitInterval() {
        return this.transmitInterval;
    }

    /**
     * The time interval (in milliseconds) between heartbeat packets for BFD when
     * sending heartbeats.| For edge cluster type of bare metal, this value should be
     * >= 300ms.| For edge cluster type of virtual machine or hybrid, this value should
     * be >= 1000ms. format: int64
     *
     * @param transmitInterval New value for the property.
     */
    public void setTransmitInterval(java.lang.Long transmitInterval) {
        this.transmitInterval = transmitInterval;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.bfdConfigParameters;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("declare_dead_multiple",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.declareDeadMultiple, this._getType().getField("declare_dead_multiple")));
        structValue.setField("receive_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.receiveInterval, this._getType().getField("receive_interval")));
        structValue.setField("transmit_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transmitInterval, this._getType().getField("transmit_interval")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.bfdConfigParameters;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.bfdConfigParameters.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static BfdConfigParameters _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new BfdConfigParameters(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static BfdConfigParameters _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new BfdConfigParameters(structValue);
    }

    /**
     * Builder class for {@link BfdConfigParameters}.
     */
    public static final class Builder {
        private java.lang.Long declareDeadMultiple;
        private java.lang.Long receiveInterval;
        private java.lang.Long transmitInterval;

        /**
         * Constructor with parameters for the required properties of
         * {@link BfdConfigParameters}.
         */
        public Builder() {
        }

        /**
         * Number of times a packet is missed before BFD declares the neighbor down.
         * format: int64
         *
         * @param declareDeadMultiple New value for the property.
         */
        public Builder setDeclareDeadMultiple(java.lang.Long declareDeadMultiple) {
            this.declareDeadMultiple = declareDeadMultiple;
            return this;
        }

        /**
         * The time interval (in milliseconds) between heartbeat packets for BFD when
         * receiving heartbeats.| For edge cluster type of bare metal, this value should be
         * >= 50ms.| For edge cluster type of virtual machine or hybrid, this value should
         * be >= 500ms. format: int64
         *
         * @param receiveInterval New value for the property.
         */
        public Builder setReceiveInterval(java.lang.Long receiveInterval) {
            this.receiveInterval = receiveInterval;
            return this;
        }

        /**
         * The time interval (in milliseconds) between heartbeat packets for BFD when
         * sending heartbeats.| For edge cluster type of bare metal, this value should be
         * >= 300ms.| For edge cluster type of virtual machine or hybrid, this value should
         * be >= 1000ms. format: int64
         *
         * @param transmitInterval New value for the property.
         */
        public Builder setTransmitInterval(java.lang.Long transmitInterval) {
            this.transmitInterval = transmitInterval;
            return this;
        }

        public BfdConfigParameters build() {
            BfdConfigParameters result = new BfdConfigParameters();
            result.setDeclareDeadMultiple(this.declareDeadMultiple);
            result.setReceiveInterval(this.receiveInterval);
            result.setTransmitInterval(this.transmitInterval);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("declare_dead_multiple", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("declare_dead_multiple",
                                                                                "declareDeadMultiple",
                                                                                "getDeclareDeadMultiple",
                                                                                "setDeclareDeadMultiple");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("receive_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("receive_interval",
                                                                                "receiveInterval",
                                                                                "getReceiveInterval",
                                                                                "setReceiveInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transmit_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transmit_interval",
                                                                                "transmitInterval",
                                                                                "getTransmitInterval",
                                                                                "setTransmitInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.bfd_config_parameters",
                                                            fields,
                                                            com.vmware.nsx.model.BfdConfigParameters.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

