/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * CallbackAuthenticationScheme describes how notification requests should
 * authenticate to the server.
 */
public final class CallbackAuthenticationScheme implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String SCHEME_NAME_BASIC_AUTH = "BASIC_AUTH";

    public static final java.lang.String SCHEME_NAME_CERTIFICATE = "CERTIFICATE";

    private java.lang.String certificateId;

    private java.lang.String password;

    private java.lang.String schemeName;

    private java.lang.String username;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public CallbackAuthenticationScheme() {
    }

    protected CallbackAuthenticationScheme(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Certificate ID with a valid certificate and private key, procured from
     * trust-management API.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCertificateId() {
        return this.certificateId;
    }

    /**
     * Certificate ID with a valid certificate and private key, procured from
     * trust-management API.
     *
     * @param certificateId New value for the property.
     */
    public void setCertificateId(java.lang.String certificateId) {
        this.certificateId = certificateId;
    }

    /**
     * Password to use if scheme_name is BASIC_AUTH.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPassword() {
        return this.password;
    }

    /**
     * Password to use if scheme_name is BASIC_AUTH.
     *
     * @param password New value for the property.
     */
    public void setPassword(java.lang.String password) {
        this.password = password;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.CallbackAuthenticationScheme#SCHEME_NAME_BASIC_AUTH}</li>
     * <li> {@link
     * com.vmware.nsx.model.CallbackAuthenticationScheme#SCHEME_NAME_CERTIFICATE}</li>
     * </ul> Authentication scheme to use when making notification requests to the
     * partner console. Specify one of BASIC_AUTH or CERTIFICATE.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchemeName() {
        return this.schemeName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.CallbackAuthenticationScheme#SCHEME_NAME_BASIC_AUTH}</li>
     * <li> {@link
     * com.vmware.nsx.model.CallbackAuthenticationScheme#SCHEME_NAME_CERTIFICATE}</li>
     * </ul> Authentication scheme to use when making notification requests to the
     * partner console. Specify one of BASIC_AUTH or CERTIFICATE.
     *
     * @param schemeName New value for the property.
     */
    public void setSchemeName(java.lang.String schemeName) {
        this.schemeName = schemeName;
    }

    /**
     * Username to use if scheme_name is BASIC_AUTH.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUsername() {
        return this.username;
    }

    /**
     * Username to use if scheme_name is BASIC_AUTH.
     *
     * @param username New value for the property.
     */
    public void setUsername(java.lang.String username) {
        this.username = username;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.callbackAuthenticationScheme;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("certificate_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificateId, this._getType().getField("certificate_id")));
        structValue.setField("password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.password, this._getType().getField("password")));
        structValue.setField("scheme_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schemeName, this._getType().getField("scheme_name")));
        structValue.setField("username",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.username, this._getType().getField("username")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.callbackAuthenticationScheme;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.callbackAuthenticationScheme.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static CallbackAuthenticationScheme _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new CallbackAuthenticationScheme(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static CallbackAuthenticationScheme _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new CallbackAuthenticationScheme(structValue);
    }

    /**
     * Builder class for {@link CallbackAuthenticationScheme}.
     */
    public static final class Builder {
        private java.lang.String certificateId;
        private java.lang.String password;
        private java.lang.String schemeName;
        private java.lang.String username;

        /**
         * Constructor with parameters for the required properties of
         * {@link CallbackAuthenticationScheme}.
         */
        public Builder() {
        }

        /**
         * Certificate ID with a valid certificate and private key, procured from
         * trust-management API.
         *
         * @param certificateId New value for the property.
         */
        public Builder setCertificateId(java.lang.String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        /**
         * Password to use if scheme_name is BASIC_AUTH.
         *
         * @param password New value for the property.
         */
        public Builder setPassword(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.CallbackAuthenticationScheme#SCHEME_NAME_BASIC_AUTH}</li>
         * <li> {@link
         * com.vmware.nsx.model.CallbackAuthenticationScheme#SCHEME_NAME_CERTIFICATE}</li>
         * </ul> Authentication scheme to use when making notification requests to the
         * partner console. Specify one of BASIC_AUTH or CERTIFICATE.
         *
         * @param schemeName New value for the property.
         */
        public Builder setSchemeName(java.lang.String schemeName) {
            this.schemeName = schemeName;
            return this;
        }

        /**
         * Username to use if scheme_name is BASIC_AUTH.
         *
         * @param username New value for the property.
         */
        public Builder setUsername(java.lang.String username) {
            this.username = username;
            return this;
        }

        public CallbackAuthenticationScheme build() {
            CallbackAuthenticationScheme result = new CallbackAuthenticationScheme();
            result.setCertificateId(this.certificateId);
            result.setPassword(this.password);
            result.setSchemeName(this.schemeName);
            result.setUsername(this.username);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("certificate_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificate_id",
                                                                                "certificateId",
                                                                                "getCertificateId",
                                                                                "setCertificateId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("password",
                                                                                "password",
                                                                                "getPassword",
                                                                                "setPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("scheme_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("scheme_name",
                                                                                "schemeName",
                                                                                "getSchemeName",
                                                                                "setSchemeName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("username", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("username",
                                                                                "username",
                                                                                "getUsername",
                                                                                "setUsername");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.callback_authentication_scheme",
                                                            fields,
                                                            com.vmware.nsx.model.CallbackAuthenticationScheme.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

