/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Runtime status information of the compute manager
 */
public final class ComputeManagerStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CONNECTION_STATUS_UP = "UP";

    public static final java.lang.String CONNECTION_STATUS_DOWN = "DOWN";

    public static final java.lang.String CONNECTION_STATUS_CONNECTING = "CONNECTING";

    public static final java.lang.String REGISTRATION_STATUS_REGISTERED = "REGISTERED";

    public static final java.lang.String REGISTRATION_STATUS_UNREGISTERED = "UNREGISTERED";

    public static final java.lang.String REGISTRATION_STATUS_REGISTERING = "REGISTERING";

    public static final java.lang.String REGISTRATION_STATUS_REGISTERED_WITH_ERRORS = "REGISTERED_WITH_ERRORS";

    private java.util.List<com.vmware.nsx.model.ErrorInfo> connectionErrors;

    private java.lang.String connectionStatus;

    private java.lang.String connectionStatusDetails;

    private java.lang.Long lastSyncTime;

    private java.lang.String oidcEndPointId;

    private java.util.List<com.vmware.nsx.model.ErrorInfo> registrationErrors;

    private java.lang.String registrationStatus;

    private java.lang.String version;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ComputeManagerStatus() {
    }

    protected ComputeManagerStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Errors when connecting with compute manager
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ErrorInfo> getConnectionErrors() {
        return this.connectionErrors;
    }

    /**
     * Errors when connecting with compute manager
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param connectionErrors New value for the property.
     */
    public void setConnectionErrors(java.util.List<com.vmware.nsx.model.ErrorInfo> connectionErrors) {
        this.connectionErrors = connectionErrors;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#CONNECTION_STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#CONNECTION_STATUS_DOWN}</li> <li>
     * {@link
     * com.vmware.nsx.model.ComputeManagerStatus#CONNECTION_STATUS_CONNECTING}</li>
     * </ul> Status of connection with the compute manager
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getConnectionStatus() {
        return this.connectionStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#CONNECTION_STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#CONNECTION_STATUS_DOWN}</li> <li>
     * {@link
     * com.vmware.nsx.model.ComputeManagerStatus#CONNECTION_STATUS_CONNECTING}</li>
     * </ul> Status of connection with the compute manager
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param connectionStatus New value for the property.
     */
    public void setConnectionStatus(java.lang.String connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    /**
     * Details about connection status
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getConnectionStatusDetails() {
        return this.connectionStatusDetails;
    }

    /**
     * Details about connection status
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param connectionStatusDetails New value for the property.
     */
    public void setConnectionStatusDetails(java.lang.String connectionStatusDetails) {
        this.connectionStatusDetails = connectionStatusDetails;
    }

    /**
     * Timestamp of the last successful update of Inventory, in epoch milliseconds.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastSyncTime() {
        return this.lastSyncTime;
    }

    /**
     * Timestamp of the last successful update of Inventory, in epoch milliseconds.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastSyncTime New value for the property.
     */
    public void setLastSyncTime(java.lang.Long lastSyncTime) {
        this.lastSyncTime = lastSyncTime;
    }

    /**
     * If Compute manager is trusted as authorization server, then this Id will be Id
     * of corresponding oidc end point.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOidcEndPointId() {
        return this.oidcEndPointId;
    }

    /**
     * If Compute manager is trusted as authorization server, then this Id will be Id
     * of corresponding oidc end point.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param oidcEndPointId New value for the property.
     */
    public void setOidcEndPointId(java.lang.String oidcEndPointId) {
        this.oidcEndPointId = oidcEndPointId;
    }

    /**
     * Errors when registering with compute manager
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ErrorInfo> getRegistrationErrors() {
        return this.registrationErrors;
    }

    /**
     * Errors when registering with compute manager
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param registrationErrors New value for the property.
     */
    public void setRegistrationErrors(java.util.List<com.vmware.nsx.model.ErrorInfo> registrationErrors) {
        this.registrationErrors = registrationErrors;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_REGISTERED}</li>
     * <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_UNREGISTERED}</li>
     * <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_REGISTERING}</li>
     * <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_REGISTERED_WITH_ERRORS}</li>
     * </ul> Registration status of compute manager
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRegistrationStatus() {
        return this.registrationStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_REGISTERED}</li>
     * <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_UNREGISTERED}</li>
     * <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_REGISTERING}</li>
     * <li> {@link
     * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_REGISTERED_WITH_ERRORS}</li>
     * </ul> Registration status of compute manager
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param registrationStatus New value for the property.
     */
    public void setRegistrationStatus(java.lang.String registrationStatus) {
        this.registrationStatus = registrationStatus;
    }

    /**
     * Version of the compute manager
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVersion() {
        return this.version;
    }

    /**
     * Version of the compute manager
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param version New value for the property.
     */
    public void setVersion(java.lang.String version) {
        this.version = version;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.computeManagerStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("connection_errors",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectionErrors, this._getType().getField("connection_errors")));
        structValue.setField("connection_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectionStatus, this._getType().getField("connection_status")));
        structValue.setField("connection_status_details",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectionStatusDetails, this._getType().getField("connection_status_details")));
        structValue.setField("last_sync_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastSyncTime, this._getType().getField("last_sync_time")));
        structValue.setField("oidc_end_point_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.oidcEndPointId, this._getType().getField("oidc_end_point_id")));
        structValue.setField("registration_errors",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.registrationErrors, this._getType().getField("registration_errors")));
        structValue.setField("registration_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.registrationStatus, this._getType().getField("registration_status")));
        structValue.setField("version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.version, this._getType().getField("version")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.computeManagerStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.computeManagerStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ComputeManagerStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ComputeManagerStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ComputeManagerStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ComputeManagerStatus(structValue);
    }

    /**
     * Builder class for {@link ComputeManagerStatus}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.ErrorInfo> connectionErrors;
        private java.lang.String connectionStatus;
        private java.lang.String connectionStatusDetails;
        private java.lang.Long lastSyncTime;
        private java.lang.String oidcEndPointId;
        private java.util.List<com.vmware.nsx.model.ErrorInfo> registrationErrors;
        private java.lang.String registrationStatus;
        private java.lang.String version;

        /**
         * Constructor with parameters for the required properties of
         * {@link ComputeManagerStatus}.
         */
        public Builder() {
        }

        /**
         * Errors when connecting with compute manager
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param connectionErrors New value for the property.
         */
        public Builder setConnectionErrors(java.util.List<com.vmware.nsx.model.ErrorInfo> connectionErrors) {
            this.connectionErrors = connectionErrors;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.ComputeManagerStatus#CONNECTION_STATUS_UP}</li> <li> {@link
         * com.vmware.nsx.model.ComputeManagerStatus#CONNECTION_STATUS_DOWN}</li> <li>
         * {@link
         * com.vmware.nsx.model.ComputeManagerStatus#CONNECTION_STATUS_CONNECTING}</li>
         * </ul> Status of connection with the compute manager
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param connectionStatus New value for the property.
         */
        public Builder setConnectionStatus(java.lang.String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        /**
         * Details about connection status
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param connectionStatusDetails New value for the property.
         */
        public Builder setConnectionStatusDetails(java.lang.String connectionStatusDetails) {
            this.connectionStatusDetails = connectionStatusDetails;
            return this;
        }

        /**
         * Timestamp of the last successful update of Inventory, in epoch milliseconds.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastSyncTime New value for the property.
         */
        public Builder setLastSyncTime(java.lang.Long lastSyncTime) {
            this.lastSyncTime = lastSyncTime;
            return this;
        }

        /**
         * If Compute manager is trusted as authorization server, then this Id will be Id
         * of corresponding oidc end point.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param oidcEndPointId New value for the property.
         */
        public Builder setOidcEndPointId(java.lang.String oidcEndPointId) {
            this.oidcEndPointId = oidcEndPointId;
            return this;
        }

        /**
         * Errors when registering with compute manager
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param registrationErrors New value for the property.
         */
        public Builder setRegistrationErrors(java.util.List<com.vmware.nsx.model.ErrorInfo> registrationErrors) {
            this.registrationErrors = registrationErrors;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_REGISTERED}</li>
         * <li> {@link
         * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_UNREGISTERED}</li>
         * <li> {@link
         * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_REGISTERING}</li>
         * <li> {@link
         * com.vmware.nsx.model.ComputeManagerStatus#REGISTRATION_STATUS_REGISTERED_WITH_ERRORS}</li>
         * </ul> Registration status of compute manager
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param registrationStatus New value for the property.
         */
        public Builder setRegistrationStatus(java.lang.String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        /**
         * Version of the compute manager
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param version New value for the property.
         */
        public Builder setVersion(java.lang.String version) {
            this.version = version;
            return this;
        }

        public ComputeManagerStatus build() {
            ComputeManagerStatus result = new ComputeManagerStatus();
            result.setConnectionErrors(this.connectionErrors);
            result.setConnectionStatus(this.connectionStatus);
            result.setConnectionStatusDetails(this.connectionStatusDetails);
            result.setLastSyncTime(this.lastSyncTime);
            result.setOidcEndPointId(this.oidcEndPointId);
            result.setRegistrationErrors(this.registrationErrors);
            result.setRegistrationStatus(this.registrationStatus);
            result.setVersion(this.version);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("connection_errors", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.errorInfo; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connection_errors",
                                                                                "connectionErrors",
                                                                                "getConnectionErrors",
                                                                                "setConnectionErrors");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connection_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connection_status",
                                                                                "connectionStatus",
                                                                                "getConnectionStatus",
                                                                                "setConnectionStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connection_status_details", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connection_status_details",
                                                                                "connectionStatusDetails",
                                                                                "getConnectionStatusDetails",
                                                                                "setConnectionStatusDetails");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("last_sync_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("last_sync_time",
                                                                                "lastSyncTime",
                                                                                "getLastSyncTime",
                                                                                "setLastSyncTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("oidc_end_point_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("oidc_end_point_id",
                                                                                "oidcEndPointId",
                                                                                "getOidcEndPointId",
                                                                                "setOidcEndPointId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("registration_errors", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.errorInfo; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("registration_errors",
                                                                                "registrationErrors",
                                                                                "getRegistrationErrors",
                                                                                "setRegistrationErrors");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("registration_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("registration_status",
                                                                                "registrationStatus",
                                                                                "getRegistrationStatus",
                                                                                "setRegistrationStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("version",
                                                                                "version",
                                                                                "getVersion",
                                                                                "setVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.compute_manager_status",
                                                            fields,
                                                            com.vmware.nsx.model.ComputeManagerStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

