/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Listener embodies the concept of a logical endpoint where a Gateway accepts
 * network connections.
 */
public final class ContainerGatewayListener implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String PROTOCOL_HTTP = "HTTP";

    public static final java.lang.String PROTOCOL_HTTPS = "HTTPS";

    public static final java.lang.String PROTOCOL_TCP = "TCP";

    public static final java.lang.String PROTOCOL_TLS = "TLS";

    public static final java.lang.String PROTOCOL_UDP = "UDP";

    private java.lang.String hostname;

    private java.lang.String name;

    private java.lang.Long port;

    private java.lang.String protocol;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ContainerGatewayListener() {
    }

    protected ContainerGatewayListener(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Specifies the virtual hostname to match for protocol type.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostname() {
        return this.hostname;
    }

    /**
     * Specifies the virtual hostname to match for protocol type.
     *
     * @param hostname New value for the property.
     */
    public void setHostname(java.lang.String hostname) {
        this.hostname = hostname;
    }

    /**
     * Specifies name of gateway listener
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * Specifies name of gateway listener
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Specifies network port of gateway. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPort() {
        return this.port;
    }

    /**
     * Specifies network port of gateway. format: int64
     *
     * @param port New value for the property.
     */
    public void setPort(java.lang.Long port) {
        this.port = port;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_HTTP}</li> <li> {@link
     * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_HTTPS}</li> <li> {@link
     * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_TCP}</li> <li> {@link
     * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_TLS}</li> <li> {@link
     * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_UDP}</li> </ul> Specifies
     * the network protocol this listener expects to receive. e.g. HTTP，HTTPS，TCP, TLS,
     * UDP.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtocol() {
        return this.protocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_HTTP}</li> <li> {@link
     * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_HTTPS}</li> <li> {@link
     * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_TCP}</li> <li> {@link
     * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_TLS}</li> <li> {@link
     * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_UDP}</li> </ul> Specifies
     * the network protocol this listener expects to receive. e.g. HTTP，HTTPS，TCP, TLS,
     * UDP.
     *
     * @param protocol New value for the property.
     */
    public void setProtocol(java.lang.String protocol) {
        this.protocol = protocol;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.containerGatewayListener;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("hostname",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostname, this._getType().getField("hostname")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.port, this._getType().getField("port")));
        structValue.setField("protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protocol, this._getType().getField("protocol")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.containerGatewayListener;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.containerGatewayListener.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ContainerGatewayListener _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ContainerGatewayListener(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ContainerGatewayListener _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ContainerGatewayListener(structValue);
    }

    /**
     * Builder class for {@link ContainerGatewayListener}.
     */
    public static final class Builder {
        private java.lang.String hostname;
        private java.lang.String name;
        private java.lang.Long port;
        private java.lang.String protocol;

        /**
         * Constructor with parameters for the required properties of
         * {@link ContainerGatewayListener}.
         */
        public Builder() {
        }

        /**
         * Specifies the virtual hostname to match for protocol type.
         *
         * @param hostname New value for the property.
         */
        public Builder setHostname(java.lang.String hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * Specifies name of gateway listener
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Specifies network port of gateway. format: int64
         *
         * @param port New value for the property.
         */
        public Builder setPort(java.lang.Long port) {
            this.port = port;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_HTTP}</li> <li> {@link
         * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_HTTPS}</li> <li> {@link
         * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_TCP}</li> <li> {@link
         * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_TLS}</li> <li> {@link
         * com.vmware.nsx.model.ContainerGatewayListener#PROTOCOL_UDP}</li> </ul> Specifies
         * the network protocol this listener expects to receive. e.g. HTTP，HTTPS，TCP, TLS,
         * UDP.
         *
         * @param protocol New value for the property.
         */
        public Builder setProtocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        public ContainerGatewayListener build() {
            ContainerGatewayListener result = new ContainerGatewayListener();
            result.setHostname(this.hostname);
            result.setName(this.name);
            result.setPort(this.port);
            result.setProtocol(this.protocol);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("hostname", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hostname",
                                                                                "hostname",
                                                                                "getHostname",
                                                                                "setHostname");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port",
                                                                                "port",
                                                                                "getPort",
                                                                                "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("protocol",
                                                                                "protocol",
                                                                                "getProtocol",
                                                                                "setProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.container_gateway_listener",
                                                            fields,
                                                            com.vmware.nsx.model.ContainerGatewayListener.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

