/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Firewall to use TTL config to manage firewall cache to expire snooped FQDN
 * entries from DNS response.
 */
public final class DnsTtlConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String DNS_TTL_TYPE_USE_TTL = "USE_TTL";

    public static final java.lang.String DNS_TTL_TYPE_AUTO = "AUTO";

    public static final java.lang.String DNS_TTL_TYPE_NEVER_EXPIRE = "NEVER_EXPIRE";

    private java.lang.String dnsTtlType;

    private java.lang.Long ttl;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DnsTtlConfig() {
    }

    protected DnsTtlConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.DnsTtlConfig#DNS_TTL_TYPE_USE_TTL}</li> <li> {@link
     * com.vmware.nsx.model.DnsTtlConfig#DNS_TTL_TYPE_AUTO}</li> <li> {@link
     * com.vmware.nsx.model.DnsTtlConfig#DNS_TTL_TYPE_NEVER_EXPIRE}</li> </ul> TTL type
     * to decide how to manage ttl.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDnsTtlType() {
        return this.dnsTtlType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.DnsTtlConfig#DNS_TTL_TYPE_USE_TTL}</li> <li> {@link
     * com.vmware.nsx.model.DnsTtlConfig#DNS_TTL_TYPE_AUTO}</li> <li> {@link
     * com.vmware.nsx.model.DnsTtlConfig#DNS_TTL_TYPE_NEVER_EXPIRE}</li> </ul> TTL type
     * to decide how to manage ttl.
     *
     * @param dnsTtlType New value for the property.
     */
    public void setDnsTtlType(java.lang.String dnsTtlType) {
        this.dnsTtlType = dnsTtlType;
    }

    /**
     * The number of seconds that snooped DNS responses are retained in the cache. Used
     * only when dns_ttl_type is USE_TTL. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTtl() {
        return this.ttl;
    }

    /**
     * The number of seconds that snooped DNS responses are retained in the cache. Used
     * only when dns_ttl_type is USE_TTL. format: int64
     *
     * @param ttl New value for the property.
     */
    public void setTtl(java.lang.Long ttl) {
        this.ttl = ttl;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.dnsTtlConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dns_ttl_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsTtlType, this._getType().getField("dns_ttl_type")));
        structValue.setField("ttl",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ttl, this._getType().getField("ttl")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.dnsTtlConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.dnsTtlConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DnsTtlConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DnsTtlConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DnsTtlConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DnsTtlConfig(structValue);
    }

    /**
     * Builder class for {@link DnsTtlConfig}.
     */
    public static final class Builder {
        private java.lang.String dnsTtlType;
        private java.lang.Long ttl;

        /**
         * Constructor with parameters for the required properties of
         * {@link DnsTtlConfig}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.DnsTtlConfig#DNS_TTL_TYPE_USE_TTL}</li> <li> {@link
         * com.vmware.nsx.model.DnsTtlConfig#DNS_TTL_TYPE_AUTO}</li> <li> {@link
         * com.vmware.nsx.model.DnsTtlConfig#DNS_TTL_TYPE_NEVER_EXPIRE}</li> </ul> TTL type
         * to decide how to manage ttl.
         *
         * @param dnsTtlType New value for the property.
         */
        public Builder setDnsTtlType(java.lang.String dnsTtlType) {
            this.dnsTtlType = dnsTtlType;
            return this;
        }

        /**
         * The number of seconds that snooped DNS responses are retained in the cache. Used
         * only when dns_ttl_type is USE_TTL. format: int64
         *
         * @param ttl New value for the property.
         */
        public Builder setTtl(java.lang.Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public DnsTtlConfig build() {
            DnsTtlConfig result = new DnsTtlConfig();
            result.setDnsTtlType(this.dnsTtlType);
            result.setTtl(this.ttl);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dns_ttl_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_ttl_type",
                                                                                "dnsTtlType",
                                                                                "getDnsTtlType",
                                                                                "setDnsTtlType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ttl", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ttl",
                                                                                "ttl",
                                                                                "getTtl",
                                                                                "setTtl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.dns_ttl_config",
                                                            fields,
                                                            com.vmware.nsx.model.DnsTtlConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

