/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * IPSec VPN tunnel profile is a reusable profile that captures phase two
 * negotiation parameters and tunnel properties. Any changes affects all IPSec VPN
 * sessions consuming this profile.
 */
public final class IPSecVPNTunnelProfile implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String DF_POLICY_COPY = "COPY";

    public static final java.lang.String DF_POLICY_CLEAR = "CLEAR";

    public static final java.lang.String DH_GROUPS_GROUP2 = "GROUP2";

    public static final java.lang.String DH_GROUPS_GROUP5 = "GROUP5";

    public static final java.lang.String DH_GROUPS_GROUP14 = "GROUP14";

    public static final java.lang.String DH_GROUPS_GROUP15 = "GROUP15";

    public static final java.lang.String DH_GROUPS_GROUP16 = "GROUP16";

    public static final java.lang.String DH_GROUPS_GROUP19 = "GROUP19";

    public static final java.lang.String DH_GROUPS_GROUP20 = "GROUP20";

    public static final java.lang.String DH_GROUPS_GROUP21 = "GROUP21";

    public static final java.lang.String DIGEST_ALGORITHMS_SHA1 = "SHA1";

    public static final java.lang.String DIGEST_ALGORITHMS_SHA2_256 = "SHA2_256";

    public static final java.lang.String DIGEST_ALGORITHMS_SHA2_384 = "SHA2_384";

    public static final java.lang.String DIGEST_ALGORITHMS_SHA2_512 = "SHA2_512";

    public static final java.lang.String ENCAPSULATION_MODE_MODE = "TUNNEL_MODE";

    public static final java.lang.String ENCRYPTION_ALGORITHMS_AES_128 = "AES_128";

    public static final java.lang.String ENCRYPTION_ALGORITHMS_AES_256 = "AES_256";

    public static final java.lang.String ENCRYPTION_ALGORITHMS_AES_GCM_128 = "AES_GCM_128";

    public static final java.lang.String ENCRYPTION_ALGORITHMS_AES_GCM_192 = "AES_GCM_192";

    public static final java.lang.String ENCRYPTION_ALGORITHMS_AES_GCM_256 = "AES_GCM_256";

    public static final java.lang.String ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_128 = "NO_ENCRYPTION_AUTH_AES_GMAC_128";

    public static final java.lang.String ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_192 = "NO_ENCRYPTION_AUTH_AES_GMAC_192";

    public static final java.lang.String ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_256 = "NO_ENCRYPTION_AUTH_AES_GMAC_256";

    public static final java.lang.String ENCRYPTION_ALGORITHMS_NO_ENCRYPTION = "NO_ENCRYPTION";

    public static final java.lang.String TRANSFORM_PROTOCOL_ESP = "ESP";

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    private java.lang.String dfPolicy;

    private java.util.List<java.lang.String> dhGroups;

    private java.util.List<java.lang.String> digestAlgorithms;

    private java.lang.Boolean enablePerfectForwardSecrecy;

    private java.lang.String encapsulationMode;

    private java.util.List<java.lang.String> encryptionAlgorithms;

    private java.lang.Long saLifeTime;

    private java.lang.String transformProtocol;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IPSecVPNTunnelProfile() {
    }

    protected IPSecVPNTunnelProfile(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DF_POLICY_COPY}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DF_POLICY_CLEAR}</li> </ul>
     * Defragmentation policy helps to handle defragmentation bit present in the inner
     * packet. COPY copies the defragmentation bit from the inner IP packet into the
     * outer packet. CLEAR ignores the defragmentation bit present in the inner packet.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDfPolicy() {
        return this.dfPolicy;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DF_POLICY_COPY}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DF_POLICY_CLEAR}</li> </ul>
     * Defragmentation policy helps to handle defragmentation bit present in the inner
     * packet. COPY copies the defragmentation bit from the inner IP packet into the
     * outer packet. CLEAR ignores the defragmentation bit present in the inner packet.
     *
     * @param dfPolicy New value for the property.
     */
    public void setDfPolicy(java.lang.String dfPolicy) {
        this.dfPolicy = dfPolicy;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP2}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP5}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP14}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP15}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP16}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP19}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP20}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP21}</li> </ul>
     * Diffie-Hellman group to be used if PFS is enabled. Default is GROUP14.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDhGroups() {
        return this.dhGroups;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP2}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP5}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP14}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP15}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP16}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP19}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP20}</li> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP21}</li> </ul>
     * Diffie-Hellman group to be used if PFS is enabled. Default is GROUP14.
     *
     * @param dhGroups New value for the property.
     */
    public void setDhGroups(java.util.List<java.lang.String> dhGroups) {
        this.dhGroups = dhGroups;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA1}</li> <li>
     * {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA2_256}</li> <li>
     * {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA2_384}</li> <li>
     * {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA2_512}</li>
     * </ul> Algorithm to be used for message digest. Default digest algorithm is
     * implicitly covered by default encryption algorithm \"AES_GCM_128\".
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA1}</li> <li>
     * {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA2_256}</li> <li>
     * {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA2_384}</li> <li>
     * {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA2_512}</li>
     * </ul> Algorithm to be used for message digest. Default digest algorithm is
     * implicitly covered by default encryption algorithm \"AES_GCM_128\".
     *
     * @param digestAlgorithms New value for the property.
     */
    public void setDigestAlgorithms(java.util.List<java.lang.String> digestAlgorithms) {
        this.digestAlgorithms = digestAlgorithms;
    }

    /**
     * If true, perfect forward secrecy (PFS) is enabled.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnablePerfectForwardSecrecy() {
        return this.enablePerfectForwardSecrecy;
    }

    /**
     * If true, perfect forward secrecy (PFS) is enabled.
     *
     * @param enablePerfectForwardSecrecy New value for the property.
     */
    public void setEnablePerfectForwardSecrecy(java.lang.Boolean enablePerfectForwardSecrecy) {
        this.enablePerfectForwardSecrecy = enablePerfectForwardSecrecy;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCAPSULATION_MODE_MODE}</li> </ul>
     * Encapsulation Mode to be used for encryption of packet. Tunnel mode protects
     * internal routing information by encrypting IP header of original packet.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEncapsulationMode() {
        return this.encapsulationMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCAPSULATION_MODE_MODE}</li> </ul>
     * Encapsulation Mode to be used for encryption of packet. Tunnel mode protects
     * internal routing information by encrypting IP header of original packet.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param encapsulationMode New value for the property.
     */
    public void setEncapsulationMode(java.lang.String encapsulationMode) {
        this.encapsulationMode = encapsulationMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_128}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_256}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_GCM_128}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_GCM_192}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_GCM_256}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_128}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_192}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_256}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION}</li>
     * </ul> Encryption algorithm to encrypt/decrypt the messages exchanged between
     * IPSec VPN initiator and responder during tunnel negotiation. Default is
     * AES_GCM_128.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getEncryptionAlgorithms() {
        return this.encryptionAlgorithms;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_128}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_256}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_GCM_128}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_GCM_192}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_GCM_256}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_128}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_192}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_256}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION}</li>
     * </ul> Encryption algorithm to encrypt/decrypt the messages exchanged between
     * IPSec VPN initiator and responder during tunnel negotiation. Default is
     * AES_GCM_128.
     *
     * @param encryptionAlgorithms New value for the property.
     */
    public void setEncryptionAlgorithms(java.util.List<java.lang.String> encryptionAlgorithms) {
        this.encryptionAlgorithms = encryptionAlgorithms;
    }

    /**
     * SA life time specifies the expiry time of security association. Default is 3600
     * seconds. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSaLifeTime() {
        return this.saLifeTime;
    }

    /**
     * SA life time specifies the expiry time of security association. Default is 3600
     * seconds. format: int64
     *
     * @param saLifeTime New value for the property.
     */
    public void setSaLifeTime(java.lang.Long saLifeTime) {
        this.saLifeTime = saLifeTime;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#TRANSFORM_PROTOCOL_ESP}</li> </ul>
     * IPSec transform specifies IPSec security protocol.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransformProtocol() {
        return this.transformProtocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelProfile#TRANSFORM_PROTOCOL_ESP}</li> </ul>
     * IPSec transform specifies IPSec security protocol.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param transformProtocol New value for the property.
     */
    public void setTransformProtocol(java.lang.String transformProtocol) {
        this.transformProtocol = transformProtocol;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.IPSecVPNTunnelProfile;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("df_policy",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dfPolicy, this._getType().getField("df_policy")));
        structValue.setField("dh_groups",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhGroups, this._getType().getField("dh_groups")));
        structValue.setField("digest_algorithms",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.digestAlgorithms, this._getType().getField("digest_algorithms")));
        structValue.setField("enable_perfect_forward_secrecy",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enablePerfectForwardSecrecy, this._getType().getField("enable_perfect_forward_secrecy")));
        structValue.setField("encapsulation_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.encapsulationMode, this._getType().getField("encapsulation_mode")));
        structValue.setField("encryption_algorithms",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.encryptionAlgorithms, this._getType().getField("encryption_algorithms")));
        structValue.setField("sa_life_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.saLifeTime, this._getType().getField("sa_life_time")));
        structValue.setField("transform_protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transformProtocol, this._getType().getField("transform_protocol")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.IPSecVPNTunnelProfile;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.IPSecVPNTunnelProfile.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IPSecVPNTunnelProfile _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IPSecVPNTunnelProfile(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IPSecVPNTunnelProfile _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IPSecVPNTunnelProfile(structValue);
    }

    /**
     * Builder class for {@link IPSecVPNTunnelProfile}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx.model.Tag> tags;
        private java.lang.String dfPolicy;
        private java.util.List<java.lang.String> dhGroups;
        private java.util.List<java.lang.String> digestAlgorithms;
        private java.lang.Boolean enablePerfectForwardSecrecy;
        private java.lang.String encapsulationMode;
        private java.util.List<java.lang.String> encryptionAlgorithms;
        private java.lang.Long saLifeTime;
        private java.lang.String transformProtocol;

        /**
         * Constructor with parameters for the required properties of
         * {@link IPSecVPNTunnelProfile}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DF_POLICY_COPY}</li> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DF_POLICY_CLEAR}</li> </ul>
         * Defragmentation policy helps to handle defragmentation bit present in the inner
         * packet. COPY copies the defragmentation bit from the inner IP packet into the
         * outer packet. CLEAR ignores the defragmentation bit present in the inner packet.
         *
         * @param dfPolicy New value for the property.
         */
        public Builder setDfPolicy(java.lang.String dfPolicy) {
            this.dfPolicy = dfPolicy;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP2}</li> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP5}</li> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP14}</li> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP15}</li> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP16}</li> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP19}</li> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP20}</li> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DH_GROUPS_GROUP21}</li> </ul>
         * Diffie-Hellman group to be used if PFS is enabled. Default is GROUP14.
         *
         * @param dhGroups New value for the property.
         */
        public Builder setDhGroups(java.util.List<java.lang.String> dhGroups) {
            this.dhGroups = dhGroups;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA1}</li> <li>
         * {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA2_256}</li> <li>
         * {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA2_384}</li> <li>
         * {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#DIGEST_ALGORITHMS_SHA2_512}</li>
         * </ul> Algorithm to be used for message digest. Default digest algorithm is
         * implicitly covered by default encryption algorithm \"AES_GCM_128\".
         *
         * @param digestAlgorithms New value for the property.
         */
        public Builder setDigestAlgorithms(java.util.List<java.lang.String> digestAlgorithms) {
            this.digestAlgorithms = digestAlgorithms;
            return this;
        }

        /**
         * If true, perfect forward secrecy (PFS) is enabled.
         *
         * @param enablePerfectForwardSecrecy New value for the property.
         */
        public Builder setEnablePerfectForwardSecrecy(java.lang.Boolean enablePerfectForwardSecrecy) {
            this.enablePerfectForwardSecrecy = enablePerfectForwardSecrecy;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCAPSULATION_MODE_MODE}</li> </ul>
         * Encapsulation Mode to be used for encryption of packet. Tunnel mode protects
         * internal routing information by encrypting IP header of original packet.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param encapsulationMode New value for the property.
         */
        public Builder setEncapsulationMode(java.lang.String encapsulationMode) {
            this.encapsulationMode = encapsulationMode;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_128}</li>
         * <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_256}</li>
         * <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_GCM_128}</li>
         * <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_GCM_192}</li>
         * <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_AES_GCM_256}</li>
         * <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_128}</li>
         * <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_192}</li>
         * <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION_AUTH_AES_GMAC_256}</li>
         * <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#ENCRYPTION_ALGORITHMS_NO_ENCRYPTION}</li>
         * </ul> Encryption algorithm to encrypt/decrypt the messages exchanged between
         * IPSec VPN initiator and responder during tunnel negotiation. Default is
         * AES_GCM_128.
         *
         * @param encryptionAlgorithms New value for the property.
         */
        public Builder setEncryptionAlgorithms(java.util.List<java.lang.String> encryptionAlgorithms) {
            this.encryptionAlgorithms = encryptionAlgorithms;
            return this;
        }

        /**
         * SA life time specifies the expiry time of security association. Default is 3600
         * seconds. format: int64
         *
         * @param saLifeTime New value for the property.
         */
        public Builder setSaLifeTime(java.lang.Long saLifeTime) {
            this.saLifeTime = saLifeTime;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelProfile#TRANSFORM_PROTOCOL_ESP}</li> </ul>
         * IPSec transform specifies IPSec security protocol.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param transformProtocol New value for the property.
         */
        public Builder setTransformProtocol(java.lang.String transformProtocol) {
            this.transformProtocol = transformProtocol;
            return this;
        }

        public IPSecVPNTunnelProfile build() {
            IPSecVPNTunnelProfile result = new IPSecVPNTunnelProfile();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setDfPolicy(this.dfPolicy);
            result.setDhGroups(this.dhGroups);
            result.setDigestAlgorithms(this.digestAlgorithms);
            result.setEnablePerfectForwardSecrecy(this.enablePerfectForwardSecrecy);
            result.setEncapsulationMode(this.encapsulationMode);
            result.setEncryptionAlgorithms(this.encryptionAlgorithms);
            result.setSaLifeTime(this.saLifeTime);
            result.setTransformProtocol(this.transformProtocol);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("df_policy", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("df_policy",
                                                                                "dfPolicy",
                                                                                "getDfPolicy",
                                                                                "setDfPolicy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dh_groups", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dh_groups",
                                                                                "dhGroups",
                                                                                "getDhGroups",
                                                                                "setDhGroups");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("digest_algorithms", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("digest_algorithms",
                                                                                "digestAlgorithms",
                                                                                "getDigestAlgorithms",
                                                                                "setDigestAlgorithms");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_perfect_forward_secrecy", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_perfect_forward_secrecy",
                                                                                "enablePerfectForwardSecrecy",
                                                                                "getEnablePerfectForwardSecrecy",
                                                                                "setEnablePerfectForwardSecrecy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("encapsulation_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("encapsulation_mode",
                                                                                "encapsulationMode",
                                                                                "getEncapsulationMode",
                                                                                "setEncapsulationMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("encryption_algorithms", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("encryption_algorithms",
                                                                                "encryptionAlgorithms",
                                                                                "getEncryptionAlgorithms",
                                                                                "setEncryptionAlgorithms");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sa_life_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sa_life_time",
                                                                                "saLifeTime",
                                                                                "getSaLifeTime",
                                                                                "setSaLifeTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transform_protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transform_protocol",
                                                                                "transformProtocol",
                                                                                "getTransformProtocol",
                                                                                "setTransformProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.IP_sec_VPN_tunnel_profile",
                                                            fields,
                                                            com.vmware.nsx.model.IPSecVPNTunnelProfile.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

