/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * IDS event flow data specific to each IDS event. The data includes source ip,
 * source port, destination ip, destination port, protocol, rule id, profile id,
 * and the action.
 */
public final class IdsEventFlowData implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ACTION_TYPE_ALERT = "ALERT";

    public static final java.lang.String ACTION_TYPE_DROP = "DROP";

    public static final java.lang.String ACTION_TYPE_REJECT = "REJECT";

    public static final java.lang.String ACTION_TYPE_INVALID = "INVALID";

    private java.lang.String actionType;

    private java.lang.Long bytesToclient;

    private java.lang.Long bytesToserver;

    private java.lang.String clientIp;

    private java.lang.String destinationIp;

    private java.lang.Long destinationPort;

    private java.lang.String localVmIp;

    private java.lang.String profileId;

    private java.lang.String protocol;

    private java.lang.Long ruleId;

    private java.lang.String sourceIp;

    private java.lang.Long sourcePort;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IdsEventFlowData() {
    }

    protected IdsEventFlowData(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_ALERT}</li> <li> {@link
     * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_DROP}</li> <li> {@link
     * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_REJECT}</li> <li> {@link
     * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_INVALID}</li> </ul> The action
     * pertaining to the detected intrusion. Possible values are ALERT, DROP, REJECT,
     * and INVALID. ALERT - If there is a signature match on the packet, it is allowed
     * to pass but a notification is sent to the user notifying an intrusion was
     * detected. DROP - On a signature match, the packet is silently dropped. An alert
     * is sent to the user that an intrusion was detected. REJECT - On a signature
     * match, the packet is dropped and TCP RST or ICMP error messages (for non-TCP
     * pkts) are sent to the endpoints. An alert is sent to the user that an intrusion
     * was detected. INVALID - If the action doesn't belong to any of the above
     * mentioned categories, it is marked as INVALID.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getActionType() {
        return this.actionType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_ALERT}</li> <li> {@link
     * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_DROP}</li> <li> {@link
     * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_REJECT}</li> <li> {@link
     * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_INVALID}</li> </ul> The action
     * pertaining to the detected intrusion. Possible values are ALERT, DROP, REJECT,
     * and INVALID. ALERT - If there is a signature match on the packet, it is allowed
     * to pass but a notification is sent to the user notifying an intrusion was
     * detected. DROP - On a signature match, the packet is silently dropped. An alert
     * is sent to the user that an intrusion was detected. REJECT - On a signature
     * match, the packet is dropped and TCP RST or ICMP error messages (for non-TCP
     * pkts) are sent to the endpoints. An alert is sent to the user that an intrusion
     * was detected. INVALID - If the action doesn't belong to any of the above
     * mentioned categories, it is marked as INVALID.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param actionType New value for the property.
     */
    public void setActionType(java.lang.String actionType) {
        this.actionType = actionType;
    }

    /**
     * Bytes sent to client. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getBytesToclient() {
        return this.bytesToclient;
    }

    /**
     * Bytes sent to client. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param bytesToclient New value for the property.
     */
    public void setBytesToclient(java.lang.Long bytesToclient) {
        this.bytesToclient = bytesToclient;
    }

    /**
     * Bytes sent to server. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getBytesToserver() {
        return this.bytesToserver;
    }

    /**
     * Bytes sent to server. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param bytesToserver New value for the property.
     */
    public void setBytesToserver(java.lang.Long bytesToserver) {
        this.bytesToserver = bytesToserver;
    }

    /**
     * IP address of the VM that initiated the communication.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientIp() {
        return this.clientIp;
    }

    /**
     * IP address of the VM that initiated the communication.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param clientIp New value for the property.
     */
    public void setClientIp(java.lang.String clientIp) {
        this.clientIp = clientIp;
    }

    /**
     * IP address of the destination VM on the intrusion flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDestinationIp() {
        return this.destinationIp;
    }

    /**
     * IP address of the destination VM on the intrusion flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param destinationIp New value for the property.
     */
    public void setDestinationIp(java.lang.String destinationIp) {
        this.destinationIp = destinationIp;
    }

    /**
     * Port on the destination VM where the traffic was sent to. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDestinationPort() {
        return this.destinationPort;
    }

    /**
     * Port on the destination VM where the traffic was sent to. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param destinationPort New value for the property.
     */
    public void setDestinationPort(java.lang.Long destinationPort) {
        this.destinationPort = destinationPort;
    }

    /**
     * IP address of VM on the host where IDS engine is running.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLocalVmIp() {
        return this.localVmIp;
    }

    /**
     * IP address of VM on the host where IDS engine is running.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param localVmIp New value for the property.
     */
    public void setLocalVmIp(java.lang.String localVmIp) {
        this.localVmIp = localVmIp;
    }

    /**
     * The IDS profile id that is associated with the IDS rule pertaining to the
     * intrusion event detected.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProfileId() {
        return this.profileId;
    }

    /**
     * The IDS profile id that is associated with the IDS rule pertaining to the
     * intrusion event detected.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param profileId New value for the property.
     */
    public void setProfileId(java.lang.String profileId) {
        this.profileId = profileId;
    }

    /**
     * Traffic protocol pertaining to the detected intrusion, could be TCP/UDP etc.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtocol() {
        return this.protocol;
    }

    /**
     * Traffic protocol pertaining to the detected intrusion, could be TCP/UDP etc.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protocol New value for the property.
     */
    public void setProtocol(java.lang.String protocol) {
        this.protocol = protocol;
    }

    /**
     * The IDS Rule id pertaining to the detected intrusion. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRuleId() {
        return this.ruleId;
    }

    /**
     * The IDS Rule id pertaining to the detected intrusion. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ruleId New value for the property.
     */
    public void setRuleId(java.lang.Long ruleId) {
        this.ruleId = ruleId;
    }

    /**
     * IP address of the source VM on the intrusion flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSourceIp() {
        return this.sourceIp;
    }

    /**
     * IP address of the source VM on the intrusion flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sourceIp New value for the property.
     */
    public void setSourceIp(java.lang.String sourceIp) {
        this.sourceIp = sourceIp;
    }

    /**
     * Source port through which traffic was initiated that caused the intrusion to be
     * detected. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSourcePort() {
        return this.sourcePort;
    }

    /**
     * Source port through which traffic was initiated that caused the intrusion to be
     * detected. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sourcePort New value for the property.
     */
    public void setSourcePort(java.lang.Long sourcePort) {
        this.sourcePort = sourcePort;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.idsEventFlowData;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("action_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.actionType, this._getType().getField("action_type")));
        structValue.setField("bytes_toclient",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bytesToclient, this._getType().getField("bytes_toclient")));
        structValue.setField("bytes_toserver",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bytesToserver, this._getType().getField("bytes_toserver")));
        structValue.setField("client_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientIp, this._getType().getField("client_ip")));
        structValue.setField("destination_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.destinationIp, this._getType().getField("destination_ip")));
        structValue.setField("destination_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.destinationPort, this._getType().getField("destination_port")));
        structValue.setField("local_vm_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localVmIp, this._getType().getField("local_vm_ip")));
        structValue.setField("profile_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.profileId, this._getType().getField("profile_id")));
        structValue.setField("protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protocol, this._getType().getField("protocol")));
        structValue.setField("rule_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ruleId, this._getType().getField("rule_id")));
        structValue.setField("source_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourceIp, this._getType().getField("source_ip")));
        structValue.setField("source_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourcePort, this._getType().getField("source_port")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.idsEventFlowData;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.idsEventFlowData.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IdsEventFlowData _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IdsEventFlowData(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IdsEventFlowData _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IdsEventFlowData(structValue);
    }

    /**
     * Builder class for {@link IdsEventFlowData}.
     */
    public static final class Builder {
        private java.lang.String actionType;
        private java.lang.Long bytesToclient;
        private java.lang.Long bytesToserver;
        private java.lang.String clientIp;
        private java.lang.String destinationIp;
        private java.lang.Long destinationPort;
        private java.lang.String localVmIp;
        private java.lang.String profileId;
        private java.lang.String protocol;
        private java.lang.Long ruleId;
        private java.lang.String sourceIp;
        private java.lang.Long sourcePort;

        /**
         * Constructor with parameters for the required properties of
         * {@link IdsEventFlowData}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_ALERT}</li> <li> {@link
         * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_DROP}</li> <li> {@link
         * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_REJECT}</li> <li> {@link
         * com.vmware.nsx.model.IdsEventFlowData#ACTION_TYPE_INVALID}</li> </ul> The action
         * pertaining to the detected intrusion. Possible values are ALERT, DROP, REJECT,
         * and INVALID. ALERT - If there is a signature match on the packet, it is allowed
         * to pass but a notification is sent to the user notifying an intrusion was
         * detected. DROP - On a signature match, the packet is silently dropped. An alert
         * is sent to the user that an intrusion was detected. REJECT - On a signature
         * match, the packet is dropped and TCP RST or ICMP error messages (for non-TCP
         * pkts) are sent to the endpoints. An alert is sent to the user that an intrusion
         * was detected. INVALID - If the action doesn't belong to any of the above
         * mentioned categories, it is marked as INVALID.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param actionType New value for the property.
         */
        public Builder setActionType(java.lang.String actionType) {
            this.actionType = actionType;
            return this;
        }

        /**
         * Bytes sent to client. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param bytesToclient New value for the property.
         */
        public Builder setBytesToclient(java.lang.Long bytesToclient) {
            this.bytesToclient = bytesToclient;
            return this;
        }

        /**
         * Bytes sent to server. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param bytesToserver New value for the property.
         */
        public Builder setBytesToserver(java.lang.Long bytesToserver) {
            this.bytesToserver = bytesToserver;
            return this;
        }

        /**
         * IP address of the VM that initiated the communication.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param clientIp New value for the property.
         */
        public Builder setClientIp(java.lang.String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        /**
         * IP address of the destination VM on the intrusion flow.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param destinationIp New value for the property.
         */
        public Builder setDestinationIp(java.lang.String destinationIp) {
            this.destinationIp = destinationIp;
            return this;
        }

        /**
         * Port on the destination VM where the traffic was sent to. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param destinationPort New value for the property.
         */
        public Builder setDestinationPort(java.lang.Long destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        /**
         * IP address of VM on the host where IDS engine is running.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param localVmIp New value for the property.
         */
        public Builder setLocalVmIp(java.lang.String localVmIp) {
            this.localVmIp = localVmIp;
            return this;
        }

        /**
         * The IDS profile id that is associated with the IDS rule pertaining to the
         * intrusion event detected.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param profileId New value for the property.
         */
        public Builder setProfileId(java.lang.String profileId) {
            this.profileId = profileId;
            return this;
        }

        /**
         * Traffic protocol pertaining to the detected intrusion, could be TCP/UDP etc.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protocol New value for the property.
         */
        public Builder setProtocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * The IDS Rule id pertaining to the detected intrusion. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ruleId New value for the property.
         */
        public Builder setRuleId(java.lang.Long ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        /**
         * IP address of the source VM on the intrusion flow.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sourceIp New value for the property.
         */
        public Builder setSourceIp(java.lang.String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        /**
         * Source port through which traffic was initiated that caused the intrusion to be
         * detected. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sourcePort New value for the property.
         */
        public Builder setSourcePort(java.lang.Long sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        public IdsEventFlowData build() {
            IdsEventFlowData result = new IdsEventFlowData();
            result.setActionType(this.actionType);
            result.setBytesToclient(this.bytesToclient);
            result.setBytesToserver(this.bytesToserver);
            result.setClientIp(this.clientIp);
            result.setDestinationIp(this.destinationIp);
            result.setDestinationPort(this.destinationPort);
            result.setLocalVmIp(this.localVmIp);
            result.setProfileId(this.profileId);
            result.setProtocol(this.protocol);
            result.setRuleId(this.ruleId);
            result.setSourceIp(this.sourceIp);
            result.setSourcePort(this.sourcePort);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("action_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("action_type",
                                                                                "actionType",
                                                                                "getActionType",
                                                                                "setActionType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bytes_toclient", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bytes_toclient",
                                                                                "bytesToclient",
                                                                                "getBytesToclient",
                                                                                "setBytesToclient");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bytes_toserver", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bytes_toserver",
                                                                                "bytesToserver",
                                                                                "getBytesToserver",
                                                                                "setBytesToserver");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_ip",
                                                                                "clientIp",
                                                                                "getClientIp",
                                                                                "setClientIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("destination_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("destination_ip",
                                                                                "destinationIp",
                                                                                "getDestinationIp",
                                                                                "setDestinationIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("destination_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("destination_port",
                                                                                "destinationPort",
                                                                                "getDestinationPort",
                                                                                "setDestinationPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("local_vm_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("local_vm_ip",
                                                                                "localVmIp",
                                                                                "getLocalVmIp",
                                                                                "setLocalVmIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("profile_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("profile_id",
                                                                                "profileId",
                                                                                "getProfileId",
                                                                                "setProfileId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("protocol",
                                                                                "protocol",
                                                                                "getProtocol",
                                                                                "setProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rule_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rule_id",
                                                                                "ruleId",
                                                                                "getRuleId",
                                                                                "setRuleId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_ip",
                                                                                "sourceIp",
                                                                                "getSourceIp",
                                                                                "setSourceIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_port",
                                                                                "sourcePort",
                                                                                "getSourcePort",
                                                                                "setSourcePort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.ids_event_flow_data",
                                                            fields,
                                                            com.vmware.nsx.model.IdsEventFlowData.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

