/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Napp cluster form factor
 */
public final class IntelligenceFormFactor implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String TYPE_EVALUATION = "EVALUATION";

    public static final java.lang.String TYPE_STANDARD = "STANDARD";

    public static final java.lang.String TYPE_ADVANCED = "ADVANCED";

    public static final java.lang.String TYPE_SMALL = "SMALL";

    public static final java.lang.String TYPE_LARGE = "LARGE";

    public static final java.lang.String TYPE_EXTRA_LARGE = "EXTRA_LARGE";

    private java.lang.Long defaultWorkerCount;

    private java.lang.Long disk;

    private java.lang.Long memory;

    private java.lang.String type;

    private java.lang.Long vcpu;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IntelligenceFormFactor() {
    }

    protected IntelligenceFormFactor(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Default number of Napp worker nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDefaultWorkerCount() {
        return this.defaultWorkerCount;
    }

    /**
     * Default number of Napp worker nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param defaultWorkerCount New value for the property.
     */
    public void setDefaultWorkerCount(java.lang.Long defaultWorkerCount) {
        this.defaultWorkerCount = defaultWorkerCount;
    }

    /**
     * Disk size of the Napp worker nodes in GBs. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDisk() {
        return this.disk;
    }

    /**
     * Disk size of the Napp worker nodes in GBs. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param disk New value for the property.
     */
    public void setDisk(java.lang.Long disk) {
        this.disk = disk;
    }

    /**
     * Memory size of the Napp worker nodes in GBs format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMemory() {
        return this.memory;
    }

    /**
     * Memory size of the Napp worker nodes in GBs format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param memory New value for the property.
     */
    public void setMemory(java.lang.Long memory) {
        this.memory = memory;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_EVALUATION}</li> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_STANDARD}</li> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_ADVANCED}</li> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_SMALL}</li> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_LARGE}</li> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_EXTRA_LARGE}</li> </ul> NSX
     * Intelligence node form factor type
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_EVALUATION}</li> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_STANDARD}</li> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_ADVANCED}</li> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_SMALL}</li> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_LARGE}</li> <li> {@link
     * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_EXTRA_LARGE}</li> </ul> NSX
     * Intelligence node form factor type
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param type New value for the property.
     */
    public void setType(java.lang.String type) {
        this.type = type;
    }

    /**
     * Number of virtual cpus on the Napp worker nodes format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getVcpu() {
        return this.vcpu;
    }

    /**
     * Number of virtual cpus on the Napp worker nodes format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param vcpu New value for the property.
     */
    public void setVcpu(java.lang.Long vcpu) {
        this.vcpu = vcpu;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.intelligenceFormFactor;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("default_worker_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultWorkerCount, this._getType().getField("default_worker_count")));
        structValue.setField("disk",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.disk, this._getType().getField("disk")));
        structValue.setField("memory",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.memory, this._getType().getField("memory")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
        structValue.setField("vcpu",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcpu, this._getType().getField("vcpu")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.intelligenceFormFactor;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.intelligenceFormFactor.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IntelligenceFormFactor _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IntelligenceFormFactor(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IntelligenceFormFactor _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IntelligenceFormFactor(structValue);
    }

    /**
     * Builder class for {@link IntelligenceFormFactor}.
     */
    public static final class Builder {
        private java.lang.Long defaultWorkerCount;
        private java.lang.Long disk;
        private java.lang.Long memory;
        private java.lang.String type;
        private java.lang.Long vcpu;

        /**
         * Constructor with parameters for the required properties of
         * {@link IntelligenceFormFactor}.
         */
        public Builder() {
        }

        /**
         * Default number of Napp worker nodes. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param defaultWorkerCount New value for the property.
         */
        public Builder setDefaultWorkerCount(java.lang.Long defaultWorkerCount) {
            this.defaultWorkerCount = defaultWorkerCount;
            return this;
        }

        /**
         * Disk size of the Napp worker nodes in GBs. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param disk New value for the property.
         */
        public Builder setDisk(java.lang.Long disk) {
            this.disk = disk;
            return this;
        }

        /**
         * Memory size of the Napp worker nodes in GBs format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param memory New value for the property.
         */
        public Builder setMemory(java.lang.Long memory) {
            this.memory = memory;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_EVALUATION}</li> <li> {@link
         * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_STANDARD}</li> <li> {@link
         * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_ADVANCED}</li> <li> {@link
         * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_SMALL}</li> <li> {@link
         * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_LARGE}</li> <li> {@link
         * com.vmware.nsx.model.IntelligenceFormFactor#TYPE_EXTRA_LARGE}</li> </ul> NSX
         * Intelligence node form factor type
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param type New value for the property.
         */
        public Builder setType(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Number of virtual cpus on the Napp worker nodes format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param vcpu New value for the property.
         */
        public Builder setVcpu(java.lang.Long vcpu) {
            this.vcpu = vcpu;
            return this;
        }

        public IntelligenceFormFactor build() {
            IntelligenceFormFactor result = new IntelligenceFormFactor();
            result.setDefaultWorkerCount(this.defaultWorkerCount);
            result.setDisk(this.disk);
            result.setMemory(this.memory);
            result.setType(this.type);
            result.setVcpu(this.vcpu);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("default_worker_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_worker_count",
                                                                                "defaultWorkerCount",
                                                                                "getDefaultWorkerCount",
                                                                                "setDefaultWorkerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("disk", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("disk",
                                                                                "disk",
                                                                                "getDisk",
                                                                                "setDisk");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("memory", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("memory",
                                                                                "memory",
                                                                                "getMemory",
                                                                                "setMemory");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vcpu", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vcpu",
                                                                                "vcpu",
                                                                                "getVcpu",
                                                                                "setVcpu");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.intelligence_form_factor",
                                                            fields,
                                                            com.vmware.nsx.model.IntelligenceFormFactor.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

