/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * This entity represents the flow parameters which are exported.
 */
public final class IpfixDfwTemplateParameters implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean destinationAddress;

    private java.lang.Boolean destinationTransportPort;

    private java.lang.Boolean firewallEvent;

    private java.lang.Boolean flowDirection;

    private java.lang.Boolean flowEnd;

    private java.lang.Boolean flowStart;

    private java.lang.Boolean icmpCode;

    private java.lang.Boolean octetDeltaCount;

    private java.lang.Boolean packetDeltaCount;

    private java.lang.Boolean protocolIdentifier;

    private java.lang.Boolean ruleId;

    private java.lang.Boolean sourceAddress;

    private java.lang.Boolean sourceIcmpType;

    private java.lang.Boolean sourceTransportPort;

    private java.lang.Boolean vifUuid;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IpfixDfwTemplateParameters() {
    }

    protected IpfixDfwTemplateParameters(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The destination IP address of a monitored network flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDestinationAddress() {
        return this.destinationAddress;
    }

    /**
     * The destination IP address of a monitored network flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param destinationAddress New value for the property.
     */
    public void setDestinationAddress(java.lang.Boolean destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    /**
     * The destination transport port of a monitored network flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDestinationTransportPort() {
        return this.destinationTransportPort;
    }

    /**
     * The destination transport port of a monitored network flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param destinationTransportPort New value for the property.
     */
    public void setDestinationTransportPort(java.lang.Boolean destinationTransportPort) {
        this.destinationTransportPort = destinationTransportPort;
    }

    /**
     * Five valid values are allowed: 1. Flow Created. 2. Flow Deleted. 3. Flow Denied.
     * 4. Flow Alert (not used in DropKick implementation). 5. Flow Update.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getFirewallEvent() {
        return this.firewallEvent;
    }

    /**
     * Five valid values are allowed: 1. Flow Created. 2. Flow Deleted. 3. Flow Denied.
     * 4. Flow Alert (not used in DropKick implementation). 5. Flow Update.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param firewallEvent New value for the property.
     */
    public void setFirewallEvent(java.lang.Boolean firewallEvent) {
        this.firewallEvent = firewallEvent;
    }

    /**
     * Two valid values are allowed: 1. 0x00: igress flow to VM. 2. 0x01: egress flow
     * from VM.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getFlowDirection() {
        return this.flowDirection;
    }

    /**
     * Two valid values are allowed: 1. 0x00: igress flow to VM. 2. 0x01: egress flow
     * from VM.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param flowDirection New value for the property.
     */
    public void setFlowDirection(java.lang.Boolean flowDirection) {
        this.flowDirection = flowDirection;
    }

    /**
     * The absolute timestamp (seconds) of the last packet of this flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getFlowEnd() {
        return this.flowEnd;
    }

    /**
     * The absolute timestamp (seconds) of the last packet of this flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param flowEnd New value for the property.
     */
    public void setFlowEnd(java.lang.Boolean flowEnd) {
        this.flowEnd = flowEnd;
    }

    /**
     * The absolute timestamp (seconds) of the first packet of this flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getFlowStart() {
        return this.flowStart;
    }

    /**
     * The absolute timestamp (seconds) of the first packet of this flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param flowStart New value for the property.
     */
    public void setFlowStart(java.lang.Boolean flowStart) {
        this.flowStart = flowStart;
    }

    /**
     * Code of the IPv4 ICMP message.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIcmpCode() {
        return this.icmpCode;
    }

    /**
     * Code of the IPv4 ICMP message.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param icmpCode New value for the property.
     */
    public void setIcmpCode(java.lang.Boolean icmpCode) {
        this.icmpCode = icmpCode;
    }

    /**
     * The number of octets since the previous report (if any) in incoming packets for
     * this flow at the observation point. The number of octets include IP header(s)
     * and payload.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getOctetDeltaCount() {
        return this.octetDeltaCount;
    }

    /**
     * The number of octets since the previous report (if any) in incoming packets for
     * this flow at the observation point. The number of octets include IP header(s)
     * and payload.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param octetDeltaCount New value for the property.
     */
    public void setOctetDeltaCount(java.lang.Boolean octetDeltaCount) {
        this.octetDeltaCount = octetDeltaCount;
    }

    /**
     * The number of incoming packets since the previous report (if any) for this flow
     * at the observation point.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getPacketDeltaCount() {
        return this.packetDeltaCount;
    }

    /**
     * The number of incoming packets since the previous report (if any) for this flow
     * at the observation point.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param packetDeltaCount New value for the property.
     */
    public void setPacketDeltaCount(java.lang.Boolean packetDeltaCount) {
        this.packetDeltaCount = packetDeltaCount;
    }

    /**
     * The value of the protocol number in the IP packet header.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getProtocolIdentifier() {
        return this.protocolIdentifier;
    }

    /**
     * The value of the protocol number in the IP packet header.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protocolIdentifier New value for the property.
     */
    public void setProtocolIdentifier(java.lang.Boolean protocolIdentifier) {
        this.protocolIdentifier = protocolIdentifier;
    }

    /**
     * Firewall rule Id - enterprise specific Information Element that uniquely
     * identifies firewall rule.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getRuleId() {
        return this.ruleId;
    }

    /**
     * Firewall rule Id - enterprise specific Information Element that uniquely
     * identifies firewall rule.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ruleId New value for the property.
     */
    public void setRuleId(java.lang.Boolean ruleId) {
        this.ruleId = ruleId;
    }

    /**
     * The source IP address of a monitored network flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSourceAddress() {
        return this.sourceAddress;
    }

    /**
     * The source IP address of a monitored network flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sourceAddress New value for the property.
     */
    public void setSourceAddress(java.lang.Boolean sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    /**
     * Type of the IPv4 ICMP message.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSourceIcmpType() {
        return this.sourceIcmpType;
    }

    /**
     * Type of the IPv4 ICMP message.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sourceIcmpType New value for the property.
     */
    public void setSourceIcmpType(java.lang.Boolean sourceIcmpType) {
        this.sourceIcmpType = sourceIcmpType;
    }

    /**
     * The source transport port of a monitored network flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSourceTransportPort() {
        return this.sourceTransportPort;
    }

    /**
     * The source transport port of a monitored network flow.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sourceTransportPort New value for the property.
     */
    public void setSourceTransportPort(java.lang.Boolean sourceTransportPort) {
        this.sourceTransportPort = sourceTransportPort;
    }

    /**
     * VIF UUID - enterprise specific Information Element that uniquely identifies VIF.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getVifUuid() {
        return this.vifUuid;
    }

    /**
     * VIF UUID - enterprise specific Information Element that uniquely identifies VIF.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param vifUuid New value for the property.
     */
    public void setVifUuid(java.lang.Boolean vifUuid) {
        this.vifUuid = vifUuid;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.ipfixDfwTemplateParameters;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("destination_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.destinationAddress, this._getType().getField("destination_address")));
        structValue.setField("destination_transport_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.destinationTransportPort, this._getType().getField("destination_transport_port")));
        structValue.setField("firewall_event",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.firewallEvent, this._getType().getField("firewall_event")));
        structValue.setField("flow_direction",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.flowDirection, this._getType().getField("flow_direction")));
        structValue.setField("flow_end",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.flowEnd, this._getType().getField("flow_end")));
        structValue.setField("flow_start",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.flowStart, this._getType().getField("flow_start")));
        structValue.setField("icmp_code",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.icmpCode, this._getType().getField("icmp_code")));
        structValue.setField("octet_delta_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.octetDeltaCount, this._getType().getField("octet_delta_count")));
        structValue.setField("packet_delta_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.packetDeltaCount, this._getType().getField("packet_delta_count")));
        structValue.setField("protocol_identifier",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protocolIdentifier, this._getType().getField("protocol_identifier")));
        structValue.setField("rule_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ruleId, this._getType().getField("rule_id")));
        structValue.setField("source_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourceAddress, this._getType().getField("source_address")));
        structValue.setField("source_icmp_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourceIcmpType, this._getType().getField("source_icmp_type")));
        structValue.setField("source_transport_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourceTransportPort, this._getType().getField("source_transport_port")));
        structValue.setField("vif_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vifUuid, this._getType().getField("vif_uuid")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.ipfixDfwTemplateParameters;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.ipfixDfwTemplateParameters.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IpfixDfwTemplateParameters _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IpfixDfwTemplateParameters(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IpfixDfwTemplateParameters _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IpfixDfwTemplateParameters(structValue);
    }

    /**
     * Builder class for {@link IpfixDfwTemplateParameters}.
     */
    public static final class Builder {
        private java.lang.Boolean destinationAddress;
        private java.lang.Boolean destinationTransportPort;
        private java.lang.Boolean firewallEvent;
        private java.lang.Boolean flowDirection;
        private java.lang.Boolean flowEnd;
        private java.lang.Boolean flowStart;
        private java.lang.Boolean icmpCode;
        private java.lang.Boolean octetDeltaCount;
        private java.lang.Boolean packetDeltaCount;
        private java.lang.Boolean protocolIdentifier;
        private java.lang.Boolean ruleId;
        private java.lang.Boolean sourceAddress;
        private java.lang.Boolean sourceIcmpType;
        private java.lang.Boolean sourceTransportPort;
        private java.lang.Boolean vifUuid;

        /**
         * Constructor with parameters for the required properties of
         * {@link IpfixDfwTemplateParameters}.
         */
        public Builder() {
        }

        /**
         * The destination IP address of a monitored network flow.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param destinationAddress New value for the property.
         */
        public Builder setDestinationAddress(java.lang.Boolean destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        /**
         * The destination transport port of a monitored network flow.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param destinationTransportPort New value for the property.
         */
        public Builder setDestinationTransportPort(java.lang.Boolean destinationTransportPort) {
            this.destinationTransportPort = destinationTransportPort;
            return this;
        }

        /**
         * Five valid values are allowed: 1. Flow Created. 2. Flow Deleted. 3. Flow Denied.
         * 4. Flow Alert (not used in DropKick implementation). 5. Flow Update.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param firewallEvent New value for the property.
         */
        public Builder setFirewallEvent(java.lang.Boolean firewallEvent) {
            this.firewallEvent = firewallEvent;
            return this;
        }

        /**
         * Two valid values are allowed: 1. 0x00: igress flow to VM. 2. 0x01: egress flow
         * from VM.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param flowDirection New value for the property.
         */
        public Builder setFlowDirection(java.lang.Boolean flowDirection) {
            this.flowDirection = flowDirection;
            return this;
        }

        /**
         * The absolute timestamp (seconds) of the last packet of this flow.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param flowEnd New value for the property.
         */
        public Builder setFlowEnd(java.lang.Boolean flowEnd) {
            this.flowEnd = flowEnd;
            return this;
        }

        /**
         * The absolute timestamp (seconds) of the first packet of this flow.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param flowStart New value for the property.
         */
        public Builder setFlowStart(java.lang.Boolean flowStart) {
            this.flowStart = flowStart;
            return this;
        }

        /**
         * Code of the IPv4 ICMP message.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param icmpCode New value for the property.
         */
        public Builder setIcmpCode(java.lang.Boolean icmpCode) {
            this.icmpCode = icmpCode;
            return this;
        }

        /**
         * The number of octets since the previous report (if any) in incoming packets for
         * this flow at the observation point. The number of octets include IP header(s)
         * and payload.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param octetDeltaCount New value for the property.
         */
        public Builder setOctetDeltaCount(java.lang.Boolean octetDeltaCount) {
            this.octetDeltaCount = octetDeltaCount;
            return this;
        }

        /**
         * The number of incoming packets since the previous report (if any) for this flow
         * at the observation point.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param packetDeltaCount New value for the property.
         */
        public Builder setPacketDeltaCount(java.lang.Boolean packetDeltaCount) {
            this.packetDeltaCount = packetDeltaCount;
            return this;
        }

        /**
         * The value of the protocol number in the IP packet header.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protocolIdentifier New value for the property.
         */
        public Builder setProtocolIdentifier(java.lang.Boolean protocolIdentifier) {
            this.protocolIdentifier = protocolIdentifier;
            return this;
        }

        /**
         * Firewall rule Id - enterprise specific Information Element that uniquely
         * identifies firewall rule.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ruleId New value for the property.
         */
        public Builder setRuleId(java.lang.Boolean ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        /**
         * The source IP address of a monitored network flow.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sourceAddress New value for the property.
         */
        public Builder setSourceAddress(java.lang.Boolean sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        /**
         * Type of the IPv4 ICMP message.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sourceIcmpType New value for the property.
         */
        public Builder setSourceIcmpType(java.lang.Boolean sourceIcmpType) {
            this.sourceIcmpType = sourceIcmpType;
            return this;
        }

        /**
         * The source transport port of a monitored network flow.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sourceTransportPort New value for the property.
         */
        public Builder setSourceTransportPort(java.lang.Boolean sourceTransportPort) {
            this.sourceTransportPort = sourceTransportPort;
            return this;
        }

        /**
         * VIF UUID - enterprise specific Information Element that uniquely identifies VIF.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param vifUuid New value for the property.
         */
        public Builder setVifUuid(java.lang.Boolean vifUuid) {
            this.vifUuid = vifUuid;
            return this;
        }

        public IpfixDfwTemplateParameters build() {
            IpfixDfwTemplateParameters result = new IpfixDfwTemplateParameters();
            result.setDestinationAddress(this.destinationAddress);
            result.setDestinationTransportPort(this.destinationTransportPort);
            result.setFirewallEvent(this.firewallEvent);
            result.setFlowDirection(this.flowDirection);
            result.setFlowEnd(this.flowEnd);
            result.setFlowStart(this.flowStart);
            result.setIcmpCode(this.icmpCode);
            result.setOctetDeltaCount(this.octetDeltaCount);
            result.setPacketDeltaCount(this.packetDeltaCount);
            result.setProtocolIdentifier(this.protocolIdentifier);
            result.setRuleId(this.ruleId);
            result.setSourceAddress(this.sourceAddress);
            result.setSourceIcmpType(this.sourceIcmpType);
            result.setSourceTransportPort(this.sourceTransportPort);
            result.setVifUuid(this.vifUuid);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("destination_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("destination_address",
                                                                                "destinationAddress",
                                                                                "getDestinationAddress",
                                                                                "setDestinationAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("destination_transport_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("destination_transport_port",
                                                                                "destinationTransportPort",
                                                                                "getDestinationTransportPort",
                                                                                "setDestinationTransportPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("firewall_event", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("firewall_event",
                                                                                "firewallEvent",
                                                                                "getFirewallEvent",
                                                                                "setFirewallEvent");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("flow_direction", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("flow_direction",
                                                                                "flowDirection",
                                                                                "getFlowDirection",
                                                                                "setFlowDirection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("flow_end", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("flow_end",
                                                                                "flowEnd",
                                                                                "getFlowEnd",
                                                                                "setFlowEnd");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("flow_start", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("flow_start",
                                                                                "flowStart",
                                                                                "getFlowStart",
                                                                                "setFlowStart");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("icmp_code", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("icmp_code",
                                                                                "icmpCode",
                                                                                "getIcmpCode",
                                                                                "setIcmpCode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("octet_delta_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("octet_delta_count",
                                                                                "octetDeltaCount",
                                                                                "getOctetDeltaCount",
                                                                                "setOctetDeltaCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("packet_delta_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("packet_delta_count",
                                                                                "packetDeltaCount",
                                                                                "getPacketDeltaCount",
                                                                                "setPacketDeltaCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("protocol_identifier", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("protocol_identifier",
                                                                                "protocolIdentifier",
                                                                                "getProtocolIdentifier",
                                                                                "setProtocolIdentifier");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rule_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rule_id",
                                                                                "ruleId",
                                                                                "getRuleId",
                                                                                "setRuleId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_address",
                                                                                "sourceAddress",
                                                                                "getSourceAddress",
                                                                                "setSourceAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_icmp_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_icmp_type",
                                                                                "sourceIcmpType",
                                                                                "getSourceIcmpType",
                                                                                "setSourceIcmpType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_transport_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_transport_port",
                                                                                "sourceTransportPort",
                                                                                "getSourceTransportPort",
                                                                                "setSourceTransportPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vif_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vif_uuid",
                                                                                "vifUuid",
                                                                                "getVifUuid",
                                                                                "setVifUuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.ipfix_dfw_template_parameters",
                                                            fields,
                                                            com.vmware.nsx.model.IpfixDfwTemplateParameters.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

