/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Session statistics gives VPN session status and traffic statistics per logical
 * switch.
 */
public final class L2VPNSessionStatistics implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String displayName;

    private java.lang.Boolean partialStats;

    private java.lang.String sessionId;

    private java.util.List<com.vmware.nsx.model.L2VPNTapTrafficStatistics> tapTrafficCounters;

    private java.util.List<com.vmware.nsx.model.L2VPNPerLSTrafficStatistics> trafficStatisticsPerLogicalSwitch;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public L2VPNSessionStatistics() {
    }

    protected L2VPNSessionStatistics(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * L2VPN display name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * L2VPN display name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Partial statistics is set to true if onle active node responds while standby
     * does not. In case of both nodes responded statistics will be summed and partial
     * stats will be false. If cluster has only active node, partial statistics will
     * always be false.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getPartialStats() {
        return this.partialStats;
    }

    /**
     * Partial statistics is set to true if onle active node responds while standby
     * does not. In case of both nodes responded statistics will be summed and partial
     * stats will be false. If cluster has only active node, partial statistics will
     * always be false.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param partialStats New value for the property.
     */
    public void setPartialStats(java.lang.Boolean partialStats) {
        this.partialStats = partialStats;
    }

    /**
     * Session identifier for L2VPN.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSessionId() {
        return this.sessionId;
    }

    /**
     * Session identifier for L2VPN.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sessionId New value for the property.
     */
    public void setSessionId(java.lang.String sessionId) {
        this.sessionId = sessionId;
    }

    /**
     * Tunnel port traffic counters.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.L2VPNTapTrafficStatistics> getTapTrafficCounters() {
        return this.tapTrafficCounters;
    }

    /**
     * Tunnel port traffic counters.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param tapTrafficCounters New value for the property.
     */
    public void setTapTrafficCounters(java.util.List<com.vmware.nsx.model.L2VPNTapTrafficStatistics> tapTrafficCounters) {
        this.tapTrafficCounters = tapTrafficCounters;
    }

    /**
     * Traffic statistics per logical switch.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.L2VPNPerLSTrafficStatistics> getTrafficStatisticsPerLogicalSwitch() {
        return this.trafficStatisticsPerLogicalSwitch;
    }

    /**
     * Traffic statistics per logical switch.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param trafficStatisticsPerLogicalSwitch New value for the property.
     */
    public void setTrafficStatisticsPerLogicalSwitch(java.util.List<com.vmware.nsx.model.L2VPNPerLSTrafficStatistics> trafficStatisticsPerLogicalSwitch) {
        this.trafficStatisticsPerLogicalSwitch = trafficStatisticsPerLogicalSwitch;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.l2VPNSessionStatistics;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("partial_stats",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.partialStats, this._getType().getField("partial_stats")));
        structValue.setField("session_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sessionId, this._getType().getField("session_id")));
        structValue.setField("tap_traffic_counters",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tapTrafficCounters, this._getType().getField("tap_traffic_counters")));
        structValue.setField("traffic_statistics_per_logical_switch",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.trafficStatisticsPerLogicalSwitch, this._getType().getField("traffic_statistics_per_logical_switch")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.l2VPNSessionStatistics;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.l2VPNSessionStatistics.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static L2VPNSessionStatistics _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new L2VPNSessionStatistics(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static L2VPNSessionStatistics _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new L2VPNSessionStatistics(structValue);
    }

    /**
     * Builder class for {@link L2VPNSessionStatistics}.
     */
    public static final class Builder {
        private java.lang.String displayName;
        private java.lang.Boolean partialStats;
        private java.lang.String sessionId;
        private java.util.List<com.vmware.nsx.model.L2VPNTapTrafficStatistics> tapTrafficCounters;
        private java.util.List<com.vmware.nsx.model.L2VPNPerLSTrafficStatistics> trafficStatisticsPerLogicalSwitch;

        /**
         * Constructor with parameters for the required properties of
         * {@link L2VPNSessionStatistics}.
         */
        public Builder() {
        }

        /**
         * L2VPN display name.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Partial statistics is set to true if onle active node responds while standby
         * does not. In case of both nodes responded statistics will be summed and partial
         * stats will be false. If cluster has only active node, partial statistics will
         * always be false.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param partialStats New value for the property.
         */
        public Builder setPartialStats(java.lang.Boolean partialStats) {
            this.partialStats = partialStats;
            return this;
        }

        /**
         * Session identifier for L2VPN.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sessionId New value for the property.
         */
        public Builder setSessionId(java.lang.String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        /**
         * Tunnel port traffic counters.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param tapTrafficCounters New value for the property.
         */
        public Builder setTapTrafficCounters(java.util.List<com.vmware.nsx.model.L2VPNTapTrafficStatistics> tapTrafficCounters) {
            this.tapTrafficCounters = tapTrafficCounters;
            return this;
        }

        /**
         * Traffic statistics per logical switch.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param trafficStatisticsPerLogicalSwitch New value for the property.
         */
        public Builder setTrafficStatisticsPerLogicalSwitch(java.util.List<com.vmware.nsx.model.L2VPNPerLSTrafficStatistics> trafficStatisticsPerLogicalSwitch) {
            this.trafficStatisticsPerLogicalSwitch = trafficStatisticsPerLogicalSwitch;
            return this;
        }

        public L2VPNSessionStatistics build() {
            L2VPNSessionStatistics result = new L2VPNSessionStatistics();
            result.setDisplayName(this.displayName);
            result.setPartialStats(this.partialStats);
            result.setSessionId(this.sessionId);
            result.setTapTrafficCounters(this.tapTrafficCounters);
            result.setTrafficStatisticsPerLogicalSwitch(this.trafficStatisticsPerLogicalSwitch);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("partial_stats", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("partial_stats",
                                                                                "partialStats",
                                                                                "getPartialStats",
                                                                                "setPartialStats");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("session_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("session_id",
                                                                                "sessionId",
                                                                                "getSessionId",
                                                                                "setSessionId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tap_traffic_counters", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.l2VPNTapTrafficStatistics; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tap_traffic_counters",
                                                                                "tapTrafficCounters",
                                                                                "getTapTrafficCounters",
                                                                                "setTapTrafficCounters");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("traffic_statistics_per_logical_switch", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.l2VPNPerLSTrafficStatistics; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("traffic_statistics_per_logical_switch",
                                                                                "trafficStatisticsPerLogicalSwitch",
                                                                                "getTrafficStatisticsPerLogicalSwitch",
                                                                                "setTrafficStatisticsPerLogicalSwitch");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.l2_VPN_session_statistics",
                                                            fields,
                                                            com.vmware.nsx.model.L2VPNSessionStatistics.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

