/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * L2VPN tunnel encapsulation config
 */
public final class L2VpnTunnelEncapsulation implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String PROTOCOL_GRE = "GRE";

    private java.lang.String localEndpointIp;

    private java.lang.String peerEndpointIp;

    private java.lang.String protocol;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public L2VpnTunnelEncapsulation() {
    }

    protected L2VpnTunnelEncapsulation(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * IP Address of the tunnel port. For hub, the IP is allocated from L2VpnService
     * logical_tap_ip_pool. All sessions on same L2VpnService get the same
     * local_endpoint_ip. For spoke, the IP must be provided. format: ipv4
     *
     * @return The current value of the property.
     */
    public java.lang.String getLocalEndpointIp() {
        return this.localEndpointIp;
    }

    /**
     * IP Address of the tunnel port. For hub, the IP is allocated from L2VpnService
     * logical_tap_ip_pool. All sessions on same L2VpnService get the same
     * local_endpoint_ip. For spoke, the IP must be provided. format: ipv4
     *
     * @param localEndpointIp New value for the property.
     */
    public void setLocalEndpointIp(java.lang.String localEndpointIp) {
        this.localEndpointIp = localEndpointIp;
    }

    /**
     * IP Address of the peer tunnel port. For hub, the IP is allocated from
     * L2VpnService logical_tap_ip_pool. For spoke, the IP must be provided. format:
     * ipv4
     *
     * @return The current value of the property.
     */
    public java.lang.String getPeerEndpointIp() {
        return this.peerEndpointIp;
    }

    /**
     * IP Address of the peer tunnel port. For hub, the IP is allocated from
     * L2VpnService logical_tap_ip_pool. For spoke, the IP must be provided. format:
     * ipv4
     *
     * @param peerEndpointIp New value for the property.
     */
    public void setPeerEndpointIp(java.lang.String peerEndpointIp) {
        this.peerEndpointIp = peerEndpointIp;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.L2VpnTunnelEncapsulation#PROTOCOL_GRE}</li> </ul>
     * Encapsulation protocol used by the tunnel
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtocol() {
        return this.protocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.L2VpnTunnelEncapsulation#PROTOCOL_GRE}</li> </ul>
     * Encapsulation protocol used by the tunnel
     *
     * @param protocol New value for the property.
     */
    public void setProtocol(java.lang.String protocol) {
        this.protocol = protocol;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.l2VpnTunnelEncapsulation;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("local_endpoint_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localEndpointIp, this._getType().getField("local_endpoint_ip")));
        structValue.setField("peer_endpoint_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.peerEndpointIp, this._getType().getField("peer_endpoint_ip")));
        structValue.setField("protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protocol, this._getType().getField("protocol")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.l2VpnTunnelEncapsulation;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.l2VpnTunnelEncapsulation.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static L2VpnTunnelEncapsulation _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new L2VpnTunnelEncapsulation(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static L2VpnTunnelEncapsulation _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new L2VpnTunnelEncapsulation(structValue);
    }

    /**
     * Builder class for {@link L2VpnTunnelEncapsulation}.
     */
    public static final class Builder {
        private java.lang.String localEndpointIp;
        private java.lang.String peerEndpointIp;
        private java.lang.String protocol;

        /**
         * Constructor with parameters for the required properties of
         * {@link L2VpnTunnelEncapsulation}.
         */
        public Builder() {
        }

        /**
         * IP Address of the tunnel port. For hub, the IP is allocated from L2VpnService
         * logical_tap_ip_pool. All sessions on same L2VpnService get the same
         * local_endpoint_ip. For spoke, the IP must be provided. format: ipv4
         *
         * @param localEndpointIp New value for the property.
         */
        public Builder setLocalEndpointIp(java.lang.String localEndpointIp) {
            this.localEndpointIp = localEndpointIp;
            return this;
        }

        /**
         * IP Address of the peer tunnel port. For hub, the IP is allocated from
         * L2VpnService logical_tap_ip_pool. For spoke, the IP must be provided. format:
         * ipv4
         *
         * @param peerEndpointIp New value for the property.
         */
        public Builder setPeerEndpointIp(java.lang.String peerEndpointIp) {
            this.peerEndpointIp = peerEndpointIp;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.L2VpnTunnelEncapsulation#PROTOCOL_GRE}</li> </ul>
         * Encapsulation protocol used by the tunnel
         *
         * @param protocol New value for the property.
         */
        public Builder setProtocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        public L2VpnTunnelEncapsulation build() {
            L2VpnTunnelEncapsulation result = new L2VpnTunnelEncapsulation();
            result.setLocalEndpointIp(this.localEndpointIp);
            result.setPeerEndpointIp(this.peerEndpointIp);
            result.setProtocol(this.protocol);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("local_endpoint_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("local_endpoint_ip",
                                                                                "localEndpointIp",
                                                                                "getLocalEndpointIp",
                                                                                "setLocalEndpointIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("peer_endpoint_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("peer_endpoint_ip",
                                                                                "peerEndpointIp",
                                                                                "getPeerEndpointIp",
                                                                                "setPeerEndpointIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("protocol",
                                                                                "protocol",
                                                                                "getProtocol",
                                                                                "setProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.l2_vpn_tunnel_encapsulation",
                                                            fields,
                                                            com.vmware.nsx.model.L2VpnTunnelEncapsulation.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

