/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * L4PortSet can be specified in comma separated notation of parts. Parts of a
 * L4PortSet includes single integer or range of port in hyphen notation. Example
 * of a PortSet: \"22, 33-70, 44\".
 */
public final class L4PortSetNSService implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "L4PortSetNSService";

    public static final java.lang.String L4PROTOCOL_TCP = "TCP";

    public static final java.lang.String L4PROTOCOL_UDP = "UDP";

    private java.util.List<java.lang.String> destinationPorts;

    private java.lang.String l4Protocol;

    private java.util.List<java.lang.String> sourcePorts;

    private final java.lang.String resourceType = "L4PortSetNSService";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public L4PortSetNSService() {
    }

    protected L4PortSetNSService(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Number of values should not exceed 15, ranges count as 2 values. format:
     * port-or-range
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDestinationPorts() {
        return this.destinationPorts;
    }

    /**
     * Number of values should not exceed 15, ranges count as 2 values. format:
     * port-or-range
     *
     * @param destinationPorts New value for the property.
     */
    public void setDestinationPorts(java.util.List<java.lang.String> destinationPorts) {
        this.destinationPorts = destinationPorts;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.L4PortSetNSService#L4PROTOCOL_TCP}</li> <li> {@link
     * com.vmware.nsx.model.L4PortSetNSService#L4PROTOCOL_UDP}</li> </ul>
     *
     * @return The current value of the property.
     */
    public java.lang.String getL4Protocol() {
        return this.l4Protocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.L4PortSetNSService#L4PROTOCOL_TCP}</li> <li> {@link
     * com.vmware.nsx.model.L4PortSetNSService#L4PROTOCOL_UDP}</li> </ul>
     *
     * @param l4Protocol New value for the property.
     */
    public void setL4Protocol(java.lang.String l4Protocol) {
        this.l4Protocol = l4Protocol;
    }

    /**
     * Number of values should not exceed 15, ranges count as 2 values. format:
     * port-or-range
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getSourcePorts() {
        return this.sourcePorts;
    }

    /**
     * Number of values should not exceed 15, ranges count as 2 values. format:
     * port-or-range
     *
     * @param sourcePorts New value for the property.
     */
    public void setSourcePorts(java.util.List<java.lang.String> sourcePorts) {
        this.sourcePorts = sourcePorts;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_ETHERTYPENSSERVICE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_IPPROTOCOLNSSERVICE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_IGMPTYPENSSERVICE}</li> <li>
     * {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_ICMPTYPENSSERVICE}</li> <li>
     * {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_ALGTYPENSSERVICE}</li> <li>
     * {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_L4PORTSETNSSERVICE}</li>
     * </ul> The specific type of NSServiceElement
     * The value of this property is automatically populated to {@code "L4PortSetNSService"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.l4PortSetNSService;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("destination_ports",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.destinationPorts, this._getType().getField("destination_ports")));
        structValue.setField("l4_protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.l4Protocol, this._getType().getField("l4_protocol")));
        structValue.setField("source_ports",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourcePorts, this._getType().getField("source_ports")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.l4PortSetNSService;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.l4PortSetNSService.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static L4PortSetNSService _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new L4PortSetNSService(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static L4PortSetNSService _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new L4PortSetNSService(structValue);
    }

    /**
     * Builder class for {@link L4PortSetNSService}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> destinationPorts;
        private java.lang.String l4Protocol;
        private java.util.List<java.lang.String> sourcePorts;

        /**
         * Constructor with parameters for the required properties of
         * {@link L4PortSetNSService}.
         */
        public Builder() {
        }

        /**
         * Number of values should not exceed 15, ranges count as 2 values. format:
         * port-or-range
         *
         * @param destinationPorts New value for the property.
         */
        public Builder setDestinationPorts(java.util.List<java.lang.String> destinationPorts) {
            this.destinationPorts = destinationPorts;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.L4PortSetNSService#L4PROTOCOL_TCP}</li> <li> {@link
         * com.vmware.nsx.model.L4PortSetNSService#L4PROTOCOL_UDP}</li> </ul>
         *
         * @param l4Protocol New value for the property.
         */
        public Builder setL4Protocol(java.lang.String l4Protocol) {
            this.l4Protocol = l4Protocol;
            return this;
        }

        /**
         * Number of values should not exceed 15, ranges count as 2 values. format:
         * port-or-range
         *
         * @param sourcePorts New value for the property.
         */
        public Builder setSourcePorts(java.util.List<java.lang.String> sourcePorts) {
            this.sourcePorts = sourcePorts;
            return this;
        }

        public L4PortSetNSService build() {
            L4PortSetNSService result = new L4PortSetNSService();
            result.setDestinationPorts(this.destinationPorts);
            result.setL4Protocol(this.l4Protocol);
            result.setSourcePorts(this.sourcePorts);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("destination_ports", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("destination_ports",
                                                                                "destinationPorts",
                                                                                "getDestinationPorts",
                                                                                "setDestinationPorts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("l4_protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("l4_protocol",
                                                                                "l4Protocol",
                                                                                "getL4Protocol",
                                                                                "setL4Protocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_ports", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_ports",
                                                                                "sourcePorts",
                                                                                "getSourcePorts",
                                                                                "setSourcePorts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.l4_port_set_NS_service",
                                                            fields,
                                                            com.vmware.nsx.model.L4PortSetNSService.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "L4PortSetNSService");
    }
}

