/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The object is deprecated as NSX-T Load Balancer is deprecated.
 */
public final class LbHttpProfile implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LbHttpProfile";

    public static final java.lang.String X_FORWARDED_FOR_INSERT = "INSERT";

    public static final java.lang.String X_FORWARDED_FOR_REPLACE = "REPLACE";

    private java.lang.String httpRedirectTo;

    private java.lang.Boolean httpRedirectToHttps;

    private java.lang.Long idleTimeout;

    private java.lang.Boolean ntlm;

    private java.lang.Long requestBodySize;

    private java.lang.Long requestHeaderSize;

    private java.lang.Boolean responseBuffering;

    private java.lang.Long responseHeaderSize;

    private java.lang.Long responseTimeout;

    private java.lang.Boolean serverKeepAlive;

    private java.lang.String xForwardedFor;

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private final java.lang.String resourceType = "LbHttpProfile";

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbHttpProfile() {
    }

    protected LbHttpProfile(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * If a website is temporarily down or has moved, incoming requests for that
     * virtual server can be temporarily redirected to a URL
     *
     * @return The current value of the property.
     */
    public java.lang.String getHttpRedirectTo() {
        return this.httpRedirectTo;
    }

    /**
     * If a website is temporarily down or has moved, incoming requests for that
     * virtual server can be temporarily redirected to a URL
     *
     * @param httpRedirectTo New value for the property.
     */
    public void setHttpRedirectTo(java.lang.String httpRedirectTo) {
        this.httpRedirectTo = httpRedirectTo;
    }

    /**
     * Certain secure applications may want to force communication over SSL, but
     * instead of rejecting non-SSL connections, they may choose to redirect the client
     * automatically to use SSL.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getHttpRedirectToHttps() {
        return this.httpRedirectToHttps;
    }

    /**
     * Certain secure applications may want to force communication over SSL, but
     * instead of rejecting non-SSL connections, they may choose to redirect the client
     * automatically to use SSL.
     *
     * @param httpRedirectToHttps New value for the property.
     */
    public void setHttpRedirectToHttps(java.lang.Boolean httpRedirectToHttps) {
        this.httpRedirectToHttps = httpRedirectToHttps;
    }

    /**
     * It is used to specify the HTTP application idle timeout, it means that how long
     * the load balancer will keep the connection idle to wait for the client to send
     * the next keep-alive request. It is not a TCP socket setting. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIdleTimeout() {
        return this.idleTimeout;
    }

    /**
     * It is used to specify the HTTP application idle timeout, it means that how long
     * the load balancer will keep the connection idle to wait for the client to send
     * the next keep-alive request. It is not a TCP socket setting. format: int64
     *
     * @param idleTimeout New value for the property.
     */
    public void setIdleTimeout(java.lang.Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    /**
     * NTLM is an authentication protocol that can be used over HTTP. If the flag is
     * set to true, LB will use NTLM challenge/response methodology. This property is
     * deprecated. Please use the property server_keep_alive in order to keep the
     * backend server connection alive for the client connection. When create a new
     * profile, if both ntlm and server_keep_alive are set as different values, ERROR
     * will be reported. When update an existing profile, if either ntlm or
     * server_keep_alive value is changed, both of them are updated with the changed
     * value.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Boolean getNtlm() {
        return this.ntlm;
    }

    /**
     * NTLM is an authentication protocol that can be used over HTTP. If the flag is
     * set to true, LB will use NTLM challenge/response methodology. This property is
     * deprecated. Please use the property server_keep_alive in order to keep the
     * backend server connection alive for the client connection. When create a new
     * profile, if both ntlm and server_keep_alive are set as different values, ERROR
     * will be reported. When update an existing profile, if either ntlm or
     * server_keep_alive value is changed, both of them are updated with the changed
     * value.
     *
     * @param ntlm New value for the property.
     */
    @Deprecated
    public void setNtlm(java.lang.Boolean ntlm) {
        this.ntlm = ntlm;
    }

    /**
     * If it is not specified, it means that request body size is unlimited. format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRequestBodySize() {
        return this.requestBodySize;
    }

    /**
     * If it is not specified, it means that request body size is unlimited. format:
     * int64
     *
     * @param requestBodySize New value for the property.
     */
    public void setRequestBodySize(java.lang.Long requestBodySize) {
        this.requestBodySize = requestBodySize;
    }

    /**
     * A request with header equal to or below this size is guaranteed to be processed.
     * A request with header larger than request_header_size will be processed up to
     * 32K bytes on best effort basis. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    /**
     * A request with header equal to or below this size is guaranteed to be processed.
     * A request with header larger than request_header_size will be processed up to
     * 32K bytes on best effort basis. format: int64
     *
     * @param requestHeaderSize New value for the property.
     */
    public void setRequestHeaderSize(java.lang.Long requestHeaderSize) {
        this.requestHeaderSize = requestHeaderSize;
    }

    /**
     * When buffering is disabled, the response is passed to a client synchronously,
     * immediately as it is received. When buffering is enabled, LB receives a response
     * from the backend server as soon as possible, saving it into the buffers.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getResponseBuffering() {
        return this.responseBuffering;
    }

    /**
     * When buffering is disabled, the response is passed to a client synchronously,
     * immediately as it is received. When buffering is enabled, LB receives a response
     * from the backend server as soon as possible, saving it into the buffers.
     *
     * @param responseBuffering New value for the property.
     */
    public void setResponseBuffering(java.lang.Boolean responseBuffering) {
        this.responseBuffering = responseBuffering;
    }

    /**
     * A response with header larger than response_header_size will be dropped. format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    /**
     * A response with header larger than response_header_size will be dropped. format:
     * int64
     *
     * @param responseHeaderSize New value for the property.
     */
    public void setResponseHeaderSize(java.lang.Long responseHeaderSize) {
        this.responseHeaderSize = responseHeaderSize;
    }

    /**
     * If server doesn't send any packet within this time, the connection is closed.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getResponseTimeout() {
        return this.responseTimeout;
    }

    /**
     * If server doesn't send any packet within this time, the connection is closed.
     * format: int64
     *
     * @param responseTimeout New value for the property.
     */
    public void setResponseTimeout(java.lang.Long responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    /**
     * If server_keep_alive is true, it means the backend connection will keep alive
     * for the client connection. Every client connection is tied 1:1 with the
     * corresponding server-side connection. If server_keep_alive is false, it means
     * the backend connection won't keep alive for the client connection. The default
     * value is false. If server_keep_alive is not specified for API input, its value
     * in API output will be the same with the property ntlm.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getServerKeepAlive() {
        return this.serverKeepAlive;
    }

    /**
     * If server_keep_alive is true, it means the backend connection will keep alive
     * for the client connection. Every client connection is tied 1:1 with the
     * corresponding server-side connection. If server_keep_alive is false, it means
     * the backend connection won't keep alive for the client connection. The default
     * value is false. If server_keep_alive is not specified for API input, its value
     * in API output will be the same with the property ntlm.
     *
     * @param serverKeepAlive New value for the property.
     */
    public void setServerKeepAlive(java.lang.Boolean serverKeepAlive) {
        this.serverKeepAlive = serverKeepAlive;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpProfile#X_FORWARDED_FOR_INSERT}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpProfile#X_FORWARDED_FOR_REPLACE}</li> </ul> When
     * X-Forwareded-For is configured, X-Forwarded-Proto and X-Forwarded-Port
     * information is added automatically. The two additional header information can be
     * also modified or deleted in load balancer rules.
     *
     * @return The current value of the property.
     */
    public java.lang.String getxForwardedFor() {
        return this.xForwardedFor;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpProfile#X_FORWARDED_FOR_INSERT}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpProfile#X_FORWARDED_FOR_REPLACE}</li> </ul> When
     * X-Forwareded-For is configured, X-Forwarded-Proto and X-Forwarded-Port
     * information is added automatically. The two additional header information can be
     * also modified or deleted in load balancer rules.
     *
     * @param xForwardedFor New value for the property.
     */
    public void setxForwardedFor(java.lang.String xForwardedFor) {
        this.xForwardedFor = xForwardedFor;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbAppProfile#RESOURCE_TYPE_LBHTTPPROFILE}</li> <li> {@link
     * com.vmware.nsx.model.LbAppProfile#RESOURCE_TYPE_LBFASTTCPPROFILE}</li> <li>
     * {@link com.vmware.nsx.model.LbAppProfile#RESOURCE_TYPE_LBFASTUDPPROFILE}</li>
     * </ul> An application profile can be bound to a virtual server to specify the
     * application protocol characteristics. It is used to influence how load balancing
     * is performed. Currently, three types of application profiles are supported:
     * LbFastTCPProfile, LbFastUDPProfile and LbHttpProfile. LbFastTCPProfile or
     * LbFastUDPProfile is typically used when the application is using a custom
     * protocol or a standard protocol not supported by the load balancer. It is also
     * used in cases where the user only wants L4 load balancing mainly because L4 load
     * balancing has much higher performance and scalability, and/or supports
     * connection mirroring. LbHttpProfile is used for both HTTP and HTTPS
     * applications. Though application rules, if bound to the virtual server, can be
     * used to accomplish the same goal, LbHttpProfile is intended to simplify enabling
     * certain common use cases. LbHttpProfile is deprecated as NSX-T Load Balancer is
     * deprecated.
     * The value of this property is automatically populated to {@code "LbHttpProfile"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbHttpProfile;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("http_redirect_to",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.httpRedirectTo, this._getType().getField("http_redirect_to")));
        structValue.setField("http_redirect_to_https",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.httpRedirectToHttps, this._getType().getField("http_redirect_to_https")));
        structValue.setField("idle_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.idleTimeout, this._getType().getField("idle_timeout")));
        structValue.setField("ntlm",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ntlm, this._getType().getField("ntlm")));
        structValue.setField("request_body_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestBodySize, this._getType().getField("request_body_size")));
        structValue.setField("request_header_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestHeaderSize, this._getType().getField("request_header_size")));
        structValue.setField("response_buffering",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.responseBuffering, this._getType().getField("response_buffering")));
        structValue.setField("response_header_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.responseHeaderSize, this._getType().getField("response_header_size")));
        structValue.setField("response_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.responseTimeout, this._getType().getField("response_timeout")));
        structValue.setField("server_keep_alive",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverKeepAlive, this._getType().getField("server_keep_alive")));
        structValue.setField("x_forwarded_for",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.xForwardedFor, this._getType().getField("x_forwarded_for")));
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbHttpProfile;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbHttpProfile.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbHttpProfile _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbHttpProfile(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbHttpProfile _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbHttpProfile(structValue);
    }

    /**
     * Builder class for {@link LbHttpProfile}.
     */
    public static final class Builder {
        private java.lang.String httpRedirectTo;
        private java.lang.Boolean httpRedirectToHttps;
        private java.lang.Long idleTimeout;
        private java.lang.Boolean ntlm;
        private java.lang.Long requestBodySize;
        private java.lang.Long requestHeaderSize;
        private java.lang.Boolean responseBuffering;
        private java.lang.Long responseHeaderSize;
        private java.lang.Long responseTimeout;
        private java.lang.Boolean serverKeepAlive;
        private java.lang.String xForwardedFor;
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.util.List<com.vmware.nsx.model.Tag> tags;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbHttpProfile}.
         */
        public Builder() {
        }

        /**
         * If a website is temporarily down or has moved, incoming requests for that
         * virtual server can be temporarily redirected to a URL
         *
         * @param httpRedirectTo New value for the property.
         */
        public Builder setHttpRedirectTo(java.lang.String httpRedirectTo) {
            this.httpRedirectTo = httpRedirectTo;
            return this;
        }

        /**
         * Certain secure applications may want to force communication over SSL, but
         * instead of rejecting non-SSL connections, they may choose to redirect the client
         * automatically to use SSL.
         *
         * @param httpRedirectToHttps New value for the property.
         */
        public Builder setHttpRedirectToHttps(java.lang.Boolean httpRedirectToHttps) {
            this.httpRedirectToHttps = httpRedirectToHttps;
            return this;
        }

        /**
         * It is used to specify the HTTP application idle timeout, it means that how long
         * the load balancer will keep the connection idle to wait for the client to send
         * the next keep-alive request. It is not a TCP socket setting. format: int64
         *
         * @param idleTimeout New value for the property.
         */
        public Builder setIdleTimeout(java.lang.Long idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        /**
         * NTLM is an authentication protocol that can be used over HTTP. If the flag is
         * set to true, LB will use NTLM challenge/response methodology. This property is
         * deprecated. Please use the property server_keep_alive in order to keep the
         * backend server connection alive for the client connection. When create a new
         * profile, if both ntlm and server_keep_alive are set as different values, ERROR
         * will be reported. When update an existing profile, if either ntlm or
         * server_keep_alive value is changed, both of them are updated with the changed
         * value.
         *
         * @param ntlm New value for the property.
         */
        public Builder setNtlm(java.lang.Boolean ntlm) {
            this.ntlm = ntlm;
            return this;
        }

        /**
         * If it is not specified, it means that request body size is unlimited. format:
         * int64
         *
         * @param requestBodySize New value for the property.
         */
        public Builder setRequestBodySize(java.lang.Long requestBodySize) {
            this.requestBodySize = requestBodySize;
            return this;
        }

        /**
         * A request with header equal to or below this size is guaranteed to be processed.
         * A request with header larger than request_header_size will be processed up to
         * 32K bytes on best effort basis. format: int64
         *
         * @param requestHeaderSize New value for the property.
         */
        public Builder setRequestHeaderSize(java.lang.Long requestHeaderSize) {
            this.requestHeaderSize = requestHeaderSize;
            return this;
        }

        /**
         * When buffering is disabled, the response is passed to a client synchronously,
         * immediately as it is received. When buffering is enabled, LB receives a response
         * from the backend server as soon as possible, saving it into the buffers.
         *
         * @param responseBuffering New value for the property.
         */
        public Builder setResponseBuffering(java.lang.Boolean responseBuffering) {
            this.responseBuffering = responseBuffering;
            return this;
        }

        /**
         * A response with header larger than response_header_size will be dropped. format:
         * int64
         *
         * @param responseHeaderSize New value for the property.
         */
        public Builder setResponseHeaderSize(java.lang.Long responseHeaderSize) {
            this.responseHeaderSize = responseHeaderSize;
            return this;
        }

        /**
         * If server doesn't send any packet within this time, the connection is closed.
         * format: int64
         *
         * @param responseTimeout New value for the property.
         */
        public Builder setResponseTimeout(java.lang.Long responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        /**
         * If server_keep_alive is true, it means the backend connection will keep alive
         * for the client connection. Every client connection is tied 1:1 with the
         * corresponding server-side connection. If server_keep_alive is false, it means
         * the backend connection won't keep alive for the client connection. The default
         * value is false. If server_keep_alive is not specified for API input, its value
         * in API output will be the same with the property ntlm.
         *
         * @param serverKeepAlive New value for the property.
         */
        public Builder setServerKeepAlive(java.lang.Boolean serverKeepAlive) {
            this.serverKeepAlive = serverKeepAlive;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpProfile#X_FORWARDED_FOR_INSERT}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpProfile#X_FORWARDED_FOR_REPLACE}</li> </ul> When
         * X-Forwareded-For is configured, X-Forwarded-Proto and X-Forwarded-Port
         * information is added automatically. The two additional header information can be
         * also modified or deleted in load balancer rules.
         *
         * @param xForwardedFor New value for the property.
         */
        public Builder setxForwardedFor(java.lang.String xForwardedFor) {
            this.xForwardedFor = xForwardedFor;
            return this;
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        public LbHttpProfile build() {
            LbHttpProfile result = new LbHttpProfile();
            result.setHttpRedirectTo(this.httpRedirectTo);
            result.setHttpRedirectToHttps(this.httpRedirectToHttps);
            result.setIdleTimeout(this.idleTimeout);
            result.setNtlm(this.ntlm);
            result.setRequestBodySize(this.requestBodySize);
            result.setRequestHeaderSize(this.requestHeaderSize);
            result.setResponseBuffering(this.responseBuffering);
            result.setResponseHeaderSize(this.responseHeaderSize);
            result.setResponseTimeout(this.responseTimeout);
            result.setServerKeepAlive(this.serverKeepAlive);
            result.setxForwardedFor(this.xForwardedFor);
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setTags(this.tags);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("http_redirect_to", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("http_redirect_to",
                                                                                "httpRedirectTo",
                                                                                "getHttpRedirectTo",
                                                                                "setHttpRedirectTo");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("http_redirect_to_https", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("http_redirect_to_https",
                                                                                "httpRedirectToHttps",
                                                                                "getHttpRedirectToHttps",
                                                                                "setHttpRedirectToHttps");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("idle_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("idle_timeout",
                                                                                "idleTimeout",
                                                                                "getIdleTimeout",
                                                                                "setIdleTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ntlm", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ntlm",
                                                                                "ntlm",
                                                                                "getNtlm",
                                                                                "setNtlm");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_body_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_body_size",
                                                                                "requestBodySize",
                                                                                "getRequestBodySize",
                                                                                "setRequestBodySize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_header_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_header_size",
                                                                                "requestHeaderSize",
                                                                                "getRequestHeaderSize",
                                                                                "setRequestHeaderSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("response_buffering", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("response_buffering",
                                                                                "responseBuffering",
                                                                                "getResponseBuffering",
                                                                                "setResponseBuffering");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("response_header_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("response_header_size",
                                                                                "responseHeaderSize",
                                                                                "getResponseHeaderSize",
                                                                                "setResponseHeaderSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("response_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("response_timeout",
                                                                                "responseTimeout",
                                                                                "getResponseTimeout",
                                                                                "setResponseTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_keep_alive", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_keep_alive",
                                                                                "serverKeepAlive",
                                                                                "getServerKeepAlive",
                                                                                "setServerKeepAlive");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("x_forwarded_for", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("x_forwarded_for",
                                                                                "xForwardedFor",
                                                                                "getxForwardedFor",
                                                                                "setxForwardedFor");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_http_profile",
                                                            fields,
                                                            com.vmware.nsx.model.LbHttpProfile.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "LbHttpProfile");
    }
}

