/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * This condition is used to match URI arguments aka query string of Http request
 * messages, for example, in URI http://exaple.com?foo=1&bar=2, the \"foo=1&bar=2\"
 * is the query string containing URI arguments. In an URI scheme, query string is
 * indicated by the first question mark (\"?\") character and terminated by a
 * number sign (\"#\") character or by the end of the URI. The uri_arguments field
 * can be specified as a regular expression(Set match_type to REGEX). For example,
 * \"foo=(?&lt;x&gt;\\d+)\". It matches HTTP requests whose URI arguments
 * containing \"foo\", the value of foo contains only digits. And the value of foo
 * is captured as $x which can be used in LbRuleAction fields which support
 * variables.
 */
public final class LbHttpRequestUriArgumentsCondition implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LbHttpRequestUriArgumentsCondition";

    public static final java.lang.String MATCH_TYPE_STARTS_WITH = "STARTS_WITH";

    public static final java.lang.String MATCH_TYPE_ENDS_WITH = "ENDS_WITH";

    public static final java.lang.String MATCH_TYPE_EQUALS = "EQUALS";

    public static final java.lang.String MATCH_TYPE_CONTAINS = "CONTAINS";

    public static final java.lang.String MATCH_TYPE_REGEX = "REGEX";

    private java.lang.Boolean caseSensitive;

    private java.lang.String matchType;

    private java.lang.String uriArguments;

    private java.lang.Boolean inverse;

    private final java.lang.String type = "LbHttpRequestUriArgumentsCondition";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbHttpRequestUriArgumentsCondition() {
    }

    protected LbHttpRequestUriArgumentsCondition(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * If true, case is significant when comparing URI arguments.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    /**
     * If true, case is significant when comparing URI arguments.
     *
     * @param caseSensitive New value for the property.
     */
    public void setCaseSensitive(java.lang.Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_STARTS_WITH}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_ENDS_WITH}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_EQUALS}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_CONTAINS}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_REGEX}</li>
     * </ul> Match type of URI arguments
     *
     * @return The current value of the property.
     */
    public java.lang.String getMatchType() {
        return this.matchType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_STARTS_WITH}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_ENDS_WITH}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_EQUALS}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_CONTAINS}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_REGEX}</li>
     * </ul> Match type of URI arguments
     *
     * @param matchType New value for the property.
     */
    public void setMatchType(java.lang.String matchType) {
        this.matchType = matchType;
    }

    /**
     * URI arguments, aka query string of URI.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUriArguments() {
        return this.uriArguments;
    }

    /**
     * URI arguments, aka query string of URI.
     *
     * @param uriArguments New value for the property.
     */
    public void setUriArguments(java.lang.String uriArguments) {
        this.uriArguments = uriArguments;
    }

    /**
     * A flag to indicate whether reverse the match result of this condition
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getInverse() {
        return this.inverse;
    }

    /**
     * A flag to indicate whether reverse the match result of this condition
     *
     * @param inverse New value for the property.
     */
    public void setInverse(java.lang.Boolean inverse) {
        this.inverse = inverse;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTMETHODCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTURICONDITION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTURIARGUMENTSCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTVERSIONCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTHEADERCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTCOOKIECONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTBODYCONDITION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPRESPONSEHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBTCPHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBIPHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBVARIABLECONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPSSLCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBSSLSNICONDITION}</li>
     * </ul> Type of load balancer rule condition
     * The value of this property is automatically populated to {@code "LbHttpRequestUriArgumentsCondition"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbHttpRequestUriArgumentsCondition;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("case_sensitive",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.caseSensitive, this._getType().getField("case_sensitive")));
        structValue.setField("match_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchType, this._getType().getField("match_type")));
        structValue.setField("uri_arguments",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uriArguments, this._getType().getField("uri_arguments")));
        structValue.setField("inverse",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.inverse, this._getType().getField("inverse")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbHttpRequestUriArgumentsCondition;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbHttpRequestUriArgumentsCondition.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbHttpRequestUriArgumentsCondition _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbHttpRequestUriArgumentsCondition(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbHttpRequestUriArgumentsCondition _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbHttpRequestUriArgumentsCondition(structValue);
    }

    /**
     * Builder class for {@link LbHttpRequestUriArgumentsCondition}.
     */
    public static final class Builder {
        private java.lang.Boolean caseSensitive;
        private java.lang.String matchType;
        private java.lang.String uriArguments;
        private java.lang.Boolean inverse;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbHttpRequestUriArgumentsCondition}.
         */
        public Builder() {
        }

        /**
         * If true, case is significant when comparing URI arguments.
         *
         * @param caseSensitive New value for the property.
         */
        public Builder setCaseSensitive(java.lang.Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_STARTS_WITH}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_ENDS_WITH}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_EQUALS}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_CONTAINS}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition#MATCH_TYPE_REGEX}</li>
         * </ul> Match type of URI arguments
         *
         * @param matchType New value for the property.
         */
        public Builder setMatchType(java.lang.String matchType) {
            this.matchType = matchType;
            return this;
        }

        /**
         * URI arguments, aka query string of URI.
         *
         * @param uriArguments New value for the property.
         */
        public Builder setUriArguments(java.lang.String uriArguments) {
            this.uriArguments = uriArguments;
            return this;
        }

        /**
         * A flag to indicate whether reverse the match result of this condition
         *
         * @param inverse New value for the property.
         */
        public Builder setInverse(java.lang.Boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public LbHttpRequestUriArgumentsCondition build() {
            LbHttpRequestUriArgumentsCondition result = new LbHttpRequestUriArgumentsCondition();
            result.setCaseSensitive(this.caseSensitive);
            result.setMatchType(this.matchType);
            result.setUriArguments(this.uriArguments);
            result.setInverse(this.inverse);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("case_sensitive", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("case_sensitive",
                                                                                "caseSensitive",
                                                                                "getCaseSensitive",
                                                                                "setCaseSensitive");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_type",
                                                                                "matchType",
                                                                                "getMatchType",
                                                                                "setMatchType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("uri_arguments", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("uri_arguments",
                                                                                "uriArguments",
                                                                                "getUriArguments",
                                                                                "setUriArguments");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("inverse", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("inverse",
                                                                                "inverse",
                                                                                "getInverse",
                                                                                "setInverse");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_http_request_uri_arguments_condition",
                                                            fields,
                                                            com.vmware.nsx.model.LbHttpRequestUriArgumentsCondition.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LbHttpRequestUriArgumentsCondition");
    }
}

