/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * This condition is used to match URIs(Uniform Resource Identifier) of HTTP
 * request messages. The URI field can be specified as a regular expression. If an
 * HTTP request message is requesting an URI which matches specified regular
 * expression, it matches the condition. The syntax of whole URI looks like this:
 * scheme:[//[user[:password]@]host[:port]][/path][?query][#fragment] This
 * condition matches only the path part of entire URI. When match_type field is
 * specified as REGEX, the uri field is used as a regular expression to match URI
 * path of HTTP requests. For example, to match any URI that has \"/image/\" or
 * \"/images/\", uri field can be specified as: \"/image[s]?/\". Named capturing
 * groups can be used in the uri field to capture substrings of matched URIs and
 * store them in variables for use in LbRuleAction. For example, specify uri field
 * as: \"/news/(?&lt;year&gt;\\d+)/(?&lt;month&gt;\\d+)/(?&lt;article&gt;.*)\" If
 * the URI path is /articles/news/2017/06/xyz.html, then substring \"2017\" is
 * captured in variable year, \"06\" is captured in variable month, and
 * \"xyz.html\" is captured in variable article. These variables can then be used
 * in an LbRuleAction field which supports variables, such as uri field of
 * LbHttpRequestUriRewriteAction. For example, set the uri field of
 * LbHttpRequestUriRewriteAction as: \"/articles/news/$year-$month-$article\" Then
 * the URI path /articles/news/2017/06/xyz.html is rewritten to:
 * \"/articles/news/2017-06-xyz.html\"
 */
public final class LbHttpRequestUriCondition implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LbHttpRequestUriCondition";

    public static final java.lang.String MATCH_TYPE_STARTS_WITH = "STARTS_WITH";

    public static final java.lang.String MATCH_TYPE_ENDS_WITH = "ENDS_WITH";

    public static final java.lang.String MATCH_TYPE_EQUALS = "EQUALS";

    public static final java.lang.String MATCH_TYPE_CONTAINS = "CONTAINS";

    public static final java.lang.String MATCH_TYPE_REGEX = "REGEX";

    private java.lang.Boolean caseSensitive;

    private java.lang.String matchType;

    private java.lang.String uri;

    private java.lang.Boolean inverse;

    private final java.lang.String type = "LbHttpRequestUriCondition";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbHttpRequestUriCondition() {
    }

    protected LbHttpRequestUriCondition(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * If true, case is significant when comparing URI.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    /**
     * If true, case is significant when comparing URI.
     *
     * @param caseSensitive New value for the property.
     */
    public void setCaseSensitive(java.lang.Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_STARTS_WITH}</li> <li>
     * {@link com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_ENDS_WITH}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_EQUALS}</li> <li>
     * {@link com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_CONTAINS}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_REGEX}</li> </ul>
     * Match type of URI
     *
     * @return The current value of the property.
     */
    public java.lang.String getMatchType() {
        return this.matchType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_STARTS_WITH}</li> <li>
     * {@link com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_ENDS_WITH}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_EQUALS}</li> <li>
     * {@link com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_CONTAINS}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_REGEX}</li> </ul>
     * Match type of URI
     *
     * @param matchType New value for the property.
     */
    public void setMatchType(java.lang.String matchType) {
        this.matchType = matchType;
    }

    /**
     * A string used to identify resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getUri() {
        return this.uri;
    }

    /**
     * A string used to identify resource
     *
     * @param uri New value for the property.
     */
    public void setUri(java.lang.String uri) {
        this.uri = uri;
    }

    /**
     * A flag to indicate whether reverse the match result of this condition
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getInverse() {
        return this.inverse;
    }

    /**
     * A flag to indicate whether reverse the match result of this condition
     *
     * @param inverse New value for the property.
     */
    public void setInverse(java.lang.Boolean inverse) {
        this.inverse = inverse;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTMETHODCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTURICONDITION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTURIARGUMENTSCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTVERSIONCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTHEADERCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTCOOKIECONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTBODYCONDITION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPRESPONSEHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBTCPHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBIPHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBVARIABLECONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPSSLCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBSSLSNICONDITION}</li>
     * </ul> Type of load balancer rule condition
     * The value of this property is automatically populated to {@code "LbHttpRequestUriCondition"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbHttpRequestUriCondition;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("case_sensitive",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.caseSensitive, this._getType().getField("case_sensitive")));
        structValue.setField("match_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchType, this._getType().getField("match_type")));
        structValue.setField("uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uri, this._getType().getField("uri")));
        structValue.setField("inverse",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.inverse, this._getType().getField("inverse")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbHttpRequestUriCondition;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbHttpRequestUriCondition.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbHttpRequestUriCondition _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbHttpRequestUriCondition(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbHttpRequestUriCondition _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbHttpRequestUriCondition(structValue);
    }

    /**
     * Builder class for {@link LbHttpRequestUriCondition}.
     */
    public static final class Builder {
        private java.lang.Boolean caseSensitive;
        private java.lang.String matchType;
        private java.lang.String uri;
        private java.lang.Boolean inverse;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbHttpRequestUriCondition}.
         */
        public Builder() {
        }

        /**
         * If true, case is significant when comparing URI.
         *
         * @param caseSensitive New value for the property.
         */
        public Builder setCaseSensitive(java.lang.Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_STARTS_WITH}</li> <li>
         * {@link com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_ENDS_WITH}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_EQUALS}</li> <li>
         * {@link com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_CONTAINS}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpRequestUriCondition#MATCH_TYPE_REGEX}</li> </ul>
         * Match type of URI
         *
         * @param matchType New value for the property.
         */
        public Builder setMatchType(java.lang.String matchType) {
            this.matchType = matchType;
            return this;
        }

        /**
         * A string used to identify resource
         *
         * @param uri New value for the property.
         */
        public Builder setUri(java.lang.String uri) {
            this.uri = uri;
            return this;
        }

        /**
         * A flag to indicate whether reverse the match result of this condition
         *
         * @param inverse New value for the property.
         */
        public Builder setInverse(java.lang.Boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public LbHttpRequestUriCondition build() {
            LbHttpRequestUriCondition result = new LbHttpRequestUriCondition();
            result.setCaseSensitive(this.caseSensitive);
            result.setMatchType(this.matchType);
            result.setUri(this.uri);
            result.setInverse(this.inverse);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("case_sensitive", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("case_sensitive",
                                                                                "caseSensitive",
                                                                                "getCaseSensitive",
                                                                                "setCaseSensitive");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_type",
                                                                                "matchType",
                                                                                "getMatchType",
                                                                                "setMatchType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("uri",
                                                                                "uri",
                                                                                "getUri",
                                                                                "setUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("inverse", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("inverse",
                                                                                "inverse",
                                                                                "getInverse",
                                                                                "setInverse");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_http_request_uri_condition",
                                                            fields,
                                                            com.vmware.nsx.model.LbHttpRequestUriCondition.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LbHttpRequestUriCondition");
    }
}

