/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class LbHttpsMonitor implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CIPHER_GROUP_LABEL_BALANCED = "BALANCED";

    public static final java.lang.String CIPHER_GROUP_LABEL_HIGH_SECURITY = "HIGH_SECURITY";

    public static final java.lang.String CIPHER_GROUP_LABEL_HIGH_COMPATIBILITY = "HIGH_COMPATIBILITY";

    public static final java.lang.String CIPHER_GROUP_LABEL_CUSTOM = "CUSTOM";

    public static final java.lang.String CIPHERS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CIPHERS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA = "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CIPHERS_RSA_WITH_AES_256_CBC_SHA = "TLS_RSA_WITH_AES_256_CBC_SHA";

    public static final java.lang.String CIPHERS_RSA_WITH_AES_128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CIPHERS_RSA_WITH_3DES_EDE_CBC_SHA = "TLS_RSA_WITH_3DES_EDE_CBC_SHA";

    public static final java.lang.String CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String CIPHERS_RSA_WITH_AES_128_CBC_SHA256 = "TLS_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CIPHERS_RSA_WITH_AES_128_GCM_SHA256 = "TLS_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CIPHERS_RSA_WITH_AES_256_CBC_SHA256 = "TLS_RSA_WITH_AES_256_CBC_SHA256";

    public static final java.lang.String CIPHERS_RSA_WITH_AES_256_GCM_SHA384 = "TLS_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CIPHERS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String CIPHERS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CIPHERS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String CIPHERS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA = "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA";

    public static final java.lang.String CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA256 = "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256";

    public static final java.lang.String CIPHERS_ECDH_RSA_WITH_AES_128_GCM_SHA256 = "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256";

    public static final java.lang.String CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA384 = "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384";

    public static final java.lang.String CIPHERS_ECDH_RSA_WITH_AES_256_GCM_SHA384 = "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384";

    public static final java.lang.String PROTOCOLS_SSL_V2 = "SSL_V2";

    public static final java.lang.String PROTOCOLS_SSL_V3 = "SSL_V3";

    public static final java.lang.String PROTOCOLS_TLS_V1 = "TLS_V1";

    public static final java.lang.String PROTOCOLS_TLS_V1_1 = "TLS_V1_1";

    public static final java.lang.String PROTOCOLS_TLS_V1_2 = "TLS_V1_2";

    public static final java.lang.String REQUEST_METHOD_GET = "GET";

    public static final java.lang.String REQUEST_METHOD_OPTIONS = "OPTIONS";

    public static final java.lang.String REQUEST_METHOD_POST = "POST";

    public static final java.lang.String REQUEST_METHOD_HEAD = "HEAD";

    public static final java.lang.String REQUEST_METHOD_PUT = "PUT";

    public static final java.lang.String REQUEST_VERSION_0 = "HTTP_VERSION_1_0";

    public static final java.lang.String REQUEST_VERSION_1 = "HTTP_VERSION_1_1";

    public static final java.lang.String SERVER_AUTH_REQUIRED = "REQUIRED";

    public static final java.lang.String SERVER_AUTH_IGNORE = "IGNORE";

    private java.lang.Long certificateChainDepth;

    private java.lang.String cipherGroupLabel;

    private java.util.List<java.lang.String> ciphers;

    private java.lang.String clientCertificateId;

    private java.lang.Boolean isFips;

    private java.lang.Boolean isSecure;

    private java.util.List<java.lang.String> protocols;

    private java.lang.String requestBody;

    private java.util.List<com.vmware.nsx.model.LbHttpRequestHeader> requestHeaders;

    private java.lang.String requestMethod;

    private java.lang.String requestUrl;

    private java.lang.String requestVersion;

    private java.lang.String responseBody;

    private java.util.List<java.lang.Long> responseStatusCodes;

    private java.lang.String serverAuth;

    private java.util.List<java.lang.String> serverAuthCaIds;

    private java.util.List<java.lang.String> serverAuthCrlIds;

    private java.lang.Long fallCount;

    private java.lang.Long interval;

    private java.lang.String monitorPort;

    private java.lang.Long riseCount;

    private java.lang.Long timeout;

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbHttpsMonitor() {
    }

    protected LbHttpsMonitor(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * authentication depth is used to set the verification depth in the server
     * certificates chain. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCertificateChainDepth() {
        return this.certificateChainDepth;
    }

    /**
     * authentication depth is used to set the verification depth in the server
     * certificates chain. format: int64
     *
     * @param certificateChainDepth New value for the property.
     */
    public void setCertificateChainDepth(java.lang.Long certificateChainDepth) {
        this.certificateChainDepth = certificateChainDepth;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_BALANCED}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_HIGH_SECURITY}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_HIGH_COMPATIBILITY}</li>
     * <li> {@link com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_CUSTOM}</li>
     * </ul> It is a label of cipher group which is mostly consumed by GUI.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCipherGroupLabel() {
        return this.cipherGroupLabel;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_BALANCED}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_HIGH_SECURITY}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_HIGH_COMPATIBILITY}</li>
     * <li> {@link com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_CUSTOM}</li>
     * </ul> It is a label of cipher group which is mostly consumed by GUI.
     *
     * @param cipherGroupLabel New value for the property.
     */
    public void setCipherGroupLabel(java.lang.String cipherGroupLabel) {
        this.cipherGroupLabel = cipherGroupLabel;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_256_CBC_SHA}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_128_CBC_SHA}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_3DES_EDE_CBC_SHA}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_256_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_256_GCM_SHA384}</li>
     * </ul> supported SSL cipher list to servers
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getCiphers() {
        return this.ciphers;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_256_CBC_SHA}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_128_CBC_SHA}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_3DES_EDE_CBC_SHA}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_256_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_128_GCM_SHA256}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA384}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_256_GCM_SHA384}</li>
     * </ul> supported SSL cipher list to servers
     *
     * @param ciphers New value for the property.
     */
    public void setCiphers(java.util.List<java.lang.String> ciphers) {
        this.ciphers = ciphers;
    }

    /**
     * client certificate can be specified to support client authentication.
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientCertificateId() {
        return this.clientCertificateId;
    }

    /**
     * client certificate can be specified to support client authentication.
     *
     * @param clientCertificateId New value for the property.
     */
    public void setClientCertificateId(java.lang.String clientCertificateId) {
        this.clientCertificateId = clientCertificateId;
    }

    /**
     * This flag is set to true when all the ciphers and protocols are FIPS compliant.
     * It is set to false when one of the ciphers or protocols are not FIPS compliant..
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsFips() {
        return this.isFips;
    }

    /**
     * This flag is set to true when all the ciphers and protocols are FIPS compliant.
     * It is set to false when one of the ciphers or protocols are not FIPS compliant..
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isFips New value for the property.
     */
    public void setIsFips(java.lang.Boolean isFips) {
        this.isFips = isFips;
    }

    /**
     * This flag is set to true when all the ciphers and protocols are secure. It is
     * set to false when one of the ciphers or protocols is insecure.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsSecure() {
        return this.isSecure;
    }

    /**
     * This flag is set to true when all the ciphers and protocols are secure. It is
     * set to false when one of the ciphers or protocols is insecure.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isSecure New value for the property.
     */
    public void setIsSecure(java.lang.Boolean isSecure) {
        this.isSecure = isSecure;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_SSL_V2}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_SSL_V3}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_TLS_V1}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_TLS_V1_1}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_TLS_V1_2}</li> </ul> SSL versions
     * TLS1.1 and TLS1.2 are supported and enabled by default. SSLv2, SSLv3, and TLS1.0
     * are supported, but disabled by default.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getProtocols() {
        return this.protocols;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_SSL_V2}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_SSL_V3}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_TLS_V1}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_TLS_V1_1}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_TLS_V1_2}</li> </ul> SSL versions
     * TLS1.1 and TLS1.2 are supported and enabled by default. SSLv2, SSLv3, and TLS1.0
     * are supported, but disabled by default.
     *
     * @param protocols New value for the property.
     */
    public void setProtocols(java.util.List<java.lang.String> protocols) {
        this.protocols = protocols;
    }

    /**
     * String to send as part of HTTP health check request body. Valid only for certain
     * HTTP methods like POST.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRequestBody() {
        return this.requestBody;
    }

    /**
     * String to send as part of HTTP health check request body. Valid only for certain
     * HTTP methods like POST.
     *
     * @param requestBody New value for the property.
     */
    public void setRequestBody(java.lang.String requestBody) {
        this.requestBody = requestBody;
    }

    /**
     * Array of HTTP request headers
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.LbHttpRequestHeader> getRequestHeaders() {
        return this.requestHeaders;
    }

    /**
     * Array of HTTP request headers
     *
     * @param requestHeaders New value for the property.
     */
    public void setRequestHeaders(java.util.List<com.vmware.nsx.model.LbHttpRequestHeader> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_GET}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_OPTIONS}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_POST}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_HEAD}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_PUT}</li> </ul> the health
     * check method for HTTP monitor type
     *
     * @return The current value of the property.
     */
    public java.lang.String getRequestMethod() {
        return this.requestMethod;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_GET}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_OPTIONS}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_POST}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_HEAD}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_PUT}</li> </ul> the health
     * check method for HTTP monitor type
     *
     * @param requestMethod New value for the property.
     */
    public void setRequestMethod(java.lang.String requestMethod) {
        this.requestMethod = requestMethod;
    }

    /**
     * URL used for HTTP monitor
     *
     * @return The current value of the property.
     */
    public java.lang.String getRequestUrl() {
        return this.requestUrl;
    }

    /**
     * URL used for HTTP monitor
     *
     * @param requestUrl New value for the property.
     */
    public void setRequestUrl(java.lang.String requestUrl) {
        this.requestUrl = requestUrl;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_VERSION_0}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_VERSION_1}</li> </ul> HTTP request
     * version
     *
     * @return The current value of the property.
     */
    public java.lang.String getRequestVersion() {
        return this.requestVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_VERSION_0}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_VERSION_1}</li> </ul> HTTP request
     * version
     *
     * @param requestVersion New value for the property.
     */
    public void setRequestVersion(java.lang.String requestVersion) {
        this.requestVersion = requestVersion;
    }

    /**
     * If HTTP response body match string (regular expressions not supported) is
     * specified (using LbHttpMonitor.response_body) then the healthcheck HTTP response
     * body is matched against the specified string and server is considered healthy
     * only if there is a match. If the response body string is not specified, HTTP
     * healthcheck is considered successful if the HTTP response status code is 2xx,
     * but it can be configured to accept other status codes as successful.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResponseBody() {
        return this.responseBody;
    }

    /**
     * If HTTP response body match string (regular expressions not supported) is
     * specified (using LbHttpMonitor.response_body) then the healthcheck HTTP response
     * body is matched against the specified string and server is considered healthy
     * only if there is a match. If the response body string is not specified, HTTP
     * healthcheck is considered successful if the HTTP response status code is 2xx,
     * but it can be configured to accept other status codes as successful.
     *
     * @param responseBody New value for the property.
     */
    public void setResponseBody(java.lang.String responseBody) {
        this.responseBody = responseBody;
    }

    /**
     * The HTTP response status code should be a valid HTTP status code. format: int32
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.Long> getResponseStatusCodes() {
        return this.responseStatusCodes;
    }

    /**
     * The HTTP response status code should be a valid HTTP status code. format: int32
     *
     * @param responseStatusCodes New value for the property.
     */
    public void setResponseStatusCodes(java.util.List<java.lang.Long> responseStatusCodes) {
        this.responseStatusCodes = responseStatusCodes;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#SERVER_AUTH_REQUIRED}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#SERVER_AUTH_IGNORE}</li> </ul> server
     * authentication mode
     *
     * @return The current value of the property.
     */
    public java.lang.String getServerAuth() {
        return this.serverAuth;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#SERVER_AUTH_REQUIRED}</li> <li> {@link
     * com.vmware.nsx.model.LbHttpsMonitor#SERVER_AUTH_IGNORE}</li> </ul> server
     * authentication mode
     *
     * @param serverAuth New value for the property.
     */
    public void setServerAuth(java.lang.String serverAuth) {
        this.serverAuth = serverAuth;
    }

    /**
     * If server auth type is REQUIRED, server certificate must be signed by one of the
     * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
     * signed certificates are specified.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getServerAuthCaIds() {
        return this.serverAuthCaIds;
    }

    /**
     * If server auth type is REQUIRED, server certificate must be signed by one of the
     * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
     * signed certificates are specified.
     *
     * @param serverAuthCaIds New value for the property.
     */
    public void setServerAuthCaIds(java.util.List<java.lang.String> serverAuthCaIds) {
        this.serverAuthCaIds = serverAuthCaIds;
    }

    /**
     * A Certificate Revocation List (CRL) can be specified in the server-side SSL
     * profile binding to disallow compromised server certificates.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getServerAuthCrlIds() {
        return this.serverAuthCrlIds;
    }

    /**
     * A Certificate Revocation List (CRL) can be specified in the server-side SSL
     * profile binding to disallow compromised server certificates.
     *
     * @param serverAuthCrlIds New value for the property.
     */
    public void setServerAuthCrlIds(java.util.List<java.lang.String> serverAuthCrlIds) {
        this.serverAuthCrlIds = serverAuthCrlIds;
    }

    /**
     * num of consecutive checks must fail before marking it down format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getFallCount() {
        return this.fallCount;
    }

    /**
     * num of consecutive checks must fail before marking it down format: int64
     *
     * @param fallCount New value for the property.
     */
    public void setFallCount(java.lang.Long fallCount) {
        this.fallCount = fallCount;
    }

    /**
     * the frequency at which the system issues the monitor check (in second) format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getInterval() {
        return this.interval;
    }

    /**
     * the frequency at which the system issues the monitor check (in second) format:
     * int64
     *
     * @param interval New value for the property.
     */
    public void setInterval(java.lang.Long interval) {
        this.interval = interval;
    }

    /**
     * If the monitor port is specified, it would override pool member port setting for
     * healthcheck. A port range is not supported. For ICMP monitor, monitor_port is
     * not required. format: port-or-range
     *
     * @return The current value of the property.
     */
    public java.lang.String getMonitorPort() {
        return this.monitorPort;
    }

    /**
     * If the monitor port is specified, it would override pool member port setting for
     * healthcheck. A port range is not supported. For ICMP monitor, monitor_port is
     * not required. format: port-or-range
     *
     * @param monitorPort New value for the property.
     */
    public void setMonitorPort(java.lang.String monitorPort) {
        this.monitorPort = monitorPort;
    }

    /**
     * num of consecutive checks must pass before marking it up format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRiseCount() {
        return this.riseCount;
    }

    /**
     * num of consecutive checks must pass before marking it up format: int64
     *
     * @param riseCount New value for the property.
     */
    public void setRiseCount(java.lang.Long riseCount) {
        this.riseCount = riseCount;
    }

    /**
     * the number of seconds the target has in which to respond to the monitor request
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTimeout() {
        return this.timeout;
    }

    /**
     * the number of seconds the target has in which to respond to the monitor request
     * format: int64
     *
     * @param timeout New value for the property.
     */
    public void setTimeout(java.lang.Long timeout) {
        this.timeout = timeout;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBHTTPMONITOR}</li> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBHTTPSMONITOR}</li> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBICMPMONITOR}</li> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBTCPMONITOR}</li> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBUDPMONITOR}</li> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBPASSIVEMONITOR}</li> </ul> Load
     * balancers monitor the health of backend servers to ensure traffic is not black
     * holed. There are two types of healthchecks: active and passive. Passive
     * healthchecks depend on failures in actual client traffic (e.g. RST from server
     * in response to a client connection) to detect that the server or the application
     * is down. In case of active healthchecks, load balancer itself initiates new
     * connections (or sends ICMP ping) to the servers periodically to check their
     * health, completely independent of any data traffic. Currently, active health
     * monitors are supported for HTTP, HTTPS, TCP, UDP and ICMP protocols.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBHTTPMONITOR}</li> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBHTTPSMONITOR}</li> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBICMPMONITOR}</li> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBTCPMONITOR}</li> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBUDPMONITOR}</li> <li> {@link
     * com.vmware.nsx.model.LbMonitor#RESOURCE_TYPE_LBPASSIVEMONITOR}</li> </ul> Load
     * balancers monitor the health of backend servers to ensure traffic is not black
     * holed. There are two types of healthchecks: active and passive. Passive
     * healthchecks depend on failures in actual client traffic (e.g. RST from server
     * in response to a client connection) to detect that the server or the application
     * is down. In case of active healthchecks, load balancer itself initiates new
     * connections (or sends ICMP ping) to the servers periodically to check their
     * health, completely independent of any data traffic. Currently, active health
     * monitors are supported for HTTP, HTTPS, TCP, UDP and ICMP protocols.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbHttpsMonitor;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("certificate_chain_depth",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificateChainDepth, this._getType().getField("certificate_chain_depth")));
        structValue.setField("cipher_group_label",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cipherGroupLabel, this._getType().getField("cipher_group_label")));
        structValue.setField("ciphers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ciphers, this._getType().getField("ciphers")));
        structValue.setField("client_certificate_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientCertificateId, this._getType().getField("client_certificate_id")));
        structValue.setField("is_fips",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isFips, this._getType().getField("is_fips")));
        structValue.setField("is_secure",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isSecure, this._getType().getField("is_secure")));
        structValue.setField("protocols",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protocols, this._getType().getField("protocols")));
        structValue.setField("request_body",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestBody, this._getType().getField("request_body")));
        structValue.setField("request_headers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestHeaders, this._getType().getField("request_headers")));
        structValue.setField("request_method",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestMethod, this._getType().getField("request_method")));
        structValue.setField("request_url",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestUrl, this._getType().getField("request_url")));
        structValue.setField("request_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestVersion, this._getType().getField("request_version")));
        structValue.setField("response_body",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.responseBody, this._getType().getField("response_body")));
        structValue.setField("response_status_codes",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.responseStatusCodes, this._getType().getField("response_status_codes")));
        structValue.setField("server_auth",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverAuth, this._getType().getField("server_auth")));
        structValue.setField("server_auth_ca_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverAuthCaIds, this._getType().getField("server_auth_ca_ids")));
        structValue.setField("server_auth_crl_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverAuthCrlIds, this._getType().getField("server_auth_crl_ids")));
        structValue.setField("fall_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fallCount, this._getType().getField("fall_count")));
        structValue.setField("interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.interval, this._getType().getField("interval")));
        structValue.setField("monitor_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.monitorPort, this._getType().getField("monitor_port")));
        structValue.setField("rise_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.riseCount, this._getType().getField("rise_count")));
        structValue.setField("timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.timeout, this._getType().getField("timeout")));
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbHttpsMonitor;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbHttpsMonitor.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbHttpsMonitor _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbHttpsMonitor(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbHttpsMonitor _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbHttpsMonitor(structValue);
    }

    /**
     * Builder class for {@link LbHttpsMonitor}.
     */
    public static final class Builder {
        private java.lang.Long certificateChainDepth;
        private java.lang.String cipherGroupLabel;
        private java.util.List<java.lang.String> ciphers;
        private java.lang.String clientCertificateId;
        private java.lang.Boolean isFips;
        private java.lang.Boolean isSecure;
        private java.util.List<java.lang.String> protocols;
        private java.lang.String requestBody;
        private java.util.List<com.vmware.nsx.model.LbHttpRequestHeader> requestHeaders;
        private java.lang.String requestMethod;
        private java.lang.String requestUrl;
        private java.lang.String requestVersion;
        private java.lang.String responseBody;
        private java.util.List<java.lang.Long> responseStatusCodes;
        private java.lang.String serverAuth;
        private java.util.List<java.lang.String> serverAuthCaIds;
        private java.util.List<java.lang.String> serverAuthCrlIds;
        private java.lang.Long fallCount;
        private java.lang.Long interval;
        private java.lang.String monitorPort;
        private java.lang.Long riseCount;
        private java.lang.Long timeout;
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx.model.Tag> tags;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbHttpsMonitor}.
         */
        public Builder(java.lang.String resourceType) {
            this.resourceType = resourceType;
        }

        /**
         * authentication depth is used to set the verification depth in the server
         * certificates chain. format: int64
         *
         * @param certificateChainDepth New value for the property.
         */
        public Builder setCertificateChainDepth(java.lang.Long certificateChainDepth) {
            this.certificateChainDepth = certificateChainDepth;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_BALANCED}</li> <li>
         * {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_HIGH_SECURITY}</li> <li>
         * {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_HIGH_COMPATIBILITY}</li>
         * <li> {@link com.vmware.nsx.model.LbHttpsMonitor#CIPHER_GROUP_LABEL_CUSTOM}</li>
         * </ul> It is a label of cipher group which is mostly consumed by GUI.
         *
         * @param cipherGroupLabel New value for the property.
         */
        public Builder setCipherGroupLabel(java.lang.String cipherGroupLabel) {
            this.cipherGroupLabel = cipherGroupLabel;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_256_CBC_SHA}</li> <li>
         * {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_128_CBC_SHA}</li> <li>
         * {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_3DES_EDE_CBC_SHA}</li> <li>
         * {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_RSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_256_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_RSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_128_CBC_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_128_GCM_SHA256}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_256_CBC_SHA384}</li>
         * <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#CIPHERS_ECDH_RSA_WITH_AES_256_GCM_SHA384}</li>
         * </ul> supported SSL cipher list to servers
         *
         * @param ciphers New value for the property.
         */
        public Builder setCiphers(java.util.List<java.lang.String> ciphers) {
            this.ciphers = ciphers;
            return this;
        }

        /**
         * client certificate can be specified to support client authentication.
         *
         * @param clientCertificateId New value for the property.
         */
        public Builder setClientCertificateId(java.lang.String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        /**
         * This flag is set to true when all the ciphers and protocols are FIPS compliant.
         * It is set to false when one of the ciphers or protocols are not FIPS compliant..
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isFips New value for the property.
         */
        public Builder setIsFips(java.lang.Boolean isFips) {
            this.isFips = isFips;
            return this;
        }

        /**
         * This flag is set to true when all the ciphers and protocols are secure. It is
         * set to false when one of the ciphers or protocols is insecure.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isSecure New value for the property.
         */
        public Builder setIsSecure(java.lang.Boolean isSecure) {
            this.isSecure = isSecure;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_SSL_V2}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_SSL_V3}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_TLS_V1}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_TLS_V1_1}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#PROTOCOLS_TLS_V1_2}</li> </ul> SSL versions
         * TLS1.1 and TLS1.2 are supported and enabled by default. SSLv2, SSLv3, and TLS1.0
         * are supported, but disabled by default.
         *
         * @param protocols New value for the property.
         */
        public Builder setProtocols(java.util.List<java.lang.String> protocols) {
            this.protocols = protocols;
            return this;
        }

        /**
         * String to send as part of HTTP health check request body. Valid only for certain
         * HTTP methods like POST.
         *
         * @param requestBody New value for the property.
         */
        public Builder setRequestBody(java.lang.String requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        /**
         * Array of HTTP request headers
         *
         * @param requestHeaders New value for the property.
         */
        public Builder setRequestHeaders(java.util.List<com.vmware.nsx.model.LbHttpRequestHeader> requestHeaders) {
            this.requestHeaders = requestHeaders;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_GET}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_OPTIONS}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_POST}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_HEAD}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_METHOD_PUT}</li> </ul> the health
         * check method for HTTP monitor type
         *
         * @param requestMethod New value for the property.
         */
        public Builder setRequestMethod(java.lang.String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        /**
         * URL used for HTTP monitor
         *
         * @param requestUrl New value for the property.
         */
        public Builder setRequestUrl(java.lang.String requestUrl) {
            this.requestUrl = requestUrl;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_VERSION_0}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#REQUEST_VERSION_1}</li> </ul> HTTP request
         * version
         *
         * @param requestVersion New value for the property.
         */
        public Builder setRequestVersion(java.lang.String requestVersion) {
            this.requestVersion = requestVersion;
            return this;
        }

        /**
         * If HTTP response body match string (regular expressions not supported) is
         * specified (using LbHttpMonitor.response_body) then the healthcheck HTTP response
         * body is matched against the specified string and server is considered healthy
         * only if there is a match. If the response body string is not specified, HTTP
         * healthcheck is considered successful if the HTTP response status code is 2xx,
         * but it can be configured to accept other status codes as successful.
         *
         * @param responseBody New value for the property.
         */
        public Builder setResponseBody(java.lang.String responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        /**
         * The HTTP response status code should be a valid HTTP status code. format: int32
         *
         * @param responseStatusCodes New value for the property.
         */
        public Builder setResponseStatusCodes(java.util.List<java.lang.Long> responseStatusCodes) {
            this.responseStatusCodes = responseStatusCodes;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#SERVER_AUTH_REQUIRED}</li> <li> {@link
         * com.vmware.nsx.model.LbHttpsMonitor#SERVER_AUTH_IGNORE}</li> </ul> server
         * authentication mode
         *
         * @param serverAuth New value for the property.
         */
        public Builder setServerAuth(java.lang.String serverAuth) {
            this.serverAuth = serverAuth;
            return this;
        }

        /**
         * If server auth type is REQUIRED, server certificate must be signed by one of the
         * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
         * signed certificates are specified.
         *
         * @param serverAuthCaIds New value for the property.
         */
        public Builder setServerAuthCaIds(java.util.List<java.lang.String> serverAuthCaIds) {
            this.serverAuthCaIds = serverAuthCaIds;
            return this;
        }

        /**
         * A Certificate Revocation List (CRL) can be specified in the server-side SSL
         * profile binding to disallow compromised server certificates.
         *
         * @param serverAuthCrlIds New value for the property.
         */
        public Builder setServerAuthCrlIds(java.util.List<java.lang.String> serverAuthCrlIds) {
            this.serverAuthCrlIds = serverAuthCrlIds;
            return this;
        }

        /**
         * num of consecutive checks must fail before marking it down format: int64
         *
         * @param fallCount New value for the property.
         */
        public Builder setFallCount(java.lang.Long fallCount) {
            this.fallCount = fallCount;
            return this;
        }

        /**
         * the frequency at which the system issues the monitor check (in second) format:
         * int64
         *
         * @param interval New value for the property.
         */
        public Builder setInterval(java.lang.Long interval) {
            this.interval = interval;
            return this;
        }

        /**
         * If the monitor port is specified, it would override pool member port setting for
         * healthcheck. A port range is not supported. For ICMP monitor, monitor_port is
         * not required. format: port-or-range
         *
         * @param monitorPort New value for the property.
         */
        public Builder setMonitorPort(java.lang.String monitorPort) {
            this.monitorPort = monitorPort;
            return this;
        }

        /**
         * num of consecutive checks must pass before marking it up format: int64
         *
         * @param riseCount New value for the property.
         */
        public Builder setRiseCount(java.lang.Long riseCount) {
            this.riseCount = riseCount;
            return this;
        }

        /**
         * the number of seconds the target has in which to respond to the monitor request
         * format: int64
         *
         * @param timeout New value for the property.
         */
        public Builder setTimeout(java.lang.Long timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        public LbHttpsMonitor build() {
            LbHttpsMonitor result = new LbHttpsMonitor();
            result.setCertificateChainDepth(this.certificateChainDepth);
            result.setCipherGroupLabel(this.cipherGroupLabel);
            result.setCiphers(this.ciphers);
            result.setClientCertificateId(this.clientCertificateId);
            result.setIsFips(this.isFips);
            result.setIsSecure(this.isSecure);
            result.setProtocols(this.protocols);
            result.setRequestBody(this.requestBody);
            result.setRequestHeaders(this.requestHeaders);
            result.setRequestMethod(this.requestMethod);
            result.setRequestUrl(this.requestUrl);
            result.setRequestVersion(this.requestVersion);
            result.setResponseBody(this.responseBody);
            result.setResponseStatusCodes(this.responseStatusCodes);
            result.setServerAuth(this.serverAuth);
            result.setServerAuthCaIds(this.serverAuthCaIds);
            result.setServerAuthCrlIds(this.serverAuthCrlIds);
            result.setFallCount(this.fallCount);
            result.setInterval(this.interval);
            result.setMonitorPort(this.monitorPort);
            result.setRiseCount(this.riseCount);
            result.setTimeout(this.timeout);
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("certificate_chain_depth", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificate_chain_depth",
                                                                                "certificateChainDepth",
                                                                                "getCertificateChainDepth",
                                                                                "setCertificateChainDepth");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cipher_group_label", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cipher_group_label",
                                                                                "cipherGroupLabel",
                                                                                "getCipherGroupLabel",
                                                                                "setCipherGroupLabel");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ciphers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ciphers",
                                                                                "ciphers",
                                                                                "getCiphers",
                                                                                "setCiphers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_certificate_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_certificate_id",
                                                                                "clientCertificateId",
                                                                                "getClientCertificateId",
                                                                                "setClientCertificateId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_fips", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_fips",
                                                                                "isFips",
                                                                                "getIsFips",
                                                                                "setIsFips");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_secure", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_secure",
                                                                                "isSecure",
                                                                                "getIsSecure",
                                                                                "setIsSecure");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("protocols", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("protocols",
                                                                                "protocols",
                                                                                "getProtocols",
                                                                                "setProtocols");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_body", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_body",
                                                                                "requestBody",
                                                                                "getRequestBody",
                                                                                "setRequestBody");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_headers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbHttpRequestHeader; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_headers",
                                                                                "requestHeaders",
                                                                                "getRequestHeaders",
                                                                                "setRequestHeaders");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_method", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_method",
                                                                                "requestMethod",
                                                                                "getRequestMethod",
                                                                                "setRequestMethod");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_url", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_url",
                                                                                "requestUrl",
                                                                                "getRequestUrl",
                                                                                "setRequestUrl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_version",
                                                                                "requestVersion",
                                                                                "getRequestVersion",
                                                                                "setRequestVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("response_body", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("response_body",
                                                                                "responseBody",
                                                                                "getResponseBody",
                                                                                "setResponseBody");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("response_status_codes", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.IntegerType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("response_status_codes",
                                                                                "responseStatusCodes",
                                                                                "getResponseStatusCodes",
                                                                                "setResponseStatusCodes");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_auth", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_auth",
                                                                                "serverAuth",
                                                                                "getServerAuth",
                                                                                "setServerAuth");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_auth_ca_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_auth_ca_ids",
                                                                                "serverAuthCaIds",
                                                                                "getServerAuthCaIds",
                                                                                "setServerAuthCaIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_auth_crl_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_auth_crl_ids",
                                                                                "serverAuthCrlIds",
                                                                                "getServerAuthCrlIds",
                                                                                "setServerAuthCrlIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("fall_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fall_count",
                                                                                "fallCount",
                                                                                "getFallCount",
                                                                                "setFallCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("interval",
                                                                                "interval",
                                                                                "getInterval",
                                                                                "setInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("monitor_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("monitor_port",
                                                                                "monitorPort",
                                                                                "getMonitorPort",
                                                                                "setMonitorPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rise_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rise_count",
                                                                                "riseCount",
                                                                                "getRiseCount",
                                                                                "setRiseCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("timeout",
                                                                                "timeout",
                                                                                "getTimeout",
                                                                                "setTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_https_monitor",
                                                            fields,
                                                            com.vmware.nsx.model.LbHttpsMonitor.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            null);
    }
}

