/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Match conditions are used to match application traffic passing through load
 * balancers. Multiple match conditions can be specified in one load balancer rule,
 * each match condition defines a criterion for application traffic. If inverse
 * field is set to true, the match result of the condition is inverted. If more
 * than one match condition is specified, match strategy determines if all
 * conditions should match or any one condition should match for the load balancer
 * rule to be considered a match. Currently only HTTP messages are supported by
 * load balancer rules. Each load balancer rule is used at a specific phase of load
 * balancer processing. Currently three phases are supported, HTTP_REQUEST_REWRITE,
 * HTTP_FORWARDING and HTTP_RESPONSE_REWRITE. Each phase supports certain types of
 * match conditions, supported match conditions in HTTP_REQUEST_REWRITE phase are:
 * LbHttpRequestMethodCondition LbHttpRequestUriCondition
 * LbHttpRequestUriArgumentsCondition LbHttpRequestVersionCondition
 * LbHttpRequestHeaderCondition LbHttpRequestCookieCondition
 * LbHttpRequestBodyCondition LbTcpHeaderCondition LbIpHeaderCondition
 * LbVariableCondition LbHttpSslCondition Supported match conditions in
 * HTTP_FORWARDING phase are: LbHttpRequestMethodCondition
 * LbHttpRequestUriCondition LbHttpRequestUriArgumentsCondition
 * LbHttpRequestVersionCondition LbHttpRequestHeaderCondition
 * LbHttpRequestCookieCondition LbHttpRequestBodyCondition LbTcpHeaderCondition
 * LbIpHeaderCondition LbVariableCondition LbHttpSslCondition LbSslSniCondition
 * Supported match condition in HTTP_RESPONSE_REWRITE phase is:
 * LbHttpResponseHeaderCondition LbHttpRequestMethodCondition
 * LbHttpRequestUriCondition LbHttpRequestUriArgumentsCondition
 * LbHttpRequestVersionCondition LbHttpRequestHeaderCondition
 * LbHttpRequestCookieCondition LbTcpHeaderCondition LbIpHeaderCondition
 * LbVariableCondition LbHttpSslCondition Supported match condition in HTTP_ACCESS
 * phase is: LbHttpRequestMethodCondition LbHttpRequestUriCondition
 * LbHttpRequestUriArgumentsCondition LbHttpRequestVersionCondition
 * LbHttpRequestHeaderCondition LbHttpRequestCookieCondition
 * LbHttpRequestBodyCondition LbTcpHeaderCondition LbIpHeaderCondition
 * LbVariableCondition LbHttpSslCondition Supported match condition in TRANSPORT
 * phase is: LbSslSniCondition
 */
public final class LbRuleCondition implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LbRuleCondition";

    public static final java.lang.String TYPE_LBHTTPREQUESTMETHODCONDITION = "LbHttpRequestMethodCondition";

    public static final java.lang.String TYPE_LBHTTPREQUESTURICONDITION = "LbHttpRequestUriCondition";

    public static final java.lang.String TYPE_LBHTTPREQUESTURIARGUMENTSCONDITION = "LbHttpRequestUriArgumentsCondition";

    public static final java.lang.String TYPE_LBHTTPREQUESTVERSIONCONDITION = "LbHttpRequestVersionCondition";

    public static final java.lang.String TYPE_LBHTTPREQUESTHEADERCONDITION = "LbHttpRequestHeaderCondition";

    public static final java.lang.String TYPE_LBHTTPREQUESTCOOKIECONDITION = "LbHttpRequestCookieCondition";

    public static final java.lang.String TYPE_LBHTTPREQUESTBODYCONDITION = "LbHttpRequestBodyCondition";

    public static final java.lang.String TYPE_LBHTTPRESPONSEHEADERCONDITION = "LbHttpResponseHeaderCondition";

    public static final java.lang.String TYPE_LBTCPHEADERCONDITION = "LbTcpHeaderCondition";

    public static final java.lang.String TYPE_LBIPHEADERCONDITION = "LbIpHeaderCondition";

    public static final java.lang.String TYPE_LBVARIABLECONDITION = "LbVariableCondition";

    public static final java.lang.String TYPE_LBHTTPSSLCONDITION = "LbHttpSslCondition";

    public static final java.lang.String TYPE_LBSSLSNICONDITION = "LbSslSniCondition";

    private java.lang.Boolean inverse;

    private final java.lang.String type = "LbRuleCondition";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbRuleCondition() {
    }

    protected LbRuleCondition(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * A flag to indicate whether reverse the match result of this condition
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getInverse() {
        return this.inverse;
    }

    /**
     * A flag to indicate whether reverse the match result of this condition
     *
     * @param inverse New value for the property.
     */
    public void setInverse(java.lang.Boolean inverse) {
        this.inverse = inverse;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTMETHODCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTURICONDITION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTURIARGUMENTSCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTVERSIONCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTHEADERCONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTCOOKIECONDITION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPREQUESTBODYCONDITION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPRESPONSEHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBTCPHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBIPHEADERCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBVARIABLECONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBHTTPSSLCONDITION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleCondition#TYPE_LBSSLSNICONDITION}</li>
     * </ul> Type of load balancer rule condition
     * The value of this property is automatically populated to {@code "LbRuleCondition"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbRuleCondition;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("inverse",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.inverse, this._getType().getField("inverse")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbRuleCondition;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbRuleCondition.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbRuleCondition _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbRuleCondition(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbRuleCondition _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbRuleCondition(structValue);
    }

    /**
     * Builder class for {@link LbRuleCondition}.
     */
    public static final class Builder {
        private java.lang.Boolean inverse;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbRuleCondition}.
         */
        public Builder() {
        }

        /**
         * A flag to indicate whether reverse the match result of this condition
         *
         * @param inverse New value for the property.
         */
        public Builder setInverse(java.lang.Boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public LbRuleCondition build() {
            LbRuleCondition result = new LbRuleCondition();
            result.setInverse(this.inverse);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("inverse", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("inverse",
                                                                                "inverse",
                                                                                "getInverse",
                                                                                "setInverse");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_rule_condition",
                                                            fields,
                                                            com.vmware.nsx.model.LbRuleCondition.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LbRuleCondition");
    }
}

