/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class LbVirtualServer implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String IP_PROTOCOL_TCP = "TCP";

    public static final java.lang.String IP_PROTOCOL_UDP = "UDP";

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    private com.vmware.nsx.model.LbAccessListControl accessListControl;

    private java.lang.Boolean accessLogEnabled;

    private java.lang.String applicationProfileId;

    private com.vmware.nsx.model.ClientSslProfileBinding clientSslProfileBinding;

    private java.lang.String defaultPoolMemberPort;

    private java.util.List<java.lang.String> defaultPoolMemberPorts;

    private java.lang.Boolean enabled;

    private java.lang.String ipAddress;

    private java.lang.String ipProtocol;

    private java.lang.Boolean logSignificantEventOnly;

    private java.lang.Long maxConcurrentConnections;

    private java.lang.Long maxNewConnectionRate;

    private java.lang.String persistenceProfileId;

    private java.lang.String poolId;

    private java.lang.String port;

    private java.util.List<java.lang.String> ports;

    private java.util.List<java.lang.String> ruleIds;

    private com.vmware.nsx.model.ServerSslProfileBinding serverSslProfileBinding;

    private java.lang.String sorryPoolId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbVirtualServer() {
    }

    protected LbVirtualServer(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.LbAccessListControl getAccessListControl() {
        return this.accessListControl;
    }

    /**
     *
     *
     * @param accessListControl New value for the property.
     */
    public void setAccessListControl(com.vmware.nsx.model.LbAccessListControl accessListControl) {
        this.accessListControl = accessListControl;
    }

    /**
     * Whether access log is enabled
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAccessLogEnabled() {
        return this.accessLogEnabled;
    }

    /**
     * Whether access log is enabled
     *
     * @param accessLogEnabled New value for the property.
     */
    public void setAccessLogEnabled(java.lang.Boolean accessLogEnabled) {
        this.accessLogEnabled = accessLogEnabled;
    }

    /**
     * The application profile defines the application protocol characteristics. It is
     * used to influence how load balancing is performed. Currently, LbFastTCPProfile,
     * LbFastUDPProfile and LbHttpProfile, etc are supported.
     *
     * @return The current value of the property.
     */
    public java.lang.String getApplicationProfileId() {
        return this.applicationProfileId;
    }

    /**
     * The application profile defines the application protocol characteristics. It is
     * used to influence how load balancing is performed. Currently, LbFastTCPProfile,
     * LbFastUDPProfile and LbHttpProfile, etc are supported.
     *
     * @param applicationProfileId New value for the property.
     */
    public void setApplicationProfileId(java.lang.String applicationProfileId) {
        this.applicationProfileId = applicationProfileId;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.ClientSslProfileBinding getClientSslProfileBinding() {
        return this.clientSslProfileBinding;
    }

    /**
     *
     *
     * @param clientSslProfileBinding New value for the property.
     */
    public void setClientSslProfileBinding(com.vmware.nsx.model.ClientSslProfileBinding clientSslProfileBinding) {
        this.clientSslProfileBinding = clientSslProfileBinding;
    }

    /**
     * This is a deprecated property, please use 'default_pool_member_ports' instead.
     * If default_pool_member_port is configured and default_pool_member_ports are not
     * specified, both default_pool_member_port and default_pool_member_ports in
     * response payload would return the same port value. If both are specified,
     * default_pool_member_ports setting would take effect with higher priority.
     * format: port-or-range
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getDefaultPoolMemberPort() {
        return this.defaultPoolMemberPort;
    }

    /**
     * This is a deprecated property, please use 'default_pool_member_ports' instead.
     * If default_pool_member_port is configured and default_pool_member_ports are not
     * specified, both default_pool_member_port and default_pool_member_ports in
     * response payload would return the same port value. If both are specified,
     * default_pool_member_ports setting would take effect with higher priority.
     * format: port-or-range
     *
     * @param defaultPoolMemberPort New value for the property.
     */
    @Deprecated
    public void setDefaultPoolMemberPort(java.lang.String defaultPoolMemberPort) {
        this.defaultPoolMemberPort = defaultPoolMemberPort;
    }

    /**
     * If default_pool_member_ports are configured, both default_pool_member_port and
     * default_pool_member_ports in the response payload would include port settings,
     * notice that the value of default_pool_member_port is the first element of
     * default_pool_member_ports. format: port-or-range
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDefaultPoolMemberPorts() {
        return this.defaultPoolMemberPorts;
    }

    /**
     * If default_pool_member_ports are configured, both default_pool_member_port and
     * default_pool_member_ports in the response payload would include port settings,
     * notice that the value of default_pool_member_port is the first element of
     * default_pool_member_ports. format: port-or-range
     *
     * @param defaultPoolMemberPorts New value for the property.
     */
    public void setDefaultPoolMemberPorts(java.util.List<java.lang.String> defaultPoolMemberPorts) {
        this.defaultPoolMemberPorts = defaultPoolMemberPorts;
    }

    /**
     * whether the virtual server is enabled
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * whether the virtual server is enabled
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * virtual server IP address format: ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * virtual server IP address format: ip
     *
     * @param ipAddress New value for the property.
     */
    public void setIpAddress(java.lang.String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbVirtualServer#IP_PROTOCOL_TCP}</li> <li> {@link
     * com.vmware.nsx.model.LbVirtualServer#IP_PROTOCOL_UDP}</li> </ul> Assigned
     * Internet Protocol in IP header, TCP, UDP are supported.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpProtocol() {
        return this.ipProtocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbVirtualServer#IP_PROTOCOL_TCP}</li> <li> {@link
     * com.vmware.nsx.model.LbVirtualServer#IP_PROTOCOL_UDP}</li> </ul> Assigned
     * Internet Protocol in IP header, TCP, UDP are supported.
     *
     * @param ipProtocol New value for the property.
     */
    public void setIpProtocol(java.lang.String ipProtocol) {
        this.ipProtocol = ipProtocol;
    }

    /**
     * The property log_significant_event_only can take effect only when
     * access_log_enabled is true. If log_significant_event_only is true, significant
     * events are logged in access log. For L4 virtual server, significant event means
     * unsuccessful(error or dropped) TCP/UDP connections. For L7 virtual server,
     * significant event means unsuccessful connections or HTTP/HTTPS requests which
     * have error response code(e.g. 4xx, 5xx).
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getLogSignificantEventOnly() {
        return this.logSignificantEventOnly;
    }

    /**
     * The property log_significant_event_only can take effect only when
     * access_log_enabled is true. If log_significant_event_only is true, significant
     * events are logged in access log. For L4 virtual server, significant event means
     * unsuccessful(error or dropped) TCP/UDP connections. For L7 virtual server,
     * significant event means unsuccessful connections or HTTP/HTTPS requests which
     * have error response code(e.g. 4xx, 5xx).
     *
     * @param logSignificantEventOnly New value for the property.
     */
    public void setLogSignificantEventOnly(java.lang.Boolean logSignificantEventOnly) {
        this.logSignificantEventOnly = logSignificantEventOnly;
    }

    /**
     * To ensure one virtual server does not over consume resources, affecting other
     * applications hosted on the same LBS, connections to a virtual server can be
     * capped. If it is not specified, it means that connections are unlimited. The
     * property is deprecated as NSX-T Load Balancer is deprecated. format: int64
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getMaxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    /**
     * To ensure one virtual server does not over consume resources, affecting other
     * applications hosted on the same LBS, connections to a virtual server can be
     * capped. If it is not specified, it means that connections are unlimited. The
     * property is deprecated as NSX-T Load Balancer is deprecated. format: int64
     *
     * @param maxConcurrentConnections New value for the property.
     */
    @Deprecated
    public void setMaxConcurrentConnections(java.lang.Long maxConcurrentConnections) {
        this.maxConcurrentConnections = maxConcurrentConnections;
    }

    /**
     * To ensure one virtual server does not over consume resources, connections to a
     * member can be rate limited. If it is not specified, it means that connection
     * rate is unlimited. The property is deprecated as NSX-T Load Balancer is
     * deprecated. format: int64
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getMaxNewConnectionRate() {
        return this.maxNewConnectionRate;
    }

    /**
     * To ensure one virtual server does not over consume resources, connections to a
     * member can be rate limited. If it is not specified, it means that connection
     * rate is unlimited. The property is deprecated as NSX-T Load Balancer is
     * deprecated. format: int64
     *
     * @param maxNewConnectionRate New value for the property.
     */
    @Deprecated
    public void setMaxNewConnectionRate(java.lang.Long maxNewConnectionRate) {
        this.maxNewConnectionRate = maxNewConnectionRate;
    }

    /**
     * Persistence profile is used to allow related client connections to be sent to
     * the same backend server.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPersistenceProfileId() {
        return this.persistenceProfileId;
    }

    /**
     * Persistence profile is used to allow related client connections to be sent to
     * the same backend server.
     *
     * @param persistenceProfileId New value for the property.
     */
    public void setPersistenceProfileId(java.lang.String persistenceProfileId) {
        this.persistenceProfileId = persistenceProfileId;
    }

    /**
     * The server pool(LbPool) contains backend servers. Server pool consists of one or
     * more servers, also referred to as pool members, that are similarly configured
     * and are running the same application.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPoolId() {
        return this.poolId;
    }

    /**
     * The server pool(LbPool) contains backend servers. Server pool consists of one or
     * more servers, also referred to as pool members, that are similarly configured
     * and are running the same application.
     *
     * @param poolId New value for the property.
     */
    public void setPoolId(java.lang.String poolId) {
        this.poolId = poolId;
    }

    /**
     * This is a deprecated property, please use 'ports' instead. Port setting could be
     * single port for both L7 mode and L4 mode. For L4 mode, a single port range is
     * also supported. The port setting could be a single port or port range such as
     * \"80\", \"1234-1236\". If port is configured and ports are not specified, both
     * port and ports in response payload would return the same port value. If both
     * port and ports are configured, ports setting would take effect with higher
     * priority. format: port-or-range
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getPort() {
        return this.port;
    }

    /**
     * This is a deprecated property, please use 'ports' instead. Port setting could be
     * single port for both L7 mode and L4 mode. For L4 mode, a single port range is
     * also supported. The port setting could be a single port or port range such as
     * \"80\", \"1234-1236\". If port is configured and ports are not specified, both
     * port and ports in response payload would return the same port value. If both
     * port and ports are configured, ports setting would take effect with higher
     * priority. format: port-or-range
     *
     * @param port New value for the property.
     */
    @Deprecated
    public void setPort(java.lang.String port) {
        this.port = port;
    }

    /**
     * Port setting could be a single port for both L7 mode and L4 mode. For L4 mode,
     * multiple ports or port ranges are also supported such as \"80\", \"443\",
     * \"1234-1236\". If ports is configured, both port and ports in the response
     * payload would include port settings, notice that the port field value is the
     * first element of ports. format: port-or-range
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getPorts() {
        return this.ports;
    }

    /**
     * Port setting could be a single port for both L7 mode and L4 mode. For L4 mode,
     * multiple ports or port ranges are also supported such as \"80\", \"443\",
     * \"1234-1236\". If ports is configured, both port and ports in the response
     * payload would include port settings, notice that the port field value is the
     * first element of ports. format: port-or-range
     *
     * @param ports New value for the property.
     */
    public void setPorts(java.util.List<java.lang.String> ports) {
        this.ports = ports;
    }

    /**
     * Load balancer rules allow customization of load balancing behavior using
     * match/action rules. Currently, load balancer rules are supported for only layer
     * 7 virtual servers with LbHttpProfile. The property is deprecated as NSX-T Load
     * Balancer is deprecated.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<java.lang.String> getRuleIds() {
        return this.ruleIds;
    }

    /**
     * Load balancer rules allow customization of load balancing behavior using
     * match/action rules. Currently, load balancer rules are supported for only layer
     * 7 virtual servers with LbHttpProfile. The property is deprecated as NSX-T Load
     * Balancer is deprecated.
     *
     * @param ruleIds New value for the property.
     */
    @Deprecated
    public void setRuleIds(java.util.List<java.lang.String> ruleIds) {
        this.ruleIds = ruleIds;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.ServerSslProfileBinding getServerSslProfileBinding() {
        return this.serverSslProfileBinding;
    }

    /**
     *
     *
     * @param serverSslProfileBinding New value for the property.
     */
    public void setServerSslProfileBinding(com.vmware.nsx.model.ServerSslProfileBinding serverSslProfileBinding) {
        this.serverSslProfileBinding = serverSslProfileBinding;
    }

    /**
     * When load balancer can not select a backend server to serve the request in
     * default pool or pool in rules, the request would be served by sorry server pool.
     * The property is deprecated as NSX-T Load Balancer is deprecated.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getSorryPoolId() {
        return this.sorryPoolId;
    }

    /**
     * When load balancer can not select a backend server to serve the request in
     * default pool or pool in rules, the request would be served by sorry server pool.
     * The property is deprecated as NSX-T Load Balancer is deprecated.
     *
     * @param sorryPoolId New value for the property.
     */
    @Deprecated
    public void setSorryPoolId(java.lang.String sorryPoolId) {
        this.sorryPoolId = sorryPoolId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbVirtualServer;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("access_list_control",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.accessListControl, this._getType().getField("access_list_control")));
        structValue.setField("access_log_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.accessLogEnabled, this._getType().getField("access_log_enabled")));
        structValue.setField("application_profile_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.applicationProfileId, this._getType().getField("application_profile_id")));
        structValue.setField("client_ssl_profile_binding",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientSslProfileBinding, this._getType().getField("client_ssl_profile_binding")));
        structValue.setField("default_pool_member_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultPoolMemberPort, this._getType().getField("default_pool_member_port")));
        structValue.setField("default_pool_member_ports",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultPoolMemberPorts, this._getType().getField("default_pool_member_ports")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddress, this._getType().getField("ip_address")));
        structValue.setField("ip_protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipProtocol, this._getType().getField("ip_protocol")));
        structValue.setField("log_significant_event_only",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.logSignificantEventOnly, this._getType().getField("log_significant_event_only")));
        structValue.setField("max_concurrent_connections",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxConcurrentConnections, this._getType().getField("max_concurrent_connections")));
        structValue.setField("max_new_connection_rate",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxNewConnectionRate, this._getType().getField("max_new_connection_rate")));
        structValue.setField("persistence_profile_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.persistenceProfileId, this._getType().getField("persistence_profile_id")));
        structValue.setField("pool_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolId, this._getType().getField("pool_id")));
        structValue.setField("port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.port, this._getType().getField("port")));
        structValue.setField("ports",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ports, this._getType().getField("ports")));
        structValue.setField("rule_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ruleIds, this._getType().getField("rule_ids")));
        structValue.setField("server_ssl_profile_binding",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverSslProfileBinding, this._getType().getField("server_ssl_profile_binding")));
        structValue.setField("sorry_pool_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sorryPoolId, this._getType().getField("sorry_pool_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbVirtualServer;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbVirtualServer.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbVirtualServer _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbVirtualServer(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbVirtualServer _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbVirtualServer(structValue);
    }

    /**
     * Builder class for {@link LbVirtualServer}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx.model.Tag> tags;
        private com.vmware.nsx.model.LbAccessListControl accessListControl;
        private java.lang.Boolean accessLogEnabled;
        private java.lang.String applicationProfileId;
        private com.vmware.nsx.model.ClientSslProfileBinding clientSslProfileBinding;
        private java.lang.String defaultPoolMemberPort;
        private java.util.List<java.lang.String> defaultPoolMemberPorts;
        private java.lang.Boolean enabled;
        private java.lang.String ipAddress;
        private java.lang.String ipProtocol;
        private java.lang.Boolean logSignificantEventOnly;
        private java.lang.Long maxConcurrentConnections;
        private java.lang.Long maxNewConnectionRate;
        private java.lang.String persistenceProfileId;
        private java.lang.String poolId;
        private java.lang.String port;
        private java.util.List<java.lang.String> ports;
        private java.util.List<java.lang.String> ruleIds;
        private com.vmware.nsx.model.ServerSslProfileBinding serverSslProfileBinding;
        private java.lang.String sorryPoolId;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbVirtualServer}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         *
         *
         * @param accessListControl New value for the property.
         */
        public Builder setAccessListControl(com.vmware.nsx.model.LbAccessListControl accessListControl) {
            this.accessListControl = accessListControl;
            return this;
        }

        /**
         * Whether access log is enabled
         *
         * @param accessLogEnabled New value for the property.
         */
        public Builder setAccessLogEnabled(java.lang.Boolean accessLogEnabled) {
            this.accessLogEnabled = accessLogEnabled;
            return this;
        }

        /**
         * The application profile defines the application protocol characteristics. It is
         * used to influence how load balancing is performed. Currently, LbFastTCPProfile,
         * LbFastUDPProfile and LbHttpProfile, etc are supported.
         *
         * @param applicationProfileId New value for the property.
         */
        public Builder setApplicationProfileId(java.lang.String applicationProfileId) {
            this.applicationProfileId = applicationProfileId;
            return this;
        }

        /**
         *
         *
         * @param clientSslProfileBinding New value for the property.
         */
        public Builder setClientSslProfileBinding(com.vmware.nsx.model.ClientSslProfileBinding clientSslProfileBinding) {
            this.clientSslProfileBinding = clientSslProfileBinding;
            return this;
        }

        /**
         * This is a deprecated property, please use 'default_pool_member_ports' instead.
         * If default_pool_member_port is configured and default_pool_member_ports are not
         * specified, both default_pool_member_port and default_pool_member_ports in
         * response payload would return the same port value. If both are specified,
         * default_pool_member_ports setting would take effect with higher priority.
         * format: port-or-range
         *
         * @param defaultPoolMemberPort New value for the property.
         */
        public Builder setDefaultPoolMemberPort(java.lang.String defaultPoolMemberPort) {
            this.defaultPoolMemberPort = defaultPoolMemberPort;
            return this;
        }

        /**
         * If default_pool_member_ports are configured, both default_pool_member_port and
         * default_pool_member_ports in the response payload would include port settings,
         * notice that the value of default_pool_member_port is the first element of
         * default_pool_member_ports. format: port-or-range
         *
         * @param defaultPoolMemberPorts New value for the property.
         */
        public Builder setDefaultPoolMemberPorts(java.util.List<java.lang.String> defaultPoolMemberPorts) {
            this.defaultPoolMemberPorts = defaultPoolMemberPorts;
            return this;
        }

        /**
         * whether the virtual server is enabled
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * virtual server IP address format: ip
         *
         * @param ipAddress New value for the property.
         */
        public Builder setIpAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbVirtualServer#IP_PROTOCOL_TCP}</li> <li> {@link
         * com.vmware.nsx.model.LbVirtualServer#IP_PROTOCOL_UDP}</li> </ul> Assigned
         * Internet Protocol in IP header, TCP, UDP are supported.
         *
         * @param ipProtocol New value for the property.
         */
        public Builder setIpProtocol(java.lang.String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        /**
         * The property log_significant_event_only can take effect only when
         * access_log_enabled is true. If log_significant_event_only is true, significant
         * events are logged in access log. For L4 virtual server, significant event means
         * unsuccessful(error or dropped) TCP/UDP connections. For L7 virtual server,
         * significant event means unsuccessful connections or HTTP/HTTPS requests which
         * have error response code(e.g. 4xx, 5xx).
         *
         * @param logSignificantEventOnly New value for the property.
         */
        public Builder setLogSignificantEventOnly(java.lang.Boolean logSignificantEventOnly) {
            this.logSignificantEventOnly = logSignificantEventOnly;
            return this;
        }

        /**
         * To ensure one virtual server does not over consume resources, affecting other
         * applications hosted on the same LBS, connections to a virtual server can be
         * capped. If it is not specified, it means that connections are unlimited. The
         * property is deprecated as NSX-T Load Balancer is deprecated. format: int64
         *
         * @param maxConcurrentConnections New value for the property.
         */
        public Builder setMaxConcurrentConnections(java.lang.Long maxConcurrentConnections) {
            this.maxConcurrentConnections = maxConcurrentConnections;
            return this;
        }

        /**
         * To ensure one virtual server does not over consume resources, connections to a
         * member can be rate limited. If it is not specified, it means that connection
         * rate is unlimited. The property is deprecated as NSX-T Load Balancer is
         * deprecated. format: int64
         *
         * @param maxNewConnectionRate New value for the property.
         */
        public Builder setMaxNewConnectionRate(java.lang.Long maxNewConnectionRate) {
            this.maxNewConnectionRate = maxNewConnectionRate;
            return this;
        }

        /**
         * Persistence profile is used to allow related client connections to be sent to
         * the same backend server.
         *
         * @param persistenceProfileId New value for the property.
         */
        public Builder setPersistenceProfileId(java.lang.String persistenceProfileId) {
            this.persistenceProfileId = persistenceProfileId;
            return this;
        }

        /**
         * The server pool(LbPool) contains backend servers. Server pool consists of one or
         * more servers, also referred to as pool members, that are similarly configured
         * and are running the same application.
         *
         * @param poolId New value for the property.
         */
        public Builder setPoolId(java.lang.String poolId) {
            this.poolId = poolId;
            return this;
        }

        /**
         * This is a deprecated property, please use 'ports' instead. Port setting could be
         * single port for both L7 mode and L4 mode. For L4 mode, a single port range is
         * also supported. The port setting could be a single port or port range such as
         * \"80\", \"1234-1236\". If port is configured and ports are not specified, both
         * port and ports in response payload would return the same port value. If both
         * port and ports are configured, ports setting would take effect with higher
         * priority. format: port-or-range
         *
         * @param port New value for the property.
         */
        public Builder setPort(java.lang.String port) {
            this.port = port;
            return this;
        }

        /**
         * Port setting could be a single port for both L7 mode and L4 mode. For L4 mode,
         * multiple ports or port ranges are also supported such as \"80\", \"443\",
         * \"1234-1236\". If ports is configured, both port and ports in the response
         * payload would include port settings, notice that the port field value is the
         * first element of ports. format: port-or-range
         *
         * @param ports New value for the property.
         */
        public Builder setPorts(java.util.List<java.lang.String> ports) {
            this.ports = ports;
            return this;
        }

        /**
         * Load balancer rules allow customization of load balancing behavior using
         * match/action rules. Currently, load balancer rules are supported for only layer
         * 7 virtual servers with LbHttpProfile. The property is deprecated as NSX-T Load
         * Balancer is deprecated.
         *
         * @param ruleIds New value for the property.
         */
        public Builder setRuleIds(java.util.List<java.lang.String> ruleIds) {
            this.ruleIds = ruleIds;
            return this;
        }

        /**
         *
         *
         * @param serverSslProfileBinding New value for the property.
         */
        public Builder setServerSslProfileBinding(com.vmware.nsx.model.ServerSslProfileBinding serverSslProfileBinding) {
            this.serverSslProfileBinding = serverSslProfileBinding;
            return this;
        }

        /**
         * When load balancer can not select a backend server to serve the request in
         * default pool or pool in rules, the request would be served by sorry server pool.
         * The property is deprecated as NSX-T Load Balancer is deprecated.
         *
         * @param sorryPoolId New value for the property.
         */
        public Builder setSorryPoolId(java.lang.String sorryPoolId) {
            this.sorryPoolId = sorryPoolId;
            return this;
        }

        public LbVirtualServer build() {
            LbVirtualServer result = new LbVirtualServer();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setAccessListControl(this.accessListControl);
            result.setAccessLogEnabled(this.accessLogEnabled);
            result.setApplicationProfileId(this.applicationProfileId);
            result.setClientSslProfileBinding(this.clientSslProfileBinding);
            result.setDefaultPoolMemberPort(this.defaultPoolMemberPort);
            result.setDefaultPoolMemberPorts(this.defaultPoolMemberPorts);
            result.setEnabled(this.enabled);
            result.setIpAddress(this.ipAddress);
            result.setIpProtocol(this.ipProtocol);
            result.setLogSignificantEventOnly(this.logSignificantEventOnly);
            result.setMaxConcurrentConnections(this.maxConcurrentConnections);
            result.setMaxNewConnectionRate(this.maxNewConnectionRate);
            result.setPersistenceProfileId(this.persistenceProfileId);
            result.setPoolId(this.poolId);
            result.setPort(this.port);
            result.setPorts(this.ports);
            result.setRuleIds(this.ruleIds);
            result.setServerSslProfileBinding(this.serverSslProfileBinding);
            result.setSorryPoolId(this.sorryPoolId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("access_list_control", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbAccessListControl; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("access_list_control",
                                                                                "accessListControl",
                                                                                "getAccessListControl",
                                                                                "setAccessListControl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("access_log_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("access_log_enabled",
                                                                                "accessLogEnabled",
                                                                                "getAccessLogEnabled",
                                                                                "setAccessLogEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("application_profile_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("application_profile_id",
                                                                                "applicationProfileId",
                                                                                "getApplicationProfileId",
                                                                                "setApplicationProfileId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_ssl_profile_binding", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.clientSslProfileBinding; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_ssl_profile_binding",
                                                                                "clientSslProfileBinding",
                                                                                "getClientSslProfileBinding",
                                                                                "setClientSslProfileBinding");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_pool_member_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_pool_member_port",
                                                                                "defaultPoolMemberPort",
                                                                                "getDefaultPoolMemberPort",
                                                                                "setDefaultPoolMemberPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_pool_member_ports", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_pool_member_ports",
                                                                                "defaultPoolMemberPorts",
                                                                                "getDefaultPoolMemberPorts",
                                                                                "setDefaultPoolMemberPorts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_address",
                                                                                "ipAddress",
                                                                                "getIpAddress",
                                                                                "setIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_protocol",
                                                                                "ipProtocol",
                                                                                "getIpProtocol",
                                                                                "setIpProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("log_significant_event_only", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("log_significant_event_only",
                                                                                "logSignificantEventOnly",
                                                                                "getLogSignificantEventOnly",
                                                                                "setLogSignificantEventOnly");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_concurrent_connections", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_concurrent_connections",
                                                                                "maxConcurrentConnections",
                                                                                "getMaxConcurrentConnections",
                                                                                "setMaxConcurrentConnections");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_new_connection_rate", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_new_connection_rate",
                                                                                "maxNewConnectionRate",
                                                                                "getMaxNewConnectionRate",
                                                                                "setMaxNewConnectionRate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("persistence_profile_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("persistence_profile_id",
                                                                                "persistenceProfileId",
                                                                                "getPersistenceProfileId",
                                                                                "setPersistenceProfileId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_id",
                                                                                "poolId",
                                                                                "getPoolId",
                                                                                "setPoolId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port",
                                                                                "port",
                                                                                "getPort",
                                                                                "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ports", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ports",
                                                                                "ports",
                                                                                "getPorts",
                                                                                "setPorts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rule_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rule_ids",
                                                                                "ruleIds",
                                                                                "getRuleIds",
                                                                                "setRuleIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_ssl_profile_binding", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.serverSslProfileBinding; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_ssl_profile_binding",
                                                                                "serverSslProfileBinding",
                                                                                "getServerSslProfileBinding",
                                                                                "setServerSslProfileBinding");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sorry_pool_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sorry_pool_id",
                                                                                "sorryPoolId",
                                                                                "getSorryPoolId",
                                                                                "setSorryPoolId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_virtual_server",
                                                            fields,
                                                            com.vmware.nsx.model.LbVirtualServer.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

