/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Subscription offer.
 */
public final class LicenseOffer implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String PRICING_METRICS_TYPE_CORE = "CORE";

    public static final java.lang.String PRICING_METRICS_TYPE_SERVICE_CORE = "SERVICE_CORE";

    public static final java.lang.String PRICING_METRICS_TYPE_IP_ADDRESS = "IP_ADDRESS";

    public static final java.lang.String PRICING_METRICS_TYPE_DATA_STORAGE = "DATA_STORAGE";

    public static final java.lang.String STATUS_CREATED = "CREATED";

    public static final java.lang.String STATUS_ACTIVE = "ACTIVE";

    public static final java.lang.String STATUS_SUSPENDED = "SUSPENDED";

    public static final java.lang.String STATUS_CANCELLED = "CANCELLED";

    public static final java.lang.String STATUS_TERMINATED = "TERMINATED";

    public static final java.lang.String STATUS_PENDING_EXPIRY = "PENDING_EXPIRY";

    public static final java.lang.String STATUS_EXPIRED = "EXPIRED";

    private java.lang.Long capacity;

    private java.lang.String chargeId;

    private java.util.List<java.lang.String> enabledFeatures;

    private java.lang.Long gracePeriod;

    private java.lang.Boolean isFreeTrial;

    private java.lang.Long offerEndTime;

    private java.lang.String offerName;

    private java.lang.Long offerStartTime;

    private java.lang.String pricingMetricsType;

    private java.lang.String status;

    private java.lang.String subscriptionId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LicenseOffer() {
    }

    protected LicenseOffer(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The capacity of the offer. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCapacity() {
        return this.capacity;
    }

    /**
     * The capacity of the offer. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param capacity New value for the property.
     */
    public void setCapacity(java.lang.Long capacity) {
        this.capacity = capacity;
    }

    /**
     * The charge ID of the offer.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getChargeId() {
        return this.chargeId;
    }

    /**
     * The charge ID of the offer.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param chargeId New value for the property.
     */
    public void setChargeId(java.lang.String chargeId) {
        this.chargeId = chargeId;
    }

    /**
     * The property is used to identify the enabled features for the offer.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    /**
     * The property is used to identify the enabled features for the offer.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param enabledFeatures New value for the property.
     */
    public void setEnabledFeatures(java.util.List<java.lang.String> enabledFeatures) {
        this.enabledFeatures = enabledFeatures;
    }

    /**
     * When the offer end time comes or the offer is terminated, the services will
     * still be kept for the grace period. During the grace period, customers cannot
     * make any configuration change except deletion operation. The status will be
     * changed to PENDING_EXPIRY for expiration or SUSPENDED for termination. After
     * grace period, the subscription is expired or terminated. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getGracePeriod() {
        return this.gracePeriod;
    }

    /**
     * When the offer end time comes or the offer is terminated, the services will
     * still be kept for the grace period. During the grace period, customers cannot
     * make any configuration change except deletion operation. The status will be
     * changed to PENDING_EXPIRY for expiration or SUSPENDED for termination. After
     * grace period, the subscription is expired or terminated. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param gracePeriod New value for the property.
     */
    public void setGracePeriod(java.lang.Long gracePeriod) {
        this.gracePeriod = gracePeriod;
    }

    /**
     * The property is used to identify whether the offer is for free trial.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsFreeTrial() {
        return this.isFreeTrial;
    }

    /**
     * The property is used to identify whether the offer is for free trial.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isFreeTrial New value for the property.
     */
    public void setIsFreeTrial(java.lang.Boolean isFreeTrial) {
        this.isFreeTrial = isFreeTrial;
    }

    /**
     * Subscription offer end time. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getOfferEndTime() {
        return this.offerEndTime;
    }

    /**
     * Subscription offer end time. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param offerEndTime New value for the property.
     */
    public void setOfferEndTime(java.lang.Long offerEndTime) {
        this.offerEndTime = offerEndTime;
    }

    /**
     * Subscription offer name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOfferName() {
        return this.offerName;
    }

    /**
     * Subscription offer name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param offerName New value for the property.
     */
    public void setOfferName(java.lang.String offerName) {
        this.offerName = offerName;
    }

    /**
     * Subscription offer start time. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getOfferStartTime() {
        return this.offerStartTime;
    }

    /**
     * Subscription offer start time. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param offerStartTime New value for the property.
     */
    public void setOfferStartTime(java.lang.Long offerStartTime) {
        this.offerStartTime = offerStartTime;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_CORE}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_SERVICE_CORE}</li> <li>
     * {@link com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_IP_ADDRESS}</li>
     * <li> {@link
     * com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_DATA_STORAGE}</li> </ul>
     * Pricing metrics type is used for usage reporting. CORE means CPU cores.
     * SERVICE_CORE means service cores. IP_ADDRESS means IP address number.
     * DATA_STORAGE means GB of data stored.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPricingMetricsType() {
        return this.pricingMetricsType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_CORE}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_SERVICE_CORE}</li> <li>
     * {@link com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_IP_ADDRESS}</li>
     * <li> {@link
     * com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_DATA_STORAGE}</li> </ul>
     * Pricing metrics type is used for usage reporting. CORE means CPU cores.
     * SERVICE_CORE means service cores. IP_ADDRESS means IP address number.
     * DATA_STORAGE means GB of data stored.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param pricingMetricsType New value for the property.
     */
    public void setPricingMetricsType(java.lang.String pricingMetricsType) {
        this.pricingMetricsType = pricingMetricsType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_CREATED}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_ACTIVE}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_SUSPENDED}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_CANCELLED}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_TERMINATED}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_PENDING_EXPIRY}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_EXPIRED}</li> </ul> Subscription status
     * for the offer.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStatus() {
        return this.status;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_CREATED}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_ACTIVE}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_SUSPENDED}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_CANCELLED}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_TERMINATED}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_PENDING_EXPIRY}</li> <li> {@link
     * com.vmware.nsx.model.LicenseOffer#STATUS_EXPIRED}</li> </ul> Subscription status
     * for the offer.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param status New value for the property.
     */
    public void setStatus(java.lang.String status) {
        this.status = status;
    }

    /**
     * The subscription ID of the offer.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSubscriptionId() {
        return this.subscriptionId;
    }

    /**
     * The subscription ID of the offer.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param subscriptionId New value for the property.
     */
    public void setSubscriptionId(java.lang.String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.licenseOffer;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("capacity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.capacity, this._getType().getField("capacity")));
        structValue.setField("charge_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.chargeId, this._getType().getField("charge_id")));
        structValue.setField("enabled_features",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabledFeatures, this._getType().getField("enabled_features")));
        structValue.setField("grace_period",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.gracePeriod, this._getType().getField("grace_period")));
        structValue.setField("is_free_trial",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isFreeTrial, this._getType().getField("is_free_trial")));
        structValue.setField("offer_end_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.offerEndTime, this._getType().getField("offer_end_time")));
        structValue.setField("offer_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.offerName, this._getType().getField("offer_name")));
        structValue.setField("offer_start_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.offerStartTime, this._getType().getField("offer_start_time")));
        structValue.setField("pricing_metrics_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pricingMetricsType, this._getType().getField("pricing_metrics_type")));
        structValue.setField("status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.status, this._getType().getField("status")));
        structValue.setField("subscription_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subscriptionId, this._getType().getField("subscription_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.licenseOffer;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.licenseOffer.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LicenseOffer _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LicenseOffer(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LicenseOffer _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LicenseOffer(structValue);
    }

    /**
     * Builder class for {@link LicenseOffer}.
     */
    public static final class Builder {
        private java.lang.Long capacity;
        private java.lang.String chargeId;
        private java.util.List<java.lang.String> enabledFeatures;
        private java.lang.Long gracePeriod;
        private java.lang.Boolean isFreeTrial;
        private java.lang.Long offerEndTime;
        private java.lang.String offerName;
        private java.lang.Long offerStartTime;
        private java.lang.String pricingMetricsType;
        private java.lang.String status;
        private java.lang.String subscriptionId;

        /**
         * Constructor with parameters for the required properties of
         * {@link LicenseOffer}.
         */
        public Builder() {
        }

        /**
         * The capacity of the offer. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param capacity New value for the property.
         */
        public Builder setCapacity(java.lang.Long capacity) {
            this.capacity = capacity;
            return this;
        }

        /**
         * The charge ID of the offer.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param chargeId New value for the property.
         */
        public Builder setChargeId(java.lang.String chargeId) {
            this.chargeId = chargeId;
            return this;
        }

        /**
         * The property is used to identify the enabled features for the offer.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param enabledFeatures New value for the property.
         */
        public Builder setEnabledFeatures(java.util.List<java.lang.String> enabledFeatures) {
            this.enabledFeatures = enabledFeatures;
            return this;
        }

        /**
         * When the offer end time comes or the offer is terminated, the services will
         * still be kept for the grace period. During the grace period, customers cannot
         * make any configuration change except deletion operation. The status will be
         * changed to PENDING_EXPIRY for expiration or SUSPENDED for termination. After
         * grace period, the subscription is expired or terminated. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param gracePeriod New value for the property.
         */
        public Builder setGracePeriod(java.lang.Long gracePeriod) {
            this.gracePeriod = gracePeriod;
            return this;
        }

        /**
         * The property is used to identify whether the offer is for free trial.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isFreeTrial New value for the property.
         */
        public Builder setIsFreeTrial(java.lang.Boolean isFreeTrial) {
            this.isFreeTrial = isFreeTrial;
            return this;
        }

        /**
         * Subscription offer end time. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param offerEndTime New value for the property.
         */
        public Builder setOfferEndTime(java.lang.Long offerEndTime) {
            this.offerEndTime = offerEndTime;
            return this;
        }

        /**
         * Subscription offer name.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param offerName New value for the property.
         */
        public Builder setOfferName(java.lang.String offerName) {
            this.offerName = offerName;
            return this;
        }

        /**
         * Subscription offer start time. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param offerStartTime New value for the property.
         */
        public Builder setOfferStartTime(java.lang.Long offerStartTime) {
            this.offerStartTime = offerStartTime;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_CORE}</li> <li> {@link
         * com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_SERVICE_CORE}</li> <li>
         * {@link com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_IP_ADDRESS}</li>
         * <li> {@link
         * com.vmware.nsx.model.LicenseOffer#PRICING_METRICS_TYPE_DATA_STORAGE}</li> </ul>
         * Pricing metrics type is used for usage reporting. CORE means CPU cores.
         * SERVICE_CORE means service cores. IP_ADDRESS means IP address number.
         * DATA_STORAGE means GB of data stored.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param pricingMetricsType New value for the property.
         */
        public Builder setPricingMetricsType(java.lang.String pricingMetricsType) {
            this.pricingMetricsType = pricingMetricsType;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LicenseOffer#STATUS_CREATED}</li> <li> {@link
         * com.vmware.nsx.model.LicenseOffer#STATUS_ACTIVE}</li> <li> {@link
         * com.vmware.nsx.model.LicenseOffer#STATUS_SUSPENDED}</li> <li> {@link
         * com.vmware.nsx.model.LicenseOffer#STATUS_CANCELLED}</li> <li> {@link
         * com.vmware.nsx.model.LicenseOffer#STATUS_TERMINATED}</li> <li> {@link
         * com.vmware.nsx.model.LicenseOffer#STATUS_PENDING_EXPIRY}</li> <li> {@link
         * com.vmware.nsx.model.LicenseOffer#STATUS_EXPIRED}</li> </ul> Subscription status
         * for the offer.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param status New value for the property.
         */
        public Builder setStatus(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * The subscription ID of the offer.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param subscriptionId New value for the property.
         */
        public Builder setSubscriptionId(java.lang.String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public LicenseOffer build() {
            LicenseOffer result = new LicenseOffer();
            result.setCapacity(this.capacity);
            result.setChargeId(this.chargeId);
            result.setEnabledFeatures(this.enabledFeatures);
            result.setGracePeriod(this.gracePeriod);
            result.setIsFreeTrial(this.isFreeTrial);
            result.setOfferEndTime(this.offerEndTime);
            result.setOfferName(this.offerName);
            result.setOfferStartTime(this.offerStartTime);
            result.setPricingMetricsType(this.pricingMetricsType);
            result.setStatus(this.status);
            result.setSubscriptionId(this.subscriptionId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("capacity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("capacity",
                                                                                "capacity",
                                                                                "getCapacity",
                                                                                "setCapacity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("charge_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("charge_id",
                                                                                "chargeId",
                                                                                "getChargeId",
                                                                                "setChargeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled_features", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled_features",
                                                                                "enabledFeatures",
                                                                                "getEnabledFeatures",
                                                                                "setEnabledFeatures");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("grace_period", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("grace_period",
                                                                                "gracePeriod",
                                                                                "getGracePeriod",
                                                                                "setGracePeriod");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_free_trial", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_free_trial",
                                                                                "isFreeTrial",
                                                                                "getIsFreeTrial",
                                                                                "setIsFreeTrial");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("offer_end_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("offer_end_time",
                                                                                "offerEndTime",
                                                                                "getOfferEndTime",
                                                                                "setOfferEndTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("offer_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("offer_name",
                                                                                "offerName",
                                                                                "getOfferName",
                                                                                "setOfferName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("offer_start_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("offer_start_time",
                                                                                "offerStartTime",
                                                                                "getOfferStartTime",
                                                                                "setOfferStartTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pricing_metrics_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pricing_metrics_type",
                                                                                "pricingMetricsType",
                                                                                "getPricingMetricsType",
                                                                                "setPricingMetricsType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("status",
                                                                                "status",
                                                                                "getStatus",
                                                                                "setStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subscription_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subscription_id",
                                                                                "subscriptionId",
                                                                                "getSubscriptionId",
                                                                                "setSubscriptionId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.license_offer",
                                                            fields,
                                                            com.vmware.nsx.model.LicenseOffer.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

