/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * MAC learning configuration
 */
public final class MacLearningSpec implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String LIMIT_POLICY_ALLOW = "ALLOW";

    public static final java.lang.String LIMIT_POLICY_DROP = "DROP";

    private java.lang.Long agingTime;

    private java.lang.Boolean enabled;

    private java.lang.Long limit;

    private java.lang.String limitPolicy;

    private java.lang.Long remoteOverlayMacLimit;

    private java.lang.Boolean unicastFloodingAllowed;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public MacLearningSpec() {
    }

    protected MacLearningSpec(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Aging time in sec for learned MAC address format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getAgingTime() {
        return this.agingTime;
    }

    /**
     * Aging time in sec for learned MAC address format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param agingTime New value for the property.
     */
    public void setAgingTime(java.lang.Long agingTime) {
        this.agingTime = agingTime;
    }

    /**
     * Allowing source MAC address learning
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Allowing source MAC address learning
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * This property specifies the limit on the maximum number of MAC addresses that
     * can be learned on a port. It is consumed by vswitch kernel module on the
     * hypervisor while learning MACs per port for VMs that are local to the host.
     * format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLimit() {
        return this.limit;
    }

    /**
     * This property specifies the limit on the maximum number of MAC addresses that
     * can be learned on a port. It is consumed by vswitch kernel module on the
     * hypervisor while learning MACs per port for VMs that are local to the host.
     * format: int32
     *
     * @param limit New value for the property.
     */
    public void setLimit(java.lang.Long limit) {
        this.limit = limit;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.MacLearningSpec#LIMIT_POLICY_ALLOW}</li> <li> {@link
     * com.vmware.nsx.model.MacLearningSpec#LIMIT_POLICY_DROP}</li> </ul> The policy
     * after MAC Limit is exceeded
     *
     * @return The current value of the property.
     */
    public java.lang.String getLimitPolicy() {
        return this.limitPolicy;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.MacLearningSpec#LIMIT_POLICY_ALLOW}</li> <li> {@link
     * com.vmware.nsx.model.MacLearningSpec#LIMIT_POLICY_DROP}</li> </ul> The policy
     * after MAC Limit is exceeded
     *
     * @param limitPolicy New value for the property.
     */
    public void setLimitPolicy(java.lang.String limitPolicy) {
        this.limitPolicy = limitPolicy;
    }

    /**
     * This property specifies the limit on the maximum number of MACs learned for a
     * remote Virtual Machine's MAC to vtep binding per overlay logical switch. format:
     * int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemoteOverlayMacLimit() {
        return this.remoteOverlayMacLimit;
    }

    /**
     * This property specifies the limit on the maximum number of MACs learned for a
     * remote Virtual Machine's MAC to vtep binding per overlay logical switch. format:
     * int32
     *
     * @param remoteOverlayMacLimit New value for the property.
     */
    public void setRemoteOverlayMacLimit(java.lang.Long remoteOverlayMacLimit) {
        this.remoteOverlayMacLimit = remoteOverlayMacLimit;
    }

    /**
     * Allowing flooding for unlearned MAC for ingress traffic
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getUnicastFloodingAllowed() {
        return this.unicastFloodingAllowed;
    }

    /**
     * Allowing flooding for unlearned MAC for ingress traffic
     *
     * @param unicastFloodingAllowed New value for the property.
     */
    public void setUnicastFloodingAllowed(java.lang.Boolean unicastFloodingAllowed) {
        this.unicastFloodingAllowed = unicastFloodingAllowed;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.macLearningSpec;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("aging_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.agingTime, this._getType().getField("aging_time")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.limit, this._getType().getField("limit")));
        structValue.setField("limit_policy",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.limitPolicy, this._getType().getField("limit_policy")));
        structValue.setField("remote_overlay_mac_limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remoteOverlayMacLimit, this._getType().getField("remote_overlay_mac_limit")));
        structValue.setField("unicast_flooding_allowed",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.unicastFloodingAllowed, this._getType().getField("unicast_flooding_allowed")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.macLearningSpec;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.macLearningSpec.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static MacLearningSpec _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new MacLearningSpec(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static MacLearningSpec _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new MacLearningSpec(structValue);
    }

    /**
     * Builder class for {@link MacLearningSpec}.
     */
    public static final class Builder {
        private java.lang.Long agingTime;
        private java.lang.Boolean enabled;
        private java.lang.Long limit;
        private java.lang.String limitPolicy;
        private java.lang.Long remoteOverlayMacLimit;
        private java.lang.Boolean unicastFloodingAllowed;

        /**
         * Constructor with parameters for the required properties of
         * {@link MacLearningSpec}.
         */
        public Builder() {
        }

        /**
         * Aging time in sec for learned MAC address format: int32
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param agingTime New value for the property.
         */
        public Builder setAgingTime(java.lang.Long agingTime) {
            this.agingTime = agingTime;
            return this;
        }

        /**
         * Allowing source MAC address learning
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * This property specifies the limit on the maximum number of MAC addresses that
         * can be learned on a port. It is consumed by vswitch kernel module on the
         * hypervisor while learning MACs per port for VMs that are local to the host.
         * format: int32
         *
         * @param limit New value for the property.
         */
        public Builder setLimit(java.lang.Long limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.MacLearningSpec#LIMIT_POLICY_ALLOW}</li> <li> {@link
         * com.vmware.nsx.model.MacLearningSpec#LIMIT_POLICY_DROP}</li> </ul> The policy
         * after MAC Limit is exceeded
         *
         * @param limitPolicy New value for the property.
         */
        public Builder setLimitPolicy(java.lang.String limitPolicy) {
            this.limitPolicy = limitPolicy;
            return this;
        }

        /**
         * This property specifies the limit on the maximum number of MACs learned for a
         * remote Virtual Machine's MAC to vtep binding per overlay logical switch. format:
         * int32
         *
         * @param remoteOverlayMacLimit New value for the property.
         */
        public Builder setRemoteOverlayMacLimit(java.lang.Long remoteOverlayMacLimit) {
            this.remoteOverlayMacLimit = remoteOverlayMacLimit;
            return this;
        }

        /**
         * Allowing flooding for unlearned MAC for ingress traffic
         *
         * @param unicastFloodingAllowed New value for the property.
         */
        public Builder setUnicastFloodingAllowed(java.lang.Boolean unicastFloodingAllowed) {
            this.unicastFloodingAllowed = unicastFloodingAllowed;
            return this;
        }

        public MacLearningSpec build() {
            MacLearningSpec result = new MacLearningSpec();
            result.setAgingTime(this.agingTime);
            result.setEnabled(this.enabled);
            result.setLimit(this.limit);
            result.setLimitPolicy(this.limitPolicy);
            result.setRemoteOverlayMacLimit(this.remoteOverlayMacLimit);
            result.setUnicastFloodingAllowed(this.unicastFloodingAllowed);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("aging_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("aging_time",
                                                                                "agingTime",
                                                                                "getAgingTime",
                                                                                "setAgingTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("limit",
                                                                                "limit",
                                                                                "getLimit",
                                                                                "setLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("limit_policy", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("limit_policy",
                                                                                "limitPolicy",
                                                                                "getLimitPolicy",
                                                                                "setLimitPolicy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_overlay_mac_limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_overlay_mac_limit",
                                                                                "remoteOverlayMacLimit",
                                                                                "getRemoteOverlayMacLimit",
                                                                                "setRemoteOverlayMacLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("unicast_flooding_allowed", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("unicast_flooding_allowed",
                                                                                "unicastFloodingAllowed",
                                                                                "getUnicastFloodingAllowed",
                                                                                "setUnicastFloodingAllowed");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.mac_learning_spec",
                                                            fields,
                                                            com.vmware.nsx.model.MacLearningSpec.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

