/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Information about a messaging client
 */
public final class MsgClientInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String accountName;

    private java.lang.String certificate;

    private java.lang.String sharedSecret;

    private java.lang.String softwareVersion;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public MsgClientInfo() {
    }

    protected MsgClientInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Account name for the messaging client. Identifies the client on the management
     * plane message bus.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAccountName() {
        return this.accountName;
    }

    /**
     * Account name for the messaging client. Identifies the client on the management
     * plane message bus.
     *
     * @param accountName New value for the property.
     */
    public void setAccountName(java.lang.String accountName) {
        this.accountName = accountName;
    }

    /**
     * Messaging client's certificate. Used to authenticate to the control plane
     * messaging endpoint.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCertificate() {
        return this.certificate;
    }

    /**
     * Messaging client's certificate. Used to authenticate to the control plane
     * messaging endpoint.
     *
     * @param certificate New value for the property.
     */
    public void setCertificate(java.lang.String certificate) {
        this.certificate = certificate;
    }

    /**
     * Messaging client's secret. Used to authenticate to the management plane
     * messaging broker.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSharedSecret() {
        return this.sharedSecret;
    }

    /**
     * Messaging client's secret. Used to authenticate to the management plane
     * messaging broker.
     *
     * @param sharedSecret New value for the property.
     */
    public void setSharedSecret(java.lang.String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    /**
     * Software version of the node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSoftwareVersion() {
        return this.softwareVersion;
    }

    /**
     * Software version of the node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param softwareVersion New value for the property.
     */
    public void setSoftwareVersion(java.lang.String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.msgClientInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("account_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.accountName, this._getType().getField("account_name")));
        structValue.setField("certificate",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificate, this._getType().getField("certificate")));
        structValue.setField("shared_secret",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sharedSecret, this._getType().getField("shared_secret")));
        structValue.setField("software_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.softwareVersion, this._getType().getField("software_version")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.msgClientInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.msgClientInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static MsgClientInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new MsgClientInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static MsgClientInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new MsgClientInfo(structValue);
    }

    /**
     * Builder class for {@link MsgClientInfo}.
     */
    public static final class Builder {
        private java.lang.String accountName;
        private java.lang.String certificate;
        private java.lang.String sharedSecret;
        private java.lang.String softwareVersion;

        /**
         * Constructor with parameters for the required properties of
         * {@link MsgClientInfo}.
         */
        public Builder() {
        }

        /**
         * Account name for the messaging client. Identifies the client on the management
         * plane message bus.
         *
         * @param accountName New value for the property.
         */
        public Builder setAccountName(java.lang.String accountName) {
            this.accountName = accountName;
            return this;
        }

        /**
         * Messaging client's certificate. Used to authenticate to the control plane
         * messaging endpoint.
         *
         * @param certificate New value for the property.
         */
        public Builder setCertificate(java.lang.String certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Messaging client's secret. Used to authenticate to the management plane
         * messaging broker.
         *
         * @param sharedSecret New value for the property.
         */
        public Builder setSharedSecret(java.lang.String sharedSecret) {
            this.sharedSecret = sharedSecret;
            return this;
        }

        /**
         * Software version of the node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param softwareVersion New value for the property.
         */
        public Builder setSoftwareVersion(java.lang.String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public MsgClientInfo build() {
            MsgClientInfo result = new MsgClientInfo();
            result.setAccountName(this.accountName);
            result.setCertificate(this.certificate);
            result.setSharedSecret(this.sharedSecret);
            result.setSoftwareVersion(this.softwareVersion);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("account_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("account_name",
                                                                                "accountName",
                                                                                "getAccountName",
                                                                                "setAccountName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("certificate", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificate",
                                                                                "certificate",
                                                                                "getCertificate",
                                                                                "setCertificate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("shared_secret", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("shared_secret",
                                                                                "sharedSecret",
                                                                                "getSharedSecret",
                                                                                "setSharedSecret");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("software_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("software_version",
                                                                                "softwareVersion",
                                                                                "getSoftwareVersion",
                                                                                "setSoftwareVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.msg_client_info",
                                                            fields,
                                                            com.vmware.nsx.model.MsgClientInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

