/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Includes both scope and tag attribute of Tag. The scope and tag expressions are
 * logically 'AND' with each other. eg- tag.scope = \"S1\" AND tag.tag = 'T1'
 */
public final class NSGroupTagExpression implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "NSGroupTagExpression";

    public static final java.lang.String SCOPE_OP_EQUALS = "EQUALS";

    public static final java.lang.String TAG_OP_EQUALS = "EQUALS";

    public static final java.lang.String TAG_OP_CONTAINS = "CONTAINS";

    public static final java.lang.String TAG_OP_STARTSWITH = "STARTSWITH";

    public static final java.lang.String TAG_OP_ENDSWITH = "ENDSWITH";

    public static final java.lang.String TARGET_TYPE_LOGICALSWITCH = "LogicalSwitch";

    public static final java.lang.String TARGET_TYPE_LOGICALPORT = "LogicalPort";

    public static final java.lang.String TARGET_TYPE_VIRTUALMACHINE = "VirtualMachine";

    public static final java.lang.String TARGET_TYPE_IPSET = "IPSet";

    private java.lang.String scope;

    private java.lang.String scopeOp;

    private java.lang.String tag;

    private java.lang.String tagOp;

    private java.lang.String targetType;

    private final java.lang.String resourceType = "NSGroupTagExpression";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NSGroupTagExpression() {
    }

    protected NSGroupTagExpression(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The tag.scope attribute of the object
     *
     * @return The current value of the property.
     */
    public java.lang.String getScope() {
        return this.scope;
    }

    /**
     * The tag.scope attribute of the object
     *
     * @param scope New value for the property.
     */
    public void setScope(java.lang.String scope) {
        this.scope = scope;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#SCOPE_OP_EQUALS}</li> </ul> Operator
     * of the scope expression eg- tag.scope = \"S1\".
     *
     * @return The current value of the property.
     */
    public java.lang.String getScopeOp() {
        return this.scopeOp;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#SCOPE_OP_EQUALS}</li> </ul> Operator
     * of the scope expression eg- tag.scope = \"S1\".
     *
     * @param scopeOp New value for the property.
     */
    public void setScopeOp(java.lang.String scopeOp) {
        this.scopeOp = scopeOp;
    }

    /**
     * The tag.tag attribute of the object
     *
     * @return The current value of the property.
     */
    public java.lang.String getTag() {
        return this.tag;
    }

    /**
     * The tag.tag attribute of the object
     *
     * @param tag New value for the property.
     */
    public void setTag(java.lang.String tag) {
        this.tag = tag;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_EQUALS}</li> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_CONTAINS}</li> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_STARTSWITH}</li> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_ENDSWITH}</li> </ul>
     * Target_type VirtualMachine supports all specified operators for tag expression
     * while LogicalSwitch and LogicalPort supports only EQUALS operator. All operators
     * perform a case insensitive match.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTagOp() {
        return this.tagOp;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_EQUALS}</li> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_CONTAINS}</li> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_STARTSWITH}</li> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_ENDSWITH}</li> </ul>
     * Target_type VirtualMachine supports all specified operators for tag expression
     * while LogicalSwitch and LogicalPort supports only EQUALS operator. All operators
     * perform a case insensitive match.
     *
     * @param tagOp New value for the property.
     */
    public void setTagOp(java.lang.String tagOp) {
        this.tagOp = tagOp;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_LOGICALSWITCH}</li> <li>
     * {@link com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_LOGICALPORT}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_VIRTUALMACHINE}</li> <li>
     * {@link com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_IPSET}</li> </ul>
     * Type of the resource on which this expression is evaluated
     *
     * @return The current value of the property.
     */
    public java.lang.String getTargetType() {
        return this.targetType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_LOGICALSWITCH}</li> <li>
     * {@link com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_LOGICALPORT}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_VIRTUALMACHINE}</li> <li>
     * {@link com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_IPSET}</li> </ul>
     * Type of the resource on which this expression is evaluated
     *
     * @param targetType New value for the property.
     */
    public void setTargetType(java.lang.String targetType) {
        this.targetType = targetType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NSGroupExpression#RESOURCE_TYPE_NSGROUPSIMPLEEXPRESSION}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSGroupExpression#RESOURCE_TYPE_NSGROUPCOMPLEXEXPRESSION}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSGroupExpression#RESOURCE_TYPE_NSGROUPTAGEXPRESSION}</li>
     * </ul>
     * The value of this property is automatically populated to {@code "NSGroupTagExpression"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.NSGroupTagExpression;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("scope",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.scope, this._getType().getField("scope")));
        structValue.setField("scope_op",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.scopeOp, this._getType().getField("scope_op")));
        structValue.setField("tag",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tag, this._getType().getField("tag")));
        structValue.setField("tag_op",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tagOp, this._getType().getField("tag_op")));
        structValue.setField("target_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.targetType, this._getType().getField("target_type")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.NSGroupTagExpression;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.NSGroupTagExpression.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NSGroupTagExpression _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NSGroupTagExpression(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NSGroupTagExpression _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NSGroupTagExpression(structValue);
    }

    /**
     * Builder class for {@link NSGroupTagExpression}.
     */
    public static final class Builder {
        private java.lang.String scope;
        private java.lang.String scopeOp;
        private java.lang.String tag;
        private java.lang.String tagOp;
        private java.lang.String targetType;

        /**
         * Constructor with parameters for the required properties of
         * {@link NSGroupTagExpression}.
         */
        public Builder() {
        }

        /**
         * The tag.scope attribute of the object
         *
         * @param scope New value for the property.
         */
        public Builder setScope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NSGroupTagExpression#SCOPE_OP_EQUALS}</li> </ul> Operator
         * of the scope expression eg- tag.scope = \"S1\".
         *
         * @param scopeOp New value for the property.
         */
        public Builder setScopeOp(java.lang.String scopeOp) {
            this.scopeOp = scopeOp;
            return this;
        }

        /**
         * The tag.tag attribute of the object
         *
         * @param tag New value for the property.
         */
        public Builder setTag(java.lang.String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_EQUALS}</li> <li> {@link
         * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_CONTAINS}</li> <li> {@link
         * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_STARTSWITH}</li> <li> {@link
         * com.vmware.nsx.model.NSGroupTagExpression#TAG_OP_ENDSWITH}</li> </ul>
         * Target_type VirtualMachine supports all specified operators for tag expression
         * while LogicalSwitch and LogicalPort supports only EQUALS operator. All operators
         * perform a case insensitive match.
         *
         * @param tagOp New value for the property.
         */
        public Builder setTagOp(java.lang.String tagOp) {
            this.tagOp = tagOp;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_LOGICALSWITCH}</li> <li>
         * {@link com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_LOGICALPORT}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_VIRTUALMACHINE}</li> <li>
         * {@link com.vmware.nsx.model.NSGroupTagExpression#TARGET_TYPE_IPSET}</li> </ul>
         * Type of the resource on which this expression is evaluated
         *
         * @param targetType New value for the property.
         */
        public Builder setTargetType(java.lang.String targetType) {
            this.targetType = targetType;
            return this;
        }

        public NSGroupTagExpression build() {
            NSGroupTagExpression result = new NSGroupTagExpression();
            result.setScope(this.scope);
            result.setScopeOp(this.scopeOp);
            result.setTag(this.tag);
            result.setTagOp(this.tagOp);
            result.setTargetType(this.targetType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("scope", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("scope",
                                                                                "scope",
                                                                                "getScope",
                                                                                "setScope");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("scope_op", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("scope_op",
                                                                                "scopeOp",
                                                                                "getScopeOp",
                                                                                "setScopeOp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tag", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tag",
                                                                                "tag",
                                                                                "getTag",
                                                                                "setTag");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tag_op", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tag_op",
                                                                                "tagOp",
                                                                                "getTagOp",
                                                                                "setTagOp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("target_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("target_type",
                                                                                "targetType",
                                                                                "getTargetType",
                                                                                "setTargetType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.NS_group_tag_expression",
                                                            fields,
                                                            com.vmware.nsx.model.NSGroupTagExpression.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "NSGroupTagExpression");
    }
}

