/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The configuration entity to define a NAT rule. It defines how an ip packet is
 * matched via source address or/and destination address or/and service(s), how the
 * address (and/or) port is translated, and how the related firewall stage is
 * involved or bypassed.
 */
public final class NatRule implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ACTION_SNAT = "SNAT";

    public static final java.lang.String ACTION_DNAT = "DNAT";

    public static final java.lang.String ACTION_REFLEXIVE = "REFLEXIVE";

    public static final java.lang.String ACTION_NO_SNAT = "NO_SNAT";

    public static final java.lang.String ACTION_NO_DNAT = "NO_DNAT";

    public static final java.lang.String ACTION_NAT64 = "NAT64";

    public static final java.lang.String FIREWALL_MATCH_MATCH_EXTERNAL_ADDRESS = "MATCH_EXTERNAL_ADDRESS";

    public static final java.lang.String FIREWALL_MATCH_MATCH_INTERNAL_ADDRESS = "MATCH_INTERNAL_ADDRESS";

    public static final java.lang.String FIREWALL_MATCH_BYPASS = "BYPASS";

    public static final java.lang.String PB_VPN_MODE_BYPASS = "BYPASS";

    public static final java.lang.String PB_VPN_MODE_EXCLUSIVE = "EXCLUSIVE";

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    private java.lang.String action;

    private java.util.List<com.vmware.nsx.model.ResourceReference> appliedTos;

    private java.lang.Boolean enabled;

    private java.lang.String firewallMatch;

    private java.lang.String internalRuleId;

    private java.lang.Boolean logging;

    private java.lang.String logicalRouterId;

    private java.lang.String matchDestinationNetwork;

    private com.vmware.vapi.bindings.Structure matchService;

    private java.lang.String matchSourceNetwork;

    private java.lang.String pbVpnMode;

    private java.lang.Long rulePriority;

    private java.lang.String translatedNetwork;

    private java.lang.String translatedPorts;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NatRule() {
    }

    protected NatRule(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_SNAT}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_DNAT}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_REFLEXIVE}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_NO_SNAT}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_NO_DNAT}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_NAT64}</li> </ul> Valid actions: SNAT, DNAT,
     * NO_SNAT, NO_DNAT, REFLEXIVE, NAT64. All rules in a logical router are either
     * stateless or stateful. Mix is not supported. SNAT and DNAT are stateful, can NOT
     * be supported when the logical router is running at active-active HA mode;
     * REFLEXIVE is stateless. NO_SNAT and NO_DNAT have no translated_fields, only
     * match fields are supported.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAction() {
        return this.action;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_SNAT}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_DNAT}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_REFLEXIVE}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_NO_SNAT}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_NO_DNAT}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#ACTION_NAT64}</li> </ul> Valid actions: SNAT, DNAT,
     * NO_SNAT, NO_DNAT, REFLEXIVE, NAT64. All rules in a logical router are either
     * stateless or stateful. Mix is not supported. SNAT and DNAT are stateful, can NOT
     * be supported when the logical router is running at active-active HA mode;
     * REFLEXIVE is stateless. NO_SNAT and NO_DNAT have no translated_fields, only
     * match fields are supported.
     *
     * @param action New value for the property.
     */
    public void setAction(java.lang.String action) {
        this.action = action;
    }

    /**
     * Holds the list of LogicalRouterPort Ids that a NAT rule can be applied to. The
     * LogicalRouterPort used must belong to the same LogicalRouter for which the NAT
     * Rule is created. As of now a NAT rule can only have a single LogicalRouterPort
     * as applied_tos. When applied_tos is not set, the NAT rule is applied to all
     * LogicalRouterPorts beloging to the LogicalRouter.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceReference> getAppliedTos() {
        return this.appliedTos;
    }

    /**
     * Holds the list of LogicalRouterPort Ids that a NAT rule can be applied to. The
     * LogicalRouterPort used must belong to the same LogicalRouter for which the NAT
     * Rule is created. As of now a NAT rule can only have a single LogicalRouterPort
     * as applied_tos. When applied_tos is not set, the NAT rule is applied to all
     * LogicalRouterPorts beloging to the LogicalRouter.
     *
     * @param appliedTos New value for the property.
     */
    public void setAppliedTos(java.util.List<com.vmware.nsx.model.ResourceReference> appliedTos) {
        this.appliedTos = appliedTos;
    }

    /**
     * Indicator to enable/disable the rule.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Indicator to enable/disable the rule.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NatRule#FIREWALL_MATCH_MATCH_EXTERNAL_ADDRESS}</li> <li>
     * {@link com.vmware.nsx.model.NatRule#FIREWALL_MATCH_MATCH_INTERNAL_ADDRESS}</li>
     * <li> {@link com.vmware.nsx.model.NatRule#FIREWALL_MATCH_BYPASS}</li> </ul>
     * Indicate how firewall is applied to a traffic packet. Firewall can be bypassed,
     * or be applied to external/internal address of NAT rule.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFirewallMatch() {
        return this.firewallMatch;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NatRule#FIREWALL_MATCH_MATCH_EXTERNAL_ADDRESS}</li> <li>
     * {@link com.vmware.nsx.model.NatRule#FIREWALL_MATCH_MATCH_INTERNAL_ADDRESS}</li>
     * <li> {@link com.vmware.nsx.model.NatRule#FIREWALL_MATCH_BYPASS}</li> </ul>
     * Indicate how firewall is applied to a traffic packet. Firewall can be bypassed,
     * or be applied to external/internal address of NAT rule.
     *
     * @param firewallMatch New value for the property.
     */
    public void setFirewallMatch(java.lang.String firewallMatch) {
        this.firewallMatch = firewallMatch;
    }

    /**
     * Internal NAT rule uuid for debug used in Controller and backend.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getInternalRuleId() {
        return this.internalRuleId;
    }

    /**
     * Internal NAT rule uuid for debug used in Controller and backend.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param internalRuleId New value for the property.
     */
    public void setInternalRuleId(java.lang.String internalRuleId) {
        this.internalRuleId = internalRuleId;
    }

    /**
     * Enable/disable the logging of rule.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getLogging() {
        return this.logging;
    }

    /**
     * Enable/disable the logging of rule.
     *
     * @param logging New value for the property.
     */
    public void setLogging(java.lang.Boolean logging) {
        this.logging = logging;
    }

    /**
     * The logical router id which the nat rule runs on.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLogicalRouterId() {
        return this.logicalRouterId;
    }

    /**
     * The logical router id which the nat rule runs on.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param logicalRouterId New value for the property.
     */
    public void setLogicalRouterId(java.lang.String logicalRouterId) {
        this.logicalRouterId = logicalRouterId;
    }

    /**
     * IP Address | CIDR | (null implies Any)
     *
     * @return The current value of the property.
     */
    public java.lang.String getMatchDestinationNetwork() {
        return this.matchDestinationNetwork;
    }

    /**
     * IP Address | CIDR | (null implies Any)
     *
     * @param matchDestinationNetwork New value for the property.
     */
    public void setMatchDestinationNetwork(java.lang.String matchDestinationNetwork) {
        this.matchDestinationNetwork = matchDestinationNetwork;
    }

    /**
     *
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.NSServiceElement}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.NSServiceElement}.
     */
    public com.vmware.vapi.bindings.Structure getMatchService() {
        return this.matchService;
    }

    /**
     *
     *
     * @param matchService New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.NSServiceElement}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.NSServiceElement}.
     */
    public void setMatchService(com.vmware.vapi.bindings.Structure matchService) {
        this.matchService = matchService;
    }

    /**
     * IP Address | CIDR | (null implies Any)
     *
     * @return The current value of the property.
     */
    public java.lang.String getMatchSourceNetwork() {
        return this.matchSourceNetwork;
    }

    /**
     * IP Address | CIDR | (null implies Any)
     *
     * @param matchSourceNetwork New value for the property.
     */
    public void setMatchSourceNetwork(java.lang.String matchSourceNetwork) {
        this.matchSourceNetwork = matchSourceNetwork;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NatRule#PB_VPN_MODE_BYPASS}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#PB_VPN_MODE_EXCLUSIVE}</li> </ul> Indicate how the
     * rule applies to Policy-Based VPN traffic. It's supported only for NAT rule
     * action type DNAT and NO_DNAT. BYPASS indicates that NAT rule is applied to the
     * traffic received on Routed-Based VPN tunnel. EXCLUSIVE indicates that NAT rule
     * is applied to the inbound traffic received on Policy-Based VPN tunnel only.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPbVpnMode() {
        return this.pbVpnMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NatRule#PB_VPN_MODE_BYPASS}</li> <li> {@link
     * com.vmware.nsx.model.NatRule#PB_VPN_MODE_EXCLUSIVE}</li> </ul> Indicate how the
     * rule applies to Policy-Based VPN traffic. It's supported only for NAT rule
     * action type DNAT and NO_DNAT. BYPASS indicates that NAT rule is applied to the
     * traffic received on Routed-Based VPN tunnel. EXCLUSIVE indicates that NAT rule
     * is applied to the inbound traffic received on Policy-Based VPN tunnel only.
     *
     * @param pbVpnMode New value for the property.
     */
    public void setPbVpnMode(java.lang.String pbVpnMode) {
        this.pbVpnMode = pbVpnMode;
    }

    /**
     * Ascending, valid range [0-2147483647]. If multiple rules have the same priority,
     * evaluation sequence is undefined. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRulePriority() {
        return this.rulePriority;
    }

    /**
     * Ascending, valid range [0-2147483647]. If multiple rules have the same priority,
     * evaluation sequence is undefined. format: int64
     *
     * @param rulePriority New value for the property.
     */
    public void setRulePriority(java.lang.Long rulePriority) {
        this.rulePriority = rulePriority;
    }

    /**
     * The translated address for the matched IP packet. For a SNAT, it can be a single
     * ip address, an ip range, or a CIDR block. For a DNAT and a REFLEXIVE, it can be
     * a single ip address or a CIDR block. Translated network is not supported for
     * NO_SNAT or NO_DNAT.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTranslatedNetwork() {
        return this.translatedNetwork;
    }

    /**
     * The translated address for the matched IP packet. For a SNAT, it can be a single
     * ip address, an ip range, or a CIDR block. For a DNAT and a REFLEXIVE, it can be
     * a single ip address or a CIDR block. Translated network is not supported for
     * NO_SNAT or NO_DNAT.
     *
     * @param translatedNetwork New value for the property.
     */
    public void setTranslatedNetwork(java.lang.String translatedNetwork) {
        this.translatedNetwork = translatedNetwork;
    }

    /**
     * The translated port(s) for the mtached IP packet. It can be a single port or a
     * port range. Please note, port translating is supported only for DNAT.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTranslatedPorts() {
        return this.translatedPorts;
    }

    /**
     * The translated port(s) for the mtached IP packet. It can be a single port or a
     * port range. Please note, port translating is supported only for DNAT.
     *
     * @param translatedPorts New value for the property.
     */
    public void setTranslatedPorts(java.lang.String translatedPorts) {
        this.translatedPorts = translatedPorts;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.natRule;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.action, this._getType().getField("action")));
        structValue.setField("applied_tos",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.appliedTos, this._getType().getField("applied_tos")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("firewall_match",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.firewallMatch, this._getType().getField("firewall_match")));
        structValue.setField("internal_rule_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.internalRuleId, this._getType().getField("internal_rule_id")));
        structValue.setField("logging",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.logging, this._getType().getField("logging")));
        structValue.setField("logical_router_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.logicalRouterId, this._getType().getField("logical_router_id")));
        structValue.setField("match_destination_network",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchDestinationNetwork, this._getType().getField("match_destination_network")));
        structValue.setField("match_service",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchService, this._getType().getField("match_service")));
        structValue.setField("match_source_network",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchSourceNetwork, this._getType().getField("match_source_network")));
        structValue.setField("pb_vpn_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pbVpnMode, this._getType().getField("pb_vpn_mode")));
        structValue.setField("rule_priority",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rulePriority, this._getType().getField("rule_priority")));
        structValue.setField("translated_network",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.translatedNetwork, this._getType().getField("translated_network")));
        structValue.setField("translated_ports",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.translatedPorts, this._getType().getField("translated_ports")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.natRule;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.natRule.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NatRule _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NatRule(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NatRule _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NatRule(structValue);
    }

    /**
     * Builder class for {@link NatRule}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx.model.Tag> tags;
        private java.lang.String action;
        private java.util.List<com.vmware.nsx.model.ResourceReference> appliedTos;
        private java.lang.Boolean enabled;
        private java.lang.String firewallMatch;
        private java.lang.String internalRuleId;
        private java.lang.Boolean logging;
        private java.lang.String logicalRouterId;
        private java.lang.String matchDestinationNetwork;
        private com.vmware.vapi.bindings.Structure matchService;
        private java.lang.String matchSourceNetwork;
        private java.lang.String pbVpnMode;
        private java.lang.Long rulePriority;
        private java.lang.String translatedNetwork;
        private java.lang.String translatedPorts;

        /**
         * Constructor with parameters for the required properties of
         * {@link NatRule}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NatRule#ACTION_SNAT}</li> <li> {@link
         * com.vmware.nsx.model.NatRule#ACTION_DNAT}</li> <li> {@link
         * com.vmware.nsx.model.NatRule#ACTION_REFLEXIVE}</li> <li> {@link
         * com.vmware.nsx.model.NatRule#ACTION_NO_SNAT}</li> <li> {@link
         * com.vmware.nsx.model.NatRule#ACTION_NO_DNAT}</li> <li> {@link
         * com.vmware.nsx.model.NatRule#ACTION_NAT64}</li> </ul> Valid actions: SNAT, DNAT,
         * NO_SNAT, NO_DNAT, REFLEXIVE, NAT64. All rules in a logical router are either
         * stateless or stateful. Mix is not supported. SNAT and DNAT are stateful, can NOT
         * be supported when the logical router is running at active-active HA mode;
         * REFLEXIVE is stateless. NO_SNAT and NO_DNAT have no translated_fields, only
         * match fields are supported.
         *
         * @param action New value for the property.
         */
        public Builder setAction(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Holds the list of LogicalRouterPort Ids that a NAT rule can be applied to. The
         * LogicalRouterPort used must belong to the same LogicalRouter for which the NAT
         * Rule is created. As of now a NAT rule can only have a single LogicalRouterPort
         * as applied_tos. When applied_tos is not set, the NAT rule is applied to all
         * LogicalRouterPorts beloging to the LogicalRouter.
         *
         * @param appliedTos New value for the property.
         */
        public Builder setAppliedTos(java.util.List<com.vmware.nsx.model.ResourceReference> appliedTos) {
            this.appliedTos = appliedTos;
            return this;
        }

        /**
         * Indicator to enable/disable the rule.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NatRule#FIREWALL_MATCH_MATCH_EXTERNAL_ADDRESS}</li> <li>
         * {@link com.vmware.nsx.model.NatRule#FIREWALL_MATCH_MATCH_INTERNAL_ADDRESS}</li>
         * <li> {@link com.vmware.nsx.model.NatRule#FIREWALL_MATCH_BYPASS}</li> </ul>
         * Indicate how firewall is applied to a traffic packet. Firewall can be bypassed,
         * or be applied to external/internal address of NAT rule.
         *
         * @param firewallMatch New value for the property.
         */
        public Builder setFirewallMatch(java.lang.String firewallMatch) {
            this.firewallMatch = firewallMatch;
            return this;
        }

        /**
         * Internal NAT rule uuid for debug used in Controller and backend.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param internalRuleId New value for the property.
         */
        public Builder setInternalRuleId(java.lang.String internalRuleId) {
            this.internalRuleId = internalRuleId;
            return this;
        }

        /**
         * Enable/disable the logging of rule.
         *
         * @param logging New value for the property.
         */
        public Builder setLogging(java.lang.Boolean logging) {
            this.logging = logging;
            return this;
        }

        /**
         * The logical router id which the nat rule runs on.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param logicalRouterId New value for the property.
         */
        public Builder setLogicalRouterId(java.lang.String logicalRouterId) {
            this.logicalRouterId = logicalRouterId;
            return this;
        }

        /**
         * IP Address | CIDR | (null implies Any)
         *
         * @param matchDestinationNetwork New value for the property.
         */
        public Builder setMatchDestinationNetwork(java.lang.String matchDestinationNetwork) {
            this.matchDestinationNetwork = matchDestinationNetwork;
            return this;
        }

        /**
         *
         *
         * @param matchService New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx.model.NSServiceElement}. When methods return a value of this
         * class as a return value, the property will contain all the properties defined in
         * {@link com.vmware.nsx.model.NSServiceElement}.
         */
        public Builder setMatchService(com.vmware.vapi.bindings.Structure matchService) {
            this.matchService = matchService;
            return this;
        }

        /**
         * IP Address | CIDR | (null implies Any)
         *
         * @param matchSourceNetwork New value for the property.
         */
        public Builder setMatchSourceNetwork(java.lang.String matchSourceNetwork) {
            this.matchSourceNetwork = matchSourceNetwork;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NatRule#PB_VPN_MODE_BYPASS}</li> <li> {@link
         * com.vmware.nsx.model.NatRule#PB_VPN_MODE_EXCLUSIVE}</li> </ul> Indicate how the
         * rule applies to Policy-Based VPN traffic. It's supported only for NAT rule
         * action type DNAT and NO_DNAT. BYPASS indicates that NAT rule is applied to the
         * traffic received on Routed-Based VPN tunnel. EXCLUSIVE indicates that NAT rule
         * is applied to the inbound traffic received on Policy-Based VPN tunnel only.
         *
         * @param pbVpnMode New value for the property.
         */
        public Builder setPbVpnMode(java.lang.String pbVpnMode) {
            this.pbVpnMode = pbVpnMode;
            return this;
        }

        /**
         * Ascending, valid range [0-2147483647]. If multiple rules have the same priority,
         * evaluation sequence is undefined. format: int64
         *
         * @param rulePriority New value for the property.
         */
        public Builder setRulePriority(java.lang.Long rulePriority) {
            this.rulePriority = rulePriority;
            return this;
        }

        /**
         * The translated address for the matched IP packet. For a SNAT, it can be a single
         * ip address, an ip range, or a CIDR block. For a DNAT and a REFLEXIVE, it can be
         * a single ip address or a CIDR block. Translated network is not supported for
         * NO_SNAT or NO_DNAT.
         *
         * @param translatedNetwork New value for the property.
         */
        public Builder setTranslatedNetwork(java.lang.String translatedNetwork) {
            this.translatedNetwork = translatedNetwork;
            return this;
        }

        /**
         * The translated port(s) for the mtached IP packet. It can be a single port or a
         * port range. Please note, port translating is supported only for DNAT.
         *
         * @param translatedPorts New value for the property.
         */
        public Builder setTranslatedPorts(java.lang.String translatedPorts) {
            this.translatedPorts = translatedPorts;
            return this;
        }

        public NatRule build() {
            NatRule result = new NatRule();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setAction(this.action);
            result.setAppliedTos(this.appliedTos);
            result.setEnabled(this.enabled);
            result.setFirewallMatch(this.firewallMatch);
            result.setInternalRuleId(this.internalRuleId);
            result.setLogging(this.logging);
            result.setLogicalRouterId(this.logicalRouterId);
            result.setMatchDestinationNetwork(this.matchDestinationNetwork);
            result.setMatchService(this.matchService);
            result.setMatchSourceNetwork(this.matchSourceNetwork);
            result.setPbVpnMode(this.pbVpnMode);
            result.setRulePriority(this.rulePriority);
            result.setTranslatedNetwork(this.translatedNetwork);
            result.setTranslatedPorts(this.translatedPorts);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("action",
                                                                                "action",
                                                                                "getAction",
                                                                                "setAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("applied_tos", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceReference; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("applied_tos",
                                                                                "appliedTos",
                                                                                "getAppliedTos",
                                                                                "setAppliedTos");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("firewall_match", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("firewall_match",
                                                                                "firewallMatch",
                                                                                "getFirewallMatch",
                                                                                "setFirewallMatch");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("internal_rule_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("internal_rule_id",
                                                                                "internalRuleId",
                                                                                "getInternalRuleId",
                                                                                "setInternalRuleId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("logging", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("logging",
                                                                                "logging",
                                                                                "getLogging",
                                                                                "setLogging");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("logical_router_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("logical_router_id",
                                                                                "logicalRouterId",
                                                                                "getLogicalRouterId",
                                                                                "setLogicalRouterId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_destination_network", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_destination_network",
                                                                                "matchDestinationNetwork",
                                                                                "getMatchDestinationNetwork",
                                                                                "setMatchDestinationNetwork");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_service", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.NSServiceElement; } })))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_service",
                                                                                "matchService",
                                                                                "getMatchService",
                                                                                "setMatchService");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_source_network", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_source_network",
                                                                                "matchSourceNetwork",
                                                                                "getMatchSourceNetwork",
                                                                                "setMatchSourceNetwork");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pb_vpn_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pb_vpn_mode",
                                                                                "pbVpnMode",
                                                                                "getPbVpnMode",
                                                                                "setPbVpnMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rule_priority", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rule_priority",
                                                                                "rulePriority",
                                                                                "getRulePriority",
                                                                                "setRulePriority");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("translated_network", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("translated_network",
                                                                                "translatedNetwork",
                                                                                "getTranslatedNetwork",
                                                                                "setTranslatedNetwork");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("translated_ports", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("translated_ports",
                                                                                "translatedPorts",
                                                                                "getTranslatedPorts",
                                                                                "setTranslatedPorts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.nat_rule",
                                                            fields,
                                                            com.vmware.nsx.model.NatRule.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

