/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Information of a network interface present on the partner appliance that needs
 * to be configured by the NSX Manager.
 */
public final class NicInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String IP_ALLOCATION_TYPE_STATIC = "STATIC";

    public static final java.lang.String IP_ALLOCATION_TYPE_DHCP = "DHCP";

    public static final java.lang.String IP_ALLOCATION_TYPE_NONE = "NONE";

    private java.lang.String gatewayAddress;

    private java.lang.String ipAddress;

    private java.lang.String ipAllocationType;

    private java.lang.String ipPoolId;

    private java.lang.String networkId;

    private com.vmware.nsx.model.NicMetadata nicMetadata;

    private java.lang.String subnetMask;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NicInfo() {
    }

    protected NicInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Gateway address associated with the NIC metadata.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGatewayAddress() {
        return this.gatewayAddress;
    }

    /**
     * Gateway address associated with the NIC metadata.
     *
     * @param gatewayAddress New value for the property.
     */
    public void setGatewayAddress(java.lang.String gatewayAddress) {
        this.gatewayAddress = gatewayAddress;
    }

    /**
     * IP address associated with the NIC metadata. Required only when assigning IP
     * statically for a deployment that is for a single VM instance.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * IP address associated with the NIC metadata. Required only when assigning IP
     * statically for a deployment that is for a single VM instance.
     *
     * @param ipAddress New value for the property.
     */
    public void setIpAddress(java.lang.String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NicInfo#IP_ALLOCATION_TYPE_STATIC}</li> <li> {@link
     * com.vmware.nsx.model.NicInfo#IP_ALLOCATION_TYPE_DHCP}</li> <li> {@link
     * com.vmware.nsx.model.NicInfo#IP_ALLOCATION_TYPE_NONE}</li> </ul> IP allocation
     * type with values STATIC, DHCP, or NONE indicating that IP address is not
     * required.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpAllocationType() {
        return this.ipAllocationType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NicInfo#IP_ALLOCATION_TYPE_STATIC}</li> <li> {@link
     * com.vmware.nsx.model.NicInfo#IP_ALLOCATION_TYPE_DHCP}</li> <li> {@link
     * com.vmware.nsx.model.NicInfo#IP_ALLOCATION_TYPE_NONE}</li> </ul> IP allocation
     * type with values STATIC, DHCP, or NONE indicating that IP address is not
     * required.
     *
     * @param ipAllocationType New value for the property.
     */
    public void setIpAllocationType(java.lang.String ipAllocationType) {
        this.ipAllocationType = ipAllocationType;
    }

    /**
     * If the nic should get IP using a static IP pool then IP pool id should be
     * provided here.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpPoolId() {
        return this.ipPoolId;
    }

    /**
     * If the nic should get IP using a static IP pool then IP pool id should be
     * provided here.
     *
     * @param ipPoolId New value for the property.
     */
    public void setIpPoolId(java.lang.String ipPoolId) {
        this.ipPoolId = ipPoolId;
    }

    /**
     * Network Id associated with the NIC metadata. It can be a moref, or a logical
     * switch ID. If it is to be taken from 'Agent VM Settings', then it should be
     * empty.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNetworkId() {
        return this.networkId;
    }

    /**
     * Network Id associated with the NIC metadata. It can be a moref, or a logical
     * switch ID. If it is to be taken from 'Agent VM Settings', then it should be
     * empty.
     *
     * @param networkId New value for the property.
     */
    public void setNetworkId(java.lang.String networkId) {
        this.networkId = networkId;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.NicMetadata getNicMetadata() {
        return this.nicMetadata;
    }

    /**
     *
     *
     * @param nicMetadata New value for the property.
     */
    public void setNicMetadata(com.vmware.nsx.model.NicMetadata nicMetadata) {
        this.nicMetadata = nicMetadata;
    }

    /**
     * Subnet mask associated with the NIC metadata.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSubnetMask() {
        return this.subnetMask;
    }

    /**
     * Subnet mask associated with the NIC metadata.
     *
     * @param subnetMask New value for the property.
     */
    public void setSubnetMask(java.lang.String subnetMask) {
        this.subnetMask = subnetMask;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.nicInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("gateway_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.gatewayAddress, this._getType().getField("gateway_address")));
        structValue.setField("ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddress, this._getType().getField("ip_address")));
        structValue.setField("ip_allocation_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAllocationType, this._getType().getField("ip_allocation_type")));
        structValue.setField("ip_pool_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipPoolId, this._getType().getField("ip_pool_id")));
        structValue.setField("network_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.networkId, this._getType().getField("network_id")));
        structValue.setField("nic_metadata",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nicMetadata, this._getType().getField("nic_metadata")));
        structValue.setField("subnet_mask",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subnetMask, this._getType().getField("subnet_mask")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.nicInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.nicInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NicInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NicInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NicInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NicInfo(structValue);
    }

    /**
     * Builder class for {@link NicInfo}.
     */
    public static final class Builder {
        private java.lang.String gatewayAddress;
        private java.lang.String ipAddress;
        private java.lang.String ipAllocationType;
        private java.lang.String ipPoolId;
        private java.lang.String networkId;
        private com.vmware.nsx.model.NicMetadata nicMetadata;
        private java.lang.String subnetMask;

        /**
         * Constructor with parameters for the required properties of
         * {@link NicInfo}.
         */
        public Builder() {
        }

        /**
         * Gateway address associated with the NIC metadata.
         *
         * @param gatewayAddress New value for the property.
         */
        public Builder setGatewayAddress(java.lang.String gatewayAddress) {
            this.gatewayAddress = gatewayAddress;
            return this;
        }

        /**
         * IP address associated with the NIC metadata. Required only when assigning IP
         * statically for a deployment that is for a single VM instance.
         *
         * @param ipAddress New value for the property.
         */
        public Builder setIpAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NicInfo#IP_ALLOCATION_TYPE_STATIC}</li> <li> {@link
         * com.vmware.nsx.model.NicInfo#IP_ALLOCATION_TYPE_DHCP}</li> <li> {@link
         * com.vmware.nsx.model.NicInfo#IP_ALLOCATION_TYPE_NONE}</li> </ul> IP allocation
         * type with values STATIC, DHCP, or NONE indicating that IP address is not
         * required.
         *
         * @param ipAllocationType New value for the property.
         */
        public Builder setIpAllocationType(java.lang.String ipAllocationType) {
            this.ipAllocationType = ipAllocationType;
            return this;
        }

        /**
         * If the nic should get IP using a static IP pool then IP pool id should be
         * provided here.
         *
         * @param ipPoolId New value for the property.
         */
        public Builder setIpPoolId(java.lang.String ipPoolId) {
            this.ipPoolId = ipPoolId;
            return this;
        }

        /**
         * Network Id associated with the NIC metadata. It can be a moref, or a logical
         * switch ID. If it is to be taken from 'Agent VM Settings', then it should be
         * empty.
         *
         * @param networkId New value for the property.
         */
        public Builder setNetworkId(java.lang.String networkId) {
            this.networkId = networkId;
            return this;
        }

        /**
         *
         *
         * @param nicMetadata New value for the property.
         */
        public Builder setNicMetadata(com.vmware.nsx.model.NicMetadata nicMetadata) {
            this.nicMetadata = nicMetadata;
            return this;
        }

        /**
         * Subnet mask associated with the NIC metadata.
         *
         * @param subnetMask New value for the property.
         */
        public Builder setSubnetMask(java.lang.String subnetMask) {
            this.subnetMask = subnetMask;
            return this;
        }

        public NicInfo build() {
            NicInfo result = new NicInfo();
            result.setGatewayAddress(this.gatewayAddress);
            result.setIpAddress(this.ipAddress);
            result.setIpAllocationType(this.ipAllocationType);
            result.setIpPoolId(this.ipPoolId);
            result.setNetworkId(this.networkId);
            result.setNicMetadata(this.nicMetadata);
            result.setSubnetMask(this.subnetMask);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("gateway_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("gateway_address",
                                                                                "gatewayAddress",
                                                                                "getGatewayAddress",
                                                                                "setGatewayAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_address",
                                                                                "ipAddress",
                                                                                "getIpAddress",
                                                                                "setIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_allocation_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_allocation_type",
                                                                                "ipAllocationType",
                                                                                "getIpAllocationType",
                                                                                "setIpAllocationType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_pool_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_pool_id",
                                                                                "ipPoolId",
                                                                                "getIpPoolId",
                                                                                "setIpPoolId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("network_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("network_id",
                                                                                "networkId",
                                                                                "getNetworkId",
                                                                                "setNetworkId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nic_metadata", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.nicMetadata; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nic_metadata",
                                                                                "nicMetadata",
                                                                                "getNicMetadata",
                                                                                "setNicMetadata");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("subnet_mask", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("subnet_mask",
                                                                                "subnetMask",
                                                                                "getSubnetMask",
                                                                                "setSubnetMask");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.nic_info",
                                                            fields,
                                                            com.vmware.nsx.model.NicInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

