/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Information on the Network interfaces present on the partner appliance that
 * needs to be configured by the NSX Manager.
 */
public final class NicMetadata implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String INTERFACE_TYPE_MANAGEMENT = "MANAGEMENT";

    public static final java.lang.String INTERFACE_TYPE_DATA1 = "DATA1";

    public static final java.lang.String INTERFACE_TYPE_DATA2 = "DATA2";

    public static final java.lang.String INTERFACE_TYPE_HA1 = "HA1";

    public static final java.lang.String INTERFACE_TYPE_HA2 = "HA2";

    public static final java.lang.String INTERFACE_TYPE_CONTROL = "CONTROL";

    public static final java.lang.String TRANSPORTS_L2_BRIDGE = "L2_BRIDGE";

    public static final java.lang.String TRANSPORTS_L3_ROUTED = "L3_ROUTED";

    public static final java.lang.String TRANSPORTS_NSH = "NSH";

    private java.lang.Long interfaceIndex;

    private java.lang.String interfaceLabel;

    private java.lang.String interfaceType;

    private java.util.List<java.lang.String> transports;

    private java.lang.Boolean userConfigurable;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NicMetadata() {
    }

    protected NicMetadata(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Network Interface index. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getInterfaceIndex() {
        return this.interfaceIndex;
    }

    /**
     * Network Interface index. format: int64
     *
     * @param interfaceIndex New value for the property.
     */
    public void setInterfaceIndex(java.lang.Long interfaceIndex) {
        this.interfaceIndex = interfaceIndex;
    }

    /**
     * Network Interface label.
     *
     * @return The current value of the property.
     */
    public java.lang.String getInterfaceLabel() {
        return this.interfaceLabel;
    }

    /**
     * Network Interface label.
     *
     * @param interfaceLabel New value for the property.
     */
    public void setInterfaceLabel(java.lang.String interfaceLabel) {
        this.interfaceLabel = interfaceLabel;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_MANAGEMENT}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_DATA1}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_DATA2}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_HA1}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_HA2}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_CONTROL}</li> </ul> Interface
     * that needs to be configured on the partner appliance. Ex. MANAGEMENT, DATA1,
     * DATA2, HA1, HA2, CONTROL.
     *
     * @return The current value of the property.
     */
    public java.lang.String getInterfaceType() {
        return this.interfaceType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_MANAGEMENT}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_DATA1}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_DATA2}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_HA1}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_HA2}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_CONTROL}</li> </ul> Interface
     * that needs to be configured on the partner appliance. Ex. MANAGEMENT, DATA1,
     * DATA2, HA1, HA2, CONTROL.
     *
     * @param interfaceType New value for the property.
     */
    public void setInterfaceType(java.lang.String interfaceType) {
        this.interfaceType = interfaceType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NicMetadata#TRANSPORTS_L2_BRIDGE}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#TRANSPORTS_L3_ROUTED}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#TRANSPORTS_NSH}</li> </ul> Transport Type of
     * the service, which is the mechanism of redirecting the traffic to the the
     * partner appliance. Transport type is required if Service caters to any
     * functionality other than EPP and MPS. Here, the transports array specifies the
     * kinds of transport where this particular NIC is user configurable. If nothing is
     * specified, and the \"user_configurable\" flag is true, then user configuration
     * will be allowed for all transports. If any transport is/are specified, then it
     * will be considered as user configurable for the specified transports only.\"
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getTransports() {
        return this.transports;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NicMetadata#TRANSPORTS_L2_BRIDGE}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#TRANSPORTS_L3_ROUTED}</li> <li> {@link
     * com.vmware.nsx.model.NicMetadata#TRANSPORTS_NSH}</li> </ul> Transport Type of
     * the service, which is the mechanism of redirecting the traffic to the the
     * partner appliance. Transport type is required if Service caters to any
     * functionality other than EPP and MPS. Here, the transports array specifies the
     * kinds of transport where this particular NIC is user configurable. If nothing is
     * specified, and the \"user_configurable\" flag is true, then user configuration
     * will be allowed for all transports. If any transport is/are specified, then it
     * will be considered as user configurable for the specified transports only.\"
     *
     * @param transports New value for the property.
     */
    public void setTransports(java.util.List<java.lang.String> transports) {
        this.transports = transports;
    }

    /**
     * Used to specify if the given interface needs configuration. Management nics will
     * always need the configuration, for others it will be use case specific. For
     * example, a DATA NIC may be user configurable if the appliance is deployed in
     * certain mode, such as L3_ROUTED.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getUserConfigurable() {
        return this.userConfigurable;
    }

    /**
     * Used to specify if the given interface needs configuration. Management nics will
     * always need the configuration, for others it will be use case specific. For
     * example, a DATA NIC may be user configurable if the appliance is deployed in
     * certain mode, such as L3_ROUTED.
     *
     * @param userConfigurable New value for the property.
     */
    public void setUserConfigurable(java.lang.Boolean userConfigurable) {
        this.userConfigurable = userConfigurable;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.nicMetadata;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("interface_index",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.interfaceIndex, this._getType().getField("interface_index")));
        structValue.setField("interface_label",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.interfaceLabel, this._getType().getField("interface_label")));
        structValue.setField("interface_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.interfaceType, this._getType().getField("interface_type")));
        structValue.setField("transports",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transports, this._getType().getField("transports")));
        structValue.setField("user_configurable",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userConfigurable, this._getType().getField("user_configurable")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.nicMetadata;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.nicMetadata.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NicMetadata _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NicMetadata(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NicMetadata _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NicMetadata(structValue);
    }

    /**
     * Builder class for {@link NicMetadata}.
     */
    public static final class Builder {
        private java.lang.Long interfaceIndex;
        private java.lang.String interfaceLabel;
        private java.lang.String interfaceType;
        private java.util.List<java.lang.String> transports;
        private java.lang.Boolean userConfigurable;

        /**
         * Constructor with parameters for the required properties of
         * {@link NicMetadata}.
         */
        public Builder() {
        }

        /**
         * Network Interface index. format: int64
         *
         * @param interfaceIndex New value for the property.
         */
        public Builder setInterfaceIndex(java.lang.Long interfaceIndex) {
            this.interfaceIndex = interfaceIndex;
            return this;
        }

        /**
         * Network Interface label.
         *
         * @param interfaceLabel New value for the property.
         */
        public Builder setInterfaceLabel(java.lang.String interfaceLabel) {
            this.interfaceLabel = interfaceLabel;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_MANAGEMENT}</li> <li> {@link
         * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_DATA1}</li> <li> {@link
         * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_DATA2}</li> <li> {@link
         * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_HA1}</li> <li> {@link
         * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_HA2}</li> <li> {@link
         * com.vmware.nsx.model.NicMetadata#INTERFACE_TYPE_CONTROL}</li> </ul> Interface
         * that needs to be configured on the partner appliance. Ex. MANAGEMENT, DATA1,
         * DATA2, HA1, HA2, CONTROL.
         *
         * @param interfaceType New value for the property.
         */
        public Builder setInterfaceType(java.lang.String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NicMetadata#TRANSPORTS_L2_BRIDGE}</li> <li> {@link
         * com.vmware.nsx.model.NicMetadata#TRANSPORTS_L3_ROUTED}</li> <li> {@link
         * com.vmware.nsx.model.NicMetadata#TRANSPORTS_NSH}</li> </ul> Transport Type of
         * the service, which is the mechanism of redirecting the traffic to the the
         * partner appliance. Transport type is required if Service caters to any
         * functionality other than EPP and MPS. Here, the transports array specifies the
         * kinds of transport where this particular NIC is user configurable. If nothing is
         * specified, and the \"user_configurable\" flag is true, then user configuration
         * will be allowed for all transports. If any transport is/are specified, then it
         * will be considered as user configurable for the specified transports only.\"
         *
         * @param transports New value for the property.
         */
        public Builder setTransports(java.util.List<java.lang.String> transports) {
            this.transports = transports;
            return this;
        }

        /**
         * Used to specify if the given interface needs configuration. Management nics will
         * always need the configuration, for others it will be use case specific. For
         * example, a DATA NIC may be user configurable if the appliance is deployed in
         * certain mode, such as L3_ROUTED.
         *
         * @param userConfigurable New value for the property.
         */
        public Builder setUserConfigurable(java.lang.Boolean userConfigurable) {
            this.userConfigurable = userConfigurable;
            return this;
        }

        public NicMetadata build() {
            NicMetadata result = new NicMetadata();
            result.setInterfaceIndex(this.interfaceIndex);
            result.setInterfaceLabel(this.interfaceLabel);
            result.setInterfaceType(this.interfaceType);
            result.setTransports(this.transports);
            result.setUserConfigurable(this.userConfigurable);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("interface_index", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("interface_index",
                                                                                "interfaceIndex",
                                                                                "getInterfaceIndex",
                                                                                "setInterfaceIndex");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("interface_label", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("interface_label",
                                                                                "interfaceLabel",
                                                                                "getInterfaceLabel",
                                                                                "setInterfaceLabel");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("interface_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("interface_type",
                                                                                "interfaceType",
                                                                                "getInterfaceType",
                                                                                "setInterfaceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transports", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transports",
                                                                                "transports",
                                                                                "getTransports",
                                                                                "setTransports");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_configurable", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_configurable",
                                                                                "userConfigurable",
                                                                                "getUserConfigurable",
                                                                                "setUserConfigurable");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.nic_metadata",
                                                            fields,
                                                            com.vmware.nsx.model.NicMetadata.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

