/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * OpenID Connect end-point specifying where to fetch the JWKS document used to
 * validate JWT tokens for TokenBasedPrincipalIdentities.
 */
public final class OidcEndPoint implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String OIDC_TYPE_VCENTER = "vcenter";

    public static final java.lang.String OIDC_TYPE_WS_ONE = "ws_one";

    public static final java.lang.String OIDC_TYPE_CSP = "csp";

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    private java.lang.String authorizationEndpoint;

    private java.util.List<com.vmware.nsx.model.ClaimMap> claimMap;

    private java.util.List<java.lang.String> claimsSupported;

    private java.lang.String clientId;

    private java.lang.String clientSecret;

    private com.vmware.nsx.model.CspConfig cspConfig;

    private java.lang.String endSessionEndpointUri;

    private java.lang.String issuer;

    private java.lang.String jwksUri;

    private java.lang.String name;

    private java.lang.String oidcType;

    private java.lang.String oidcUri;

    private java.util.List<java.lang.String> overrideRoles;

    private java.lang.Boolean restrictScimSearch;

    private java.util.List<java.lang.String> scimEndpoints;

    private java.util.List<java.lang.String> servicedDomains;

    private java.lang.String thumbprint;

    private java.lang.String tokenEndpoint;

    private java.lang.String userinfoEndpoint;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public OidcEndPoint() {
    }

    protected OidcEndPoint(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * The URL of the OpenID provider's authorization endpoint.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    /**
     * The URL of the OpenID provider's authorization endpoint.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param authorizationEndpoint New value for the property.
     */
    public void setAuthorizationEndpoint(java.lang.String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    /**
     * Configuration for mapping claims in OIDC ID tokens to NSX roles.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ClaimMap> getClaimMap() {
        return this.claimMap;
    }

    /**
     * Configuration for mapping claims in OIDC ID tokens to NSX roles.
     *
     * @param claimMap New value for the property.
     */
    public void setClaimMap(java.util.List<com.vmware.nsx.model.ClaimMap> claimMap) {
        this.claimMap = claimMap;
    }

    /**
     * The list of claims that the OpenID provider supports.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getClaimsSupported() {
        return this.claimsSupported;
    }

    /**
     * The list of claims that the OpenID provider supports.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param claimsSupported New value for the property.
     */
    public void setClaimsSupported(java.util.List<java.lang.String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    /**
     * The client ID for NSX to use when authenticating via this OIDC provider. This is
     * required when oidc_type is \"ws_one\" or \"csp\".
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientId() {
        return this.clientId;
    }

    /**
     * The client ID for NSX to use when authenticating via this OIDC provider. This is
     * required when oidc_type is \"ws_one\" or \"csp\".
     *
     * @param clientId New value for the property.
     */
    public void setClientId(java.lang.String clientId) {
        this.clientId = clientId;
    }

    /**
     * The client secret for NSX to use when authenticating via this OIDC provider.
     * This is required when oidc_type is \"ws_one\".
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientSecret() {
        return this.clientSecret;
    }

    /**
     * The client secret for NSX to use when authenticating via this OIDC provider.
     * This is required when oidc_type is \"ws_one\".
     *
     * @param clientSecret New value for the property.
     */
    public void setClientSecret(java.lang.String clientSecret) {
        this.clientSecret = clientSecret;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.CspConfig getCspConfig() {
        return this.cspConfig;
    }

    /**
     *
     *
     * @param cspConfig New value for the property.
     */
    public void setCspConfig(com.vmware.nsx.model.CspConfig cspConfig) {
        this.cspConfig = cspConfig;
    }

    /**
     * URI of the OpenID session logout end-point.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEndSessionEndpointUri() {
        return this.endSessionEndpointUri;
    }

    /**
     * URI of the OpenID session logout end-point.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param endSessionEndpointUri New value for the property.
     */
    public void setEndSessionEndpointUri(java.lang.String endSessionEndpointUri) {
        this.endSessionEndpointUri = endSessionEndpointUri;
    }

    /**
     * Issuer of the JWT tokens for the given type. This field is fetched from the
     * meta-data located at the oidc_uri.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIssuer() {
        return this.issuer;
    }

    /**
     * Issuer of the JWT tokens for the given type. This field is fetched from the
     * meta-data located at the oidc_uri.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param issuer New value for the property.
     */
    public void setIssuer(java.lang.String issuer) {
        this.issuer = issuer;
    }

    /**
     * The URI where the JWKS document is located that has the key used to validate the
     * JWT signature.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getJwksUri() {
        return this.jwksUri;
    }

    /**
     * The URI where the JWKS document is located that has the key used to validate the
     * JWT signature.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param jwksUri New value for the property.
     */
    public void setJwksUri(java.lang.String jwksUri) {
        this.jwksUri = jwksUri;
    }

    /**
     * A short, unique name for this OpenID Connect end-point. OIDC endpoint names may
     * not contain spaces. If not provided, defaults to the ID of the OidcEndPoint.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * A short, unique name for this OpenID Connect end-point. OIDC endpoint names may
     * not contain spaces. If not provided, defaults to the ID of the OidcEndPoint.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.OidcEndPoint#OIDC_TYPE_VCENTER}</li> <li> {@link
     * com.vmware.nsx.model.OidcEndPoint#OIDC_TYPE_WS_ONE}</li> <li> {@link
     * com.vmware.nsx.model.OidcEndPoint#OIDC_TYPE_CSP}</li> </ul> Type used to
     * distinguish the OIDC end-points by IDP.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOidcType() {
        return this.oidcType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.OidcEndPoint#OIDC_TYPE_VCENTER}</li> <li> {@link
     * com.vmware.nsx.model.OidcEndPoint#OIDC_TYPE_WS_ONE}</li> <li> {@link
     * com.vmware.nsx.model.OidcEndPoint#OIDC_TYPE_CSP}</li> </ul> Type used to
     * distinguish the OIDC end-points by IDP.
     *
     * @param oidcType New value for the property.
     */
    public void setOidcType(java.lang.String oidcType) {
        this.oidcType = oidcType;
    }

    /**
     * URI of the OpenID Connect end-point.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOidcUri() {
        return this.oidcUri;
    }

    /**
     * URI of the OpenID Connect end-point.
     *
     * @param oidcUri New value for the property.
     */
    public void setOidcUri(java.lang.String oidcUri) {
        this.oidcUri = oidcUri;
    }

    /**
     * When specified this role or roles are used instead of the nsx-role in the JWT
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getOverrideRoles() {
        return this.overrideRoles;
    }

    /**
     * When specified this role or roles are used instead of the nsx-role in the JWT
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param overrideRoles New value for the property.
     */
    public void setOverrideRoles(java.util.List<java.lang.String> overrideRoles) {
        this.overrideRoles = overrideRoles;
    }

    /**
     * If set to true, then it is only possible to perform a SCIM search against the
     * OIDC provider used to authenticate. If OIDC was not used to authenticate (for
     * example, if authenticated as a local user), then this restriction does not
     * apply.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getRestrictScimSearch() {
        return this.restrictScimSearch;
    }

    /**
     * If set to true, then it is only possible to perform a SCIM search against the
     * OIDC provider used to authenticate. If OIDC was not used to authenticate (for
     * example, if authenticated as a local user), then this restriction does not
     * apply.
     *
     * @param restrictScimSearch New value for the property.
     */
    public void setRestrictScimSearch(java.lang.Boolean restrictScimSearch) {
        this.restrictScimSearch = restrictScimSearch;
    }

    /**
     * The SCIM (System for Cross-domain Identity Management) endpoint URLs to use when
     * enumerating users and groups. All endpoints will be queried to obtain user and
     * group information.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getScimEndpoints() {
        return this.scimEndpoints;
    }

    /**
     * The SCIM (System for Cross-domain Identity Management) endpoint URLs to use when
     * enumerating users and groups. All endpoints will be queried to obtain user and
     * group information.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param scimEndpoints New value for the property.
     */
    public void setScimEndpoints(java.util.List<java.lang.String> scimEndpoints) {
        this.scimEndpoints = scimEndpoints;
    }

    /**
     * When a login to NSX using a principal name of the form user@domain is attempted,
     * the list of OIDC providers will be scanned to find one with a matching domain.
     * If a match is found, that OIDC provider is used to authenticate the user. Each
     * domain must be unique across all OIDC providers. If a duplicate domain is
     * provided when adding or updating and OIDC provider, the request will be
     * rejected.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getServicedDomains() {
        return this.servicedDomains;
    }

    /**
     * When a login to NSX using a principal name of the form user@domain is attempted,
     * the list of OIDC providers will be scanned to find one with a matching domain.
     * If a match is found, that OIDC provider is used to authenticate the user. Each
     * domain must be unique across all OIDC providers. If a duplicate domain is
     * provided when adding or updating and OIDC provider, the request will be
     * rejected.
     *
     * @param servicedDomains New value for the property.
     */
    public void setServicedDomains(java.util.List<java.lang.String> servicedDomains) {
        this.servicedDomains = servicedDomains;
    }

    /**
     * Thumbprint in SHA-256 format used to verify the server certificate at the URI.
     *
     * @return The current value of the property.
     */
    public java.lang.String getThumbprint() {
        return this.thumbprint;
    }

    /**
     * Thumbprint in SHA-256 format used to verify the server certificate at the URI.
     *
     * @param thumbprint New value for the property.
     */
    public void setThumbprint(java.lang.String thumbprint) {
        this.thumbprint = thumbprint;
    }

    /**
     * The URL of the OpenID provider's token endpoint.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    /**
     * The URL of the OpenID provider's token endpoint.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param tokenEndpoint New value for the property.
     */
    public void setTokenEndpoint(java.lang.String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    /**
     * The URL of the OpenID provider's userinfo endpoint.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    /**
     * The URL of the OpenID provider's userinfo endpoint.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param userinfoEndpoint New value for the property.
     */
    public void setUserinfoEndpoint(java.lang.String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.oidcEndPoint;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("authorization_endpoint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.authorizationEndpoint, this._getType().getField("authorization_endpoint")));
        structValue.setField("claim_map",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.claimMap, this._getType().getField("claim_map")));
        structValue.setField("claims_supported",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.claimsSupported, this._getType().getField("claims_supported")));
        structValue.setField("client_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientId, this._getType().getField("client_id")));
        structValue.setField("client_secret",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientSecret, this._getType().getField("client_secret")));
        structValue.setField("csp_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cspConfig, this._getType().getField("csp_config")));
        structValue.setField("end_session_endpoint_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.endSessionEndpointUri, this._getType().getField("end_session_endpoint_uri")));
        structValue.setField("issuer",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.issuer, this._getType().getField("issuer")));
        structValue.setField("jwks_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.jwksUri, this._getType().getField("jwks_uri")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("oidc_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.oidcType, this._getType().getField("oidc_type")));
        structValue.setField("oidc_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.oidcUri, this._getType().getField("oidc_uri")));
        structValue.setField("override_roles",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overrideRoles, this._getType().getField("override_roles")));
        structValue.setField("restrict_scim_search",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.restrictScimSearch, this._getType().getField("restrict_scim_search")));
        structValue.setField("scim_endpoints",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.scimEndpoints, this._getType().getField("scim_endpoints")));
        structValue.setField("serviced_domains",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.servicedDomains, this._getType().getField("serviced_domains")));
        structValue.setField("thumbprint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.thumbprint, this._getType().getField("thumbprint")));
        structValue.setField("token_endpoint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tokenEndpoint, this._getType().getField("token_endpoint")));
        structValue.setField("userinfo_endpoint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userinfoEndpoint, this._getType().getField("userinfo_endpoint")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.oidcEndPoint;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.oidcEndPoint.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static OidcEndPoint _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new OidcEndPoint(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static OidcEndPoint _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new OidcEndPoint(structValue);
    }

    /**
     * Builder class for {@link OidcEndPoint}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx.model.Tag> tags;
        private java.lang.String authorizationEndpoint;
        private java.util.List<com.vmware.nsx.model.ClaimMap> claimMap;
        private java.util.List<java.lang.String> claimsSupported;
        private java.lang.String clientId;
        private java.lang.String clientSecret;
        private com.vmware.nsx.model.CspConfig cspConfig;
        private java.lang.String endSessionEndpointUri;
        private java.lang.String issuer;
        private java.lang.String jwksUri;
        private java.lang.String name;
        private java.lang.String oidcType;
        private java.lang.String oidcUri;
        private java.util.List<java.lang.String> overrideRoles;
        private java.lang.Boolean restrictScimSearch;
        private java.util.List<java.lang.String> scimEndpoints;
        private java.util.List<java.lang.String> servicedDomains;
        private java.lang.String thumbprint;
        private java.lang.String tokenEndpoint;
        private java.lang.String userinfoEndpoint;

        /**
         * Constructor with parameters for the required properties of
         * {@link OidcEndPoint}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * The URL of the OpenID provider's authorization endpoint.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param authorizationEndpoint New value for the property.
         */
        public Builder setAuthorizationEndpoint(java.lang.String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        /**
         * Configuration for mapping claims in OIDC ID tokens to NSX roles.
         *
         * @param claimMap New value for the property.
         */
        public Builder setClaimMap(java.util.List<com.vmware.nsx.model.ClaimMap> claimMap) {
            this.claimMap = claimMap;
            return this;
        }

        /**
         * The list of claims that the OpenID provider supports.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param claimsSupported New value for the property.
         */
        public Builder setClaimsSupported(java.util.List<java.lang.String> claimsSupported) {
            this.claimsSupported = claimsSupported;
            return this;
        }

        /**
         * The client ID for NSX to use when authenticating via this OIDC provider. This is
         * required when oidc_type is \"ws_one\" or \"csp\".
         *
         * @param clientId New value for the property.
         */
        public Builder setClientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * The client secret for NSX to use when authenticating via this OIDC provider.
         * This is required when oidc_type is \"ws_one\".
         *
         * @param clientSecret New value for the property.
         */
        public Builder setClientSecret(java.lang.String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        /**
         *
         *
         * @param cspConfig New value for the property.
         */
        public Builder setCspConfig(com.vmware.nsx.model.CspConfig cspConfig) {
            this.cspConfig = cspConfig;
            return this;
        }

        /**
         * URI of the OpenID session logout end-point.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param endSessionEndpointUri New value for the property.
         */
        public Builder setEndSessionEndpointUri(java.lang.String endSessionEndpointUri) {
            this.endSessionEndpointUri = endSessionEndpointUri;
            return this;
        }

        /**
         * Issuer of the JWT tokens for the given type. This field is fetched from the
         * meta-data located at the oidc_uri.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param issuer New value for the property.
         */
        public Builder setIssuer(java.lang.String issuer) {
            this.issuer = issuer;
            return this;
        }

        /**
         * The URI where the JWKS document is located that has the key used to validate the
         * JWT signature.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param jwksUri New value for the property.
         */
        public Builder setJwksUri(java.lang.String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }

        /**
         * A short, unique name for this OpenID Connect end-point. OIDC endpoint names may
         * not contain spaces. If not provided, defaults to the ID of the OidcEndPoint.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.OidcEndPoint#OIDC_TYPE_VCENTER}</li> <li> {@link
         * com.vmware.nsx.model.OidcEndPoint#OIDC_TYPE_WS_ONE}</li> <li> {@link
         * com.vmware.nsx.model.OidcEndPoint#OIDC_TYPE_CSP}</li> </ul> Type used to
         * distinguish the OIDC end-points by IDP.
         *
         * @param oidcType New value for the property.
         */
        public Builder setOidcType(java.lang.String oidcType) {
            this.oidcType = oidcType;
            return this;
        }

        /**
         * URI of the OpenID Connect end-point.
         *
         * @param oidcUri New value for the property.
         */
        public Builder setOidcUri(java.lang.String oidcUri) {
            this.oidcUri = oidcUri;
            return this;
        }

        /**
         * When specified this role or roles are used instead of the nsx-role in the JWT
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param overrideRoles New value for the property.
         */
        public Builder setOverrideRoles(java.util.List<java.lang.String> overrideRoles) {
            this.overrideRoles = overrideRoles;
            return this;
        }

        /**
         * If set to true, then it is only possible to perform a SCIM search against the
         * OIDC provider used to authenticate. If OIDC was not used to authenticate (for
         * example, if authenticated as a local user), then this restriction does not
         * apply.
         *
         * @param restrictScimSearch New value for the property.
         */
        public Builder setRestrictScimSearch(java.lang.Boolean restrictScimSearch) {
            this.restrictScimSearch = restrictScimSearch;
            return this;
        }

        /**
         * The SCIM (System for Cross-domain Identity Management) endpoint URLs to use when
         * enumerating users and groups. All endpoints will be queried to obtain user and
         * group information.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param scimEndpoints New value for the property.
         */
        public Builder setScimEndpoints(java.util.List<java.lang.String> scimEndpoints) {
            this.scimEndpoints = scimEndpoints;
            return this;
        }

        /**
         * When a login to NSX using a principal name of the form user@domain is attempted,
         * the list of OIDC providers will be scanned to find one with a matching domain.
         * If a match is found, that OIDC provider is used to authenticate the user. Each
         * domain must be unique across all OIDC providers. If a duplicate domain is
         * provided when adding or updating and OIDC provider, the request will be
         * rejected.
         *
         * @param servicedDomains New value for the property.
         */
        public Builder setServicedDomains(java.util.List<java.lang.String> servicedDomains) {
            this.servicedDomains = servicedDomains;
            return this;
        }

        /**
         * Thumbprint in SHA-256 format used to verify the server certificate at the URI.
         *
         * @param thumbprint New value for the property.
         */
        public Builder setThumbprint(java.lang.String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        /**
         * The URL of the OpenID provider's token endpoint.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param tokenEndpoint New value for the property.
         */
        public Builder setTokenEndpoint(java.lang.String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        /**
         * The URL of the OpenID provider's userinfo endpoint.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param userinfoEndpoint New value for the property.
         */
        public Builder setUserinfoEndpoint(java.lang.String userinfoEndpoint) {
            this.userinfoEndpoint = userinfoEndpoint;
            return this;
        }

        public OidcEndPoint build() {
            OidcEndPoint result = new OidcEndPoint();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setAuthorizationEndpoint(this.authorizationEndpoint);
            result.setClaimMap(this.claimMap);
            result.setClaimsSupported(this.claimsSupported);
            result.setClientId(this.clientId);
            result.setClientSecret(this.clientSecret);
            result.setCspConfig(this.cspConfig);
            result.setEndSessionEndpointUri(this.endSessionEndpointUri);
            result.setIssuer(this.issuer);
            result.setJwksUri(this.jwksUri);
            result.setName(this.name);
            result.setOidcType(this.oidcType);
            result.setOidcUri(this.oidcUri);
            result.setOverrideRoles(this.overrideRoles);
            result.setRestrictScimSearch(this.restrictScimSearch);
            result.setScimEndpoints(this.scimEndpoints);
            result.setServicedDomains(this.servicedDomains);
            result.setThumbprint(this.thumbprint);
            result.setTokenEndpoint(this.tokenEndpoint);
            result.setUserinfoEndpoint(this.userinfoEndpoint);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("authorization_endpoint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("authorization_endpoint",
                                                                                "authorizationEndpoint",
                                                                                "getAuthorizationEndpoint",
                                                                                "setAuthorizationEndpoint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("claim_map", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.claimMap; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("claim_map",
                                                                                "claimMap",
                                                                                "getClaimMap",
                                                                                "setClaimMap");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("claims_supported", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("claims_supported",
                                                                                "claimsSupported",
                                                                                "getClaimsSupported",
                                                                                "setClaimsSupported");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_id",
                                                                                "clientId",
                                                                                "getClientId",
                                                                                "setClientId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_secret", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_secret",
                                                                                "clientSecret",
                                                                                "getClientSecret",
                                                                                "setClientSecret");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("csp_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.cspConfig; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("csp_config",
                                                                                "cspConfig",
                                                                                "getCspConfig",
                                                                                "setCspConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("end_session_endpoint_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("end_session_endpoint_uri",
                                                                                "endSessionEndpointUri",
                                                                                "getEndSessionEndpointUri",
                                                                                "setEndSessionEndpointUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("issuer", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("issuer",
                                                                                "issuer",
                                                                                "getIssuer",
                                                                                "setIssuer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("jwks_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("jwks_uri",
                                                                                "jwksUri",
                                                                                "getJwksUri",
                                                                                "setJwksUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("oidc_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("oidc_type",
                                                                                "oidcType",
                                                                                "getOidcType",
                                                                                "setOidcType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("oidc_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("oidc_uri",
                                                                                "oidcUri",
                                                                                "getOidcUri",
                                                                                "setOidcUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("override_roles", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("override_roles",
                                                                                "overrideRoles",
                                                                                "getOverrideRoles",
                                                                                "setOverrideRoles");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("restrict_scim_search", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("restrict_scim_search",
                                                                                "restrictScimSearch",
                                                                                "getRestrictScimSearch",
                                                                                "setRestrictScimSearch");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("scim_endpoints", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("scim_endpoints",
                                                                                "scimEndpoints",
                                                                                "getScimEndpoints",
                                                                                "setScimEndpoints");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("serviced_domains", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("serviced_domains",
                                                                                "servicedDomains",
                                                                                "getServicedDomains",
                                                                                "setServicedDomains");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("thumbprint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("thumbprint",
                                                                                "thumbprint",
                                                                                "getThumbprint",
                                                                                "setThumbprint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("token_endpoint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("token_endpoint",
                                                                                "tokenEndpoint",
                                                                                "getTokenEndpoint",
                                                                                "setTokenEndpoint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("userinfo_endpoint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("userinfo_endpoint",
                                                                                "userinfoEndpoint",
                                                                                "getUserinfoEndpoint",
                                                                                "setUserinfoEndpoint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.oidc_end_point",
                                                            fields,
                                                            com.vmware.nsx.model.OidcEndPoint.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

