/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Parameters needed to specify a PKCE OAuth2 client.
 */
public final class PublicClientInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String baseUrl;

    private java.lang.String clientId;

    private java.lang.String defaultOrgId;

    private java.lang.String eaOrgId;

    private java.lang.String gssOrgId;

    private java.util.List<java.lang.String> redirectUris;

    private java.lang.String sreOrgId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PublicClientInfo() {
    }

    protected PublicClientInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Protocol and domain name (or IP address) of CSP, for e.g.,
     * https://console.cloud.vmware.com.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBaseUrl() {
        return this.baseUrl;
    }

    /**
     * Protocol and domain name (or IP address) of CSP, for e.g.,
     * https://console.cloud.vmware.com.
     *
     * @param baseUrl New value for the property.
     */
    public void setBaseUrl(java.lang.String baseUrl) {
        this.baseUrl = baseUrl;
    }

    /**
     * The client-id to use with CSP, identified with base_url.
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientId() {
        return this.clientId;
    }

    /**
     * The client-id to use with CSP, identified with base_url.
     *
     * @param clientId New value for the property.
     */
    public void setClientId(java.lang.String clientId) {
        this.clientId = clientId;
    }

    /**
     * The org id for this client-id, typically a UUID.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDefaultOrgId() {
        return this.defaultOrgId;
    }

    /**
     * The org id for this client-id, typically a UUID.
     *
     * @param defaultOrgId New value for the property.
     */
    public void setDefaultOrgId(java.lang.String defaultOrgId) {
        this.defaultOrgId = defaultOrgId;
    }

    /**
     * The symbolic org id for enterprise admins.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEaOrgId() {
        return this.eaOrgId;
    }

    /**
     * The symbolic org id for enterprise admins.
     *
     * @param eaOrgId New value for the property.
     */
    public void setEaOrgId(java.lang.String eaOrgId) {
        this.eaOrgId = eaOrgId;
    }

    /**
     * The symbolic org id for GSS (Global Support Services).
     *
     * @return The current value of the property.
     */
    public java.lang.String getGssOrgId() {
        return this.gssOrgId;
    }

    /**
     * The symbolic org id for GSS (Global Support Services).
     *
     * @param gssOrgId New value for the property.
     */
    public void setGssOrgId(java.lang.String gssOrgId) {
        this.gssOrgId = gssOrgId;
    }

    /**
     * The set of redirect URI's configured for this client_id.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getRedirectUris() {
        return this.redirectUris;
    }

    /**
     * The set of redirect URI's configured for this client_id.
     *
     * @param redirectUris New value for the property.
     */
    public void setRedirectUris(java.util.List<java.lang.String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    /**
     * The symbolic org id SRE (Site Reliability Engineer).
     *
     * @return The current value of the property.
     */
    public java.lang.String getSreOrgId() {
        return this.sreOrgId;
    }

    /**
     * The symbolic org id SRE (Site Reliability Engineer).
     *
     * @param sreOrgId New value for the property.
     */
    public void setSreOrgId(java.lang.String sreOrgId) {
        this.sreOrgId = sreOrgId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.publicClientInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("base_url",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.baseUrl, this._getType().getField("base_url")));
        structValue.setField("client_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientId, this._getType().getField("client_id")));
        structValue.setField("default_org_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultOrgId, this._getType().getField("default_org_id")));
        structValue.setField("ea_org_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.eaOrgId, this._getType().getField("ea_org_id")));
        structValue.setField("gss_org_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.gssOrgId, this._getType().getField("gss_org_id")));
        structValue.setField("redirect_uris",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.redirectUris, this._getType().getField("redirect_uris")));
        structValue.setField("sre_org_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sreOrgId, this._getType().getField("sre_org_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.publicClientInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.publicClientInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PublicClientInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PublicClientInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PublicClientInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PublicClientInfo(structValue);
    }

    /**
     * Builder class for {@link PublicClientInfo}.
     */
    public static final class Builder {
        private java.lang.String baseUrl;
        private java.lang.String clientId;
        private java.lang.String defaultOrgId;
        private java.lang.String eaOrgId;
        private java.lang.String gssOrgId;
        private java.util.List<java.lang.String> redirectUris;
        private java.lang.String sreOrgId;

        /**
         * Constructor with parameters for the required properties of
         * {@link PublicClientInfo}.
         */
        public Builder() {
        }

        /**
         * Protocol and domain name (or IP address) of CSP, for e.g.,
         * https://console.cloud.vmware.com.
         *
         * @param baseUrl New value for the property.
         */
        public Builder setBaseUrl(java.lang.String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        /**
         * The client-id to use with CSP, identified with base_url.
         *
         * @param clientId New value for the property.
         */
        public Builder setClientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * The org id for this client-id, typically a UUID.
         *
         * @param defaultOrgId New value for the property.
         */
        public Builder setDefaultOrgId(java.lang.String defaultOrgId) {
            this.defaultOrgId = defaultOrgId;
            return this;
        }

        /**
         * The symbolic org id for enterprise admins.
         *
         * @param eaOrgId New value for the property.
         */
        public Builder setEaOrgId(java.lang.String eaOrgId) {
            this.eaOrgId = eaOrgId;
            return this;
        }

        /**
         * The symbolic org id for GSS (Global Support Services).
         *
         * @param gssOrgId New value for the property.
         */
        public Builder setGssOrgId(java.lang.String gssOrgId) {
            this.gssOrgId = gssOrgId;
            return this;
        }

        /**
         * The set of redirect URI's configured for this client_id.
         *
         * @param redirectUris New value for the property.
         */
        public Builder setRedirectUris(java.util.List<java.lang.String> redirectUris) {
            this.redirectUris = redirectUris;
            return this;
        }

        /**
         * The symbolic org id SRE (Site Reliability Engineer).
         *
         * @param sreOrgId New value for the property.
         */
        public Builder setSreOrgId(java.lang.String sreOrgId) {
            this.sreOrgId = sreOrgId;
            return this;
        }

        public PublicClientInfo build() {
            PublicClientInfo result = new PublicClientInfo();
            result.setBaseUrl(this.baseUrl);
            result.setClientId(this.clientId);
            result.setDefaultOrgId(this.defaultOrgId);
            result.setEaOrgId(this.eaOrgId);
            result.setGssOrgId(this.gssOrgId);
            result.setRedirectUris(this.redirectUris);
            result.setSreOrgId(this.sreOrgId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("base_url", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("base_url",
                                                                                "baseUrl",
                                                                                "getBaseUrl",
                                                                                "setBaseUrl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_id",
                                                                                "clientId",
                                                                                "getClientId",
                                                                                "setClientId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_org_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_org_id",
                                                                                "defaultOrgId",
                                                                                "getDefaultOrgId",
                                                                                "setDefaultOrgId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ea_org_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ea_org_id",
                                                                                "eaOrgId",
                                                                                "getEaOrgId",
                                                                                "setEaOrgId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("gss_org_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("gss_org_id",
                                                                                "gssOrgId",
                                                                                "getGssOrgId",
                                                                                "setGssOrgId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("redirect_uris", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("redirect_uris",
                                                                                "redirectUris",
                                                                                "getRedirectUris",
                                                                                "setRedirectUris");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sre_org_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sre_org_id",
                                                                                "sreOrgId",
                                                                                "getSreOrgId",
                                                                                "setSreOrgId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.public_client_info",
                                                            fields,
                                                            com.vmware.nsx.model.PublicClientInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

