/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class PublicCloudGatewayNode implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<java.lang.String> allocationList;

    private com.vmware.nsx.model.EdgeNodeDeploymentConfig deploymentConfig;

    private java.lang.String deploymentType;

    private com.vmware.nsx.model.EdgeNodeSettings nodeSettings;

    private java.lang.String description;

    private java.util.List<java.lang.String> discoveredIpAddresses;

    private java.lang.String displayName;

    private java.lang.String externalId;

    private java.lang.String fqdn;

    private java.lang.String id;

    private java.util.List<java.lang.String> ipAddresses;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PublicCloudGatewayNode() {
    }

    protected PublicCloudGatewayNode(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * List of logical router ids to which this edge node is allocated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getAllocationList() {
        return this.allocationList;
    }

    /**
     * List of logical router ids to which this edge node is allocated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param allocationList New value for the property.
     */
    public void setAllocationList(java.util.List<java.lang.String> allocationList) {
        this.allocationList = allocationList;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.EdgeNodeDeploymentConfig getDeploymentConfig() {
        return this.deploymentConfig;
    }

    /**
     *
     *
     * @param deploymentConfig New value for the property.
     */
    public void setDeploymentConfig(com.vmware.nsx.model.EdgeNodeDeploymentConfig deploymentConfig) {
        this.deploymentConfig = deploymentConfig;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.EdgeNode#DEPLOYMENT_TYPE_VIRTUAL_MACHINE}</li> <li> {@link
     * com.vmware.nsx.model.EdgeNode#DEPLOYMENT_TYPE_PHYSICAL_MACHINE}</li> <li> {@link
     * com.vmware.nsx.model.EdgeNode#DEPLOYMENT_TYPE_UNKNOWN}</li> </ul> Supported edge
     * deployment type.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDeploymentType() {
        return this.deploymentType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.EdgeNode#DEPLOYMENT_TYPE_VIRTUAL_MACHINE}</li> <li> {@link
     * com.vmware.nsx.model.EdgeNode#DEPLOYMENT_TYPE_PHYSICAL_MACHINE}</li> <li> {@link
     * com.vmware.nsx.model.EdgeNode#DEPLOYMENT_TYPE_UNKNOWN}</li> </ul> Supported edge
     * deployment type.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param deploymentType New value for the property.
     */
    public void setDeploymentType(java.lang.String deploymentType) {
        this.deploymentType = deploymentType;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.EdgeNodeSettings getNodeSettings() {
        return this.nodeSettings;
    }

    /**
     *
     *
     * @param nodeSettings New value for the property.
     */
    public void setNodeSettings(com.vmware.nsx.model.EdgeNodeSettings nodeSettings) {
        this.nodeSettings = nodeSettings;
    }

    /**
     * This field is deprecated. TransportNode field 'description' must be used
     * instead. For EdgeNode and PublicCloudGatewayNode, this field is ignored if
     * specified in request payload.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * This field is deprecated. TransportNode field 'description' must be used
     * instead. For EdgeNode and PublicCloudGatewayNode, this field is ignored if
     * specified in request payload.
     *
     * @param description New value for the property.
     */
    @Deprecated
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Discovered IP Addresses of the fabric node, version 4 or 6 format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDiscoveredIpAddresses() {
        return this.discoveredIpAddresses;
    }

    /**
     * Discovered IP Addresses of the fabric node, version 4 or 6 format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param discoveredIpAddresses New value for the property.
     */
    public void setDiscoveredIpAddresses(java.util.List<java.lang.String> discoveredIpAddresses) {
        this.discoveredIpAddresses = discoveredIpAddresses;
    }

    /**
     * This field is deprecated. TransportNode field 'display_name' must be used
     * instead. For HostNode, this field defaults to ID if not set. For EdgeNode and
     * PublicCloudGatewayNode, this field is ignored if specified in request payload.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * This field is deprecated. TransportNode field 'display_name' must be used
     * instead. For HostNode, this field defaults to ID if not set. For EdgeNode and
     * PublicCloudGatewayNode, this field is ignored if specified in request payload.
     *
     * @param displayName New value for the property.
     */
    @Deprecated
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * ID of the Node maintained on the Node and used to recognize the Node
     *
     * @return The current value of the property.
     */
    public java.lang.String getExternalId() {
        return this.externalId;
    }

    /**
     * ID of the Node maintained on the Node and used to recognize the Node
     *
     * @param externalId New value for the property.
     */
    public void setExternalId(java.lang.String externalId) {
        this.externalId = externalId;
    }

    /**
     * Fully qualified domain name of the fabric node
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFqdn() {
        return this.fqdn;
    }

    /**
     * Fully qualified domain name of the fabric node
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param fqdn New value for the property.
     */
    public void setFqdn(java.lang.String fqdn) {
        this.fqdn = fqdn;
    }

    /**
     * Unique identifier of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource.
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * IP Addresses of the Node, version 4 or 6. This property is mandatory for all
     * nodes except for automatic deployment of edge virtual machine node. For
     * automatic deployment, the ip address from management_port_subnets property will
     * be considered. format: ip
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getIpAddresses() {
        return this.ipAddresses;
    }

    /**
     * IP Addresses of the Node, version 4 or 6. This property is mandatory for all
     * nodes except for automatic deployment of edge virtual machine node. For
     * automatic deployment, the ip address from management_port_subnets property will
     * be considered. format: ip
     *
     * @param ipAddresses New value for the property.
     */
    public void setIpAddresses(java.util.List<java.lang.String> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    /**
     * Fabric node type, for example 'HostNode', 'EdgeNode' or 'PublicCloudGatewayNode'
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * Fabric node type, for example 'HostNode', 'EdgeNode' or 'PublicCloudGatewayNode'
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * This field is deprecated. TransportNode field 'tags' must be used instead. For
     * EdgeNode and PublicCloudGatewayNode, this field is ignored if specified in
     * request payload.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * This field is deprecated. TransportNode field 'tags' must be used instead. For
     * EdgeNode and PublicCloudGatewayNode, this field is ignored if specified in
     * request payload.
     *
     * @param tags New value for the property.
     */
    @Deprecated
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.publicCloudGatewayNode;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("allocation_list",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allocationList, this._getType().getField("allocation_list")));
        structValue.setField("deployment_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.deploymentConfig, this._getType().getField("deployment_config")));
        structValue.setField("deployment_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.deploymentType, this._getType().getField("deployment_type")));
        structValue.setField("node_settings",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeSettings, this._getType().getField("node_settings")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("discovered_ip_addresses",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.discoveredIpAddresses, this._getType().getField("discovered_ip_addresses")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("external_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.externalId, this._getType().getField("external_id")));
        structValue.setField("fqdn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fqdn, this._getType().getField("fqdn")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("ip_addresses",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddresses, this._getType().getField("ip_addresses")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.publicCloudGatewayNode;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.publicCloudGatewayNode.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PublicCloudGatewayNode _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PublicCloudGatewayNode(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PublicCloudGatewayNode _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PublicCloudGatewayNode(structValue);
    }

    /**
     * Builder class for {@link PublicCloudGatewayNode}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> allocationList;
        private com.vmware.nsx.model.EdgeNodeDeploymentConfig deploymentConfig;
        private java.lang.String deploymentType;
        private com.vmware.nsx.model.EdgeNodeSettings nodeSettings;
        private java.lang.String description;
        private java.util.List<java.lang.String> discoveredIpAddresses;
        private java.lang.String displayName;
        private java.lang.String externalId;
        private java.lang.String fqdn;
        private java.lang.String id;
        private java.util.List<java.lang.String> ipAddresses;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx.model.Tag> tags;

        /**
         * Constructor with parameters for the required properties of
         * {@link PublicCloudGatewayNode}.
         */
        public Builder(java.lang.String resourceType) {
            this.resourceType = resourceType;
        }

        /**
         * List of logical router ids to which this edge node is allocated.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param allocationList New value for the property.
         */
        public Builder setAllocationList(java.util.List<java.lang.String> allocationList) {
            this.allocationList = allocationList;
            return this;
        }

        /**
         *
         *
         * @param deploymentConfig New value for the property.
         */
        public Builder setDeploymentConfig(com.vmware.nsx.model.EdgeNodeDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.EdgeNode#DEPLOYMENT_TYPE_VIRTUAL_MACHINE}</li> <li> {@link
         * com.vmware.nsx.model.EdgeNode#DEPLOYMENT_TYPE_PHYSICAL_MACHINE}</li> <li> {@link
         * com.vmware.nsx.model.EdgeNode#DEPLOYMENT_TYPE_UNKNOWN}</li> </ul> Supported edge
         * deployment type.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param deploymentType New value for the property.
         */
        public Builder setDeploymentType(java.lang.String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        /**
         *
         *
         * @param nodeSettings New value for the property.
         */
        public Builder setNodeSettings(com.vmware.nsx.model.EdgeNodeSettings nodeSettings) {
            this.nodeSettings = nodeSettings;
            return this;
        }

        /**
         * This field is deprecated. TransportNode field 'description' must be used
         * instead. For EdgeNode and PublicCloudGatewayNode, this field is ignored if
         * specified in request payload.
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Discovered IP Addresses of the fabric node, version 4 or 6 format: ip
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param discoveredIpAddresses New value for the property.
         */
        public Builder setDiscoveredIpAddresses(java.util.List<java.lang.String> discoveredIpAddresses) {
            this.discoveredIpAddresses = discoveredIpAddresses;
            return this;
        }

        /**
         * This field is deprecated. TransportNode field 'display_name' must be used
         * instead. For HostNode, this field defaults to ID if not set. For EdgeNode and
         * PublicCloudGatewayNode, this field is ignored if specified in request payload.
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * ID of the Node maintained on the Node and used to recognize the Node
         *
         * @param externalId New value for the property.
         */
        public Builder setExternalId(java.lang.String externalId) {
            this.externalId = externalId;
            return this;
        }

        /**
         * Fully qualified domain name of the fabric node
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param fqdn New value for the property.
         */
        public Builder setFqdn(java.lang.String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        /**
         * Unique identifier of this resource.
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * IP Addresses of the Node, version 4 or 6. This property is mandatory for all
         * nodes except for automatic deployment of edge virtual machine node. For
         * automatic deployment, the ip address from management_port_subnets property will
         * be considered. format: ip
         *
         * @param ipAddresses New value for the property.
         */
        public Builder setIpAddresses(java.util.List<java.lang.String> ipAddresses) {
            this.ipAddresses = ipAddresses;
            return this;
        }

        /**
         * This field is deprecated. TransportNode field 'tags' must be used instead. For
         * EdgeNode and PublicCloudGatewayNode, this field is ignored if specified in
         * request payload.
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        public PublicCloudGatewayNode build() {
            PublicCloudGatewayNode result = new PublicCloudGatewayNode();
            result.setAllocationList(this.allocationList);
            result.setDeploymentConfig(this.deploymentConfig);
            result.setDeploymentType(this.deploymentType);
            result.setNodeSettings(this.nodeSettings);
            result.setDescription(this.description);
            result.setDiscoveredIpAddresses(this.discoveredIpAddresses);
            result.setDisplayName(this.displayName);
            result.setExternalId(this.externalId);
            result.setFqdn(this.fqdn);
            result.setId(this.id);
            result.setIpAddresses(this.ipAddresses);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("allocation_list", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allocation_list",
                                                                                "allocationList",
                                                                                "getAllocationList",
                                                                                "setAllocationList");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("deployment_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.edgeNodeDeploymentConfig; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("deployment_config",
                                                                                "deploymentConfig",
                                                                                "getDeploymentConfig",
                                                                                "setDeploymentConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("deployment_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("deployment_type",
                                                                                "deploymentType",
                                                                                "getDeploymentType",
                                                                                "setDeploymentType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_settings", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.edgeNodeSettings; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_settings",
                                                                                "nodeSettings",
                                                                                "getNodeSettings",
                                                                                "setNodeSettings");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("discovered_ip_addresses", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("discovered_ip_addresses",
                                                                                "discoveredIpAddresses",
                                                                                "getDiscoveredIpAddresses",
                                                                                "setDiscoveredIpAddresses");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("external_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("external_id",
                                                                                "externalId",
                                                                                "getExternalId",
                                                                                "setExternalId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("fqdn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fqdn",
                                                                                "fqdn",
                                                                                "getFqdn",
                                                                                "setFqdn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_addresses", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_addresses",
                                                                                "ipAddresses",
                                                                                "getIpAddresses",
                                                                                "setIpAddresses");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.public_cloud_gateway_node",
                                                            fields,
                                                            com.vmware.nsx.model.PublicCloudGatewayNode.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            null);
    }
}

