/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Specify limit, shares and reservation for all kinds of traffic. Values for limit
 * and reservation are expressed in percentage. And for shares, the value is
 * expressed as a number between 1-100. The overall reservation among all traffic
 * types should not exceed 75%. Otherwise, the API request will be rejected.
 */
public final class ResourceAllocation implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Double limit;

    private java.lang.Double reservation;

    private java.lang.Long shares;

    private com.vmware.nsx.model.HostInfraTrafficType trafficType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ResourceAllocation() {
    }

    protected ResourceAllocation(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The limit property specifies the maximum bandwidth allocation for a given
     * traffic type and is expressed in percentage. The default value for this field is
     * set to -1 which means the traffic is unbounded for the traffic type. All other
     * negative values for this property is not supported and will be rejected by the
     * API.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getLimit() {
        return this.limit;
    }

    /**
     * The limit property specifies the maximum bandwidth allocation for a given
     * traffic type and is expressed in percentage. The default value for this field is
     * set to -1 which means the traffic is unbounded for the traffic type. All other
     * negative values for this property is not supported and will be rejected by the
     * API.
     *
     * @param limit New value for the property.
     */
    public void setLimit(java.lang.Double limit) {
        this.limit = limit;
    }

    /**
     * Minimum guaranteed bandwidth percentage
     *
     * @return The current value of the property.
     */
    public java.lang.Double getReservation() {
        return this.reservation;
    }

    /**
     * Minimum guaranteed bandwidth percentage
     *
     * @param reservation New value for the property.
     */
    public void setReservation(java.lang.Double reservation) {
        this.reservation = reservation;
    }

    /**
     * Shares format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getShares() {
        return this.shares;
    }

    /**
     * Shares format: int32
     *
     * @param shares New value for the property.
     */
    public void setShares(java.lang.Long shares) {
        this.shares = shares;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.HostInfraTrafficType getTrafficType() {
        return this.trafficType;
    }

    /**
     *
     *
     * @param trafficType New value for the property.
     */
    public void setTrafficType(com.vmware.nsx.model.HostInfraTrafficType trafficType) {
        this.trafficType = trafficType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.resourceAllocation;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.limit, this._getType().getField("limit")));
        structValue.setField("reservation",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.reservation, this._getType().getField("reservation")));
        structValue.setField("shares",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.shares, this._getType().getField("shares")));
        structValue.setField("traffic_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.trafficType, this._getType().getField("traffic_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.resourceAllocation;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.resourceAllocation.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ResourceAllocation _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ResourceAllocation(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ResourceAllocation _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ResourceAllocation(structValue);
    }

    /**
     * Builder class for {@link ResourceAllocation}.
     */
    public static final class Builder {
        private java.lang.Double limit;
        private java.lang.Double reservation;
        private java.lang.Long shares;
        private com.vmware.nsx.model.HostInfraTrafficType trafficType;

        /**
         * Constructor with parameters for the required properties of
         * {@link ResourceAllocation}.
         */
        public Builder() {
        }

        /**
         * The limit property specifies the maximum bandwidth allocation for a given
         * traffic type and is expressed in percentage. The default value for this field is
         * set to -1 which means the traffic is unbounded for the traffic type. All other
         * negative values for this property is not supported and will be rejected by the
         * API.
         *
         * @param limit New value for the property.
         */
        public Builder setLimit(java.lang.Double limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Minimum guaranteed bandwidth percentage
         *
         * @param reservation New value for the property.
         */
        public Builder setReservation(java.lang.Double reservation) {
            this.reservation = reservation;
            return this;
        }

        /**
         * Shares format: int32
         *
         * @param shares New value for the property.
         */
        public Builder setShares(java.lang.Long shares) {
            this.shares = shares;
            return this;
        }

        /**
         *
         *
         * @param trafficType New value for the property.
         */
        public Builder setTrafficType(com.vmware.nsx.model.HostInfraTrafficType trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        public ResourceAllocation build() {
            ResourceAllocation result = new ResourceAllocation();
            result.setLimit(this.limit);
            result.setReservation(this.reservation);
            result.setShares(this.shares);
            result.setTrafficType(this.trafficType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("limit",
                                                                                "limit",
                                                                                "getLimit",
                                                                                "setLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("reservation", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reservation",
                                                                                "reservation",
                                                                                "getReservation",
                                                                                "setReservation");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("shares", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("shares",
                                                                                "shares",
                                                                                "getShares",
                                                                                "setShares");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("traffic_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.hostInfraTrafficType; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("traffic_type",
                                                                                "trafficType",
                                                                                "getTrafficType",
                                                                                "setTrafficType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.resource_allocation",
                                                            fields,
                                                            com.vmware.nsx.model.ResourceAllocation.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

