/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Deployment Specs holds information required to deploy the Service-VMs.i.e. OVF
 * url where the partner Service-VM OVF is hosted. The host type on which the
 * OVF(Open Virtualization Format) can be deployed, Form factor to name a few.
 */
public final class SVMDeploymentSpec implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String HOST_TYPE_ESXI = "ESXI";

    public static final java.lang.String HOST_TYPE_RHELKVM = "RHELKVM";

    public static final java.lang.String HOST_TYPE_UBUNTUKVM = "UBUNTUKVM";

    public static final java.lang.String SERVICE_FORM_FACTOR_SMALL = "SMALL";

    public static final java.lang.String SERVICE_FORM_FACTOR_MEDIUM = "MEDIUM";

    public static final java.lang.String SERVICE_FORM_FACTOR_LARGE = "LARGE";

    private java.lang.String hostType;

    private java.lang.String minHostVersion;

    private java.lang.String name;

    private java.lang.String ovfUrl;

    private java.lang.String serviceFormFactor;

    private java.lang.String svmVersion;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SVMDeploymentSpec() {
    }

    protected SVMDeploymentSpec(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SVMDeploymentSpec#HOST_TYPE_ESXI}</li> <li> {@link
     * com.vmware.nsx.model.SVMDeploymentSpec#HOST_TYPE_RHELKVM}</li> <li> {@link
     * com.vmware.nsx.model.SVMDeploymentSpec#HOST_TYPE_UBUNTUKVM}</li> </ul> Host Type
     * on which the specified OVF can be deployed.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostType() {
        return this.hostType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SVMDeploymentSpec#HOST_TYPE_ESXI}</li> <li> {@link
     * com.vmware.nsx.model.SVMDeploymentSpec#HOST_TYPE_RHELKVM}</li> <li> {@link
     * com.vmware.nsx.model.SVMDeploymentSpec#HOST_TYPE_UBUNTUKVM}</li> </ul> Host Type
     * on which the specified OVF can be deployed.
     *
     * @param hostType New value for the property.
     */
    public void setHostType(java.lang.String hostType) {
        this.hostType = hostType;
    }

    /**
     * Minimum host version supported by this ovf. If a host in the deployment cluster
     * is having version less than this, then service deployment will not happen on
     * that host.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMinHostVersion() {
        return this.minHostVersion;
    }

    /**
     * Minimum host version supported by this ovf. If a host in the deployment cluster
     * is having version less than this, then service deployment will not happen on
     * that host.
     *
     * @param minHostVersion New value for the property.
     */
    public void setMinHostVersion(java.lang.String minHostVersion) {
        this.minHostVersion = minHostVersion;
    }

    /**
     * Deployment Spec name for ease of use, since multiple DeploymentSpec can be
     * specified.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * Deployment Spec name for ease of use, since multiple DeploymentSpec can be
     * specified.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Location of the partner VM OVF to be deployed.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOvfUrl() {
        return this.ovfUrl;
    }

    /**
     * Location of the partner VM OVF to be deployed.
     *
     * @param ovfUrl New value for the property.
     */
    public void setOvfUrl(java.lang.String ovfUrl) {
        this.ovfUrl = ovfUrl;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SVMDeploymentSpec#SERVICE_FORM_FACTOR_SMALL}</li> <li>
     * {@link com.vmware.nsx.model.SVMDeploymentSpec#SERVICE_FORM_FACTOR_MEDIUM}</li>
     * <li> {@link
     * com.vmware.nsx.model.SVMDeploymentSpec#SERVICE_FORM_FACTOR_LARGE}</li> </ul>
     * Supported ServiceInsertion Form Factor for the OVF deployment. The default
     * FormFactor is Medium.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceFormFactor() {
        return this.serviceFormFactor;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SVMDeploymentSpec#SERVICE_FORM_FACTOR_SMALL}</li> <li>
     * {@link com.vmware.nsx.model.SVMDeploymentSpec#SERVICE_FORM_FACTOR_MEDIUM}</li>
     * <li> {@link
     * com.vmware.nsx.model.SVMDeploymentSpec#SERVICE_FORM_FACTOR_LARGE}</li> </ul>
     * Supported ServiceInsertion Form Factor for the OVF deployment. The default
     * FormFactor is Medium.
     *
     * @param serviceFormFactor New value for the property.
     */
    public void setServiceFormFactor(java.lang.String serviceFormFactor) {
        this.serviceFormFactor = serviceFormFactor;
    }

    /**
     * Partner needs to specify the Service VM version which will get deployed.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSvmVersion() {
        return this.svmVersion;
    }

    /**
     * Partner needs to specify the Service VM version which will get deployed.
     *
     * @param svmVersion New value for the property.
     */
    public void setSvmVersion(java.lang.String svmVersion) {
        this.svmVersion = svmVersion;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.SVMDeploymentSpec;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("host_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostType, this._getType().getField("host_type")));
        structValue.setField("min_host_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.minHostVersion, this._getType().getField("min_host_version")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("ovf_url",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ovfUrl, this._getType().getField("ovf_url")));
        structValue.setField("service_form_factor",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceFormFactor, this._getType().getField("service_form_factor")));
        structValue.setField("svm_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.svmVersion, this._getType().getField("svm_version")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.SVMDeploymentSpec;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.SVMDeploymentSpec.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SVMDeploymentSpec _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SVMDeploymentSpec(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SVMDeploymentSpec _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SVMDeploymentSpec(structValue);
    }

    /**
     * Builder class for {@link SVMDeploymentSpec}.
     */
    public static final class Builder {
        private java.lang.String hostType;
        private java.lang.String minHostVersion;
        private java.lang.String name;
        private java.lang.String ovfUrl;
        private java.lang.String serviceFormFactor;
        private java.lang.String svmVersion;

        /**
         * Constructor with parameters for the required properties of
         * {@link SVMDeploymentSpec}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.SVMDeploymentSpec#HOST_TYPE_ESXI}</li> <li> {@link
         * com.vmware.nsx.model.SVMDeploymentSpec#HOST_TYPE_RHELKVM}</li> <li> {@link
         * com.vmware.nsx.model.SVMDeploymentSpec#HOST_TYPE_UBUNTUKVM}</li> </ul> Host Type
         * on which the specified OVF can be deployed.
         *
         * @param hostType New value for the property.
         */
        public Builder setHostType(java.lang.String hostType) {
            this.hostType = hostType;
            return this;
        }

        /**
         * Minimum host version supported by this ovf. If a host in the deployment cluster
         * is having version less than this, then service deployment will not happen on
         * that host.
         *
         * @param minHostVersion New value for the property.
         */
        public Builder setMinHostVersion(java.lang.String minHostVersion) {
            this.minHostVersion = minHostVersion;
            return this;
        }

        /**
         * Deployment Spec name for ease of use, since multiple DeploymentSpec can be
         * specified.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Location of the partner VM OVF to be deployed.
         *
         * @param ovfUrl New value for the property.
         */
        public Builder setOvfUrl(java.lang.String ovfUrl) {
            this.ovfUrl = ovfUrl;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.SVMDeploymentSpec#SERVICE_FORM_FACTOR_SMALL}</li> <li>
         * {@link com.vmware.nsx.model.SVMDeploymentSpec#SERVICE_FORM_FACTOR_MEDIUM}</li>
         * <li> {@link
         * com.vmware.nsx.model.SVMDeploymentSpec#SERVICE_FORM_FACTOR_LARGE}</li> </ul>
         * Supported ServiceInsertion Form Factor for the OVF deployment. The default
         * FormFactor is Medium.
         *
         * @param serviceFormFactor New value for the property.
         */
        public Builder setServiceFormFactor(java.lang.String serviceFormFactor) {
            this.serviceFormFactor = serviceFormFactor;
            return this;
        }

        /**
         * Partner needs to specify the Service VM version which will get deployed.
         *
         * @param svmVersion New value for the property.
         */
        public Builder setSvmVersion(java.lang.String svmVersion) {
            this.svmVersion = svmVersion;
            return this;
        }

        public SVMDeploymentSpec build() {
            SVMDeploymentSpec result = new SVMDeploymentSpec();
            result.setHostType(this.hostType);
            result.setMinHostVersion(this.minHostVersion);
            result.setName(this.name);
            result.setOvfUrl(this.ovfUrl);
            result.setServiceFormFactor(this.serviceFormFactor);
            result.setSvmVersion(this.svmVersion);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("host_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_type",
                                                                                "hostType",
                                                                                "getHostType",
                                                                                "setHostType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("min_host_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("min_host_version",
                                                                                "minHostVersion",
                                                                                "getMinHostVersion",
                                                                                "setMinHostVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ovf_url", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ovf_url",
                                                                                "ovfUrl",
                                                                                "getOvfUrl",
                                                                                "setOvfUrl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_form_factor", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_form_factor",
                                                                                "serviceFormFactor",
                                                                                "getServiceFormFactor",
                                                                                "setServiceFormFactor");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("svm_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("svm_version",
                                                                                "svmVersion",
                                                                                "getSvmVersion",
                                                                                "setSvmVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.SVM_deployment_spec",
                                                            fields,
                                                            com.vmware.nsx.model.SVMDeploymentSpec.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

