/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * ServiceDeployment Spec consists of information required to deploy and configure
 * the partner appliances. viz. Deployment template, deployment spec and NIC
 * metatdata.
 */
public final class ServiceDeploymentSpec implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<com.vmware.nsx.model.SVMDeploymentSpec> deploymentSpecs;

    private java.util.List<com.vmware.nsx.model.DeploymentTemplate> deploymentTemplate;

    private java.util.List<com.vmware.nsx.model.NicMetadata> nicMetadataList;

    private java.lang.String svmVersion;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ServiceDeploymentSpec() {
    }

    protected ServiceDeploymentSpec(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Deployment Specs holds information required to deploy the Service-VMs. i.e. OVF
     * url where the partner Service-VM OVF is hosted. The host type on which the OVF
     * can be deployed, Form factor to name a few.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.SVMDeploymentSpec> getDeploymentSpecs() {
        return this.deploymentSpecs;
    }

    /**
     * Deployment Specs holds information required to deploy the Service-VMs. i.e. OVF
     * url where the partner Service-VM OVF is hosted. The host type on which the OVF
     * can be deployed, Form factor to name a few.
     *
     * @param deploymentSpecs New value for the property.
     */
    public void setDeploymentSpecs(java.util.List<com.vmware.nsx.model.SVMDeploymentSpec> deploymentSpecs) {
        this.deploymentSpecs = deploymentSpecs;
    }

    /**
     * Deployment Template holds the attributes specific to partner for which the
     * service is created. These attributes are opaque to NSX Manager.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.DeploymentTemplate> getDeploymentTemplate() {
        return this.deploymentTemplate;
    }

    /**
     * Deployment Template holds the attributes specific to partner for which the
     * service is created. These attributes are opaque to NSX Manager.
     *
     * @param deploymentTemplate New value for the property.
     */
    public void setDeploymentTemplate(java.util.List<com.vmware.nsx.model.DeploymentTemplate> deploymentTemplate) {
        this.deploymentTemplate = deploymentTemplate;
    }

    /**
     * NIC metadata associated with the deployment spec.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.NicMetadata> getNicMetadataList() {
        return this.nicMetadataList;
    }

    /**
     * NIC metadata associated with the deployment spec.
     *
     * @param nicMetadataList New value for the property.
     */
    public void setNicMetadataList(java.util.List<com.vmware.nsx.model.NicMetadata> nicMetadataList) {
        this.nicMetadataList = nicMetadataList;
    }

    /**
     * Partner needs to specify the Service VM version which will get deployed.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSvmVersion() {
        return this.svmVersion;
    }

    /**
     * Partner needs to specify the Service VM version which will get deployed.
     *
     * @param svmVersion New value for the property.
     */
    public void setSvmVersion(java.lang.String svmVersion) {
        this.svmVersion = svmVersion;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.serviceDeploymentSpec;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("deployment_specs",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.deploymentSpecs, this._getType().getField("deployment_specs")));
        structValue.setField("deployment_template",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.deploymentTemplate, this._getType().getField("deployment_template")));
        structValue.setField("nic_metadata_list",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nicMetadataList, this._getType().getField("nic_metadata_list")));
        structValue.setField("svm_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.svmVersion, this._getType().getField("svm_version")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.serviceDeploymentSpec;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.serviceDeploymentSpec.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ServiceDeploymentSpec _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ServiceDeploymentSpec(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ServiceDeploymentSpec _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ServiceDeploymentSpec(structValue);
    }

    /**
     * Builder class for {@link ServiceDeploymentSpec}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.SVMDeploymentSpec> deploymentSpecs;
        private java.util.List<com.vmware.nsx.model.DeploymentTemplate> deploymentTemplate;
        private java.util.List<com.vmware.nsx.model.NicMetadata> nicMetadataList;
        private java.lang.String svmVersion;

        /**
         * Constructor with parameters for the required properties of
         * {@link ServiceDeploymentSpec}.
         */
        public Builder() {
        }

        /**
         * Deployment Specs holds information required to deploy the Service-VMs. i.e. OVF
         * url where the partner Service-VM OVF is hosted. The host type on which the OVF
         * can be deployed, Form factor to name a few.
         *
         * @param deploymentSpecs New value for the property.
         */
        public Builder setDeploymentSpecs(java.util.List<com.vmware.nsx.model.SVMDeploymentSpec> deploymentSpecs) {
            this.deploymentSpecs = deploymentSpecs;
            return this;
        }

        /**
         * Deployment Template holds the attributes specific to partner for which the
         * service is created. These attributes are opaque to NSX Manager.
         *
         * @param deploymentTemplate New value for the property.
         */
        public Builder setDeploymentTemplate(java.util.List<com.vmware.nsx.model.DeploymentTemplate> deploymentTemplate) {
            this.deploymentTemplate = deploymentTemplate;
            return this;
        }

        /**
         * NIC metadata associated with the deployment spec.
         *
         * @param nicMetadataList New value for the property.
         */
        public Builder setNicMetadataList(java.util.List<com.vmware.nsx.model.NicMetadata> nicMetadataList) {
            this.nicMetadataList = nicMetadataList;
            return this;
        }

        /**
         * Partner needs to specify the Service VM version which will get deployed.
         *
         * @param svmVersion New value for the property.
         */
        public Builder setSvmVersion(java.lang.String svmVersion) {
            this.svmVersion = svmVersion;
            return this;
        }

        public ServiceDeploymentSpec build() {
            ServiceDeploymentSpec result = new ServiceDeploymentSpec();
            result.setDeploymentSpecs(this.deploymentSpecs);
            result.setDeploymentTemplate(this.deploymentTemplate);
            result.setNicMetadataList(this.nicMetadataList);
            result.setSvmVersion(this.svmVersion);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("deployment_specs", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.SVMDeploymentSpec; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("deployment_specs",
                                                                                "deploymentSpecs",
                                                                                "getDeploymentSpecs",
                                                                                "setDeploymentSpecs");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("deployment_template", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.deploymentTemplate; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("deployment_template",
                                                                                "deploymentTemplate",
                                                                                "getDeploymentTemplate",
                                                                                "setDeploymentTemplate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nic_metadata_list", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.nicMetadata; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nic_metadata_list",
                                                                                "nicMetadataList",
                                                                                "getNicMetadataList",
                                                                                "setNicMetadataList");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("svm_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("svm_version",
                                                                                "svmVersion",
                                                                                "getSvmVersion",
                                                                                "setSvmVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.service_deployment_spec",
                                                            fields,
                                                            com.vmware.nsx.model.ServiceDeploymentSpec.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

