/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * This object contains list of SNMP v2c communities used to poll NSX nodes over
 * SNMP and list of SNMP v2c targets used to receive SNMP traps/notifications from
 * NSX nodes.
 */
public final class Snmpv2cProperties implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<com.vmware.nsx.model.Snmpv2cCommunity> communities;

    private java.util.List<com.vmware.nsx.model.Snmpv2cTarget> targets;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public Snmpv2cProperties() {
    }

    protected Snmpv2cProperties(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * List of SNMP v2c communities allowed to poll NSX nodes over SNMP v2c.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Snmpv2cCommunity> getCommunities() {
        return this.communities;
    }

    /**
     * List of SNMP v2c communities allowed to poll NSX nodes over SNMP v2c.
     *
     * @param communities New value for the property.
     */
    public void setCommunities(java.util.List<com.vmware.nsx.model.Snmpv2cCommunity> communities) {
        this.communities = communities;
    }

    /**
     * List of SNMP v2c targets/receivers where SNMP v2c traps/notifications will be
     * sent from NSX nodes.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Snmpv2cTarget> getTargets() {
        return this.targets;
    }

    /**
     * List of SNMP v2c targets/receivers where SNMP v2c traps/notifications will be
     * sent from NSX nodes.
     *
     * @param targets New value for the property.
     */
    public void setTargets(java.util.List<com.vmware.nsx.model.Snmpv2cTarget> targets) {
        this.targets = targets;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.snmpv2cProperties;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("communities",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.communities, this._getType().getField("communities")));
        structValue.setField("targets",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.targets, this._getType().getField("targets")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.snmpv2cProperties;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.snmpv2cProperties.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static Snmpv2cProperties _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new Snmpv2cProperties(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static Snmpv2cProperties _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new Snmpv2cProperties(structValue);
    }

    /**
     * Builder class for {@link Snmpv2cProperties}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.Snmpv2cCommunity> communities;
        private java.util.List<com.vmware.nsx.model.Snmpv2cTarget> targets;

        /**
         * Constructor with parameters for the required properties of
         * {@link Snmpv2cProperties}.
         */
        public Builder() {
        }

        /**
         * List of SNMP v2c communities allowed to poll NSX nodes over SNMP v2c.
         *
         * @param communities New value for the property.
         */
        public Builder setCommunities(java.util.List<com.vmware.nsx.model.Snmpv2cCommunity> communities) {
            this.communities = communities;
            return this;
        }

        /**
         * List of SNMP v2c targets/receivers where SNMP v2c traps/notifications will be
         * sent from NSX nodes.
         *
         * @param targets New value for the property.
         */
        public Builder setTargets(java.util.List<com.vmware.nsx.model.Snmpv2cTarget> targets) {
            this.targets = targets;
            return this;
        }

        public Snmpv2cProperties build() {
            Snmpv2cProperties result = new Snmpv2cProperties();
            result.setCommunities(this.communities);
            result.setTargets(this.targets);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("communities", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.snmpv2cCommunity; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("communities",
                                                                                "communities",
                                                                                "getCommunities",
                                                                                "setCommunities");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("targets", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.snmpv2cTarget; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("targets",
                                                                                "targets",
                                                                                "getTargets",
                                                                                "setTargets");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.snmpv2c_properties",
                                                            fields,
                                                            com.vmware.nsx.model.Snmpv2cProperties.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

