/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * This object contains properties for a SNMP v3 user that can be used to receive
 * SNMP traps/notifications from NSX and/or poll NSX nodes over SNMP.
 */
public final class Snmpv3User implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ACCESS_ONLY = "READ_ONLY";

    public static final java.lang.String SECURITY_LEVEL_PRIV = "AUTH_PRIV";

    private java.lang.String access;

    private java.lang.String authPassword;

    private java.lang.String privPassword;

    private java.lang.String securityLevel;

    private java.lang.String userId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public Snmpv3User() {
    }

    protected Snmpv3User(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.Snmpv3User#ACCESS_ONLY}</li> </ul> Access permissions for
     * polling NSX nodes over SNMP v3.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAccess() {
        return this.access;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.Snmpv3User#ACCESS_ONLY}</li> </ul> Access permissions for
     * polling NSX nodes over SNMP v3.
     *
     * @param access New value for the property.
     */
    public void setAccess(java.lang.String access) {
        this.access = access;
    }

    /**
     * Authentication password used for SNMP v3 communication. This field is required
     * when adding a user. When updating a user, do not include this field in the
     * request. If this field is present in an update request, it will be considered as
     * a new value for authentication password.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAuthPassword() {
        return this.authPassword;
    }

    /**
     * Authentication password used for SNMP v3 communication. This field is required
     * when adding a user. When updating a user, do not include this field in the
     * request. If this field is present in an update request, it will be considered as
     * a new value for authentication password.
     *
     * @param authPassword New value for the property.
     */
    public void setAuthPassword(java.lang.String authPassword) {
        this.authPassword = authPassword;
    }

    /**
     * Privacy password used for SNMP v3 communication. This field is required when
     * adding a user. When updating a user, do not include this field in the request.
     * If this field is present in an update request, it will be considered as a new
     * value for privacy password.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPrivPassword() {
        return this.privPassword;
    }

    /**
     * Privacy password used for SNMP v3 communication. This field is required when
     * adding a user. When updating a user, do not include this field in the request.
     * If this field is present in an update request, it will be considered as a new
     * value for privacy password.
     *
     * @param privPassword New value for the property.
     */
    public void setPrivPassword(java.lang.String privPassword) {
        this.privPassword = privPassword;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.Snmpv3User#SECURITY_LEVEL_PRIV}</li> </ul> Security level
     * indicates whether SNMP communication involves authentication and privacy
     * protocols for this user. Value \"AUTH_PRIV\" indicates both authentication and
     * privacy protocols will be used for SNMP communication.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSecurityLevel() {
        return this.securityLevel;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.Snmpv3User#SECURITY_LEVEL_PRIV}</li> </ul> Security level
     * indicates whether SNMP communication involves authentication and privacy
     * protocols for this user. Value \"AUTH_PRIV\" indicates both authentication and
     * privacy protocols will be used for SNMP communication.
     *
     * @param securityLevel New value for the property.
     */
    public void setSecurityLevel(java.lang.String securityLevel) {
        this.securityLevel = securityLevel;
    }

    /**
     * Unique SNMP v3 user id.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUserId() {
        return this.userId;
    }

    /**
     * Unique SNMP v3 user id.
     *
     * @param userId New value for the property.
     */
    public void setUserId(java.lang.String userId) {
        this.userId = userId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.snmpv3User;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("access",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.access, this._getType().getField("access")));
        structValue.setField("auth_password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.authPassword, this._getType().getField("auth_password")));
        structValue.setField("priv_password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.privPassword, this._getType().getField("priv_password")));
        structValue.setField("security_level",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.securityLevel, this._getType().getField("security_level")));
        structValue.setField("user_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userId, this._getType().getField("user_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.snmpv3User;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.snmpv3User.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static Snmpv3User _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new Snmpv3User(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static Snmpv3User _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new Snmpv3User(structValue);
    }

    /**
     * Builder class for {@link Snmpv3User}.
     */
    public static final class Builder {
        private java.lang.String access;
        private java.lang.String authPassword;
        private java.lang.String privPassword;
        private java.lang.String securityLevel;
        private java.lang.String userId;

        /**
         * Constructor with parameters for the required properties of
         * {@link Snmpv3User}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.Snmpv3User#ACCESS_ONLY}</li> </ul> Access permissions for
         * polling NSX nodes over SNMP v3.
         *
         * @param access New value for the property.
         */
        public Builder setAccess(java.lang.String access) {
            this.access = access;
            return this;
        }

        /**
         * Authentication password used for SNMP v3 communication. This field is required
         * when adding a user. When updating a user, do not include this field in the
         * request. If this field is present in an update request, it will be considered as
         * a new value for authentication password.
         *
         * @param authPassword New value for the property.
         */
        public Builder setAuthPassword(java.lang.String authPassword) {
            this.authPassword = authPassword;
            return this;
        }

        /**
         * Privacy password used for SNMP v3 communication. This field is required when
         * adding a user. When updating a user, do not include this field in the request.
         * If this field is present in an update request, it will be considered as a new
         * value for privacy password.
         *
         * @param privPassword New value for the property.
         */
        public Builder setPrivPassword(java.lang.String privPassword) {
            this.privPassword = privPassword;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.Snmpv3User#SECURITY_LEVEL_PRIV}</li> </ul> Security level
         * indicates whether SNMP communication involves authentication and privacy
         * protocols for this user. Value \"AUTH_PRIV\" indicates both authentication and
         * privacy protocols will be used for SNMP communication.
         *
         * @param securityLevel New value for the property.
         */
        public Builder setSecurityLevel(java.lang.String securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        /**
         * Unique SNMP v3 user id.
         *
         * @param userId New value for the property.
         */
        public Builder setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
        }

        public Snmpv3User build() {
            Snmpv3User result = new Snmpv3User();
            result.setAccess(this.access);
            result.setAuthPassword(this.authPassword);
            result.setPrivPassword(this.privPassword);
            result.setSecurityLevel(this.securityLevel);
            result.setUserId(this.userId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("access", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("access",
                                                                                "access",
                                                                                "getAccess",
                                                                                "setAccess");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("auth_password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("auth_password",
                                                                                "authPassword",
                                                                                "getAuthPassword",
                                                                                "setAuthPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("priv_password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("priv_password",
                                                                                "privPassword",
                                                                                "getPrivPassword",
                                                                                "setPrivPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("security_level", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("security_level",
                                                                                "securityLevel",
                                                                                "getSecurityLevel",
                                                                                "setSecurityLevel");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_id",
                                                                                "userId",
                                                                                "getUserId",
                                                                                "setUserId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.snmpv3_user",
                                                            fields,
                                                            com.vmware.nsx.model.Snmpv3User.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

