/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Service insertion data path inserts unique 'source node id' value into each
 * packet before it received by Service VM. This value can be resolved to multiple
 * Source Entities. It represents source of the packets.
 */
public final class SourceEntity implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String SOURCE_ENTITY_TYPE_NETWORK_INTERFACE = "VIRTUAL_NETWORK_INTERFACE";

    public static final java.lang.String SOURCE_ENTITY_TYPE_MACHINE = "VIRTUAL_MACHINE";

    private java.lang.String sourceEntityId;

    private java.lang.String sourceEntityType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SourceEntity() {
    }

    protected SourceEntity(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * UUID of Source entity
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSourceEntityId() {
        return this.sourceEntityId;
    }

    /**
     * UUID of Source entity
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sourceEntityId New value for the property.
     */
    public void setSourceEntityId(java.lang.String sourceEntityId) {
        this.sourceEntityId = sourceEntityId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SourceEntity#SOURCE_ENTITY_TYPE_NETWORK_INTERFACE}</li>
     * <li> {@link com.vmware.nsx.model.SourceEntity#SOURCE_ENTITY_TYPE_MACHINE}</li>
     * </ul> Type of source entity. Currently source value can be resolved to VIF and
     * Virtual Machine.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSourceEntityType() {
        return this.sourceEntityType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.SourceEntity#SOURCE_ENTITY_TYPE_NETWORK_INTERFACE}</li>
     * <li> {@link com.vmware.nsx.model.SourceEntity#SOURCE_ENTITY_TYPE_MACHINE}</li>
     * </ul> Type of source entity. Currently source value can be resolved to VIF and
     * Virtual Machine.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param sourceEntityType New value for the property.
     */
    public void setSourceEntityType(java.lang.String sourceEntityType) {
        this.sourceEntityType = sourceEntityType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.sourceEntity;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("source_entity_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourceEntityId, this._getType().getField("source_entity_id")));
        structValue.setField("source_entity_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sourceEntityType, this._getType().getField("source_entity_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.sourceEntity;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.sourceEntity.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SourceEntity _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SourceEntity(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SourceEntity _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SourceEntity(structValue);
    }

    /**
     * Builder class for {@link SourceEntity}.
     */
    public static final class Builder {
        private java.lang.String sourceEntityId;
        private java.lang.String sourceEntityType;

        /**
         * Constructor with parameters for the required properties of
         * {@link SourceEntity}.
         */
        public Builder() {
        }

        /**
         * UUID of Source entity
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sourceEntityId New value for the property.
         */
        public Builder setSourceEntityId(java.lang.String sourceEntityId) {
            this.sourceEntityId = sourceEntityId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.SourceEntity#SOURCE_ENTITY_TYPE_NETWORK_INTERFACE}</li>
         * <li> {@link com.vmware.nsx.model.SourceEntity#SOURCE_ENTITY_TYPE_MACHINE}</li>
         * </ul> Type of source entity. Currently source value can be resolved to VIF and
         * Virtual Machine.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param sourceEntityType New value for the property.
         */
        public Builder setSourceEntityType(java.lang.String sourceEntityType) {
            this.sourceEntityType = sourceEntityType;
            return this;
        }

        public SourceEntity build() {
            SourceEntity result = new SourceEntity();
            result.setSourceEntityId(this.sourceEntityId);
            result.setSourceEntityType(this.sourceEntityType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("source_entity_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_entity_id",
                                                                                "sourceEntityId",
                                                                                "getSourceEntityId",
                                                                                "setSourceEntityId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source_entity_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source_entity_type",
                                                                                "sourceEntityType",
                                                                                "getSourceEntityType",
                                                                                "setSourceEntityType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.source_entity",
                                                            fields,
                                                            com.vmware.nsx.model.SourceEntity.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

