/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Standard host switch specification
 */
public final class StandardHostSwitch implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String HOST_SWITCH_MODE_STANDARD = "STANDARD";

    public static final java.lang.String HOST_SWITCH_MODE_ENS = "ENS";

    public static final java.lang.String HOST_SWITCH_MODE_ENS_INTERRUPT = "ENS_INTERRUPT";

    public static final java.lang.String HOST_SWITCH_MODE_LEGACY = "LEGACY";

    public static final java.lang.String HOST_SWITCH_TYPE_NVDS = "NVDS";

    public static final java.lang.String HOST_SWITCH_TYPE_VDS = "VDS";

    private java.util.List<com.vmware.nsx.model.CpuCoreConfigForEnhancedNetworkingStackSwitch> cpuConfig;

    private java.lang.String hostSwitchId;

    private java.lang.String hostSwitchMode;

    private java.lang.String hostSwitchName;

    private java.util.List<com.vmware.nsx.model.HostSwitchProfileTypeIdEntry> hostSwitchProfileIds;

    private java.lang.String hostSwitchType;

    private com.vmware.vapi.bindings.Structure ipAssignmentSpec;

    private com.vmware.vapi.bindings.Structure ipv6AssignmentSpec;

    private java.lang.Boolean isMigratePnics;

    private java.util.List<com.vmware.nsx.model.Pnic> pnics;

    private java.util.List<com.vmware.nsx.model.Pnic> pnicsUninstallMigration;

    private java.lang.String portgroupTransportZoneId;

    private java.util.List<com.vmware.nsx.model.TransportNodeProfileSubConfig> transportNodeProfileSubConfigs;

    private java.util.List<com.vmware.nsx.model.TransportZoneEndPoint> transportZoneEndpoints;

    private java.util.List<com.vmware.nsx.model.VdsUplink> uplinks;

    private java.util.List<com.vmware.nsx.model.VmknicNetwork> vmkInstallMigration;

    private java.util.List<com.vmware.nsx.model.VmknicNetwork> vmkUninstallMigration;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public StandardHostSwitch() {
    }

    protected StandardHostSwitch(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * CPU configuration specifies number of Logical cpu cores (Lcores) per Non Uniform
     * Memory Access (NUMA) node dedicated to Enhanced Networking Stack enabled
     * HostSwitch to get the best performance.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.CpuCoreConfigForEnhancedNetworkingStackSwitch> getCpuConfig() {
        return this.cpuConfig;
    }

    /**
     * CPU configuration specifies number of Logical cpu cores (Lcores) per Non Uniform
     * Memory Access (NUMA) node dedicated to Enhanced Networking Stack enabled
     * HostSwitch to get the best performance.
     *
     * @param cpuConfig New value for the property.
     */
    public void setCpuConfig(java.util.List<com.vmware.nsx.model.CpuCoreConfigForEnhancedNetworkingStackSwitch> cpuConfig) {
        this.cpuConfig = cpuConfig;
    }

    /**
     * This field is writable only in case of VDS type HostSwitch and system generated
     * for NVDS type. For VDS type host switch, This field is used to lookup a VDS from
     * corresponding Compute Manager and then can be configured for logical networking.
     * For NVDS type host switch, This field is system generated and if provided will
     * be overwritten.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostSwitchId() {
        return this.hostSwitchId;
    }

    /**
     * This field is writable only in case of VDS type HostSwitch and system generated
     * for NVDS type. For VDS type host switch, This field is used to lookup a VDS from
     * corresponding Compute Manager and then can be configured for logical networking.
     * For NVDS type host switch, This field is system generated and if provided will
     * be overwritten.
     *
     * @param hostSwitchId New value for the property.
     */
    public void setHostSwitchId(java.lang.String hostSwitchId) {
        this.hostSwitchId = hostSwitchId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_STANDARD}</li> <li>
     * {@link com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_ENS}</li> <li>
     * {@link
     * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_ENS_INTERRUPT}</li>
     * <li> {@link
     * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_LEGACY}</li> </ul>
     * STANDARD - This mode applies to all transport nodes. The realized host switch
     * mode will be chosen automatically (best applicable as per uplink capabilities)
     * by the data-plane in the transport node and may change in future. ENS - This is
     * the Enhanced Data Path switch mode for ESX host tranport node. This mode
     * provides accelerated networking performances but also introduces additional
     * prerequisites. In order to benefit from this mode, workloads will be need to be
     * compiled with DPDK and will use VMXNET3 for their vNIC. This mode is only
     * available on ESX hypervisor (6.7 and above, recommended 6.7 U2 and above) and
     * unavailable on KVM, EDGE and Public Cloud Gateway. Not all NSX features are
     * available in this mode, please consult the documentation. ENS_INTERRUPT - This
     * is an interrupt driven variant of the Enhanced Data Path mode. Please, consult
     * your account representative for applicability. This mode is available only on
     * ESX hypervisor (7.0 and above). LEGACY - This mode applies to all transport
     * nodes. This mode was formerly called as STANDARD and is realized as pktHandle.
     * IMPORTANT: ENS and ENS_INTERRUPT modes require a higher tier of NSX licenses.
     * ENS and ENS_INTERRUPT with classic Nic - NSX advanced or higher ENS with
     * SmartNic : NSX Enterprise Plus or higher. Please consult NSX documentation for
     * complete details.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostSwitchMode() {
        return this.hostSwitchMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_STANDARD}</li> <li>
     * {@link com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_ENS}</li> <li>
     * {@link
     * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_ENS_INTERRUPT}</li>
     * <li> {@link
     * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_LEGACY}</li> </ul>
     * STANDARD - This mode applies to all transport nodes. The realized host switch
     * mode will be chosen automatically (best applicable as per uplink capabilities)
     * by the data-plane in the transport node and may change in future. ENS - This is
     * the Enhanced Data Path switch mode for ESX host tranport node. This mode
     * provides accelerated networking performances but also introduces additional
     * prerequisites. In order to benefit from this mode, workloads will be need to be
     * compiled with DPDK and will use VMXNET3 for their vNIC. This mode is only
     * available on ESX hypervisor (6.7 and above, recommended 6.7 U2 and above) and
     * unavailable on KVM, EDGE and Public Cloud Gateway. Not all NSX features are
     * available in this mode, please consult the documentation. ENS_INTERRUPT - This
     * is an interrupt driven variant of the Enhanced Data Path mode. Please, consult
     * your account representative for applicability. This mode is available only on
     * ESX hypervisor (7.0 and above). LEGACY - This mode applies to all transport
     * nodes. This mode was formerly called as STANDARD and is realized as pktHandle.
     * IMPORTANT: ENS and ENS_INTERRUPT modes require a higher tier of NSX licenses.
     * ENS and ENS_INTERRUPT with classic Nic - NSX advanced or higher ENS with
     * SmartNic : NSX Enterprise Plus or higher. Please consult NSX documentation for
     * complete details.
     *
     * @param hostSwitchMode New value for the property.
     */
    public void setHostSwitchMode(java.lang.String hostSwitchMode) {
        this.hostSwitchMode = hostSwitchMode;
    }

    /**
     * This field is writable only in case of NVDS type HostSwitch and system generated
     * for VDS type. For NVDS type host switch, If this name is unset or empty then the
     * default host switch name will be used. The name must be unique among all host
     * switches specified in a given transport node; unset name, empty name and the
     * default host switch name are considered the same in terms of uniqueness. For VDS
     * type host switch, Manager fetches VDS name from corresponding Compute Manager
     * and populates this field. If VDS name is given (correct or incorrect) it is
     * ignored and overwritten with correct one.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getHostSwitchName() {
        return this.hostSwitchName;
    }

    /**
     * This field is writable only in case of NVDS type HostSwitch and system generated
     * for VDS type. For NVDS type host switch, If this name is unset or empty then the
     * default host switch name will be used. The name must be unique among all host
     * switches specified in a given transport node; unset name, empty name and the
     * default host switch name are considered the same in terms of uniqueness. For VDS
     * type host switch, Manager fetches VDS name from corresponding Compute Manager
     * and populates this field. If VDS name is given (correct or incorrect) it is
     * ignored and overwritten with correct one.
     *
     * @param hostSwitchName New value for the property.
     */
    @Deprecated
    public void setHostSwitchName(java.lang.String hostSwitchName) {
        this.hostSwitchName = hostSwitchName;
    }

    /**
     * Host switch profiles bound to this host switch. If a profile ID is not provided
     * for any HostSwitchProfileType that is supported by the transport node, the
     * corresponding default profile will be bound to the host switch. If transport
     * node is created using Policy APIs, use policyPaths instead of UUIDs.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.HostSwitchProfileTypeIdEntry> getHostSwitchProfileIds() {
        return this.hostSwitchProfileIds;
    }

    /**
     * Host switch profiles bound to this host switch. If a profile ID is not provided
     * for any HostSwitchProfileType that is supported by the transport node, the
     * corresponding default profile will be bound to the host switch. If transport
     * node is created using Policy APIs, use policyPaths instead of UUIDs.
     *
     * @param hostSwitchProfileIds New value for the property.
     */
    public void setHostSwitchProfileIds(java.util.List<com.vmware.nsx.model.HostSwitchProfileTypeIdEntry> hostSwitchProfileIds) {
        this.hostSwitchProfileIds = hostSwitchProfileIds;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_TYPE_NVDS}</li> <li> {@link
     * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_TYPE_VDS}</li> </ul> VDS
     * represents VMware vSphere Distributed Switch from vSphere that is used as
     * HostSwitch through TransportNode or TransportNodeProfile configuration. When VDS
     * is used as a HostSwitch, Hosts have to be added to VDS from vSphere and VDS
     * instance is created on Hosts. To configure NSX on such hosts, you can use this
     * VDS as a HostSwitch from NSX manager. vCenter has the ownership of MTU, LAG,
     * NIOC and LLDP configuration of such VDS backed HostSwitch. Remaining
     * configuration (e.g. UplinkHostswitchProfile) will be managed by NSX. NVDS
     * represents NSX Virtual Switch which is NSX native HostSwitch. All configurations
     * of NVDS will be managed by NSX. HostSwitch of type NVDS has been deprecated on
     * ESX hosts that are managed by a vCenter Server.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostSwitchType() {
        return this.hostSwitchType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_TYPE_NVDS}</li> <li> {@link
     * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_TYPE_VDS}</li> </ul> VDS
     * represents VMware vSphere Distributed Switch from vSphere that is used as
     * HostSwitch through TransportNode or TransportNodeProfile configuration. When VDS
     * is used as a HostSwitch, Hosts have to be added to VDS from vSphere and VDS
     * instance is created on Hosts. To configure NSX on such hosts, you can use this
     * VDS as a HostSwitch from NSX manager. vCenter has the ownership of MTU, LAG,
     * NIOC and LLDP configuration of such VDS backed HostSwitch. Remaining
     * configuration (e.g. UplinkHostswitchProfile) will be managed by NSX. NVDS
     * represents NSX Virtual Switch which is NSX native HostSwitch. All configurations
     * of NVDS will be managed by NSX. HostSwitch of type NVDS has been deprecated on
     * ESX hosts that are managed by a vCenter Server.
     *
     * @param hostSwitchType New value for the property.
     */
    public void setHostSwitchType(java.lang.String hostSwitchType) {
        this.hostSwitchType = hostSwitchType;
    }

    /**
     *
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.IpAssignmentSpec}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.IpAssignmentSpec}.
     */
    public com.vmware.vapi.bindings.Structure getIpAssignmentSpec() {
        return this.ipAssignmentSpec;
    }

    /**
     *
     *
     * @param ipAssignmentSpec New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.IpAssignmentSpec}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.IpAssignmentSpec}.
     */
    public void setIpAssignmentSpec(com.vmware.vapi.bindings.Structure ipAssignmentSpec) {
        this.ipAssignmentSpec = ipAssignmentSpec;
    }

    /**
     *
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.Ipv6AssignmentSpec}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.Ipv6AssignmentSpec}.
     */
    public com.vmware.vapi.bindings.Structure getIpv6AssignmentSpec() {
        return this.ipv6AssignmentSpec;
    }

    /**
     *
     *
     * @param ipv6AssignmentSpec New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.Ipv6AssignmentSpec}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.Ipv6AssignmentSpec}.
     */
    public void setIpv6AssignmentSpec(com.vmware.vapi.bindings.Structure ipv6AssignmentSpec) {
        this.ipv6AssignmentSpec = ipv6AssignmentSpec;
    }

    /**
     * When using the Quick Start workflow on 7.0 and above vCenter clusters, if the
     * pnics specified in the pnics field are used by a single VSS HostSwitch, then
     * they are migrated over to recommended VDS HostSwitch. If any two pnics are not
     * used by the same VSS HostSwitch or VDS HostSwitch, it is not supported. In such
     * cases, please migrate them in multiple steps, one VSS HostSwitch or VDS
     * HostSwitch at a time.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsMigratePnics() {
        return this.isMigratePnics;
    }

    /**
     * When using the Quick Start workflow on 7.0 and above vCenter clusters, if the
     * pnics specified in the pnics field are used by a single VSS HostSwitch, then
     * they are migrated over to recommended VDS HostSwitch. If any two pnics are not
     * used by the same VSS HostSwitch or VDS HostSwitch, it is not supported. In such
     * cases, please migrate them in multiple steps, one VSS HostSwitch or VDS
     * HostSwitch at a time.
     *
     * @param isMigratePnics New value for the property.
     */
    public void setIsMigratePnics(java.lang.Boolean isMigratePnics) {
        this.isMigratePnics = isMigratePnics;
    }

    /**
     * When using the Quick Start workflow on 7.0 and above vCenter clusters, pnic
     * information will be populated by the recommendation engine when providing a VDS
     * HostSwitch based recommendation for a VSS HostSwitch.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Pnic> getPnics() {
        return this.pnics;
    }

    /**
     * When using the Quick Start workflow on 7.0 and above vCenter clusters, pnic
     * information will be populated by the recommendation engine when providing a VDS
     * HostSwitch based recommendation for a VSS HostSwitch.
     *
     * @param pnics New value for the property.
     */
    public void setPnics(java.util.List<com.vmware.nsx.model.Pnic> pnics) {
        this.pnics = pnics;
    }

    /**
     * This is only supported for NVDS type of host switch. If this is specified for
     * VDS type of host switch, an error will be returned to user. The pnics to be
     * migrated out to a non N-VDS switch during transport node deletion.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.Pnic> getPnicsUninstallMigration() {
        return this.pnicsUninstallMigration;
    }

    /**
     * This is only supported for NVDS type of host switch. If this is specified for
     * VDS type of host switch, an error will be returned to user. The pnics to be
     * migrated out to a non N-VDS switch during transport node deletion.
     *
     * @param pnicsUninstallMigration New value for the property.
     */
    @Deprecated
    public void setPnicsUninstallMigration(java.util.List<com.vmware.nsx.model.Pnic> pnicsUninstallMigration) {
        this.pnicsUninstallMigration = pnicsUninstallMigration;
    }

    /**
     * A transport zone will be created for each DVS found across all hosts in a
     * cluster that is installed for NSX on DVPG. This field, populated by NSX, is the
     * ID of the transport zone created for the DVS this host switch represents. All
     * discovered segments created for the DVPGs found on the DVS will have this ID
     * specified as the transport zone id.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPortgroupTransportZoneId() {
        return this.portgroupTransportZoneId;
    }

    /**
     * A transport zone will be created for each DVS found across all hosts in a
     * cluster that is installed for NSX on DVPG. This field, populated by NSX, is the
     * ID of the transport zone created for the DVS this host switch represents. All
     * discovered segments created for the DVPGs found on the DVS will have this ID
     * specified as the transport zone id.
     *
     * @param portgroupTransportZoneId New value for the property.
     */
    public void setPortgroupTransportZoneId(java.lang.String portgroupTransportZoneId) {
        this.portgroupTransportZoneId = portgroupTransportZoneId;
    }

    /**
     * This field is supported only for Tranport Node Profile Configurations. This
     * field is used for adding a subset of the host switch configuration under a
     * Transport Node Profile. This field is applicable only for a VDS based host
     * switch and not for an NVDS based host switch.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.TransportNodeProfileSubConfig> getTransportNodeProfileSubConfigs() {
        return this.transportNodeProfileSubConfigs;
    }

    /**
     * This field is supported only for Tranport Node Profile Configurations. This
     * field is used for adding a subset of the host switch configuration under a
     * Transport Node Profile. This field is applicable only for a VDS based host
     * switch and not for an NVDS based host switch.
     *
     * @param transportNodeProfileSubConfigs New value for the property.
     */
    public void setTransportNodeProfileSubConfigs(java.util.List<com.vmware.nsx.model.TransportNodeProfileSubConfig> transportNodeProfileSubConfigs) {
        this.transportNodeProfileSubConfigs = transportNodeProfileSubConfigs;
    }

    /**
     * List of TransportZones that are to be associated with specified host switch. If
     * this property is specified, host_switch_mode at StandardHostSwitch level must be
     * specified.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.TransportZoneEndPoint> getTransportZoneEndpoints() {
        return this.transportZoneEndpoints;
    }

    /**
     * List of TransportZones that are to be associated with specified host switch. If
     * this property is specified, host_switch_mode at StandardHostSwitch level must be
     * specified.
     *
     * @param transportZoneEndpoints New value for the property.
     */
    public void setTransportZoneEndpoints(java.util.List<com.vmware.nsx.model.TransportZoneEndPoint> transportZoneEndpoints) {
        this.transportZoneEndpoints = transportZoneEndpoints;
    }

    /**
     * If VDS is used as a HostSwitch this attribute must be specified. You can
     * associate uplinks from UplinkHostSwitchProfile to either VDS uplink or LAG. VDS
     * uplink or LAG will inherit the global VDS level teaming policy from vSphere. NSX
     * managed uplink or LAG will have NSX teaming policy configured through
     * UplinkHostSwitchProfile.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.VdsUplink> getUplinks() {
        return this.uplinks;
    }

    /**
     * If VDS is used as a HostSwitch this attribute must be specified. You can
     * associate uplinks from UplinkHostSwitchProfile to either VDS uplink or LAG. VDS
     * uplink or LAG will inherit the global VDS level teaming policy from vSphere. NSX
     * managed uplink or LAG will have NSX teaming policy configured through
     * UplinkHostSwitchProfile.
     *
     * @param uplinks New value for the property.
     */
    public void setUplinks(java.util.List<com.vmware.nsx.model.VdsUplink> uplinks) {
        this.uplinks = uplinks;
    }

    /**
     * When using the Quick Start workflow on 7.0 and above vCenter clusters,
     * vmnk_install_migration will be populated by the recommendation engine when
     * providing a VDS HostSwitch based recommendation for a VSS HostSwitch. It will
     * contain The vmk interfaces and the associated logical switches on the
     * HostSwitch. The state of this field is realized on the transport node during
     * creation
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.VmknicNetwork> getVmkInstallMigration() {
        return this.vmkInstallMigration;
    }

    /**
     * When using the Quick Start workflow on 7.0 and above vCenter clusters,
     * vmnk_install_migration will be populated by the recommendation engine when
     * providing a VDS HostSwitch based recommendation for a VSS HostSwitch. It will
     * contain The vmk interfaces and the associated logical switches on the
     * HostSwitch. The state of this field is realized on the transport node during
     * creation
     *
     * @param vmkInstallMigration New value for the property.
     */
    public void setVmkInstallMigration(java.util.List<com.vmware.nsx.model.VmknicNetwork> vmkInstallMigration) {
        this.vmkInstallMigration = vmkInstallMigration;
    }

    /**
     * This is only supported for NVDS type of host switch. If this is specified for
     * VDS type of host switch, an error will be returned to user. The vmk interfaces
     * and the associated portgroups on the VSS/DVS. This field is realized on the host
     * during transport node deletion or NSX uninstallation to specify the destination
     * for all vmks on N-VDS switches.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.VmknicNetwork> getVmkUninstallMigration() {
        return this.vmkUninstallMigration;
    }

    /**
     * This is only supported for NVDS type of host switch. If this is specified for
     * VDS type of host switch, an error will be returned to user. The vmk interfaces
     * and the associated portgroups on the VSS/DVS. This field is realized on the host
     * during transport node deletion or NSX uninstallation to specify the destination
     * for all vmks on N-VDS switches.
     *
     * @param vmkUninstallMigration New value for the property.
     */
    @Deprecated
    public void setVmkUninstallMigration(java.util.List<com.vmware.nsx.model.VmknicNetwork> vmkUninstallMigration) {
        this.vmkUninstallMigration = vmkUninstallMigration;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.standardHostSwitch;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("cpu_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cpuConfig, this._getType().getField("cpu_config")));
        structValue.setField("host_switch_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostSwitchId, this._getType().getField("host_switch_id")));
        structValue.setField("host_switch_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostSwitchMode, this._getType().getField("host_switch_mode")));
        structValue.setField("host_switch_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostSwitchName, this._getType().getField("host_switch_name")));
        structValue.setField("host_switch_profile_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostSwitchProfileIds, this._getType().getField("host_switch_profile_ids")));
        structValue.setField("host_switch_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostSwitchType, this._getType().getField("host_switch_type")));
        structValue.setField("ip_assignment_spec",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAssignmentSpec, this._getType().getField("ip_assignment_spec")));
        structValue.setField("ipv6_assignment_spec",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipv6AssignmentSpec, this._getType().getField("ipv6_assignment_spec")));
        structValue.setField("is_migrate_pnics",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isMigratePnics, this._getType().getField("is_migrate_pnics")));
        structValue.setField("pnics",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pnics, this._getType().getField("pnics")));
        structValue.setField("pnics_uninstall_migration",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pnicsUninstallMigration, this._getType().getField("pnics_uninstall_migration")));
        structValue.setField("portgroup_transport_zone_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.portgroupTransportZoneId, this._getType().getField("portgroup_transport_zone_id")));
        structValue.setField("transport_node_profile_sub_configs",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportNodeProfileSubConfigs, this._getType().getField("transport_node_profile_sub_configs")));
        structValue.setField("transport_zone_endpoints",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportZoneEndpoints, this._getType().getField("transport_zone_endpoints")));
        structValue.setField("uplinks",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uplinks, this._getType().getField("uplinks")));
        structValue.setField("vmk_install_migration",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vmkInstallMigration, this._getType().getField("vmk_install_migration")));
        structValue.setField("vmk_uninstall_migration",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vmkUninstallMigration, this._getType().getField("vmk_uninstall_migration")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.standardHostSwitch;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.standardHostSwitch.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static StandardHostSwitch _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new StandardHostSwitch(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static StandardHostSwitch _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new StandardHostSwitch(structValue);
    }

    /**
     * Builder class for {@link StandardHostSwitch}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.CpuCoreConfigForEnhancedNetworkingStackSwitch> cpuConfig;
        private java.lang.String hostSwitchId;
        private java.lang.String hostSwitchMode;
        private java.lang.String hostSwitchName;
        private java.util.List<com.vmware.nsx.model.HostSwitchProfileTypeIdEntry> hostSwitchProfileIds;
        private java.lang.String hostSwitchType;
        private com.vmware.vapi.bindings.Structure ipAssignmentSpec;
        private com.vmware.vapi.bindings.Structure ipv6AssignmentSpec;
        private java.lang.Boolean isMigratePnics;
        private java.util.List<com.vmware.nsx.model.Pnic> pnics;
        private java.util.List<com.vmware.nsx.model.Pnic> pnicsUninstallMigration;
        private java.lang.String portgroupTransportZoneId;
        private java.util.List<com.vmware.nsx.model.TransportNodeProfileSubConfig> transportNodeProfileSubConfigs;
        private java.util.List<com.vmware.nsx.model.TransportZoneEndPoint> transportZoneEndpoints;
        private java.util.List<com.vmware.nsx.model.VdsUplink> uplinks;
        private java.util.List<com.vmware.nsx.model.VmknicNetwork> vmkInstallMigration;
        private java.util.List<com.vmware.nsx.model.VmknicNetwork> vmkUninstallMigration;

        /**
         * Constructor with parameters for the required properties of
         * {@link StandardHostSwitch}.
         */
        public Builder() {
        }

        /**
         * CPU configuration specifies number of Logical cpu cores (Lcores) per Non Uniform
         * Memory Access (NUMA) node dedicated to Enhanced Networking Stack enabled
         * HostSwitch to get the best performance.
         *
         * @param cpuConfig New value for the property.
         */
        public Builder setCpuConfig(java.util.List<com.vmware.nsx.model.CpuCoreConfigForEnhancedNetworkingStackSwitch> cpuConfig) {
            this.cpuConfig = cpuConfig;
            return this;
        }

        /**
         * This field is writable only in case of VDS type HostSwitch and system generated
         * for NVDS type. For VDS type host switch, This field is used to lookup a VDS from
         * corresponding Compute Manager and then can be configured for logical networking.
         * For NVDS type host switch, This field is system generated and if provided will
         * be overwritten.
         *
         * @param hostSwitchId New value for the property.
         */
        public Builder setHostSwitchId(java.lang.String hostSwitchId) {
            this.hostSwitchId = hostSwitchId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_STANDARD}</li> <li>
         * {@link com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_ENS}</li> <li>
         * {@link
         * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_ENS_INTERRUPT}</li>
         * <li> {@link
         * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_MODE_LEGACY}</li> </ul>
         * STANDARD - This mode applies to all transport nodes. The realized host switch
         * mode will be chosen automatically (best applicable as per uplink capabilities)
         * by the data-plane in the transport node and may change in future. ENS - This is
         * the Enhanced Data Path switch mode for ESX host tranport node. This mode
         * provides accelerated networking performances but also introduces additional
         * prerequisites. In order to benefit from this mode, workloads will be need to be
         * compiled with DPDK and will use VMXNET3 for their vNIC. This mode is only
         * available on ESX hypervisor (6.7 and above, recommended 6.7 U2 and above) and
         * unavailable on KVM, EDGE and Public Cloud Gateway. Not all NSX features are
         * available in this mode, please consult the documentation. ENS_INTERRUPT - This
         * is an interrupt driven variant of the Enhanced Data Path mode. Please, consult
         * your account representative for applicability. This mode is available only on
         * ESX hypervisor (7.0 and above). LEGACY - This mode applies to all transport
         * nodes. This mode was formerly called as STANDARD and is realized as pktHandle.
         * IMPORTANT: ENS and ENS_INTERRUPT modes require a higher tier of NSX licenses.
         * ENS and ENS_INTERRUPT with classic Nic - NSX advanced or higher ENS with
         * SmartNic : NSX Enterprise Plus or higher. Please consult NSX documentation for
         * complete details.
         *
         * @param hostSwitchMode New value for the property.
         */
        public Builder setHostSwitchMode(java.lang.String hostSwitchMode) {
            this.hostSwitchMode = hostSwitchMode;
            return this;
        }

        /**
         * This field is writable only in case of NVDS type HostSwitch and system generated
         * for VDS type. For NVDS type host switch, If this name is unset or empty then the
         * default host switch name will be used. The name must be unique among all host
         * switches specified in a given transport node; unset name, empty name and the
         * default host switch name are considered the same in terms of uniqueness. For VDS
         * type host switch, Manager fetches VDS name from corresponding Compute Manager
         * and populates this field. If VDS name is given (correct or incorrect) it is
         * ignored and overwritten with correct one.
         *
         * @param hostSwitchName New value for the property.
         */
        public Builder setHostSwitchName(java.lang.String hostSwitchName) {
            this.hostSwitchName = hostSwitchName;
            return this;
        }

        /**
         * Host switch profiles bound to this host switch. If a profile ID is not provided
         * for any HostSwitchProfileType that is supported by the transport node, the
         * corresponding default profile will be bound to the host switch. If transport
         * node is created using Policy APIs, use policyPaths instead of UUIDs.
         *
         * @param hostSwitchProfileIds New value for the property.
         */
        public Builder setHostSwitchProfileIds(java.util.List<com.vmware.nsx.model.HostSwitchProfileTypeIdEntry> hostSwitchProfileIds) {
            this.hostSwitchProfileIds = hostSwitchProfileIds;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_TYPE_NVDS}</li> <li> {@link
         * com.vmware.nsx.model.StandardHostSwitch#HOST_SWITCH_TYPE_VDS}</li> </ul> VDS
         * represents VMware vSphere Distributed Switch from vSphere that is used as
         * HostSwitch through TransportNode or TransportNodeProfile configuration. When VDS
         * is used as a HostSwitch, Hosts have to be added to VDS from vSphere and VDS
         * instance is created on Hosts. To configure NSX on such hosts, you can use this
         * VDS as a HostSwitch from NSX manager. vCenter has the ownership of MTU, LAG,
         * NIOC and LLDP configuration of such VDS backed HostSwitch. Remaining
         * configuration (e.g. UplinkHostswitchProfile) will be managed by NSX. NVDS
         * represents NSX Virtual Switch which is NSX native HostSwitch. All configurations
         * of NVDS will be managed by NSX. HostSwitch of type NVDS has been deprecated on
         * ESX hosts that are managed by a vCenter Server.
         *
         * @param hostSwitchType New value for the property.
         */
        public Builder setHostSwitchType(java.lang.String hostSwitchType) {
            this.hostSwitchType = hostSwitchType;
            return this;
        }

        /**
         *
         *
         * @param ipAssignmentSpec New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx.model.IpAssignmentSpec}. When methods return a value of this
         * class as a return value, the property will contain all the properties defined in
         * {@link com.vmware.nsx.model.IpAssignmentSpec}.
         */
        public Builder setIpAssignmentSpec(com.vmware.vapi.bindings.Structure ipAssignmentSpec) {
            this.ipAssignmentSpec = ipAssignmentSpec;
            return this;
        }

        /**
         *
         *
         * @param ipv6AssignmentSpec New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx.model.Ipv6AssignmentSpec}. When methods return a value of this
         * class as a return value, the property will contain all the properties defined in
         * {@link com.vmware.nsx.model.Ipv6AssignmentSpec}.
         */
        public Builder setIpv6AssignmentSpec(com.vmware.vapi.bindings.Structure ipv6AssignmentSpec) {
            this.ipv6AssignmentSpec = ipv6AssignmentSpec;
            return this;
        }

        /**
         * When using the Quick Start workflow on 7.0 and above vCenter clusters, if the
         * pnics specified in the pnics field are used by a single VSS HostSwitch, then
         * they are migrated over to recommended VDS HostSwitch. If any two pnics are not
         * used by the same VSS HostSwitch or VDS HostSwitch, it is not supported. In such
         * cases, please migrate them in multiple steps, one VSS HostSwitch or VDS
         * HostSwitch at a time.
         *
         * @param isMigratePnics New value for the property.
         */
        public Builder setIsMigratePnics(java.lang.Boolean isMigratePnics) {
            this.isMigratePnics = isMigratePnics;
            return this;
        }

        /**
         * When using the Quick Start workflow on 7.0 and above vCenter clusters, pnic
         * information will be populated by the recommendation engine when providing a VDS
         * HostSwitch based recommendation for a VSS HostSwitch.
         *
         * @param pnics New value for the property.
         */
        public Builder setPnics(java.util.List<com.vmware.nsx.model.Pnic> pnics) {
            this.pnics = pnics;
            return this;
        }

        /**
         * This is only supported for NVDS type of host switch. If this is specified for
         * VDS type of host switch, an error will be returned to user. The pnics to be
         * migrated out to a non N-VDS switch during transport node deletion.
         *
         * @param pnicsUninstallMigration New value for the property.
         */
        public Builder setPnicsUninstallMigration(java.util.List<com.vmware.nsx.model.Pnic> pnicsUninstallMigration) {
            this.pnicsUninstallMigration = pnicsUninstallMigration;
            return this;
        }

        /**
         * A transport zone will be created for each DVS found across all hosts in a
         * cluster that is installed for NSX on DVPG. This field, populated by NSX, is the
         * ID of the transport zone created for the DVS this host switch represents. All
         * discovered segments created for the DVPGs found on the DVS will have this ID
         * specified as the transport zone id.
         *
         * @param portgroupTransportZoneId New value for the property.
         */
        public Builder setPortgroupTransportZoneId(java.lang.String portgroupTransportZoneId) {
            this.portgroupTransportZoneId = portgroupTransportZoneId;
            return this;
        }

        /**
         * This field is supported only for Tranport Node Profile Configurations. This
         * field is used for adding a subset of the host switch configuration under a
         * Transport Node Profile. This field is applicable only for a VDS based host
         * switch and not for an NVDS based host switch.
         *
         * @param transportNodeProfileSubConfigs New value for the property.
         */
        public Builder setTransportNodeProfileSubConfigs(java.util.List<com.vmware.nsx.model.TransportNodeProfileSubConfig> transportNodeProfileSubConfigs) {
            this.transportNodeProfileSubConfigs = transportNodeProfileSubConfigs;
            return this;
        }

        /**
         * List of TransportZones that are to be associated with specified host switch. If
         * this property is specified, host_switch_mode at StandardHostSwitch level must be
         * specified.
         *
         * @param transportZoneEndpoints New value for the property.
         */
        public Builder setTransportZoneEndpoints(java.util.List<com.vmware.nsx.model.TransportZoneEndPoint> transportZoneEndpoints) {
            this.transportZoneEndpoints = transportZoneEndpoints;
            return this;
        }

        /**
         * If VDS is used as a HostSwitch this attribute must be specified. You can
         * associate uplinks from UplinkHostSwitchProfile to either VDS uplink or LAG. VDS
         * uplink or LAG will inherit the global VDS level teaming policy from vSphere. NSX
         * managed uplink or LAG will have NSX teaming policy configured through
         * UplinkHostSwitchProfile.
         *
         * @param uplinks New value for the property.
         */
        public Builder setUplinks(java.util.List<com.vmware.nsx.model.VdsUplink> uplinks) {
            this.uplinks = uplinks;
            return this;
        }

        /**
         * When using the Quick Start workflow on 7.0 and above vCenter clusters,
         * vmnk_install_migration will be populated by the recommendation engine when
         * providing a VDS HostSwitch based recommendation for a VSS HostSwitch. It will
         * contain The vmk interfaces and the associated logical switches on the
         * HostSwitch. The state of this field is realized on the transport node during
         * creation
         *
         * @param vmkInstallMigration New value for the property.
         */
        public Builder setVmkInstallMigration(java.util.List<com.vmware.nsx.model.VmknicNetwork> vmkInstallMigration) {
            this.vmkInstallMigration = vmkInstallMigration;
            return this;
        }

        /**
         * This is only supported for NVDS type of host switch. If this is specified for
         * VDS type of host switch, an error will be returned to user. The vmk interfaces
         * and the associated portgroups on the VSS/DVS. This field is realized on the host
         * during transport node deletion or NSX uninstallation to specify the destination
         * for all vmks on N-VDS switches.
         *
         * @param vmkUninstallMigration New value for the property.
         */
        public Builder setVmkUninstallMigration(java.util.List<com.vmware.nsx.model.VmknicNetwork> vmkUninstallMigration) {
            this.vmkUninstallMigration = vmkUninstallMigration;
            return this;
        }

        public StandardHostSwitch build() {
            StandardHostSwitch result = new StandardHostSwitch();
            result.setCpuConfig(this.cpuConfig);
            result.setHostSwitchId(this.hostSwitchId);
            result.setHostSwitchMode(this.hostSwitchMode);
            result.setHostSwitchName(this.hostSwitchName);
            result.setHostSwitchProfileIds(this.hostSwitchProfileIds);
            result.setHostSwitchType(this.hostSwitchType);
            result.setIpAssignmentSpec(this.ipAssignmentSpec);
            result.setIpv6AssignmentSpec(this.ipv6AssignmentSpec);
            result.setIsMigratePnics(this.isMigratePnics);
            result.setPnics(this.pnics);
            result.setPnicsUninstallMigration(this.pnicsUninstallMigration);
            result.setPortgroupTransportZoneId(this.portgroupTransportZoneId);
            result.setTransportNodeProfileSubConfigs(this.transportNodeProfileSubConfigs);
            result.setTransportZoneEndpoints(this.transportZoneEndpoints);
            result.setUplinks(this.uplinks);
            result.setVmkInstallMigration(this.vmkInstallMigration);
            result.setVmkUninstallMigration(this.vmkUninstallMigration);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("cpu_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.cpuCoreConfigForEnhancedNetworkingStackSwitch; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cpu_config",
                                                                                "cpuConfig",
                                                                                "getCpuConfig",
                                                                                "setCpuConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_switch_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_switch_id",
                                                                                "hostSwitchId",
                                                                                "getHostSwitchId",
                                                                                "setHostSwitchId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_switch_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_switch_mode",
                                                                                "hostSwitchMode",
                                                                                "getHostSwitchMode",
                                                                                "setHostSwitchMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_switch_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_switch_name",
                                                                                "hostSwitchName",
                                                                                "getHostSwitchName",
                                                                                "setHostSwitchName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_switch_profile_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.hostSwitchProfileTypeIdEntry; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_switch_profile_ids",
                                                                                "hostSwitchProfileIds",
                                                                                "getHostSwitchProfileIds",
                                                                                "setHostSwitchProfileIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_switch_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_switch_type",
                                                                                "hostSwitchType",
                                                                                "getHostSwitchType",
                                                                                "setHostSwitchType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_assignment_spec", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.ipAssignmentSpec; } })))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_assignment_spec",
                                                                                "ipAssignmentSpec",
                                                                                "getIpAssignmentSpec",
                                                                                "setIpAssignmentSpec");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ipv6_assignment_spec", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.ipv6AssignmentSpec; } })))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ipv6_assignment_spec",
                                                                                "ipv6AssignmentSpec",
                                                                                "getIpv6AssignmentSpec",
                                                                                "setIpv6AssignmentSpec");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_migrate_pnics", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_migrate_pnics",
                                                                                "isMigratePnics",
                                                                                "getIsMigratePnics",
                                                                                "setIsMigratePnics");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pnics", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.pnic; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pnics",
                                                                                "pnics",
                                                                                "getPnics",
                                                                                "setPnics");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pnics_uninstall_migration", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.pnic; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pnics_uninstall_migration",
                                                                                "pnicsUninstallMigration",
                                                                                "getPnicsUninstallMigration",
                                                                                "setPnicsUninstallMigration");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("portgroup_transport_zone_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("portgroup_transport_zone_id",
                                                                                "portgroupTransportZoneId",
                                                                                "getPortgroupTransportZoneId",
                                                                                "setPortgroupTransportZoneId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_node_profile_sub_configs", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.transportNodeProfileSubConfig; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_node_profile_sub_configs",
                                                                                "transportNodeProfileSubConfigs",
                                                                                "getTransportNodeProfileSubConfigs",
                                                                                "setTransportNodeProfileSubConfigs");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_zone_endpoints", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.transportZoneEndPoint; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_zone_endpoints",
                                                                                "transportZoneEndpoints",
                                                                                "getTransportZoneEndpoints",
                                                                                "setTransportZoneEndpoints");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("uplinks", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.vdsUplink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("uplinks",
                                                                                "uplinks",
                                                                                "getUplinks",
                                                                                "setUplinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vmk_install_migration", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.vmknicNetwork; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vmk_install_migration",
                                                                                "vmkInstallMigration",
                                                                                "getVmkInstallMigration",
                                                                                "setVmkInstallMigration");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vmk_uninstall_migration", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.vmknicNetwork; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vmk_uninstall_migration",
                                                                                "vmkUninstallMigration",
                                                                                "getVmkUninstallMigration",
                                                                                "setVmkUninstallMigration");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.standard_host_switch",
                                                            fields,
                                                            com.vmware.nsx.model.StandardHostSwitch.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

