/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Information about participating transport nodes
 */
public final class TransportNodeMemberInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String computeCollectionId;

    private java.util.List<com.vmware.nsx.model.HostSwitchInfo> hostSwitches;

    private java.lang.String transportNodeDisplayName;

    private java.lang.String transportNodeId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public TransportNodeMemberInfo() {
    }

    protected TransportNodeMemberInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Id of the compute collection to which this transport node belongs. Empty if this
     * is standalone transport node or non ESX type node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getComputeCollectionId() {
        return this.computeCollectionId;
    }

    /**
     * Id of the compute collection to which this transport node belongs. Empty if this
     * is standalone transport node or non ESX type node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param computeCollectionId New value for the property.
     */
    public void setComputeCollectionId(java.lang.String computeCollectionId) {
        this.computeCollectionId = computeCollectionId;
    }

    /**
     * List of host switches using the transport zone
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.HostSwitchInfo> getHostSwitches() {
        return this.hostSwitches;
    }

    /**
     * List of host switches using the transport zone
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param hostSwitches New value for the property.
     */
    public void setHostSwitches(java.util.List<com.vmware.nsx.model.HostSwitchInfo> hostSwitches) {
        this.hostSwitches = hostSwitches;
    }

    /**
     * Display name of the transport node which has one or more host switches which
     * belong to associated transport zone.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransportNodeDisplayName() {
        return this.transportNodeDisplayName;
    }

    /**
     * Display name of the transport node which has one or more host switches which
     * belong to associated transport zone.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param transportNodeDisplayName New value for the property.
     */
    public void setTransportNodeDisplayName(java.lang.String transportNodeDisplayName) {
        this.transportNodeDisplayName = transportNodeDisplayName;
    }

    /**
     * Id of the transport node which has one or more host switches which belong to
     * associated transport zone.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransportNodeId() {
        return this.transportNodeId;
    }

    /**
     * Id of the transport node which has one or more host switches which belong to
     * associated transport zone.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param transportNodeId New value for the property.
     */
    public void setTransportNodeId(java.lang.String transportNodeId) {
        this.transportNodeId = transportNodeId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.transportNodeMemberInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("compute_collection_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.computeCollectionId, this._getType().getField("compute_collection_id")));
        structValue.setField("host_switches",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostSwitches, this._getType().getField("host_switches")));
        structValue.setField("transport_node_display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportNodeDisplayName, this._getType().getField("transport_node_display_name")));
        structValue.setField("transport_node_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportNodeId, this._getType().getField("transport_node_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.transportNodeMemberInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.transportNodeMemberInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static TransportNodeMemberInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new TransportNodeMemberInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static TransportNodeMemberInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new TransportNodeMemberInfo(structValue);
    }

    /**
     * Builder class for {@link TransportNodeMemberInfo}.
     */
    public static final class Builder {
        private java.lang.String computeCollectionId;
        private java.util.List<com.vmware.nsx.model.HostSwitchInfo> hostSwitches;
        private java.lang.String transportNodeDisplayName;
        private java.lang.String transportNodeId;

        /**
         * Constructor with parameters for the required properties of
         * {@link TransportNodeMemberInfo}.
         */
        public Builder() {
        }

        /**
         * Id of the compute collection to which this transport node belongs. Empty if this
         * is standalone transport node or non ESX type node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param computeCollectionId New value for the property.
         */
        public Builder setComputeCollectionId(java.lang.String computeCollectionId) {
            this.computeCollectionId = computeCollectionId;
            return this;
        }

        /**
         * List of host switches using the transport zone
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param hostSwitches New value for the property.
         */
        public Builder setHostSwitches(java.util.List<com.vmware.nsx.model.HostSwitchInfo> hostSwitches) {
            this.hostSwitches = hostSwitches;
            return this;
        }

        /**
         * Display name of the transport node which has one or more host switches which
         * belong to associated transport zone.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param transportNodeDisplayName New value for the property.
         */
        public Builder setTransportNodeDisplayName(java.lang.String transportNodeDisplayName) {
            this.transportNodeDisplayName = transportNodeDisplayName;
            return this;
        }

        /**
         * Id of the transport node which has one or more host switches which belong to
         * associated transport zone.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param transportNodeId New value for the property.
         */
        public Builder setTransportNodeId(java.lang.String transportNodeId) {
            this.transportNodeId = transportNodeId;
            return this;
        }

        public TransportNodeMemberInfo build() {
            TransportNodeMemberInfo result = new TransportNodeMemberInfo();
            result.setComputeCollectionId(this.computeCollectionId);
            result.setHostSwitches(this.hostSwitches);
            result.setTransportNodeDisplayName(this.transportNodeDisplayName);
            result.setTransportNodeId(this.transportNodeId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("compute_collection_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("compute_collection_id",
                                                                                "computeCollectionId",
                                                                                "getComputeCollectionId",
                                                                                "setComputeCollectionId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_switches", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.hostSwitchInfo; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_switches",
                                                                                "hostSwitches",
                                                                                "getHostSwitches",
                                                                                "setHostSwitches");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_node_display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_node_display_name",
                                                                                "transportNodeDisplayName",
                                                                                "getTransportNodeDisplayName",
                                                                                "setTransportNodeDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_node_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_node_id",
                                                                                "transportNodeId",
                                                                                "getTransportNodeId",
                                                                                "setTransportNodeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.transport_node_member_info",
                                                            fields,
                                                            com.vmware.nsx.model.TransportNodeMemberInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

