/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Transport zone runtime status information
 */
public final class TransportZoneStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long numLogicalPorts;

    private java.lang.Long numLogicalSwitches;

    private java.lang.Long numTransportNodes;

    private java.util.List<com.vmware.nsx.model.TransportNodeMemberInfo> transportNodeMembers;

    private java.lang.String transportZoneId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public TransportZoneStatus() {
    }

    protected TransportZoneStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Count of logical ports in the transport zone format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNumLogicalPorts() {
        return this.numLogicalPorts;
    }

    /**
     * Count of logical ports in the transport zone format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param numLogicalPorts New value for the property.
     */
    public void setNumLogicalPorts(java.lang.Long numLogicalPorts) {
        this.numLogicalPorts = numLogicalPorts;
    }

    /**
     * Count of logical switches in the transport zone format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNumLogicalSwitches() {
        return this.numLogicalSwitches;
    }

    /**
     * Count of logical switches in the transport zone format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param numLogicalSwitches New value for the property.
     */
    public void setNumLogicalSwitches(java.lang.Long numLogicalSwitches) {
        this.numLogicalSwitches = numLogicalSwitches;
    }

    /**
     * Count of transport nodes in the transport zone format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNumTransportNodes() {
        return this.numTransportNodes;
    }

    /**
     * Count of transport nodes in the transport zone format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param numTransportNodes New value for the property.
     */
    public void setNumTransportNodes(java.lang.Long numTransportNodes) {
        this.numTransportNodes = numTransportNodes;
    }

    /**
     * Information about transport nodes which are part of this transport zone
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.TransportNodeMemberInfo> getTransportNodeMembers() {
        return this.transportNodeMembers;
    }

    /**
     * Information about transport nodes which are part of this transport zone
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param transportNodeMembers New value for the property.
     */
    public void setTransportNodeMembers(java.util.List<com.vmware.nsx.model.TransportNodeMemberInfo> transportNodeMembers) {
        this.transportNodeMembers = transportNodeMembers;
    }

    /**
     * Unique ID identifying the transport zone
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransportZoneId() {
        return this.transportZoneId;
    }

    /**
     * Unique ID identifying the transport zone
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param transportZoneId New value for the property.
     */
    public void setTransportZoneId(java.lang.String transportZoneId) {
        this.transportZoneId = transportZoneId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.transportZoneStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("num_logical_ports",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.numLogicalPorts, this._getType().getField("num_logical_ports")));
        structValue.setField("num_logical_switches",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.numLogicalSwitches, this._getType().getField("num_logical_switches")));
        structValue.setField("num_transport_nodes",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.numTransportNodes, this._getType().getField("num_transport_nodes")));
        structValue.setField("transport_node_members",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportNodeMembers, this._getType().getField("transport_node_members")));
        structValue.setField("transport_zone_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportZoneId, this._getType().getField("transport_zone_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.transportZoneStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.transportZoneStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static TransportZoneStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new TransportZoneStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static TransportZoneStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new TransportZoneStatus(structValue);
    }

    /**
     * Builder class for {@link TransportZoneStatus}.
     */
    public static final class Builder {
        private java.lang.Long numLogicalPorts;
        private java.lang.Long numLogicalSwitches;
        private java.lang.Long numTransportNodes;
        private java.util.List<com.vmware.nsx.model.TransportNodeMemberInfo> transportNodeMembers;
        private java.lang.String transportZoneId;

        /**
         * Constructor with parameters for the required properties of
         * {@link TransportZoneStatus}.
         */
        public Builder() {
        }

        /**
         * Count of logical ports in the transport zone format: int32
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param numLogicalPorts New value for the property.
         */
        public Builder setNumLogicalPorts(java.lang.Long numLogicalPorts) {
            this.numLogicalPorts = numLogicalPorts;
            return this;
        }

        /**
         * Count of logical switches in the transport zone format: int32
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param numLogicalSwitches New value for the property.
         */
        public Builder setNumLogicalSwitches(java.lang.Long numLogicalSwitches) {
            this.numLogicalSwitches = numLogicalSwitches;
            return this;
        }

        /**
         * Count of transport nodes in the transport zone format: int32
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param numTransportNodes New value for the property.
         */
        public Builder setNumTransportNodes(java.lang.Long numTransportNodes) {
            this.numTransportNodes = numTransportNodes;
            return this;
        }

        /**
         * Information about transport nodes which are part of this transport zone
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param transportNodeMembers New value for the property.
         */
        public Builder setTransportNodeMembers(java.util.List<com.vmware.nsx.model.TransportNodeMemberInfo> transportNodeMembers) {
            this.transportNodeMembers = transportNodeMembers;
            return this;
        }

        /**
         * Unique ID identifying the transport zone
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param transportZoneId New value for the property.
         */
        public Builder setTransportZoneId(java.lang.String transportZoneId) {
            this.transportZoneId = transportZoneId;
            return this;
        }

        public TransportZoneStatus build() {
            TransportZoneStatus result = new TransportZoneStatus();
            result.setNumLogicalPorts(this.numLogicalPorts);
            result.setNumLogicalSwitches(this.numLogicalSwitches);
            result.setNumTransportNodes(this.numTransportNodes);
            result.setTransportNodeMembers(this.transportNodeMembers);
            result.setTransportZoneId(this.transportZoneId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("num_logical_ports", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("num_logical_ports",
                                                                                "numLogicalPorts",
                                                                                "getNumLogicalPorts",
                                                                                "setNumLogicalPorts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("num_logical_switches", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("num_logical_switches",
                                                                                "numLogicalSwitches",
                                                                                "getNumLogicalSwitches",
                                                                                "setNumLogicalSwitches");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("num_transport_nodes", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("num_transport_nodes",
                                                                                "numTransportNodes",
                                                                                "getNumTransportNodes",
                                                                                "setNumTransportNodes");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_node_members", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.transportNodeMemberInfo; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_node_members",
                                                                                "transportNodeMembers",
                                                                                "getTransportNodeMembers",
                                                                                "setTransportNodeMembers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_zone_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_zone_id",
                                                                                "transportZoneId",
                                                                                "getTransportZoneId",
                                                                                "setTransportZoneId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.transport_zone_status",
                                                            fields,
                                                            com.vmware.nsx.model.TransportZoneStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

