/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Input spec for mapping of NSX-V and NSX-T sites
 */
public final class V2tSiteMappingSpec implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String federationSiteId;

    private java.lang.String nsxvIp;

    private java.lang.String nsxvPassword;

    private java.lang.String nsxvUsername;

    private java.lang.String vcIp;

    private java.lang.String vcPassword;

    private java.lang.Long vcPort;

    private java.lang.String vcUsername;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public V2tSiteMappingSpec() {
    }

    protected V2tSiteMappingSpec(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Federation NSX-T site id.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFederationSiteId() {
        return this.federationSiteId;
    }

    /**
     * Federation NSX-T site id.
     *
     * @param federationSiteId New value for the property.
     */
    public void setFederationSiteId(java.lang.String federationSiteId) {
        this.federationSiteId = federationSiteId;
    }

    /**
     * NSX-V API endpoint IP address format: hostname-or-ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getNsxvIp() {
        return this.nsxvIp;
    }

    /**
     * NSX-V API endpoint IP address format: hostname-or-ip
     *
     * @param nsxvIp New value for the property.
     */
    public void setNsxvIp(java.lang.String nsxvIp) {
        this.nsxvIp = nsxvIp;
    }

    /**
     * Password for connecting to NSX-V manager.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNsxvPassword() {
        return this.nsxvPassword;
    }

    /**
     * Password for connecting to NSX-V manager.
     *
     * @param nsxvPassword New value for the property.
     */
    public void setNsxvPassword(java.lang.String nsxvPassword) {
        this.nsxvPassword = nsxvPassword;
    }

    /**
     * Username for NSX-V manager
     *
     * @return The current value of the property.
     */
    public java.lang.String getNsxvUsername() {
        return this.nsxvUsername;
    }

    /**
     * Username for NSX-V manager
     *
     * @param nsxvUsername New value for the property.
     */
    public void setNsxvUsername(java.lang.String nsxvUsername) {
        this.nsxvUsername = nsxvUsername;
    }

    /**
     * IP address or host name of VC. format: hostname-or-ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getVcIp() {
        return this.vcIp;
    }

    /**
     * IP address or host name of VC. format: hostname-or-ip
     *
     * @param vcIp New value for the property.
     */
    public void setVcIp(java.lang.String vcIp) {
        this.vcIp = vcIp;
    }

    /**
     * Password for connecting to VC.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVcPassword() {
        return this.vcPassword;
    }

    /**
     * Password for connecting to VC.
     *
     * @param vcPassword New value for the property.
     */
    public void setVcPassword(java.lang.String vcPassword) {
        this.vcPassword = vcPassword;
    }

    /**
     * VC port that will be used to fetch details. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getVcPort() {
        return this.vcPort;
    }

    /**
     * VC port that will be used to fetch details. format: int32
     *
     * @param vcPort New value for the property.
     */
    public void setVcPort(java.lang.Long vcPort) {
        this.vcPort = vcPort;
    }

    /**
     * Username for connecting to VC.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVcUsername() {
        return this.vcUsername;
    }

    /**
     * Username for connecting to VC.
     *
     * @param vcUsername New value for the property.
     */
    public void setVcUsername(java.lang.String vcUsername) {
        this.vcUsername = vcUsername;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.v2tSiteMappingSpec;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("federation_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.federationSiteId, this._getType().getField("federation_site_id")));
        structValue.setField("nsxv_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsxvIp, this._getType().getField("nsxv_ip")));
        structValue.setField("nsxv_password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsxvPassword, this._getType().getField("nsxv_password")));
        structValue.setField("nsxv_username",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsxvUsername, this._getType().getField("nsxv_username")));
        structValue.setField("vc_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcIp, this._getType().getField("vc_ip")));
        structValue.setField("vc_password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcPassword, this._getType().getField("vc_password")));
        structValue.setField("vc_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcPort, this._getType().getField("vc_port")));
        structValue.setField("vc_username",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vcUsername, this._getType().getField("vc_username")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.v2tSiteMappingSpec;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.v2tSiteMappingSpec.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static V2tSiteMappingSpec _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new V2tSiteMappingSpec(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static V2tSiteMappingSpec _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new V2tSiteMappingSpec(structValue);
    }

    /**
     * Builder class for {@link V2tSiteMappingSpec}.
     */
    public static final class Builder {
        private java.lang.String federationSiteId;
        private java.lang.String nsxvIp;
        private java.lang.String nsxvPassword;
        private java.lang.String nsxvUsername;
        private java.lang.String vcIp;
        private java.lang.String vcPassword;
        private java.lang.Long vcPort;
        private java.lang.String vcUsername;

        /**
         * Constructor with parameters for the required properties of
         * {@link V2tSiteMappingSpec}.
         */
        public Builder() {
        }

        /**
         * Federation NSX-T site id.
         *
         * @param federationSiteId New value for the property.
         */
        public Builder setFederationSiteId(java.lang.String federationSiteId) {
            this.federationSiteId = federationSiteId;
            return this;
        }

        /**
         * NSX-V API endpoint IP address format: hostname-or-ip
         *
         * @param nsxvIp New value for the property.
         */
        public Builder setNsxvIp(java.lang.String nsxvIp) {
            this.nsxvIp = nsxvIp;
            return this;
        }

        /**
         * Password for connecting to NSX-V manager.
         *
         * @param nsxvPassword New value for the property.
         */
        public Builder setNsxvPassword(java.lang.String nsxvPassword) {
            this.nsxvPassword = nsxvPassword;
            return this;
        }

        /**
         * Username for NSX-V manager
         *
         * @param nsxvUsername New value for the property.
         */
        public Builder setNsxvUsername(java.lang.String nsxvUsername) {
            this.nsxvUsername = nsxvUsername;
            return this;
        }

        /**
         * IP address or host name of VC. format: hostname-or-ip
         *
         * @param vcIp New value for the property.
         */
        public Builder setVcIp(java.lang.String vcIp) {
            this.vcIp = vcIp;
            return this;
        }

        /**
         * Password for connecting to VC.
         *
         * @param vcPassword New value for the property.
         */
        public Builder setVcPassword(java.lang.String vcPassword) {
            this.vcPassword = vcPassword;
            return this;
        }

        /**
         * VC port that will be used to fetch details. format: int32
         *
         * @param vcPort New value for the property.
         */
        public Builder setVcPort(java.lang.Long vcPort) {
            this.vcPort = vcPort;
            return this;
        }

        /**
         * Username for connecting to VC.
         *
         * @param vcUsername New value for the property.
         */
        public Builder setVcUsername(java.lang.String vcUsername) {
            this.vcUsername = vcUsername;
            return this;
        }

        public V2tSiteMappingSpec build() {
            V2tSiteMappingSpec result = new V2tSiteMappingSpec();
            result.setFederationSiteId(this.federationSiteId);
            result.setNsxvIp(this.nsxvIp);
            result.setNsxvPassword(this.nsxvPassword);
            result.setNsxvUsername(this.nsxvUsername);
            result.setVcIp(this.vcIp);
            result.setVcPassword(this.vcPassword);
            result.setVcPort(this.vcPort);
            result.setVcUsername(this.vcUsername);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("federation_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("federation_site_id",
                                                                                "federationSiteId",
                                                                                "getFederationSiteId",
                                                                                "setFederationSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nsxv_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsxv_ip",
                                                                                "nsxvIp",
                                                                                "getNsxvIp",
                                                                                "setNsxvIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nsxv_password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsxv_password",
                                                                                "nsxvPassword",
                                                                                "getNsxvPassword",
                                                                                "setNsxvPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nsxv_username", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsxv_username",
                                                                                "nsxvUsername",
                                                                                "getNsxvUsername",
                                                                                "setNsxvUsername");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vc_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vc_ip",
                                                                                "vcIp",
                                                                                "getVcIp",
                                                                                "setVcIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vc_password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vc_password",
                                                                                "vcPassword",
                                                                                "getVcPassword",
                                                                                "setVcPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vc_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vc_port",
                                                                                "vcPort",
                                                                                "getVcPort",
                                                                                "setVcPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vc_username", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vc_username",
                                                                                "vcUsername",
                                                                                "getVcUsername",
                                                                                "setVcUsername");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.v2t_site_mapping_spec",
                                                            fields,
                                                            com.vmware.nsx.model.V2tSiteMappingSpec.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

