/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class VifAttachmentContext implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "VifAttachmentContext";

    public static final java.lang.String VIF_TYPE_PARENT = "PARENT";

    public static final java.lang.String VIF_TYPE_CHILD = "CHILD";

    public static final java.lang.String VIF_TYPE_INDEPENDENT = "INDEPENDENT";

    private java.lang.String appId;

    private com.vmware.nsx.model.AttachedInterface bmsInterfaceConfig;

    private java.lang.String parentVifId;

    private java.lang.Long trafficTag;

    private java.lang.String transportNodeUuid;

    private java.lang.String vifType;

    private java.lang.String allocateAddresses;

    private final java.lang.String resourceType = "VifAttachmentContext";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public VifAttachmentContext() {
    }

    protected VifAttachmentContext(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * An application ID used to identify / look up a child VIF behind a parent VIF.
     * Only effective when vif_type is CHILD.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAppId() {
        return this.appId;
    }

    /**
     * An application ID used to identify / look up a child VIF behind a parent VIF.
     * Only effective when vif_type is CHILD.
     *
     * @param appId New value for the property.
     */
    public void setAppId(java.lang.String appId) {
        this.appId = appId;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.AttachedInterface getBmsInterfaceConfig() {
        return this.bmsInterfaceConfig;
    }

    /**
     *
     *
     * @param bmsInterfaceConfig New value for the property.
     */
    public void setBmsInterfaceConfig(com.vmware.nsx.model.AttachedInterface bmsInterfaceConfig) {
        this.bmsInterfaceConfig = bmsInterfaceConfig;
    }

    /**
     * VIF ID of the parent VIF if vif_type is CHILD
     *
     * @return The current value of the property.
     */
    public java.lang.String getParentVifId() {
        return this.parentVifId;
    }

    /**
     * VIF ID of the parent VIF if vif_type is CHILD
     *
     * @param parentVifId New value for the property.
     */
    public void setParentVifId(java.lang.String parentVifId) {
        this.parentVifId = parentVifId;
    }

    /**
     * Current we use VLAN id as the traffic tag. Only effective when vif_type is
     * CHILD. Each logical port inside a container must have a unique traffic tag. If
     * the traffic_tag is not unique, no error is generated, but traffic will not be
     * delivered to any port with a non-unique tag. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTrafficTag() {
        return this.trafficTag;
    }

    /**
     * Current we use VLAN id as the traffic tag. Only effective when vif_type is
     * CHILD. Each logical port inside a container must have a unique traffic tag. If
     * the traffic_tag is not unique, no error is generated, but traffic will not be
     * delivered to any port with a non-unique tag. format: int32
     *
     * @param trafficTag New value for the property.
     */
    public void setTrafficTag(java.lang.Long trafficTag) {
        this.trafficTag = trafficTag;
    }

    /**
     * Only effective when vif_type is INDEPENDENT. Each logical port inside a bare
     * metal server or container must have a transport node UUID. We use transport node
     * ID as transport node UUID.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransportNodeUuid() {
        return this.transportNodeUuid;
    }

    /**
     * Only effective when vif_type is INDEPENDENT. Each logical port inside a bare
     * metal server or container must have a transport node UUID. We use transport node
     * ID as transport node UUID.
     *
     * @param transportNodeUuid New value for the property.
     */
    public void setTransportNodeUuid(java.lang.String transportNodeUuid) {
        this.transportNodeUuid = transportNodeUuid;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.VifAttachmentContext#VIF_TYPE_PARENT}</li> <li> {@link
     * com.vmware.nsx.model.VifAttachmentContext#VIF_TYPE_CHILD}</li> <li> {@link
     * com.vmware.nsx.model.VifAttachmentContext#VIF_TYPE_INDEPENDENT}</li> </ul> Type
     * of the VIF attached to logical port
     *
     * @return The current value of the property.
     */
    public java.lang.String getVifType() {
        return this.vifType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.VifAttachmentContext#VIF_TYPE_PARENT}</li> <li> {@link
     * com.vmware.nsx.model.VifAttachmentContext#VIF_TYPE_CHILD}</li> <li> {@link
     * com.vmware.nsx.model.VifAttachmentContext#VIF_TYPE_INDEPENDENT}</li> </ul> Type
     * of the VIF attached to logical port
     *
     * @param vifType New value for the property.
     */
    public void setVifType(java.lang.String vifType) {
        this.vifType = vifType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_IPPOOL}</li> <li>
     * {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_MACPOOL}</li>
     * <li> {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_BOTH}</li>
     * <li> {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_NONE}</li>
     * <li> {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_DHCP}</li>
     * <li> {@link
     * com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_DHCPV6}</li> <li>
     * {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_SLAAC}</li>
     * </ul> A flag to indicate whether to allocate addresses from allocation pools
     * bound to the parent logical switch.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAllocateAddresses() {
        return this.allocateAddresses;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_IPPOOL}</li> <li>
     * {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_MACPOOL}</li>
     * <li> {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_BOTH}</li>
     * <li> {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_NONE}</li>
     * <li> {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_DHCP}</li>
     * <li> {@link
     * com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_DHCPV6}</li> <li>
     * {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_SLAAC}</li>
     * </ul> A flag to indicate whether to allocate addresses from allocation pools
     * bound to the parent logical switch.
     *
     * @param allocateAddresses New value for the property.
     */
    public void setAllocateAddresses(java.lang.String allocateAddresses) {
        this.allocateAddresses = allocateAddresses;
    }

    /**
     * Used to identify which concrete class it is
     * The value of this property is automatically populated to {@code "VifAttachmentContext"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.vifAttachmentContext;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("app_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.appId, this._getType().getField("app_id")));
        structValue.setField("bms_interface_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bmsInterfaceConfig, this._getType().getField("bms_interface_config")));
        structValue.setField("parent_vif_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.parentVifId, this._getType().getField("parent_vif_id")));
        structValue.setField("traffic_tag",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.trafficTag, this._getType().getField("traffic_tag")));
        structValue.setField("transport_node_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportNodeUuid, this._getType().getField("transport_node_uuid")));
        structValue.setField("vif_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vifType, this._getType().getField("vif_type")));
        structValue.setField("allocate_addresses",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allocateAddresses, this._getType().getField("allocate_addresses")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.vifAttachmentContext;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.vifAttachmentContext.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static VifAttachmentContext _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new VifAttachmentContext(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static VifAttachmentContext _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new VifAttachmentContext(structValue);
    }

    /**
     * Builder class for {@link VifAttachmentContext}.
     */
    public static final class Builder {
        private java.lang.String appId;
        private com.vmware.nsx.model.AttachedInterface bmsInterfaceConfig;
        private java.lang.String parentVifId;
        private java.lang.Long trafficTag;
        private java.lang.String transportNodeUuid;
        private java.lang.String vifType;
        private java.lang.String allocateAddresses;

        /**
         * Constructor with parameters for the required properties of
         * {@link VifAttachmentContext}.
         */
        public Builder() {
        }

        /**
         * An application ID used to identify / look up a child VIF behind a parent VIF.
         * Only effective when vif_type is CHILD.
         *
         * @param appId New value for the property.
         */
        public Builder setAppId(java.lang.String appId) {
            this.appId = appId;
            return this;
        }

        /**
         *
         *
         * @param bmsInterfaceConfig New value for the property.
         */
        public Builder setBmsInterfaceConfig(com.vmware.nsx.model.AttachedInterface bmsInterfaceConfig) {
            this.bmsInterfaceConfig = bmsInterfaceConfig;
            return this;
        }

        /**
         * VIF ID of the parent VIF if vif_type is CHILD
         *
         * @param parentVifId New value for the property.
         */
        public Builder setParentVifId(java.lang.String parentVifId) {
            this.parentVifId = parentVifId;
            return this;
        }

        /**
         * Current we use VLAN id as the traffic tag. Only effective when vif_type is
         * CHILD. Each logical port inside a container must have a unique traffic tag. If
         * the traffic_tag is not unique, no error is generated, but traffic will not be
         * delivered to any port with a non-unique tag. format: int32
         *
         * @param trafficTag New value for the property.
         */
        public Builder setTrafficTag(java.lang.Long trafficTag) {
            this.trafficTag = trafficTag;
            return this;
        }

        /**
         * Only effective when vif_type is INDEPENDENT. Each logical port inside a bare
         * metal server or container must have a transport node UUID. We use transport node
         * ID as transport node UUID.
         *
         * @param transportNodeUuid New value for the property.
         */
        public Builder setTransportNodeUuid(java.lang.String transportNodeUuid) {
            this.transportNodeUuid = transportNodeUuid;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.VifAttachmentContext#VIF_TYPE_PARENT}</li> <li> {@link
         * com.vmware.nsx.model.VifAttachmentContext#VIF_TYPE_CHILD}</li> <li> {@link
         * com.vmware.nsx.model.VifAttachmentContext#VIF_TYPE_INDEPENDENT}</li> </ul> Type
         * of the VIF attached to logical port
         *
         * @param vifType New value for the property.
         */
        public Builder setVifType(java.lang.String vifType) {
            this.vifType = vifType;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_IPPOOL}</li> <li>
         * {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_MACPOOL}</li>
         * <li> {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_BOTH}</li>
         * <li> {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_NONE}</li>
         * <li> {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_DHCP}</li>
         * <li> {@link
         * com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_DHCPV6}</li> <li>
         * {@link com.vmware.nsx.model.AttachmentContext#ALLOCATE_ADDRESSES_SLAAC}</li>
         * </ul> A flag to indicate whether to allocate addresses from allocation pools
         * bound to the parent logical switch.
         *
         * @param allocateAddresses New value for the property.
         */
        public Builder setAllocateAddresses(java.lang.String allocateAddresses) {
            this.allocateAddresses = allocateAddresses;
            return this;
        }

        public VifAttachmentContext build() {
            VifAttachmentContext result = new VifAttachmentContext();
            result.setAppId(this.appId);
            result.setBmsInterfaceConfig(this.bmsInterfaceConfig);
            result.setParentVifId(this.parentVifId);
            result.setTrafficTag(this.trafficTag);
            result.setTransportNodeUuid(this.transportNodeUuid);
            result.setVifType(this.vifType);
            result.setAllocateAddresses(this.allocateAddresses);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("app_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("app_id",
                                                                                "appId",
                                                                                "getAppId",
                                                                                "setAppId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bms_interface_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.attachedInterface; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bms_interface_config",
                                                                                "bmsInterfaceConfig",
                                                                                "getBmsInterfaceConfig",
                                                                                "setBmsInterfaceConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("parent_vif_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("parent_vif_id",
                                                                                "parentVifId",
                                                                                "getParentVifId",
                                                                                "setParentVifId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("traffic_tag", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("traffic_tag",
                                                                                "trafficTag",
                                                                                "getTrafficTag",
                                                                                "setTrafficTag");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_node_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_node_uuid",
                                                                                "transportNodeUuid",
                                                                                "getTransportNodeUuid",
                                                                                "setTransportNodeUuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vif_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vif_type",
                                                                                "vifType",
                                                                                "getVifType",
                                                                                "setVifType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("allocate_addresses", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allocate_addresses",
                                                                                "allocateAddresses",
                                                                                "getAllocateAddresses",
                                                                                "setAllocateAddresses");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.vif_attachment_context",
                                                            fields,
                                                            com.vmware.nsx.model.VifAttachmentContext.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "VifAttachmentContext");
    }
}

