/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.node.
 * Used by client-side stubs.
 */

package com.vmware.nsx.node;

public interface Processes extends com.vmware.vapi.bindings.Service, com.vmware.nsx.node.ProcessesTypes {

    /**
     * Returns information for a specified process ID (pid).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param processId ID of process to read (required)
     * @return com.vmware.nsx.model.NodeProcessProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeProcessProperties get(java.lang.String processId);

    /**
     * Returns information for a specified process ID (pid).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param processId ID of process to read (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeProcessProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeProcessProperties get(java.lang.String processId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information for a specified process ID (pid).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeProcessProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param processId ID of process to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String processId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeProcessProperties> asyncCallback);

    /**
     * Returns information for a specified process ID (pid).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeProcessProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param processId ID of process to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String processId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeProcessProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns the number of processes and information about each process. Process
     * information includes 1) mem_resident, which is roughly equivalent to the amount
     * of RAM, in bytes, currently used by the process, 2) parent process ID (ppid), 3)
     * process name, 4) process up time in milliseconds, 5) mem_used, wich is the
     * amount of virtual memory used by the process, in bytes, 6) process start time,
     * in milliseconds since epoch, 7) process ID (pid), 8) CPU time, both user and the
     * system, consumed by the process in milliseconds.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.NodeProcessPropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeProcessPropertiesListResult list();

    /**
     * Returns the number of processes and information about each process. Process
     * information includes 1) mem_resident, which is roughly equivalent to the amount
     * of RAM, in bytes, currently used by the process, 2) parent process ID (ppid), 3)
     * process name, 4) process up time in milliseconds, 5) mem_used, wich is the
     * amount of virtual memory used by the process, in bytes, 6) process start time,
     * in milliseconds since epoch, 7) process ID (pid), 8) CPU time, both user and the
     * system, consumed by the process in milliseconds.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeProcessPropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeProcessPropertiesListResult list(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the number of processes and information about each process. Process
     * information includes 1) mem_resident, which is roughly equivalent to the amount
     * of RAM, in bytes, currently used by the process, 2) parent process ID (ppid), 3)
     * process name, 4) process up time in milliseconds, 5) mem_used, wich is the
     * amount of virtual memory used by the process, in bytes, 6) process start time,
     * in milliseconds since epoch, 7) process ID (pid), 8) CPU time, both user and the
     * system, consumed by the process in milliseconds.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeProcessPropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeProcessPropertiesListResult> asyncCallback);

    /**
     * Returns the number of processes and information about each process. Process
     * information includes 1) mem_resident, which is roughly equivalent to the amount
     * of RAM, in bytes, currently used by the process, 2) parent process ID (ppid), 3)
     * process name, 4) process up time in milliseconds, 5) mem_used, wich is the
     * amount of virtual memory used by the process, in bytes, 6) process start time,
     * in milliseconds since epoch, 7) process ID (pid), 8) CPU time, both user and the
     * system, consumed by the process in milliseconds.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeProcessPropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeProcessPropertiesListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
