/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.node.network.
 * Used by client-side stubs.
 */

package com.vmware.nsx.node.network;

public interface NameServers extends com.vmware.vapi.bindings.Service, com.vmware.nsx.node.network.NameServersTypes {

    /**
     * Returns the list of servers that the node uses to look up IP addresses
     * associated with given domain names.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.NodeNameServersProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeNameServersProperties get();

    /**
     * Returns the list of servers that the node uses to look up IP addresses
     * associated with given domain names.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeNameServersProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeNameServersProperties get(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the list of servers that the node uses to look up IP addresses
     * associated with given domain names.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeNameServersProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeNameServersProperties> asyncCallback);

    /**
     * Returns the list of servers that the node uses to look up IP addresses
     * associated with given domain names.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeNameServersProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeNameServersProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies the list of servers that the node uses to look up IP addresses
     * associated with given domain names. If DHCP is configured, this method returns a
     * 409 CONFLICT error, because DHCP manages the list of name servers.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeNameServersProperties (required)
     * @return com.vmware.nsx.model.NodeNameServersProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeNameServersProperties update(com.vmware.nsx.model.NodeNameServersProperties nodeNameServersProperties);

    /**
     * Modifies the list of servers that the node uses to look up IP addresses
     * associated with given domain names. If DHCP is configured, this method returns a
     * 409 CONFLICT error, because DHCP manages the list of name servers.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeNameServersProperties (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeNameServersProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeNameServersProperties update(com.vmware.nsx.model.NodeNameServersProperties nodeNameServersProperties, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies the list of servers that the node uses to look up IP addresses
     * associated with given domain names. If DHCP is configured, this method returns a
     * 409 CONFLICT error, because DHCP manages the list of name servers.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeNameServersProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeNameServersProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(com.vmware.nsx.model.NodeNameServersProperties nodeNameServersProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeNameServersProperties> asyncCallback);

    /**
     * Modifies the list of servers that the node uses to look up IP addresses
     * associated with given domain names. If DHCP is configured, this method returns a
     * 409 CONFLICT error, because DHCP manages the list of name servers.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeNameServersProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeNameServersProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(com.vmware.nsx.model.NodeNameServersProperties nodeNameServersProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeNameServersProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
