
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.node.network;

/**
 * {@link NetworkFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.node.network package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class NetworkFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private NetworkFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link NetworkFactory} factory instance
     */
    public static NetworkFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        NetworkFactory instance = new NetworkFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.node.network.Interfaces}
     */
    public com.vmware.nsx.node.network.Interfaces interfacesService() {
        return this.stubFactory.createStub(Interfaces.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.node.network.NameServers}
     */
    public com.vmware.nsx.node.network.NameServers nameServersService() {
        return this.stubFactory.createStub(NameServers.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.node.network.Routes}
     */
    public com.vmware.nsx.node.network.Routes routesService() {
        return this.stubFactory.createStub(Routes.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.node.network.SearchDomains}
     */
    public com.vmware.nsx.node.network.SearchDomains searchDomainsService() {
        return this.stubFactory.createStub(SearchDomains.class, this.stubConfig);
    }

    public com.vmware.nsx.node.network.interfaces.InterfacesFactory interfaces() {
        return com.vmware.nsx.node.network.interfaces.InterfacesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
