/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.nvds_urt.
 * Used by client-side stubs.
 */

package com.vmware.nsx.nvds_urt;

public interface StatusSummary extends com.vmware.vapi.bindings.Service, com.vmware.nsx.nvds_urt.StatusSummaryTypes {

    /**
     * Provides overall status for Precheck as well as actual NVDS to CVDS upgrade
     * status per host. Precheck statuses are as follows 1. IN_PROGRESS: Precheck is in
     * progress 2. FAILED: Precheck is failed, error can be found in precheck_issue
     * field 3. PENDING_TOPOLOGY: Precheck is successful, recommended topology is
     * generated 4. APPLYING_TOPOLOGY: SetTargetToplogy is in progress 5.
     * APPLY_TOPOLOGY_FAILED: SetTargetTopology is failed 6. REDAY: SetTargetTopology
     * is successful and TransportNodes provided as part of topology are ready for
     * upgrade from NVDS to CVDS
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param precheckId (required)
     * @param clusterId cluster identifier (optional)
     * @return com.vmware.nsx.model.NvdsUpgradeStatusSummary
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.NvdsUpgradeStatusSummary get(java.lang.String precheckId, java.lang.String clusterId);

    /**
     * Provides overall status for Precheck as well as actual NVDS to CVDS upgrade
     * status per host. Precheck statuses are as follows 1. IN_PROGRESS: Precheck is in
     * progress 2. FAILED: Precheck is failed, error can be found in precheck_issue
     * field 3. PENDING_TOPOLOGY: Precheck is successful, recommended topology is
     * generated 4. APPLYING_TOPOLOGY: SetTargetToplogy is in progress 5.
     * APPLY_TOPOLOGY_FAILED: SetTargetTopology is failed 6. REDAY: SetTargetTopology
     * is successful and TransportNodes provided as part of topology are ready for
     * upgrade from NVDS to CVDS
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param precheckId (required)
     * @param clusterId cluster identifier (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NvdsUpgradeStatusSummary
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.NvdsUpgradeStatusSummary get(java.lang.String precheckId, java.lang.String clusterId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Provides overall status for Precheck as well as actual NVDS to CVDS upgrade
     * status per host. Precheck statuses are as follows 1. IN_PROGRESS: Precheck is in
     * progress 2. FAILED: Precheck is failed, error can be found in precheck_issue
     * field 3. PENDING_TOPOLOGY: Precheck is successful, recommended topology is
     * generated 4. APPLYING_TOPOLOGY: SetTargetToplogy is in progress 5.
     * APPLY_TOPOLOGY_FAILED: SetTargetTopology is failed 6. REDAY: SetTargetTopology
     * is successful and TransportNodes provided as part of topology are ready for
     * upgrade from NVDS to CVDS
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NvdsUpgradeStatusSummary
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param precheckId (required)
     * @param clusterId cluster identifier (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String precheckId, java.lang.String clusterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NvdsUpgradeStatusSummary> asyncCallback);

    /**
     * Provides overall status for Precheck as well as actual NVDS to CVDS upgrade
     * status per host. Precheck statuses are as follows 1. IN_PROGRESS: Precheck is in
     * progress 2. FAILED: Precheck is failed, error can be found in precheck_issue
     * field 3. PENDING_TOPOLOGY: Precheck is successful, recommended topology is
     * generated 4. APPLYING_TOPOLOGY: SetTargetToplogy is in progress 5.
     * APPLY_TOPOLOGY_FAILED: SetTargetTopology is failed 6. REDAY: SetTargetTopology
     * is successful and TransportNodes provided as part of topology are ready for
     * upgrade from NVDS to CVDS
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NvdsUpgradeStatusSummary
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param precheckId (required)
     * @param clusterId cluster identifier (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String precheckId, java.lang.String clusterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NvdsUpgradeStatusSummary> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
