/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.nvds_urt.
 * Used by client-side stubs.
 */

package com.vmware.nsx.nvds_urt;

public interface Topology extends com.vmware.vapi.bindings.Service, com.vmware.nsx.nvds_urt.TopologyTypes {

    /**
     * Upon successful preheck status goes to PENDING_TOPOLOGY and global recommended
     * topology is generated which can be retrieved via GetRecommendedVdsTopology API.
     * User can apply the entire recommeneded topology all together or can apply
     * partial depending on which TrasportNodes user wants to be upgraded from NVDS to
     * CVDS. User can change system generated vds_name field, all other fields cannot
     * be changed when applying topology.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param upgradeTopology (required)
     * @param clusterId cluster identifier (optional)
     * @param useRecommendedTopologyConfig Flag to indicate if use recommended topology got from the latest precheck
     * (optional)
     * @return com.vmware.nsx.model.UpgradeTopology
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.UpgradeTopology apply(com.vmware.nsx.model.UpgradeTopology upgradeTopology, java.lang.String clusterId, java.lang.Boolean useRecommendedTopologyConfig);

    /**
     * Upon successful preheck status goes to PENDING_TOPOLOGY and global recommended
     * topology is generated which can be retrieved via GetRecommendedVdsTopology API.
     * User can apply the entire recommeneded topology all together or can apply
     * partial depending on which TrasportNodes user wants to be upgraded from NVDS to
     * CVDS. User can change system generated vds_name field, all other fields cannot
     * be changed when applying topology.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param upgradeTopology (required)
     * @param clusterId cluster identifier (optional)
     * @param useRecommendedTopologyConfig Flag to indicate if use recommended topology got from the latest precheck
     * (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeTopology
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.UpgradeTopology apply(com.vmware.nsx.model.UpgradeTopology upgradeTopology, java.lang.String clusterId, java.lang.Boolean useRecommendedTopologyConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Upon successful preheck status goes to PENDING_TOPOLOGY and global recommended
     * topology is generated which can be retrieved via GetRecommendedVdsTopology API.
     * User can apply the entire recommeneded topology all together or can apply
     * partial depending on which TrasportNodes user wants to be upgraded from NVDS to
     * CVDS. User can change system generated vds_name field, all other fields cannot
     * be changed when applying topology.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeTopology
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param upgradeTopology (required)
     * @param clusterId cluster identifier (optional)
     * @param useRecommendedTopologyConfig Flag to indicate if use recommended topology got from the latest precheck
     * (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void apply(com.vmware.nsx.model.UpgradeTopology upgradeTopology, java.lang.String clusterId, java.lang.Boolean useRecommendedTopologyConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeTopology> asyncCallback);

    /**
     * Upon successful preheck status goes to PENDING_TOPOLOGY and global recommended
     * topology is generated which can be retrieved via GetRecommendedVdsTopology API.
     * User can apply the entire recommeneded topology all together or can apply
     * partial depending on which TrasportNodes user wants to be upgraded from NVDS to
     * CVDS. User can change system generated vds_name field, all other fields cannot
     * be changed when applying topology.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeTopology
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param upgradeTopology (required)
     * @param clusterId cluster identifier (optional)
     * @param useRecommendedTopologyConfig Flag to indicate if use recommended topology got from the latest precheck
     * (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void apply(com.vmware.nsx.model.UpgradeTopology upgradeTopology, java.lang.String clusterId, java.lang.Boolean useRecommendedTopologyConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeTopology> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * This returns global recommended topology generated when precheck is successful.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param precheckId (required)
     * @param clusterId cluster identifier (optional)
     * @param computeManagerId vCenter identifier (optional)
     * @param showVdsConfig Flag to indicate if VdsTopology should contain VDS configuration (optional)
     * @return com.vmware.nsx.model.UpgradeTopology
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.UpgradeTopology get(java.lang.String precheckId, java.lang.String clusterId, java.lang.String computeManagerId, java.lang.Boolean showVdsConfig);

    /**
     * This returns global recommended topology generated when precheck is successful.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param precheckId (required)
     * @param clusterId cluster identifier (optional)
     * @param computeManagerId vCenter identifier (optional)
     * @param showVdsConfig Flag to indicate if VdsTopology should contain VDS configuration (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeTopology
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.UpgradeTopology get(java.lang.String precheckId, java.lang.String clusterId, java.lang.String computeManagerId, java.lang.Boolean showVdsConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This returns global recommended topology generated when precheck is successful.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeTopology
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param precheckId (required)
     * @param clusterId cluster identifier (optional)
     * @param computeManagerId vCenter identifier (optional)
     * @param showVdsConfig Flag to indicate if VdsTopology should contain VDS configuration (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String precheckId, java.lang.String clusterId, java.lang.String computeManagerId, java.lang.Boolean showVdsConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeTopology> asyncCallback);

    /**
     * This returns global recommended topology generated when precheck is successful.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeTopology
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param precheckId (required)
     * @param clusterId cluster identifier (optional)
     * @param computeManagerId vCenter identifier (optional)
     * @param showVdsConfig Flag to indicate if VdsTopology should contain VDS configuration (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String precheckId, java.lang.String clusterId, java.lang.String computeManagerId, java.lang.Boolean showVdsConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeTopology> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * This will revert corresponding VDS to PENDING_TOPOLOGY state. User can revert
     * the entire topology all together or can revert partially depending on which
     * TrasportNodes user does not want to upgrade to VDS.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param upgradeTopology (required)
     * @return com.vmware.nsx.model.UpgradeTopology
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.UpgradeTopology revert(com.vmware.nsx.model.UpgradeTopology upgradeTopology);

    /**
     * This will revert corresponding VDS to PENDING_TOPOLOGY state. User can revert
     * the entire topology all together or can revert partially depending on which
     * TrasportNodes user does not want to upgrade to VDS.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param upgradeTopology (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeTopology
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.UpgradeTopology revert(com.vmware.nsx.model.UpgradeTopology upgradeTopology, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This will revert corresponding VDS to PENDING_TOPOLOGY state. User can revert
     * the entire topology all together or can revert partially depending on which
     * TrasportNodes user does not want to upgrade to VDS.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeTopology
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param upgradeTopology (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void revert(com.vmware.nsx.model.UpgradeTopology upgradeTopology, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeTopology> asyncCallback);

    /**
     * This will revert corresponding VDS to PENDING_TOPOLOGY state. User can revert
     * the entire topology all together or can revert partially depending on which
     * TrasportNodes user does not want to upgrade to VDS.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeTopology
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param upgradeTopology (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void revert(com.vmware.nsx.model.UpgradeTopology upgradeTopology, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeTopology> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
