/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.repository.bundles.
 * Used by client-side stubs.
 */

package com.vmware.nsx.repository.bundles;

public interface UploadAllowed extends com.vmware.vapi.bindings.Service, com.vmware.nsx.repository.bundles.UploadAllowedTypes {

    /**
     * Checks whether bundle upload is allowed on given node for given appliance. There
     * are different kinds of checks for different appliances. Some of the checks for
     * Intelligence appliance are as follows: 1. Is bundle upload-allowed on given node
     * 2. Is bundle upload already in-progress
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param product Name of the appliance (required)
     * @return com.vmware.nsx.model.BundleUploadPermission
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.BundleUploadPermission get(java.lang.String product);

    /**
     * Checks whether bundle upload is allowed on given node for given appliance. There
     * are different kinds of checks for different appliances. Some of the checks for
     * Intelligence appliance are as follows: 1. Is bundle upload-allowed on given node
     * 2. Is bundle upload already in-progress
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param product Name of the appliance (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BundleUploadPermission
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.BundleUploadPermission get(java.lang.String product, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Checks whether bundle upload is allowed on given node for given appliance. There
     * are different kinds of checks for different appliances. Some of the checks for
     * Intelligence appliance are as follows: 1. Is bundle upload-allowed on given node
     * 2. Is bundle upload already in-progress
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BundleUploadPermission
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param product Name of the appliance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String product, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BundleUploadPermission> asyncCallback);

    /**
     * Checks whether bundle upload is allowed on given node for given appliance. There
     * are different kinds of checks for different appliances. Some of the checks for
     * Intelligence appliance are as follows: 1. Is bundle upload-allowed on given node
     * 2. Is bundle upload already in-progress
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BundleUploadPermission
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param product Name of the appliance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String product, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BundleUploadPermission> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
