
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.service_configs;

/**
 * {@link ServiceConfigsFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.service_configs package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class ServiceConfigsFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private ServiceConfigsFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link ServiceConfigsFactory} factory instance
     */
    public static ServiceConfigsFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        ServiceConfigsFactory instance = new ServiceConfigsFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.service_configs.Batch}
     */
    public com.vmware.nsx.service_configs.Batch batchService() {
        return this.stubFactory.createStub(Batch.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.service_configs.EffectiveProfiles}
     */
    public com.vmware.nsx.service_configs.EffectiveProfiles effectiveProfilesService() {
        return this.stubFactory.createStub(EffectiveProfiles.class, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
