/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.serviceinsertion.
 * Used by client-side stubs.
 */

package com.vmware.nsx.serviceinsertion;

public interface Sections extends com.vmware.vapi.bindings.Service, com.vmware.nsx.serviceinsertion.SectionsTypes {

    /**
     * Creates new empty Service Insertion section in the system. <br/> Note- POST
     * service insertion section API is deprecated. Please use the policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceInsertionSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx.model.ServiceInsertionSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSection create(com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection, java.lang.String id, java.lang.String operation);

    /**
     * Creates new empty Service Insertion section in the system. <br/> Note- POST
     * service insertion section API is deprecated. Please use the policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceInsertionSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceInsertionSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSection create(com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates new empty Service Insertion section in the system. <br/> Note- POST
     * service insertion section API is deprecated. Please use the policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceInsertionSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSection> asyncCallback);

    /**
     * Creates new empty Service Insertion section in the system. <br/> Note- POST
     * service insertion section API is deprecated. Please use the policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceInsertionSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Creates a new serviceinsertion section with rules. The limit on the number of
     * rules is defined by maxItems in collection types for ServiceInsertionRule
     * (ServiceInsertionRuleXXXList types). When invoked on a section with a large
     * number of rules, this API is supported only at low rates of invocation (not more
     * than 4-5 times per minute). The typical latency of this API with about 1024
     * rules is about 4-5 seconds. This API should not be invoked with large payloads
     * at automation speeds. More than 50 rules are not supported. Instead, to create
     * sections, use: POST /api/v1/serviceinsertion/sections To create rules, use: POST
     * /api/v1/serviceinsertion/sections/<section-id>/rules <br/> Note- POST service
     * insertion section creation with rules API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceInsertionSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSectionRuleList createwithrules(com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList, java.lang.String id, java.lang.String operation);

    /**
     * Creates a new serviceinsertion section with rules. The limit on the number of
     * rules is defined by maxItems in collection types for ServiceInsertionRule
     * (ServiceInsertionRuleXXXList types). When invoked on a section with a large
     * number of rules, this API is supported only at low rates of invocation (not more
     * than 4-5 times per minute). The typical latency of this API with about 1024
     * rules is about 4-5 seconds. This API should not be invoked with large payloads
     * at automation speeds. More than 50 rules are not supported. Instead, to create
     * sections, use: POST /api/v1/serviceinsertion/sections To create rules, use: POST
     * /api/v1/serviceinsertion/sections/<section-id>/rules <br/> Note- POST service
     * insertion section creation with rules API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceInsertionSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSectionRuleList createwithrules(com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new serviceinsertion section with rules. The limit on the number of
     * rules is defined by maxItems in collection types for ServiceInsertionRule
     * (ServiceInsertionRuleXXXList types). When invoked on a section with a large
     * number of rules, this API is supported only at low rates of invocation (not more
     * than 4-5 times per minute). The typical latency of this API with about 1024
     * rules is about 4-5 seconds. This API should not be invoked with large payloads
     * at automation speeds. More than 50 rules are not supported. Instead, to create
     * sections, use: POST /api/v1/serviceinsertion/sections To create rules, use: POST
     * /api/v1/serviceinsertion/sections/<section-id>/rules <br/> Note- POST service
     * insertion section creation with rules API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceInsertionSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void createwithrules(com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSectionRuleList> asyncCallback);

    /**
     * Creates a new serviceinsertion section with rules. The limit on the number of
     * rules is defined by maxItems in collection types for ServiceInsertionRule
     * (ServiceInsertionRuleXXXList types). When invoked on a section with a large
     * number of rules, this API is supported only at low rates of invocation (not more
     * than 4-5 times per minute). The typical latency of this API with about 1024
     * rules is about 4-5 seconds. This API should not be invoked with large payloads
     * at automation speeds. More than 50 rules are not supported. Instead, to create
     * sections, use: POST /api/v1/serviceinsertion/sections To create rules, use: POST
     * /api/v1/serviceinsertion/sections/<section-id>/rules <br/> Note- POST service
     * insertion section creation with rules API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceInsertionSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void createwithrules(com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSectionRuleList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Removes serviceinsertion section from the system. ServiceInsertion section with
     * rules can only be deleted by passing \"cascade=true\" parameter. <br/> Note-
     * DELETE service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param cascade Flag to cascade delete of this object to all it's child objects. (optional,
     * default to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.Boolean cascade);

    /**
     * Removes serviceinsertion section from the system. ServiceInsertion section with
     * rules can only be deleted by passing \"cascade=true\" parameter. <br/> Note-
     * DELETE service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param cascade Flag to cascade delete of this object to all it's child objects. (optional,
     * default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.Boolean cascade, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Removes serviceinsertion section from the system. ServiceInsertion section with
     * rules can only be deleted by passing \"cascade=true\" parameter. <br/> Note-
     * DELETE service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param cascade Flag to cascade delete of this object to all it's child objects. (optional,
     * default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.Boolean cascade, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Removes serviceinsertion section from the system. ServiceInsertion section with
     * rules can only be deleted by passing \"cascade=true\" parameter. <br/> Note-
     * DELETE service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param cascade Flag to cascade delete of this object to all it's child objects. (optional,
     * default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.Boolean cascade, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about serviceinsertion section for the identifier. <br/>
     * Note- GET service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @return com.vmware.nsx.model.ServiceInsertionSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSection get(java.lang.String sectionId);

    /**
     * Returns information about serviceinsertion section for the identifier. <br/>
     * Note- GET service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceInsertionSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSection get(java.lang.String sectionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about serviceinsertion section for the identifier. <br/>
     * Note- GET service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String sectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSection> asyncCallback);

    /**
     * Returns information about serviceinsertion section for the identifier. <br/>
     * Note- GET service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String sectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List all Service Insertion section in paginated form. A default page size is
     * limited to 1000 sections. By default, the list of section is filtered by
     * L3REDIRECT type. <br/> Note- GET service insertion sections API is deprecated.
     * Please use the policy redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param excludeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @param type Section Type (optional, default to L3REDIRECT)
     * @return com.vmware.nsx.model.ServiceInsertionSectionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSectionListResult list(java.lang.String appliedTos, java.lang.String cursor, java.lang.String destinations, java.lang.String excludeAppliedToType, java.lang.String filterType, java.lang.String includeAppliedToType, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources, java.lang.String type);

    /**
     * List all Service Insertion section in paginated form. A default page size is
     * limited to 1000 sections. By default, the list of section is filtered by
     * L3REDIRECT type. <br/> Note- GET service insertion sections API is deprecated.
     * Please use the policy redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param excludeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @param type Section Type (optional, default to L3REDIRECT)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceInsertionSectionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSectionListResult list(java.lang.String appliedTos, java.lang.String cursor, java.lang.String destinations, java.lang.String excludeAppliedToType, java.lang.String filterType, java.lang.String includeAppliedToType, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources, java.lang.String type, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List all Service Insertion section in paginated form. A default page size is
     * limited to 1000 sections. By default, the list of section is filtered by
     * L3REDIRECT type. <br/> Note- GET service insertion sections API is deprecated.
     * Please use the policy redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSectionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param excludeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @param type Section Type (optional, default to L3REDIRECT)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String appliedTos, java.lang.String cursor, java.lang.String destinations, java.lang.String excludeAppliedToType, java.lang.String filterType, java.lang.String includeAppliedToType, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSectionListResult> asyncCallback);

    /**
     * List all Service Insertion section in paginated form. A default page size is
     * limited to 1000 sections. By default, the list of section is filtered by
     * L3REDIRECT type. <br/> Note- GET service insertion sections API is deprecated.
     * Please use the policy redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSectionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param excludeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @param type Section Type (optional, default to L3REDIRECT)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String appliedTos, java.lang.String cursor, java.lang.String destinations, java.lang.String excludeAppliedToType, java.lang.String filterType, java.lang.String includeAppliedToType, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSectionListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns serviceinsertion section information with rules for a section
     * identifier. When invoked on a section with a large number of rules, this API is
     * supported only at low rates of invocation (not more than 4-5 times per minute).
     * The typical latency of this API with about 1024 rules is about 4-5 seconds. This
     * API should not be invoked with large payloads at automation speeds. More than 50
     * rules are not supported. Instead, to read serviceinsertion rules, use: GET
     * /api/v1/serviceinsertion/sections/<section-id>/rules with the appropriate
     * page_size. <br/> Note- GET service insertion section with rules API is
     * deprecated. Please use policy redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @return com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSectionRuleList listwithrules(java.lang.String sectionId);

    /**
     * Returns serviceinsertion section information with rules for a section
     * identifier. When invoked on a section with a large number of rules, this API is
     * supported only at low rates of invocation (not more than 4-5 times per minute).
     * The typical latency of this API with about 1024 rules is about 4-5 seconds. This
     * API should not be invoked with large payloads at automation speeds. More than 50
     * rules are not supported. Instead, to read serviceinsertion rules, use: GET
     * /api/v1/serviceinsertion/sections/<section-id>/rules with the appropriate
     * page_size. <br/> Note- GET service insertion section with rules API is
     * deprecated. Please use policy redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSectionRuleList listwithrules(java.lang.String sectionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns serviceinsertion section information with rules for a section
     * identifier. When invoked on a section with a large number of rules, this API is
     * supported only at low rates of invocation (not more than 4-5 times per minute).
     * The typical latency of this API with about 1024 rules is about 4-5 seconds. This
     * API should not be invoked with large payloads at automation speeds. More than 50
     * rules are not supported. Instead, to read serviceinsertion rules, use: GET
     * /api/v1/serviceinsertion/sections/<section-id>/rules with the appropriate
     * page_size. <br/> Note- GET service insertion section with rules API is
     * deprecated. Please use policy redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void listwithrules(java.lang.String sectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSectionRuleList> asyncCallback);

    /**
     * Returns serviceinsertion section information with rules for a section
     * identifier. When invoked on a section with a large number of rules, this API is
     * supported only at low rates of invocation (not more than 4-5 times per minute).
     * The typical latency of this API with about 1024 rules is about 4-5 seconds. This
     * API should not be invoked with large payloads at automation speeds. More than 50
     * rules are not supported. Instead, to read serviceinsertion rules, use: GET
     * /api/v1/serviceinsertion/sections/<section-id>/rules with the appropriate
     * page_size. <br/> Note- GET service insertion section with rules API is
     * deprecated. Please use policy redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void listwithrules(java.lang.String sectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSectionRuleList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies an existing serviceinsertion section along with its relative position
     * among other serviceinsertion sections in the system. <br/> Note- POST service
     * insertion section API is deprecated. Please use policy redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param serviceInsertionSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx.model.ServiceInsertionSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSection revise(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection, java.lang.String id, java.lang.String operation);

    /**
     * Modifies an existing serviceinsertion section along with its relative position
     * among other serviceinsertion sections in the system. <br/> Note- POST service
     * insertion section API is deprecated. Please use policy redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param serviceInsertionSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceInsertionSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSection revise(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies an existing serviceinsertion section along with its relative position
     * among other serviceinsertion sections in the system. <br/> Note- POST service
     * insertion section API is deprecated. Please use policy redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param serviceInsertionSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void revise(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSection> asyncCallback);

    /**
     * Modifies an existing serviceinsertion section along with its relative position
     * among other serviceinsertion sections in the system. <br/> Note- POST service
     * insertion section API is deprecated. Please use policy redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param serviceInsertionSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void revise(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies an existing serviceinsertion section along with its relative position
     * among other serviceinsertion sections with rules. When invoked on a large number
     * of rules, this API is supported only at low rates of invocation (not more than 2
     * times per minute). The typical latency of this API with about 1024 rules is
     * about 15 seconds in a cluster setup. This API should not be invoked with large
     * payloads at automation speeds. Instead, to move a section above or below another
     * section, use: POST /api/v1/serviceinsertion/sections/<section-id>?action=revise
     * To modify rules, use: PUT
     * /api/v1/serviceinsertion/sections/<section-id>/rules/<rule-id> <br/> Note- POST
     * service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param serviceInsertionSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSectionRuleList revisewithrules(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList, java.lang.String id, java.lang.String operation);

    /**
     * Modifies an existing serviceinsertion section along with its relative position
     * among other serviceinsertion sections with rules. When invoked on a large number
     * of rules, this API is supported only at low rates of invocation (not more than 2
     * times per minute). The typical latency of this API with about 1024 rules is
     * about 15 seconds in a cluster setup. This API should not be invoked with large
     * payloads at automation speeds. Instead, to move a section above or below another
     * section, use: POST /api/v1/serviceinsertion/sections/<section-id>?action=revise
     * To modify rules, use: PUT
     * /api/v1/serviceinsertion/sections/<section-id>/rules/<rule-id> <br/> Note- POST
     * service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param serviceInsertionSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSectionRuleList revisewithrules(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies an existing serviceinsertion section along with its relative position
     * among other serviceinsertion sections with rules. When invoked on a large number
     * of rules, this API is supported only at low rates of invocation (not more than 2
     * times per minute). The typical latency of this API with about 1024 rules is
     * about 15 seconds in a cluster setup. This API should not be invoked with large
     * payloads at automation speeds. Instead, to move a section above or below another
     * section, use: POST /api/v1/serviceinsertion/sections/<section-id>?action=revise
     * To modify rules, use: PUT
     * /api/v1/serviceinsertion/sections/<section-id>/rules/<rule-id> <br/> Note- POST
     * service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param serviceInsertionSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void revisewithrules(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSectionRuleList> asyncCallback);

    /**
     * Modifies an existing serviceinsertion section along with its relative position
     * among other serviceinsertion sections with rules. When invoked on a large number
     * of rules, this API is supported only at low rates of invocation (not more than 2
     * times per minute). The typical latency of this API with about 1024 rules is
     * about 15 seconds in a cluster setup. This API should not be invoked with large
     * payloads at automation speeds. Instead, to move a section above or below another
     * section, use: POST /api/v1/serviceinsertion/sections/<section-id>?action=revise
     * To modify rules, use: PUT
     * /api/v1/serviceinsertion/sections/<section-id>/rules/<rule-id> <br/> Note- POST
     * service insertion section API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param serviceInsertionSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void revisewithrules(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSectionRuleList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies the specified section, but does not modify the section's associated
     * rules. <br/> Note- PUT service insertion section API is deprecated. Please use
     * policy redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param serviceInsertionSection (required)
     * @return com.vmware.nsx.model.ServiceInsertionSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSection update(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection);

    /**
     * Modifies the specified section, but does not modify the section's associated
     * rules. <br/> Note- PUT service insertion section API is deprecated. Please use
     * policy redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param serviceInsertionSection (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceInsertionSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSection update(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies the specified section, but does not modify the section's associated
     * rules. <br/> Note- PUT service insertion section API is deprecated. Please use
     * policy redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param serviceInsertionSection (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSection> asyncCallback);

    /**
     * Modifies the specified section, but does not modify the section's associated
     * rules. <br/> Note- PUT service insertion section API is deprecated. Please use
     * policy redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param serviceInsertionSection (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSection serviceInsertionSection, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies existing serviceinsertion section along with its association with
     * rules. When invoked on a large number of rules, this API is supported only at
     * low rates of invocation (not more than 2 times per minute). The typical latency
     * of this API with about 1024 rules is about 15 seconds in a cluster setup. This
     * API should not be invoked with large payloads at automation speeds. Instead, to
     * update rule content, use: PUT
     * /api/v1/serviceinsertion/sections/<section-id>/rules/<rule-id> <br/> The POST
     * service insertion section with rules API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param serviceInsertionSectionRuleList (required)
     * @return com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSectionRuleList updatewithrules(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList);

    /**
     * Modifies existing serviceinsertion section along with its association with
     * rules. When invoked on a large number of rules, this API is supported only at
     * low rates of invocation (not more than 2 times per minute). The typical latency
     * of this API with about 1024 rules is about 15 seconds in a cluster setup. This
     * API should not be invoked with large payloads at automation speeds. Instead, to
     * update rule content, use: PUT
     * /api/v1/serviceinsertion/sections/<section-id>/rules/<rule-id> <br/> The POST
     * service insertion section with rules API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param serviceInsertionSectionRuleList (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ServiceInsertionSectionRuleList updatewithrules(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies existing serviceinsertion section along with its association with
     * rules. When invoked on a large number of rules, this API is supported only at
     * low rates of invocation (not more than 2 times per minute). The typical latency
     * of this API with about 1024 rules is about 15 seconds in a cluster setup. This
     * API should not be invoked with large payloads at automation speeds. Instead, to
     * update rule content, use: PUT
     * /api/v1/serviceinsertion/sections/<section-id>/rules/<rule-id> <br/> The POST
     * service insertion section with rules API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param serviceInsertionSectionRuleList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void updatewithrules(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSectionRuleList> asyncCallback);

    /**
     * Modifies existing serviceinsertion section along with its association with
     * rules. When invoked on a large number of rules, this API is supported only at
     * low rates of invocation (not more than 2 times per minute). The typical latency
     * of this API with about 1024 rules is about 15 seconds in a cluster setup. This
     * API should not be invoked with large payloads at automation speeds. Instead, to
     * update rule content, use: PUT
     * /api/v1/serviceinsertion/sections/<section-id>/rules/<rule-id> <br/> The POST
     * service insertion section with rules API is deprecated. Please use policy
     * redirection-policy API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInsertionSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param serviceInsertionSectionRuleList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void updatewithrules(java.lang.String sectionId, com.vmware.nsx.model.ServiceInsertionSectionRuleList serviceInsertionSectionRuleList, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInsertionSectionRuleList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
