/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.serviceinsertion.services.service_instances.
 * Used by client-side stubs.
 */

package com.vmware.nsx.serviceinsertion.services.service_instances;

public interface InstanceRuntimes extends com.vmware.vapi.bindings.Service, com.vmware.nsx.serviceinsertion.services.service_instances.InstanceRuntimesTypes {

    /**
     * Set service VM either in or out of maintenance mode for maintenance mode, or in
     * service or out of service for runtime state. Only one value can be set at one
     * time.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceRuntimeId (required)
     * @param action (optional)
     * @param unhealthyReason Reason for the unhealthy state (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void create(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceRuntimeId, java.lang.String action, java.lang.String unhealthyReason);

    /**
     * Set service VM either in or out of maintenance mode for maintenance mode, or in
     * service or out of service for runtime state. Only one value can be set at one
     * time.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceRuntimeId (required)
     * @param action (optional)
     * @param unhealthyReason Reason for the unhealthy state (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void create(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceRuntimeId, java.lang.String action, java.lang.String unhealthyReason, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Set service VM either in or out of maintenance mode for maintenance mode, or in
     * service or out of service for runtime state. Only one value can be set at one
     * time.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceRuntimeId (required)
     * @param action (optional)
     * @param unhealthyReason Reason for the unhealthy state (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceRuntimeId, java.lang.String action, java.lang.String unhealthyReason, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Set service VM either in or out of maintenance mode for maintenance mode, or in
     * service or out of service for runtime state. Only one value can be set at one
     * time.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param instanceRuntimeId (required)
     * @param action (optional)
     * @param unhealthyReason Reason for the unhealthy state (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String serviceId, java.lang.String serviceInstanceId, java.lang.String instanceRuntimeId, java.lang.String action, java.lang.String unhealthyReason, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Undeploy one service VM as standalone or two service VMs as HA. Associated
     * deployment information and instance runtime will also be deleted once service
     * VMs have been un-deployed successfully. <br/> This API has been deprecated,
     * please use below Policy API <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String serviceId, java.lang.String serviceInstanceId);

    /**
     * Undeploy one service VM as standalone or two service VMs as HA. Associated
     * deployment information and instance runtime will also be deleted once service
     * VMs have been un-deployed successfully. <br/> This API has been deprecated,
     * please use below Policy API <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Undeploy one service VM as standalone or two service VMs as HA. Associated
     * deployment information and instance runtime will also be deleted once service
     * VMs have been un-deployed successfully. <br/> This API has been deprecated,
     * please use below Policy API <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Undeploy one service VM as standalone or two service VMs as HA. Associated
     * deployment information and instance runtime will also be deleted once service
     * VMs have been un-deployed successfully. <br/> This API has been deprecated,
     * please use below Policy API <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deploys one service VM as standalone, or two service VMs as HA where one VM is
     * active and another one is standby. During the deployment of service VMs, service
     * will be set up based on deployment events using callbacks. <br/> This API has
     * been deprecated, please use below Policy API <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void deploy(java.lang.String serviceId, java.lang.String serviceInstanceId);

    /**
     * Deploys one service VM as standalone, or two service VMs as HA where one VM is
     * active and another one is standby. During the deployment of service VMs, service
     * will be set up based on deployment events using callbacks. <br/> This API has
     * been deprecated, please use below Policy API <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void deploy(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deploys one service VM as standalone, or two service VMs as HA where one VM is
     * active and another one is standby. During the deployment of service VMs, service
     * will be set up based on deployment events using callbacks. <br/> This API has
     * been deprecated, please use below Policy API <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void deploy(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deploys one service VM as standalone, or two service VMs as HA where one VM is
     * active and another one is standby. During the deployment of service VMs, service
     * will be set up based on deployment events using callbacks. <br/> This API has
     * been deprecated, please use below Policy API <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void deploy(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns list of instance runtimes of service VMs being deployed for a given
     * service instance id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @return com.vmware.nsx.model.InstanceRuntimeListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.InstanceRuntimeListResult list(java.lang.String serviceId, java.lang.String serviceInstanceId);

    /**
     * Returns list of instance runtimes of service VMs being deployed for a given
     * service instance id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.InstanceRuntimeListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.InstanceRuntimeListResult list(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns list of instance runtimes of service VMs being deployed for a given
     * service instance id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InstanceRuntimeListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InstanceRuntimeListResult> asyncCallback);

    /**
     * Returns list of instance runtimes of service VMs being deployed for a given
     * service instance id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InstanceRuntimeListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InstanceRuntimeListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Upgrade service VMs using newer version of OVF. Upgrade is a 2 step process.
     * Update the 'deployment_spec_name' in the ServiceInstance to the new
     * DeploymentSpec to which the service VMs will be upgraded, folowed by this
     * 'upgrade' api. In case of HA, the stand-by service VM will be upgrade first.
     * Once it has been upgraded, it switches to be the Active one and then the other
     * VM will be upgrade. <br/> This API has been deprecated, please use below Policy
     * API <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void upgrade(java.lang.String serviceId, java.lang.String serviceInstanceId);

    /**
     * Upgrade service VMs using newer version of OVF. Upgrade is a 2 step process.
     * Update the 'deployment_spec_name' in the ServiceInstance to the new
     * DeploymentSpec to which the service VMs will be upgraded, folowed by this
     * 'upgrade' api. In case of HA, the stand-by service VM will be upgrade first.
     * Once it has been upgraded, it switches to be the Active one and then the other
     * VM will be upgrade. <br/> This API has been deprecated, please use below Policy
     * API <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void upgrade(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Upgrade service VMs using newer version of OVF. Upgrade is a 2 step process.
     * Update the 'deployment_spec_name' in the ServiceInstance to the new
     * DeploymentSpec to which the service VMs will be upgraded, folowed by this
     * 'upgrade' api. In case of HA, the stand-by service VM will be upgrade first.
     * Once it has been upgraded, it switches to be the Active one and then the other
     * VM will be upgrade. <br/> This API has been deprecated, please use below Policy
     * API <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void upgrade(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Upgrade service VMs using newer version of OVF. Upgrade is a 2 step process.
     * Update the 'deployment_spec_name' in the ServiceInstance to the new
     * DeploymentSpec to which the service VMs will be upgraded, folowed by this
     * 'upgrade' api. In case of HA, the stand-by service VM will be upgrade first.
     * Once it has been upgraded, it switches to be the Active one and then the other
     * VM will be upgrade. <br/> This API has been deprecated, please use below Policy
     * API <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     * PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/service-instances/<service-instance-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param serviceInstanceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void upgrade(java.lang.String serviceId, java.lang.String serviceInstanceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
