/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.traceflows.
 * Used by client-side stubs.
 */

package com.vmware.nsx.traceflows;

public interface Observations extends com.vmware.vapi.bindings.Service, com.vmware.nsx.traceflows.ObservationsTypes {

    /**
     * Get observations for the Traceflow round
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param traceflowId (required)
     * @param componentName Observations having the given component name will be listed. (optional)
     * @param componentType Observations having the given component type will be listed. (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param resourceType The type of observations that will be listed. (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportNodeName Observations having the given transport node name will be listed. (optional)
     * @return com.vmware.nsx.model.TraceflowObservationListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.TraceflowObservationListResult list(java.lang.String traceflowId, java.lang.String componentName, java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String resourceType, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportNodeName);

    /**
     * Get observations for the Traceflow round
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param traceflowId (required)
     * @param componentName Observations having the given component name will be listed. (optional)
     * @param componentType Observations having the given component type will be listed. (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param resourceType The type of observations that will be listed. (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportNodeName Observations having the given transport node name will be listed. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TraceflowObservationListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.TraceflowObservationListResult list(java.lang.String traceflowId, java.lang.String componentName, java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String resourceType, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportNodeName, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get observations for the Traceflow round
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TraceflowObservationListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param traceflowId (required)
     * @param componentName Observations having the given component name will be listed. (optional)
     * @param componentType Observations having the given component type will be listed. (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param resourceType The type of observations that will be listed. (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportNodeName Observations having the given transport node name will be listed. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String traceflowId, java.lang.String componentName, java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String resourceType, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportNodeName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TraceflowObservationListResult> asyncCallback);

    /**
     * Get observations for the Traceflow round
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TraceflowObservationListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param traceflowId (required)
     * @param componentName Observations having the given component name will be listed. (optional)
     * @param componentType Observations having the given component type will be listed. (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param resourceType The type of observations that will be listed. (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportNodeName Observations having the given transport node name will be listed. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String traceflowId, java.lang.String componentName, java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String resourceType, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportNodeName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TraceflowObservationListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
